/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.annotations.checkers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;

public abstract class AnnotatedApiUsageChecker
extends BugChecker
implements BugChecker.MemberSelectTreeMatcher,
BugChecker.IdentifierTreeMatcher {
    private final String basePackage;
    private final String basePackagePlusDot;
    protected final String annotationType;
    private static final Set<ElementKind> INHERITS_ANNOTATION_FROM_OWNER = Collections.unmodifiableSet(EnumSet.of(ElementKind.FIELD, new ElementKind[]{ElementKind.METHOD, ElementKind.CONSTRUCTOR, ElementKind.ENUM_CONSTANT, ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.ENUM, ElementKind.ANNOTATION_TYPE}));

    protected AnnotatedApiUsageChecker(String basePackage, String annotationType) {
        this.basePackage = basePackage;
        this.basePackagePlusDot = basePackage + ".";
        this.annotationType = annotationType;
    }

    public final Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        if (ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ImportTree.class) != null) {
            return Description.NO_MATCH;
        }
        return this.matchTree(tree);
    }

    public final Description matchIdentifier(IdentifierTree tree, VisitorState state) {
        return AnnotatedApiUsageChecker.isSuperCall(tree) ? Description.NO_MATCH : this.matchTree(tree);
    }

    private Description matchTree(Tree tree) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        if (symbol != null && this.isInMatchingPackage(symbol) && this.isAnnotatedApi(symbol)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    private static boolean isSuperCall(IdentifierTree tree) {
        return tree.getName().contentEquals("super");
    }

    private boolean isInMatchingPackage(Symbol symbol) {
        String packageName = symbol.packge().fullname.toString();
        return !this.isIgnoredPackage(packageName) && (packageName.equals(this.basePackage) || packageName.startsWith(this.basePackagePlusDot));
    }

    protected boolean isIgnoredPackage(String packageName) {
        return false;
    }

    protected boolean isIgnoredType(String fullyQualifiedTypeName) {
        return false;
    }

    private boolean isAnnotatedApi(Symbol symbol) {
        Name name = symbol.getQualifiedName();
        if (name != null && this.isIgnoredType(name.toString())) {
            return false;
        }
        for (AnnotationMirror annotation : symbol.getAnnotationMirrors()) {
            if (!annotation.getAnnotationType().toString().equals(this.annotationType)) continue;
            return true;
        }
        return this.isMemberOfAnnotatedApi(symbol);
    }

    private boolean isMemberOfAnnotatedApi(Symbol symbol) {
        return symbol != null && INHERITS_ANNOTATION_FROM_OWNER.contains((Object)symbol.getKind()) && this.isAnnotatedApi(symbol.owner);
    }
}

