/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.annotations.checkers;

import com.google.common.annotations.checkers.AnnotatedApiUsageChecker;
import com.google.errorprone.BugPattern;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@BugPattern(name="BetaApi", summary="@Beta APIs should not be used in library code as they are subject to change", explanation="@Beta APIs should not be used in library code as they are subject to change.", linkType=BugPattern.LinkType.CUSTOM, link="https://github.com/google/guava/wiki/PhilosophyExplained#beta-apis", category=BugPattern.Category.GUAVA, severity=BugPattern.SeverityLevel.ERROR)
public final class BetaChecker
extends AnnotatedApiUsageChecker {
    private static final Set<String> IGNORED_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("com.google.common.cache.Cache", "com.google.common.cache.LoadingCache")));

    public BetaChecker() {
        super("com.google.common", "com.google.common.annotations.Beta");
    }

    @Override
    protected boolean isIgnoredType(String fullyQualifiedTypeName) {
        return IGNORED_TYPES.contains(fullyQualifiedTypeName);
    }
}

