/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.truth0.Truth;

@GwtCompatible
public class MultimapPutIterableTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    private static final Object[] EMPTY = new Object[0];

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllNonEmptyIterableOnPresentKey() {
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(this.sampleKeys().e0, new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return Lists.newArrayList((Object[])new Object[]{MultimapPutIterableTester.this.sampleValues().e3, MultimapPutIterableTester.this.sampleValues().e4}).iterator();
            }
        }));
        this.assertGet(this.sampleKeys().e0, this.sampleValues().e0, this.sampleValues().e3, this.sampleValues().e4);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllNonEmptyCollectionOnPresentKey() {
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(this.sampleKeys().e0, (Iterable)Lists.newArrayList((Object[])new Object[]{this.sampleValues().e3, this.sampleValues().e4})));
        this.assertGet(this.sampleKeys().e0, this.sampleValues().e0, this.sampleValues().e3, this.sampleValues().e4);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllNonEmptyIterableOnAbsentKey() {
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(this.sampleKeys().e3, new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return Lists.newArrayList((Object[])new Object[]{MultimapPutIterableTester.this.sampleValues().e3, MultimapPutIterableTester.this.sampleValues().e4}).iterator();
            }
        }));
        this.assertGet(this.sampleKeys().e3, this.sampleValues().e3, this.sampleValues().e4);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllNonEmptyCollectionOnAbsentKey() {
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(this.sampleKeys().e3, (Iterable)Lists.newArrayList((Object[])new Object[]{this.sampleValues().e3, this.sampleValues().e4})));
        this.assertGet(this.sampleKeys().e3, this.sampleValues().e3, this.sampleValues().e4);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    public void testPutAllNullValueOnPresentKey() {
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(this.sampleKeys().e0, (Iterable)Lists.newArrayList((Object[])new Object[]{this.sampleValues().e3, null})));
        this.assertGet(this.sampleKeys().e0, this.sampleValues().e0, this.sampleValues().e3, null);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    public void testPutAllNullValueOnAbsentKey() {
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(this.sampleKeys().e3, (Iterable)Lists.newArrayList((Object[])new Object[]{this.sampleValues().e3, null})));
        this.assertGet(this.sampleKeys().e3, this.sampleValues().e3, null);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_KEYS})
    public void testPutAllOnPresentNullKey() {
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(null, (Iterable)Lists.newArrayList((Object[])new Object[]{this.sampleValues().e3, this.sampleValues().e4})));
        this.assertGet(null, this.sampleValues().e3, this.sampleValues().e4);
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_KEYS})
    public void testPutAllNullForbidden() {
        try {
            this.multimap().putAll(null, Collections.singletonList(this.sampleValues().e3));
            MultimapPutIterableTester.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllEmptyCollectionOnAbsentKey() {
        MultimapPutIterableTester.assertFalse((boolean)this.multimap().putAll(this.sampleKeys().e3, Collections.emptyList()));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllEmptyIterableOnAbsentKey() {
        Iterable iterable = new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return Iterators.emptyIterator();
            }
        };
        MultimapPutIterableTester.assertFalse((boolean)this.multimap().putAll(this.sampleKeys().e3, iterable));
        this.expectUnchanged();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllEmptyIterableOnPresentKey() {
        this.multimap().putAll(this.sampleKeys().e0, Collections.emptyList());
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllOnlyCallsIteratorOnce() {
        Iterable iterable = new Iterable<V>(){
            private boolean calledIteratorAlready = false;

            @Override
            public Iterator<V> iterator() {
                Preconditions.checkState((!this.calledIteratorAlready ? 1 : 0) != 0);
                this.calledIteratorAlready = true;
                return Iterators.forArray((Object[])new Object[]{MultimapPutIterableTester.this.sampleValues().e3});
            }
        };
        this.multimap().putAll(this.sampleKeys().e3, iterable);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllPropagatesToGet() {
        Collection getCollection = this.multimap().get(this.sampleKeys().e0);
        int getCollectionSize = getCollection.size();
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(this.sampleKeys().e0, (Iterable)Lists.newArrayList((Object[])new Object[]{this.sampleValues().e3, this.sampleValues().e4})));
        MultimapPutIterableTester.assertEquals((int)(getCollectionSize + 2), (int)getCollection.size());
        Truth.ASSERT.that(getCollection).has().allOf(this.sampleValues().e3, this.sampleValues().e4, new Object[0]);
    }
}

