/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import junit.framework.AssertionFailedError;

@GwtCompatible
final class RelationshipTester<T> {
    private final List<ImmutableList<T>> groups = Lists.newArrayList();
    private final RelationshipAssertion<T> assertion;
    private final ItemReporter itemReporter;

    RelationshipTester(RelationshipAssertion<T> assertion, ItemReporter itemReporter) {
        this.assertion = (RelationshipAssertion)Preconditions.checkNotNull(assertion);
        this.itemReporter = (ItemReporter)Preconditions.checkNotNull((Object)itemReporter);
    }

    RelationshipTester(RelationshipAssertion<T> assertion) {
        this(assertion, new ItemReporter());
    }

    public RelationshipTester<T> addRelatedGroup(Iterable<? extends T> group) {
        this.groups.add(ImmutableList.copyOf(group));
        return this;
    }

    public void test() {
        for (int groupNumber = 0; groupNumber < this.groups.size(); ++groupNumber) {
            ImmutableList<T> group = this.groups.get(groupNumber);
            for (int itemNumber = 0; itemNumber < group.size(); ++itemNumber) {
                for (int relatedItemNumber = 0; relatedItemNumber < group.size(); ++relatedItemNumber) {
                    if (itemNumber == relatedItemNumber) continue;
                    this.assertRelated(groupNumber, itemNumber, relatedItemNumber);
                }
                for (int unrelatedGroupNumber = 0; unrelatedGroupNumber < this.groups.size(); ++unrelatedGroupNumber) {
                    if (groupNumber == unrelatedGroupNumber) continue;
                    ImmutableList<T> unrelatedGroup = this.groups.get(unrelatedGroupNumber);
                    for (int unrelatedItemNumber = 0; unrelatedItemNumber < unrelatedGroup.size(); ++unrelatedItemNumber) {
                        this.assertUnrelated(groupNumber, itemNumber, unrelatedGroupNumber, unrelatedItemNumber);
                    }
                }
            }
        }
    }

    private void assertRelated(int groupNumber, int itemNumber, int relatedItemNumber) {
        ImmutableList<T> group = this.groups.get(groupNumber);
        Object item = group.get(itemNumber);
        Object related = group.get(relatedItemNumber);
        try {
            this.assertion.assertRelated(item, related);
        }
        catch (AssertionFailedError e) {
            throw new AssertionFailedError(e.getMessage().replace("$ITEM", this.itemReporter.reportItem(new Item(item, groupNumber, itemNumber))).replace("$RELATED", this.itemReporter.reportItem(new Item(related, groupNumber, relatedItemNumber))));
        }
    }

    private void assertUnrelated(int groupNumber, int itemNumber, int unrelatedGroupNumber, int unrelatedItemNumber) {
        Object item = this.groups.get(groupNumber).get(itemNumber);
        Object unrelated = this.groups.get(unrelatedGroupNumber).get(unrelatedItemNumber);
        try {
            this.assertion.assertUnrelated(item, unrelated);
        }
        catch (AssertionFailedError e) {
            throw new AssertionFailedError(e.getMessage().replace("$ITEM", this.itemReporter.reportItem(new Item(item, groupNumber, itemNumber))).replace("$UNRELATED", this.itemReporter.reportItem(new Item(unrelated, unrelatedGroupNumber, unrelatedItemNumber))));
        }
    }

    static abstract class RelationshipAssertion<T> {
        RelationshipAssertion() {
        }

        abstract void assertRelated(T var1, T var2);

        abstract void assertUnrelated(T var1, T var2);
    }

    static final class Item {
        final Object value;
        final int groupNumber;
        final int itemNumber;

        Item(Object value, int groupNumber, int itemNumber) {
            this.value = value;
            this.groupNumber = groupNumber;
            this.itemNumber = itemNumber;
        }

        public String toString() {
            return this.value + " [group " + (this.groupNumber + 1) + ", item " + (this.itemNumber + 1) + ']';
        }
    }

    static class ItemReporter {
        ItemReporter() {
        }

        String reportItem(Item item) {
            return item.toString();
        }
    }
}

