/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.truth0.Truth;

@GwtCompatible
public class MultimapEntriesTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    public void testEntries() {
        Truth.ASSERT.that(this.multimap().entries()).has().exactlyAs(this.getSampleElements());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    public void testContainsEntryWithNullKeyPresent() {
        this.initMultimapWithNullKey();
        Truth.ASSERT.that(this.multimap().entries()).has().allOf(Helpers.mapEntry(null, this.getValueForNullKey()));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testContainsEntryWithNullKeyAbsent() {
        MultimapEntriesTester.assertFalse((boolean)this.multimap().entries().contains(Helpers.mapEntry(null, this.sampleValues().e0)));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUES})
    public void testContainsEntryWithNullValuePresent() {
        this.initMultimapWithNullValue();
        Truth.ASSERT.that(this.multimap().entries()).has().allOf(Helpers.mapEntry(this.getKeyForNullValue(), null));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testContainsEntryWithNullValueAbsent() {
        MultimapEntriesTester.assertFalse((boolean)this.multimap().entries().contains(Helpers.mapEntry(this.sampleKeys().e0, null)));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemovePropagatesToMultimap() {
        MultimapEntriesTester.assertTrue((boolean)this.multimap().entries().remove(Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e0)));
        this.expectMissing(Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e0));
        MultimapEntriesTester.assertEquals((int)(this.getNumElements() - 1), (int)this.multimap().size());
        MultimapEntriesTester.assertFalse((boolean)this.multimap().containsEntry(this.sampleKeys().e0, this.sampleValues().e0));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemoveAllPropagatesToMultimap() {
        MultimapEntriesTester.assertTrue((boolean)this.multimap().entries().removeAll(Collections.singleton(Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e0))));
        this.expectMissing(Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e0));
        MultimapEntriesTester.assertEquals((int)(this.getNumElements() - 1), (int)this.multimap().size());
        MultimapEntriesTester.assertFalse((boolean)this.multimap().containsEntry(this.sampleKeys().e0, this.sampleValues().e0));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRetainAllPropagatesToMultimap() {
        this.multimap().entries().retainAll(Collections.singleton(Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e0)));
        MultimapEntriesTester.assertEquals(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e0)), this.multimap());
        MultimapEntriesTester.assertEquals((int)1, (int)this.multimap().size());
        MultimapEntriesTester.assertTrue((boolean)this.multimap().containsEntry(this.sampleKeys().e0, this.sampleValues().e0));
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    public void testIteratorRemovePropagatesToMultimap() {
        Iterator iterator = this.multimap().entries().iterator();
        MultimapEntriesTester.assertEquals(Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e0), iterator.next());
        iterator.remove();
        MultimapEntriesTester.assertTrue((boolean)this.multimap().isEmpty());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testEntriesRemainValidAfterRemove() {
        Iterator iterator = this.multimap().entries().iterator();
        Map.Entry entry = (Map.Entry)iterator.next();
        Object key = entry.getKey();
        Object value = entry.getValue();
        this.multimap().removeAll(key);
        MultimapEntriesTester.assertEquals(key, entry.getKey());
        MultimapEntriesTester.assertEquals(value, entry.getValue());
    }
}

