/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.truth0.Truth;

@GwtCompatible
public class MultimapReplaceValuesTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_VALUES})
    public void testReplaceValuesWithNullValue() {
        int size = this.multimap().size();
        Object key = this.sampleKeys().e0;
        List<Object> values = Arrays.asList(this.sampleValues().e0, null, this.sampleValues().e3);
        this.multimap().replaceValues(key, values);
        this.assertGet(key, values);
    }

    /*
     * Exception decompiling
     */
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_KEYS})
    public void testReplaceValuesWithNullKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.getBindingFor(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "res" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.getGtbNullFiltered(GenericInferer.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.inferGenericObjectInfoFromCalls(GenericInferer.java:139)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:484)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    public void testReplaceEmptyValues() {
        int size = this.multimap().size();
        Object key = this.sampleKeys().e3;
        List<Object> values = Arrays.asList(this.sampleValues().e0, this.sampleValues().e2, this.sampleValues().e3);
        this.multimap().replaceValues(key, values);
        this.assertGet(key, values);
        MultimapReplaceValuesTester.assertEquals((int)(size + values.size()), (int)this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    public void testReplaceValuesWithEmpty() {
        int size = this.multimap().size();
        Object key = this.sampleKeys().e0;
        ArrayList oldValues = new ArrayList(this.multimap().get(key));
        List values = Collections.emptyList();
        MultimapReplaceValuesTester.assertEquals(oldValues, new ArrayList(this.multimap().replaceValues(key, values)));
        this.assertGet(key, new Object[0]);
        MultimapReplaceValuesTester.assertEquals((int)(size - oldValues.size()), (int)this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    public void testReplaceValuesWithDuplicates() {
        int size = this.multimap().size();
        Object key = this.sampleKeys().e0;
        ArrayList oldValues = new ArrayList(this.multimap().get(key));
        List<Object> values = Arrays.asList(this.sampleValues().e0, this.sampleValues().e3, this.sampleValues().e0);
        MultimapReplaceValuesTester.assertEquals(oldValues, new ArrayList(this.multimap().replaceValues(key, values)));
        MultimapReplaceValuesTester.assertEquals((int)(size - oldValues.size() + this.multimap().get(key).size()), (int)this.multimap().size());
        MultimapReplaceValuesTester.assertTrue((boolean)this.multimap().get(key).containsAll(values));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    public void testReplaceNonEmptyValues() {
        List keys = Helpers.copyToList(this.multimap().keySet());
        List<Object> values = Arrays.asList(this.sampleValues().e0, this.sampleValues().e2, this.sampleValues().e3);
        for (Object k : keys) {
            this.resetContainer();
            int size = this.multimap().size();
            List oldKeyValues = Helpers.copyToList(this.multimap().get(k));
            this.multimap().replaceValues(k, values);
            this.assertGet(k, values);
            MultimapReplaceValuesTester.assertEquals((int)(size + values.size() - oldKeyValues.size()), (int)this.multimap().size());
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    public void testReplaceValuesPropagatesToGet() {
        Object key = this.sampleKeys().e0;
        Collection getCollection = this.multimap().get(key);
        List<Object> values = Arrays.asList(this.sampleValues().e0, this.sampleValues().e2, this.sampleValues().e3);
        this.multimap().replaceValues(key, values);
        Truth.ASSERT.that(getCollection).has().exactly(this.sampleValues().e0, this.sampleValues().e2, new Object[]{this.sampleValues().e3});
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testReplaceValuesRemoveNotSupported() {
        List values = Collections.singletonList(this.sampleValues().e3);
        try {
            this.multimap().replaceValues(this.sampleKeys().e0, values);
            MultimapReplaceValuesTester.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    public void testReplaceValuesPutNotSupported() {
        List values = Collections.singletonList(this.sampleValues().e3);
        try {
            this.multimap().replaceValues(this.sampleKeys().e0, values);
            MultimapReplaceValuesTester.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

