/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.google.AbstractMultisetTester;
import java.util.Collections;
import java.util.Set;
import org.truth0.Truth;

@GwtCompatible
public class MultisetElementSetTester<E>
extends AbstractMultisetTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testElementSetReflectsAddAbsent() {
        Set elementSet = this.getMultiset().elementSet();
        MultisetElementSetTester.assertFalse((boolean)elementSet.contains(this.samples.e3));
        this.getMultiset().add(this.samples.e3, 4);
        MultisetElementSetTester.assertTrue((boolean)elementSet.contains(this.samples.e3));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testElementSetReflectsRemove() {
        Set elementSet = this.getMultiset().elementSet();
        MultisetElementSetTester.assertTrue((boolean)elementSet.contains(this.samples.e0));
        this.getMultiset().removeAll(Collections.singleton(this.samples.e0));
        MultisetElementSetTester.assertFalse((boolean)elementSet.contains(this.samples.e0));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testElementSetRemovePropagatesToMultiset() {
        Set elementSet = this.getMultiset().elementSet();
        MultisetElementSetTester.assertTrue((boolean)elementSet.remove(this.samples.e0));
        MultisetElementSetTester.assertFalse((boolean)this.getMultiset().contains(this.samples.e0));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testElementSetRemoveDuplicatePropagatesToMultiset() {
        this.initThreeCopies();
        Set elementSet = this.getMultiset().elementSet();
        MultisetElementSetTester.assertTrue((boolean)elementSet.remove(this.samples.e0));
        Truth.ASSERT.that(this.getMultiset()).isEmpty();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testElementSetRemoveAbsent() {
        Set elementSet = this.getMultiset().elementSet();
        MultisetElementSetTester.assertFalse((boolean)elementSet.remove(this.samples.e3));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testElementSetClear() {
        this.getMultiset().elementSet().clear();
        Truth.ASSERT.that(this.getMultiset()).isEmpty();
    }
}

