/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.MinimalIterable;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;

@GwtCompatible
public class MinimalIterableTest
extends TestCase {
    public void testOf_empty() {
        MinimalIterable iterable = MinimalIterable.of((Object[])new String[0]);
        Iterator iterator = iterable.iterator();
        MinimalIterableTest.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            MinimalIterableTest.fail();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
        try {
            iterable.iterator();
            MinimalIterableTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testOf_one() {
        MinimalIterable iterable = MinimalIterable.of((Object[])new String[]{"a"});
        Iterator iterator = iterable.iterator();
        MinimalIterableTest.assertTrue((boolean)iterator.hasNext());
        MinimalIterableTest.assertEquals((String)"a", (String)((String)iterator.next()));
        MinimalIterableTest.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            MinimalIterableTest.fail();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
        try {
            iterable.iterator();
            MinimalIterableTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testFrom_empty() {
        MinimalIterable iterable = MinimalIterable.from(Collections.emptySet());
        Iterator iterator = iterable.iterator();
        MinimalIterableTest.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            MinimalIterableTest.fail();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
        try {
            iterable.iterator();
            MinimalIterableTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testFrom_one() {
        MinimalIterable iterable = MinimalIterable.from(Collections.singleton("a"));
        Iterator iterator = iterable.iterator();
        MinimalIterableTest.assertTrue((boolean)iterator.hasNext());
        MinimalIterableTest.assertEquals((String)"a", (String)((String)iterator.next()));
        try {
            iterator.remove();
            MinimalIterableTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        MinimalIterableTest.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            MinimalIterableTest.fail();
        }
        catch (NoSuchElementException expected) {
            // empty catch block
        }
        try {
            iterable.iterator();
            MinimalIterableTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

