/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.testing.AbstractPackageSanityTests;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

public class AbstractPackageSanityTestsTest
extends TestCase {
    private final AbstractPackageSanityTests sanityTests = new AbstractPackageSanityTests(){};

    public void testFindClassesToTest_testClass() {
        Truth.assertThat(this.findClassesToTest((Iterable<? extends Class<?>>)ImmutableList.of(EmptyTest.class), new String[0])).isEmpty();
        Truth.assertThat(this.findClassesToTest((Iterable<? extends Class<?>>)ImmutableList.of(EmptyTests.class), new String[0])).isEmpty();
        Truth.assertThat(this.findClassesToTest((Iterable<? extends Class<?>>)ImmutableList.of(EmptyTestCase.class), new String[0])).isEmpty();
        Truth.assertThat(this.findClassesToTest((Iterable<? extends Class<?>>)ImmutableList.of(EmptyTestSuite.class), new String[0])).isEmpty();
    }

    public void testFindClassesToTest_noCorrespondingTestClass() {
        Truth.assertThat(this.findClassesToTest((Iterable<? extends Class<?>>)ImmutableList.of(Foo.class), new String[0])).containsExactly(new Object[]{Foo.class});
        Truth.assertThat(this.findClassesToTest((Iterable<? extends Class<?>>)ImmutableList.of(Foo.class, Foo2Test.class), new String[0])).containsExactly(new Object[]{Foo.class});
    }

    public void testFindClassesToTest_publicApiOnly() {
        this.sanityTests.publicApiOnly();
        Truth.assertThat(this.findClassesToTest((Iterable<? extends Class<?>>)ImmutableList.of(Foo.class), new String[0])).isEmpty();
        Truth.assertThat(this.findClassesToTest((Iterable<? extends Class<?>>)ImmutableList.of(PublicFoo.class), new String[0])).contains(PublicFoo.class);
    }

    public void testFindClassesToTest_ignoreClasses() {
        this.sanityTests.ignoreClasses(Predicates.equalTo(PublicFoo.class));
        Truth.assertThat(this.findClassesToTest((Iterable<? extends Class<?>>)ImmutableList.of(PublicFoo.class), new String[0])).isEmpty();
        Truth.assertThat(this.findClassesToTest((Iterable<? extends Class<?>>)ImmutableList.of(Foo.class), new String[0])).contains(Foo.class);
    }

    public void testFindClassesToTeset_ignoreUnderscores() {
        Truth.assertThat(this.findClassesToTest((Iterable<? extends Class<?>>)ImmutableList.of(Foo.class, Foo_Bar.class), new String[0])).containsExactly(new Object[]{Foo.class, Foo_Bar.class});
        this.sanityTests.ignoreClasses(AbstractPackageSanityTests.UNDERSCORE_IN_NAME);
        Truth.assertThat(this.findClassesToTest((Iterable<? extends Class<?>>)ImmutableList.of(Foo.class, Foo_Bar.class), new String[0])).containsExactly(new Object[]{Foo.class});
    }

    public void testFindClassesToTest_withCorrespondingTestClassButNotExplicitlyTested() {
        Truth.assertThat(this.findClassesToTest((Iterable<? extends Class<?>>)ImmutableList.of(Foo.class, FooTest.class), "testNotThere")).containsExactly(new Object[]{Foo.class});
        Truth.assertThat(this.findClassesToTest((Iterable<? extends Class<?>>)ImmutableList.of(Foo.class, FooTest.class), "testNotPublic")).containsExactly(new Object[]{Foo.class});
    }

    public void testFindClassesToTest_withCorrespondingTestClassAndExplicitlyTested() {
        ImmutableList classes = ImmutableList.of(Foo.class, FooTest.class);
        Truth.assertThat(this.findClassesToTest((Iterable<? extends Class<?>>)classes, "testPublic")).isEmpty();
        Truth.assertThat(this.findClassesToTest((Iterable<? extends Class<?>>)classes, "testNotThere", "testPublic")).isEmpty();
    }

    public void testFindClassesToTest_withCorrespondingTestClass_noTestName() {
        Truth.assertThat(this.findClassesToTest((Iterable<? extends Class<?>>)ImmutableList.of(Foo.class, FooTest.class), new String[0])).containsExactly(new Object[]{Foo.class});
    }

    private List<Class<?>> findClassesToTest(Iterable<? extends Class<?>> classes, String ... explicitTestNames) {
        return this.sanityTests.findClassesToTest(classes, Arrays.asList(explicitTestNames));
    }

    static class Foo2Test {
        Foo2Test() {
        }

        public void testPublic() {
        }
    }

    static class FooTest {
        FooTest() {
        }

        public void testPublic() {
        }

        void testNotPublic() {
        }
    }

    public static class PublicFoo {
    }

    static class Foo_Bar {
        Foo_Bar() {
        }
    }

    static class Foo {
        Foo() {
        }
    }

    static class EmptyTestSuite {
        EmptyTestSuite() {
        }
    }

    static class EmptyTests {
        EmptyTests() {
        }
    }

    static class EmptyTest {
        EmptyTest() {
        }
    }

    static class EmptyTestCase {
        EmptyTestCase() {
        }
    }
}

