/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Equivalence;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.collect.BiMap;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MapConstraint;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Range;
import com.google.common.collect.RowSortedTable;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedMapDifference;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.Table;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.google.common.testing.ArbitraryInstances;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.AtomicDouble;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Currency;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import junit.framework.TestCase;

public class ArbitraryInstancesTest
extends TestCase {
    public void testGet_primitives() {
        ArbitraryInstancesTest.assertNull((Object)ArbitraryInstances.get(Void.TYPE));
        ArbitraryInstancesTest.assertNull((Object)ArbitraryInstances.get(Void.class));
        ArbitraryInstancesTest.assertEquals((Object)Boolean.FALSE, (Object)ArbitraryInstances.get(Boolean.TYPE));
        ArbitraryInstancesTest.assertEquals((Object)Boolean.FALSE, (Object)ArbitraryInstances.get(Boolean.class));
        ArbitraryInstancesTest.assertEquals((Object)Character.valueOf('\u0000'), (Object)ArbitraryInstances.get(Character.TYPE));
        ArbitraryInstancesTest.assertEquals((Object)Character.valueOf('\u0000'), (Object)ArbitraryInstances.get(Character.class));
        ArbitraryInstancesTest.assertEquals((Object)0, (Object)ArbitraryInstances.get(Byte.TYPE));
        ArbitraryInstancesTest.assertEquals((Object)0, (Object)ArbitraryInstances.get(Byte.class));
        ArbitraryInstancesTest.assertEquals((Object)0, (Object)ArbitraryInstances.get(Short.TYPE));
        ArbitraryInstancesTest.assertEquals((Object)0, (Object)ArbitraryInstances.get(Short.class));
        ArbitraryInstancesTest.assertEquals((Object)0, (Object)ArbitraryInstances.get(Integer.TYPE));
        ArbitraryInstancesTest.assertEquals((Object)0, (Object)ArbitraryInstances.get(Integer.class));
        ArbitraryInstancesTest.assertEquals((Object)0L, (Object)ArbitraryInstances.get(Long.TYPE));
        ArbitraryInstancesTest.assertEquals((Object)0L, (Object)ArbitraryInstances.get(Long.class));
        ArbitraryInstancesTest.assertEquals((Object)Float.valueOf(0.0f), (Object)ArbitraryInstances.get(Float.TYPE));
        ArbitraryInstancesTest.assertEquals((Object)Float.valueOf(0.0f), (Object)ArbitraryInstances.get(Float.class));
        ArbitraryInstancesTest.assertEquals((Object)0.0, (Object)ArbitraryInstances.get(Double.TYPE));
        ArbitraryInstancesTest.assertEquals((Object)0.0, (Object)ArbitraryInstances.get(Double.class));
        ArbitraryInstancesTest.assertEquals((Object)UnsignedInteger.ZERO, (Object)ArbitraryInstances.get(UnsignedInteger.class));
        ArbitraryInstancesTest.assertEquals((Object)UnsignedLong.ZERO, (Object)ArbitraryInstances.get(UnsignedLong.class));
        ArbitraryInstancesTest.assertEquals((int)0, (int)((BigDecimal)ArbitraryInstances.get(BigDecimal.class)).intValue());
        ArbitraryInstancesTest.assertEquals((int)0, (int)((BigInteger)ArbitraryInstances.get(BigInteger.class)).intValue());
        ArbitraryInstancesTest.assertEquals((String)"", (String)((String)ArbitraryInstances.get(String.class)));
        ArbitraryInstancesTest.assertEquals((Object)"", (Object)ArbitraryInstances.get(CharSequence.class));
        ArbitraryInstancesTest.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)ArbitraryInstances.get(TimeUnit.class));
        ArbitraryInstancesTest.assertNotNull((Object)ArbitraryInstances.get(Object.class));
        ArbitraryInstancesTest.assertEquals((Object)0, (Object)ArbitraryInstances.get(Number.class));
        ArbitraryInstancesTest.assertEquals((Object)Charsets.UTF_8, (Object)ArbitraryInstances.get(Charset.class));
    }

    public void testGet_collections() {
        ArbitraryInstancesTest.assertEquals((Object)ImmutableSet.of().iterator(), (Object)ArbitraryInstances.get(Iterator.class));
        ArbitraryInstancesTest.assertFalse((boolean)((PeekingIterator)ArbitraryInstances.get(PeekingIterator.class)).hasNext());
        ArbitraryInstancesTest.assertFalse((boolean)((ListIterator)ArbitraryInstances.get(ListIterator.class)).hasNext());
        ArbitraryInstancesTest.assertEquals((Object)ImmutableSet.of(), (Object)ArbitraryInstances.get(Iterable.class));
        ArbitraryInstancesTest.assertEquals((Object)ImmutableSet.of(), (Object)ArbitraryInstances.get(Set.class));
        ArbitraryInstancesTest.assertEquals((Object)ImmutableSet.of(), (Object)ArbitraryInstances.get(ImmutableSet.class));
        ArbitraryInstancesTest.assertEquals((Object)ImmutableSortedSet.of(), (Object)ArbitraryInstances.get(SortedSet.class));
        ArbitraryInstancesTest.assertEquals((Object)ImmutableSortedSet.of(), (Object)ArbitraryInstances.get(ImmutableSortedSet.class));
        ArbitraryInstancesTest.assertEquals((Object)ImmutableList.of(), (Object)ArbitraryInstances.get(Collection.class));
        ArbitraryInstancesTest.assertEquals((Object)ImmutableList.of(), (Object)ArbitraryInstances.get(ImmutableCollection.class));
        ArbitraryInstancesTest.assertEquals((Object)ImmutableList.of(), (Object)ArbitraryInstances.get(List.class));
        ArbitraryInstancesTest.assertEquals((Object)ImmutableList.of(), (Object)ArbitraryInstances.get(ImmutableList.class));
        ArbitraryInstancesTest.assertEquals((Object)ImmutableMap.of(), (Object)ArbitraryInstances.get(Map.class));
        ArbitraryInstancesTest.assertEquals((Object)ImmutableMap.of(), (Object)ArbitraryInstances.get(ImmutableMap.class));
        ArbitraryInstancesTest.assertEquals((Object)ImmutableSortedMap.of(), (Object)ArbitraryInstances.get(SortedMap.class));
        ArbitraryInstancesTest.assertEquals((Object)ImmutableSortedMap.of(), (Object)ArbitraryInstances.get(ImmutableSortedMap.class));
        ArbitraryInstancesTest.assertEquals((Object)ImmutableMultiset.of(), (Object)ArbitraryInstances.get(Multiset.class));
        ArbitraryInstancesTest.assertEquals((Object)ImmutableMultiset.of(), (Object)ArbitraryInstances.get(ImmutableMultiset.class));
        ArbitraryInstancesTest.assertTrue((boolean)((SortedMultiset)ArbitraryInstances.get(SortedMultiset.class)).isEmpty());
        ArbitraryInstancesTest.assertEquals((Object)ImmutableMultimap.of(), (Object)ArbitraryInstances.get(Multimap.class));
        ArbitraryInstancesTest.assertEquals((Object)ImmutableMultimap.of(), (Object)ArbitraryInstances.get(ImmutableMultimap.class));
        ArbitraryInstancesTest.assertTrue((boolean)((SortedSetMultimap)ArbitraryInstances.get(SortedSetMultimap.class)).isEmpty());
        ArbitraryInstancesTest.assertEquals((Object)ImmutableTable.of(), (Object)ArbitraryInstances.get(Table.class));
        ArbitraryInstancesTest.assertEquals((Object)ImmutableTable.of(), (Object)ArbitraryInstances.get(ImmutableTable.class));
        ArbitraryInstancesTest.assertTrue((boolean)((RowSortedTable)ArbitraryInstances.get(RowSortedTable.class)).isEmpty());
        ArbitraryInstancesTest.assertEquals((Object)ImmutableBiMap.of(), (Object)ArbitraryInstances.get(BiMap.class));
        ArbitraryInstancesTest.assertEquals((Object)ImmutableBiMap.of(), (Object)ArbitraryInstances.get(ImmutableBiMap.class));
        ArbitraryInstancesTest.assertTrue((boolean)((ImmutableClassToInstanceMap)ArbitraryInstances.get(ImmutableClassToInstanceMap.class)).isEmpty());
        ArbitraryInstancesTest.assertTrue((boolean)((ClassToInstanceMap)ArbitraryInstances.get(ClassToInstanceMap.class)).isEmpty());
        ArbitraryInstancesTest.assertTrue((boolean)((ListMultimap)ArbitraryInstances.get(ListMultimap.class)).isEmpty());
        ArbitraryInstancesTest.assertTrue((boolean)((ImmutableListMultimap)ArbitraryInstances.get(ImmutableListMultimap.class)).isEmpty());
        ArbitraryInstancesTest.assertTrue((boolean)((SetMultimap)ArbitraryInstances.get(SetMultimap.class)).isEmpty());
        ArbitraryInstancesTest.assertTrue((boolean)((ImmutableSetMultimap)ArbitraryInstances.get(ImmutableSetMultimap.class)).isEmpty());
        ArbitraryInstancesTest.assertTrue((boolean)((MapDifference)ArbitraryInstances.get(MapDifference.class)).areEqual());
        ArbitraryInstancesTest.assertTrue((boolean)((SortedMapDifference)ArbitraryInstances.get(SortedMapDifference.class)).areEqual());
        ArbitraryInstancesTest.assertEquals((Object)Range.all(), (Object)ArbitraryInstances.get(Range.class));
        ArbitraryInstancesTest.assertTrue((boolean)((NavigableSet)ArbitraryInstances.get(NavigableSet.class)).isEmpty());
        ArbitraryInstancesTest.assertTrue((boolean)((NavigableMap)ArbitraryInstances.get(NavigableMap.class)).isEmpty());
        ArbitraryInstancesTest.assertTrue((boolean)((LinkedList)ArbitraryInstances.get(LinkedList.class)).isEmpty());
        ArbitraryInstancesTest.assertTrue((boolean)((Deque)ArbitraryInstances.get(Deque.class)).isEmpty());
        ArbitraryInstancesTest.assertTrue((boolean)((Queue)ArbitraryInstances.get(Queue.class)).isEmpty());
        ArbitraryInstancesTest.assertTrue((boolean)((PriorityQueue)ArbitraryInstances.get(PriorityQueue.class)).isEmpty());
        ArbitraryInstancesTest.assertTrue((boolean)((BitSet)ArbitraryInstances.get(BitSet.class)).isEmpty());
        ArbitraryInstancesTest.assertTrue((boolean)((TreeSet)ArbitraryInstances.get(TreeSet.class)).isEmpty());
        ArbitraryInstancesTest.assertTrue((boolean)((TreeMap)ArbitraryInstances.get(TreeMap.class)).isEmpty());
        ArbitraryInstancesTest.assertFreshInstanceReturned(LinkedList.class, Deque.class, Queue.class, PriorityQueue.class, BitSet.class, TreeSet.class, TreeMap.class);
    }

    public void testGet_misc() {
        ArbitraryInstancesTest.assertNotNull((Object)ArbitraryInstances.get(CharMatcher.class));
        ArbitraryInstancesTest.assertNotNull((Object)((Currency)ArbitraryInstances.get(Currency.class)).getCurrencyCode());
        ArbitraryInstancesTest.assertNotNull((Object)ArbitraryInstances.get(Locale.class));
        ArbitraryInstancesTest.assertNotNull((Object)((Joiner)ArbitraryInstances.get(Joiner.class)).join((Iterable)ImmutableList.of((Object)"a")));
        ArbitraryInstancesTest.assertNotNull((Object)((Splitter)ArbitraryInstances.get(Splitter.class)).split((CharSequence)"a,b"));
        Truth.assertThat((Optional)((Optional)ArbitraryInstances.get(Optional.class))).isAbsent();
        ((Stopwatch)ArbitraryInstances.get(Stopwatch.class)).start();
        ArbitraryInstancesTest.assertNotNull((Object)ArbitraryInstances.get(Ticker.class));
        ArbitraryInstancesTest.assertNotNull((Object)ArbitraryInstances.get(MapConstraint.class));
        ArbitraryInstancesTest.assertFreshInstanceReturned(Random.class);
        ArbitraryInstancesTest.assertEquals((int)((Random)ArbitraryInstances.get(Random.class)).nextInt(), (int)((Random)ArbitraryInstances.get(Random.class)).nextInt());
    }

    public void testGet_concurrent() {
        ArbitraryInstancesTest.assertTrue((boolean)((BlockingDeque)ArbitraryInstances.get(BlockingDeque.class)).isEmpty());
        ArbitraryInstancesTest.assertTrue((boolean)((BlockingQueue)ArbitraryInstances.get(BlockingQueue.class)).isEmpty());
        ArbitraryInstancesTest.assertTrue((boolean)((DelayQueue)ArbitraryInstances.get(DelayQueue.class)).isEmpty());
        ArbitraryInstancesTest.assertTrue((boolean)((SynchronousQueue)ArbitraryInstances.get(SynchronousQueue.class)).isEmpty());
        ArbitraryInstancesTest.assertTrue((boolean)((PriorityBlockingQueue)ArbitraryInstances.get(PriorityBlockingQueue.class)).isEmpty());
        ArbitraryInstancesTest.assertTrue((boolean)((ConcurrentMap)ArbitraryInstances.get(ConcurrentMap.class)).isEmpty());
        ArbitraryInstancesTest.assertTrue((boolean)((ConcurrentNavigableMap)ArbitraryInstances.get(ConcurrentNavigableMap.class)).isEmpty());
        ((Executor)ArbitraryInstances.get(Executor.class)).execute((Runnable)ArbitraryInstances.get(Runnable.class));
        ArbitraryInstancesTest.assertNotNull((Object)ArbitraryInstances.get(ThreadFactory.class));
        ArbitraryInstancesTest.assertFreshInstanceReturned(BlockingQueue.class, BlockingDeque.class, PriorityBlockingQueue.class, DelayQueue.class, SynchronousQueue.class, ConcurrentMap.class, ConcurrentNavigableMap.class, AtomicReference.class, AtomicBoolean.class, AtomicInteger.class, AtomicLong.class, AtomicDouble.class);
    }

    public void testGet_functors() {
        ArbitraryInstancesTest.assertEquals((int)0, (int)((Comparator)ArbitraryInstances.get(Comparator.class)).compare("abc", 123));
        ArbitraryInstancesTest.assertTrue((boolean)((Predicate)ArbitraryInstances.get(Predicate.class)).apply((Object)"abc"));
        ArbitraryInstancesTest.assertTrue((boolean)((Equivalence)ArbitraryInstances.get(Equivalence.class)).equivalent((Object)1, (Object)1));
        ArbitraryInstancesTest.assertFalse((boolean)((Equivalence)ArbitraryInstances.get(Equivalence.class)).equivalent((Object)1, (Object)2));
    }

    public void testGet_comparable() {
        Comparable comparable = (Comparable)ArbitraryInstances.get(Comparable.class);
        ArbitraryInstancesTest.assertEquals((int)0, (int)comparable.compareTo(comparable));
        ArbitraryInstancesTest.assertTrue((comparable.compareTo("") > 0 ? 1 : 0) != 0);
        try {
            comparable.compareTo(null);
            ArbitraryInstancesTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGet_array() {
        Truth.assertThat((int[])((int[])ArbitraryInstances.get(int[].class))).isEmpty();
        Truth.assertThat((Object[])((Object[])ArbitraryInstances.get(Object[].class))).isEmpty();
        Truth.assertThat((Object[])((Object[])ArbitraryInstances.get(String[].class))).isEmpty();
    }

    public void testGet_enum() {
        ArbitraryInstancesTest.assertNull((Object)ArbitraryInstances.get(EmptyEnum.class));
        ArbitraryInstancesTest.assertEquals((Object)((Object)Direction.UP), (Object)ArbitraryInstances.get(Direction.class));
    }

    public void testGet_interface() {
        ArbitraryInstancesTest.assertNull((Object)ArbitraryInstances.get(SomeInterface.class));
    }

    public void testGet_runnable() {
        ((Runnable)ArbitraryInstances.get(Runnable.class)).run();
    }

    public void testGet_class() {
        ArbitraryInstancesTest.assertSame((Object)SomeAbstractClass.INSTANCE, (Object)ArbitraryInstances.get(SomeAbstractClass.class));
        ArbitraryInstancesTest.assertSame((Object)WithPrivateConstructor.INSTANCE, (Object)ArbitraryInstances.get(WithPrivateConstructor.class));
        ArbitraryInstancesTest.assertNull((Object)ArbitraryInstances.get(NoDefaultConstructor.class));
        ArbitraryInstancesTest.assertSame((Object)WithExceptionalConstructor.INSTANCE, (Object)ArbitraryInstances.get(WithExceptionalConstructor.class));
        ArbitraryInstancesTest.assertNull((Object)ArbitraryInstances.get(NonPublicClass.class));
    }

    public void testGet_mutable() {
        ArbitraryInstancesTest.assertEquals((int)0, (int)((ArrayList)ArbitraryInstances.get(ArrayList.class)).size());
        ArbitraryInstancesTest.assertEquals((int)0, (int)((HashMap)ArbitraryInstances.get(HashMap.class)).size());
        Truth.assertThat((String)((Appendable)ArbitraryInstances.get(Appendable.class)).toString()).isEmpty();
        Truth.assertThat((String)((StringBuilder)ArbitraryInstances.get(StringBuilder.class)).toString()).isEmpty();
        Truth.assertThat((String)((StringBuffer)ArbitraryInstances.get(StringBuffer.class)).toString()).isEmpty();
        ArbitraryInstancesTest.assertFreshInstanceReturned(ArrayList.class, HashMap.class, Appendable.class, StringBuilder.class, StringBuffer.class, Throwable.class, Exception.class);
    }

    public void testGet_io() throws IOException {
        ArbitraryInstancesTest.assertEquals((int)-1, (int)((InputStream)ArbitraryInstances.get(InputStream.class)).read());
        ArbitraryInstancesTest.assertEquals((int)-1, (int)((ByteArrayInputStream)ArbitraryInstances.get(ByteArrayInputStream.class)).read());
        ArbitraryInstancesTest.assertEquals((int)-1, (int)((Readable)ArbitraryInstances.get(Readable.class)).read(CharBuffer.allocate(1)));
        ArbitraryInstancesTest.assertEquals((int)-1, (int)((Reader)ArbitraryInstances.get(Reader.class)).read());
        ArbitraryInstancesTest.assertEquals((int)-1, (int)((StringReader)ArbitraryInstances.get(StringReader.class)).read());
        ArbitraryInstancesTest.assertEquals((int)0, (int)((Buffer)ArbitraryInstances.get(Buffer.class)).capacity());
        ArbitraryInstancesTest.assertEquals((int)0, (int)((CharBuffer)ArbitraryInstances.get(CharBuffer.class)).capacity());
        ArbitraryInstancesTest.assertEquals((int)0, (int)((ByteBuffer)ArbitraryInstances.get(ByteBuffer.class)).capacity());
        ArbitraryInstancesTest.assertEquals((int)0, (int)((ShortBuffer)ArbitraryInstances.get(ShortBuffer.class)).capacity());
        ArbitraryInstancesTest.assertEquals((int)0, (int)((IntBuffer)ArbitraryInstances.get(IntBuffer.class)).capacity());
        ArbitraryInstancesTest.assertEquals((int)0, (int)((LongBuffer)ArbitraryInstances.get(LongBuffer.class)).capacity());
        ArbitraryInstancesTest.assertEquals((int)0, (int)((FloatBuffer)ArbitraryInstances.get(FloatBuffer.class)).capacity());
        ArbitraryInstancesTest.assertEquals((int)0, (int)((DoubleBuffer)ArbitraryInstances.get(DoubleBuffer.class)).capacity());
        ((PrintStream)ArbitraryInstances.get(PrintStream.class)).println("test");
        ((PrintWriter)ArbitraryInstances.get(PrintWriter.class)).println("test");
        ArbitraryInstancesTest.assertNotNull((Object)ArbitraryInstances.get(File.class));
        ArbitraryInstancesTest.assertFreshInstanceReturned(ByteArrayOutputStream.class, OutputStream.class, Writer.class, StringWriter.class, PrintStream.class, PrintWriter.class);
        ArbitraryInstancesTest.assertEquals((Object)ByteSource.empty(), (Object)ArbitraryInstances.get(ByteSource.class));
        ArbitraryInstancesTest.assertEquals((Object)CharSource.empty(), (Object)ArbitraryInstances.get(CharSource.class));
        ArbitraryInstancesTest.assertNotNull((Object)ArbitraryInstances.get(ByteSink.class));
        ArbitraryInstancesTest.assertNotNull((Object)ArbitraryInstances.get(CharSink.class));
    }

    public void testGet_reflect() {
        ArbitraryInstancesTest.assertNotNull((Object)ArbitraryInstances.get(Type.class));
        ArbitraryInstancesTest.assertNotNull((Object)ArbitraryInstances.get(AnnotatedElement.class));
        ArbitraryInstancesTest.assertNotNull((Object)ArbitraryInstances.get(GenericDeclaration.class));
    }

    public void testGet_regex() {
        ArbitraryInstancesTest.assertEquals((String)Pattern.compile("").pattern(), (String)((Pattern)ArbitraryInstances.get(Pattern.class)).pattern());
        ArbitraryInstancesTest.assertEquals((int)0, (int)((MatchResult)ArbitraryInstances.get(MatchResult.class)).groupCount());
    }

    public void testGet_usePublicConstant() {
        ArbitraryInstancesTest.assertSame((Object)WithPublicConstant.INSTANCE, (Object)ArbitraryInstances.get(WithPublicConstant.class));
    }

    public void testGet_useFirstPublicConstant() {
        ArbitraryInstancesTest.assertSame((Object)WithPublicConstants.FIRST, (Object)ArbitraryInstances.get(WithPublicConstants.class));
    }

    public void testGet_nullConstantIgnored() {
        ArbitraryInstancesTest.assertSame((Object)FirstConstantIsNull.SECOND, (Object)ArbitraryInstances.get(FirstConstantIsNull.class));
    }

    public void testGet_constantWithGenericsNotUsed() {
        ArbitraryInstancesTest.assertNull((Object)ArbitraryInstances.get(WithGenericConstant.class));
    }

    public void testGet_nullConstant() {
        ArbitraryInstancesTest.assertNull((Object)ArbitraryInstances.get(WithNullConstant.class));
    }

    public void testGet_constantTypeDoesNotMatch() {
        ArbitraryInstancesTest.assertNull((Object)ArbitraryInstances.get(ParentClassHasConstant.class));
    }

    public void testGet_nonPublicConstantNotUsed() {
        ArbitraryInstancesTest.assertNull((Object)ArbitraryInstances.get(NonPublicConstantIgnored.class));
    }

    public void testGet_nonStaticFieldNotUsed() {
        ArbitraryInstancesTest.assertNull((Object)ArbitraryInstances.get(NonStaticFieldIgnored.class));
    }

    public void testGet_constructorPreferredOverConstants() {
        ArbitraryInstancesTest.assertNotNull((Object)ArbitraryInstances.get(WithPublicConstructorAndConstant.class));
        ArbitraryInstancesTest.assertTrue((ArbitraryInstances.get(WithPublicConstructorAndConstant.class) != ArbitraryInstances.get(WithPublicConstructorAndConstant.class) ? 1 : 0) != 0);
    }

    public void testGet_nonFinalFieldNotUsed() {
        ArbitraryInstancesTest.assertNull((Object)ArbitraryInstances.get(NonFinalFieldIgnored.class));
    }

    private static void assertFreshInstanceReturned(Class<?> ... mutableClasses) {
        for (Class<?> mutableClass : mutableClasses) {
            Object instance = ArbitraryInstances.get(mutableClass);
            ArbitraryInstancesTest.assertNotNull((String)("Expected to return non-null for: " + mutableClass), (Object)instance);
            ArbitraryInstancesTest.assertNotSame((String)("Expected to return fresh instance for: " + mutableClass), (Object)instance, (Object)ArbitraryInstances.get(mutableClass));
        }
    }

    public static class NonStaticFieldIgnored {
        public final NonStaticFieldIgnored instance = new NonStaticFieldIgnored();

        private NonStaticFieldIgnored() {
        }
    }

    public static class NonPublicConstantIgnored {
        static final NonPublicConstantIgnored INSTANCE = new NonPublicConstantIgnored();

        private NonPublicConstantIgnored() {
        }
    }

    public static class NonFinalFieldIgnored {
        public static NonFinalFieldIgnored instance = new NonFinalFieldIgnored();

        private NonFinalFieldIgnored() {
        }
    }

    private static class FirstConstantIsNull {
        public static final FirstConstantIsNull FIRST = null;
        public static final FirstConstantIsNull SECOND = new FirstConstantIsNull();

        private FirstConstantIsNull() {
        }
    }

    private static class WithPublicConstants {
        public static final WithPublicConstants FIRST = new WithPublicConstants();
        public static final WithPublicConstants SECOND = new WithPublicConstants();

        private WithPublicConstants() {
        }
    }

    public static class WithPublicConstructorAndConstant {
        public static final WithPublicConstructorAndConstant INSTANCE = new WithPublicConstructorAndConstant();
    }

    public static class WithNullConstant {
        public static final WithNullConstant NULL = null;

        private WithNullConstant() {
        }
    }

    public static class WithGenericConstant<T> {
        public static final WithGenericConstant<String> STRING_CONSTANT = new WithGenericConstant();

        private WithGenericConstant() {
        }
    }

    private static class ParentClassHasConstant
    extends WithPublicConstant {
        private ParentClassHasConstant() {
        }
    }

    private static class WithPublicConstant {
        public static final WithPublicConstant INSTANCE = new WithPublicConstant();

        private WithPublicConstant() {
        }
    }

    public static class WithExceptionalConstructor {
        public static final WithExceptionalConstructor INSTANCE = new WithExceptionalConstructor("whatever");

        public WithExceptionalConstructor() {
            throw new RuntimeException();
        }

        private WithExceptionalConstructor(String unused) {
        }
    }

    public static class NoDefaultConstructor {
        public NoDefaultConstructor(int i) {
        }
    }

    private static class WithPrivateConstructor {
        public static final WithPrivateConstructor INSTANCE = new WithPrivateConstructor();

        private WithPrivateConstructor() {
        }
    }

    static class NonPublicClass {
    }

    public static abstract class SomeAbstractClass {
        public static final SomeAbstractClass INSTANCE = new SomeAbstractClass(){};
    }

    public static interface SomeInterface {
    }

    private static enum Direction {
        UP,
        DOWN;

    }

    private static enum EmptyEnum {

    }
}

