/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.testing.ClassSanityTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class ClassSanityTesterTest
extends TestCase {
    private final ClassSanityTester tester = new ClassSanityTester();

    public void testEqualsOnReturnValues_good() throws Exception {
        this.tester.forAllPublicStaticMethods(GoodEqualsFactory.class).testEquals();
    }

    public void testForAllPublicStaticMethods_noPublicStaticMethods() throws Exception {
        try {
            this.tester.forAllPublicStaticMethods(NoPublicStaticMethods.class).testEquals();
        }
        catch (AssertionFailedError expected) {
            Truth.assertThat((Throwable)expected).hasMessage("No public static methods that return java.lang.Object or subtype are found in " + NoPublicStaticMethods.class + ".");
            return;
        }
        ClassSanityTesterTest.fail();
    }

    public void testEqualsOnReturnValues_bad() throws Exception {
        try {
            this.tester.forAllPublicStaticMethods(BadEqualsFactory.class).testEquals();
        }
        catch (AssertionFailedError expected) {
            return;
        }
        ClassSanityTesterTest.fail();
    }

    public void testNullsOnReturnValues_good() throws Exception {
        this.tester.forAllPublicStaticMethods(GoodNullsFactory.class).testNulls();
    }

    public void testNullsOnReturnValues_bad() throws Exception {
        try {
            this.tester.forAllPublicStaticMethods(BadNullsFactory.class).thatReturn(Object.class).testNulls();
        }
        catch (AssertionFailedError expected) {
            return;
        }
        ClassSanityTesterTest.fail();
    }

    public void testNullsOnReturnValues_returnTypeFiltered() throws Exception {
        try {
            this.tester.forAllPublicStaticMethods(BadNullsFactory.class).thatReturn(Iterable.class).testNulls();
        }
        catch (AssertionFailedError expected) {
            Truth.assertThat((Throwable)expected).hasMessage("No public static methods that return java.lang.Iterable or subtype are found in " + BadNullsFactory.class + ".");
            return;
        }
        ClassSanityTesterTest.fail();
    }

    public void testSerializableOnReturnValues_good() throws Exception {
        this.tester.forAllPublicStaticMethods(GoodSerializableFactory.class).testSerializable();
    }

    public void testSerializableOnReturnValues_bad() throws Exception {
        try {
            this.tester.forAllPublicStaticMethods(BadSerializableFactory.class).testSerializable();
        }
        catch (AssertionError expected) {
            return;
        }
        ClassSanityTesterTest.fail();
    }

    public void testEqualsAndSerializableOnReturnValues_equalsIsGoodButNotSerializable() throws Exception {
        try {
            this.tester.forAllPublicStaticMethods(GoodEqualsFactory.class).testEqualsAndSerializable();
        }
        catch (AssertionError expected) {
            return;
        }
        ClassSanityTesterTest.fail((String)"should have failed");
    }

    public void testEqualsAndSerializableOnReturnValues_serializableButNotEquals() throws Exception {
        try {
            this.tester.forAllPublicStaticMethods(GoodSerializableFactory.class).testEqualsAndSerializable();
        }
        catch (AssertionFailedError expected) {
            return;
        }
        ClassSanityTesterTest.fail((String)"should have failed");
    }

    public void testEqualsAndSerializableOnReturnValues_good() throws Exception {
        this.tester.forAllPublicStaticMethods(GoodEqualsAndSerialiableFactory.class).testEqualsAndSerializable();
    }

    public void testEqualsForReturnValues_factoryReturnsNullButNotAnnotated() throws Exception {
        try {
            this.tester.forAllPublicStaticMethods(FactoryThatReturnsNullButNotAnnotated.class).testEquals();
        }
        catch (AssertionFailedError expected) {
            return;
        }
        ClassSanityTesterTest.fail();
    }

    public void testNullsForReturnValues_factoryReturnsNullButNotAnnotated() throws Exception {
        try {
            this.tester.forAllPublicStaticMethods(FactoryThatReturnsNullButNotAnnotated.class).testNulls();
        }
        catch (AssertionFailedError expected) {
            return;
        }
        ClassSanityTesterTest.fail();
    }

    public void testSerializableForReturnValues_factoryReturnsNullButNotAnnotated() throws Exception {
        try {
            this.tester.forAllPublicStaticMethods(FactoryThatReturnsNullButNotAnnotated.class).testSerializable();
        }
        catch (AssertionFailedError expected) {
            return;
        }
        ClassSanityTesterTest.fail();
    }

    public void testEqualsAndSerializableForReturnValues_factoryReturnsNullButNotAnnotated() throws Exception {
        try {
            this.tester.forAllPublicStaticMethods(FactoryThatReturnsNullButNotAnnotated.class).testEqualsAndSerializable();
        }
        catch (AssertionFailedError expected) {
            return;
        }
        ClassSanityTesterTest.fail();
    }

    public void testEqualsForReturnValues_factoryReturnsNullAndAnnotated() throws Exception {
        this.tester.forAllPublicStaticMethods(FactoryThatReturnsNullAndAnnotated.class).testEquals();
    }

    public void testNullsForReturnValues_factoryReturnsNullAndAnnotated() throws Exception {
        this.tester.forAllPublicStaticMethods(FactoryThatReturnsNullAndAnnotated.class).testNulls();
    }

    public void testSerializableForReturnValues_factoryReturnsNullAndAnnotated() throws Exception {
        this.tester.forAllPublicStaticMethods(FactoryThatReturnsNullAndAnnotated.class).testSerializable();
    }

    public void testEqualsAndSerializableForReturnValues_factoryReturnsNullAndAnnotated() throws Exception {
        this.tester.forAllPublicStaticMethods(FactoryThatReturnsNullAndAnnotated.class).testEqualsAndSerializable();
    }

    public void testGoodEquals() throws Exception {
        this.tester.testEquals(GoodEquals.class);
    }

    public void testEquals_interface() {
        this.tester.testEquals(AnInterface.class);
    }

    public void testEquals_abstractClass() {
        this.tester.testEquals(AnAbstractClass.class);
    }

    public void testEquals_enum() {
        this.tester.testEquals(OneConstantEnum.class);
    }

    public void testBadEquals() throws Exception {
        try {
            this.tester.testEquals(BadEquals.class);
        }
        catch (AssertionFailedError expected) {
            Truth.assertThat((String)expected.getMessage()).contains((CharSequence)"create(null)");
            return;
        }
        ClassSanityTesterTest.fail((String)"should have failed");
    }

    public void testBadEquals_withParameterizedType() throws Exception {
        try {
            this.tester.testEquals(BadEqualsWithParameterizedType.class);
        }
        catch (AssertionFailedError expected) {
            Truth.assertThat((String)expected.getMessage()).contains((CharSequence)"create([[1]])");
            return;
        }
        ClassSanityTesterTest.fail((String)"should have failed");
    }

    public void testBadEquals_withSingleParameterValue() throws Exception {
        try {
            this.tester.doTestEquals(ConstructorParameterWithOptionalNotInstantiable.class);
            ClassSanityTesterTest.fail();
        }
        catch (ClassSanityTester.ParameterHasNoDistinctValueException parameterHasNoDistinctValueException) {
            // empty catch block
        }
    }

    public void testGoodReferentialEqualityComparison() throws Exception {
        this.tester.testEquals(UsesEnum.class);
        this.tester.testEquals(UsesReferentialEquality.class);
        this.tester.testEquals(SameListInstance.class);
    }

    public void testEqualsUsingReferentialEquality() throws Exception {
        this.assertBadUseOfReferentialEquality(SameIntegerInstance.class);
        this.assertBadUseOfReferentialEquality(SameLongInstance.class);
        this.assertBadUseOfReferentialEquality(SameFloatInstance.class);
        this.assertBadUseOfReferentialEquality(SameDoubleInstance.class);
        this.assertBadUseOfReferentialEquality(SameShortInstance.class);
        this.assertBadUseOfReferentialEquality(SameByteInstance.class);
        this.assertBadUseOfReferentialEquality(SameCharacterInstance.class);
        this.assertBadUseOfReferentialEquality(SameBooleanInstance.class);
        this.assertBadUseOfReferentialEquality(SameObjectInstance.class);
        this.assertBadUseOfReferentialEquality(SameStringInstance.class);
        this.assertBadUseOfReferentialEquality(SameInterfaceInstance.class);
    }

    private void assertBadUseOfReferentialEquality(Class<?> cls) throws Exception {
        try {
            this.tester.testEquals(cls);
        }
        catch (AssertionFailedError expected) {
            Truth.assertThat((String)expected.getMessage()).contains((CharSequence)(cls.getSimpleName() + "("));
            return;
        }
        ClassSanityTesterTest.fail((String)"should have failed");
    }

    public void testParameterNotInstantiableForEqualsTest() throws Exception {
        try {
            this.tester.doTestEquals(ConstructorParameterNotInstantiable.class);
            ClassSanityTesterTest.fail((String)"should have failed");
        }
        catch (ClassSanityTester.ParameterNotInstantiableException parameterNotInstantiableException) {
            // empty catch block
        }
    }

    public void testNoDistinctValueForEqualsTest() throws Exception {
        try {
            this.tester.doTestEquals(ConstructorParameterSingleValue.class);
            ClassSanityTesterTest.fail((String)"should have failed");
        }
        catch (ClassSanityTester.ParameterHasNoDistinctValueException parameterHasNoDistinctValueException) {
            // empty catch block
        }
    }

    public void testConstructorThrowsForEqualsTest() throws Exception {
        try {
            this.tester.doTestEquals(ConstructorThrows.class);
            ClassSanityTesterTest.fail((String)"should have failed");
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public void testFactoryMethodReturnsNullForEqualsTest() throws Exception {
        try {
            this.tester.doTestEquals(FactoryMethodReturnsNullAndAnnotated.class);
            ClassSanityTesterTest.fail((String)"should have failed");
        }
        catch (ClassSanityTester.FactoryMethodReturnsNullException factoryMethodReturnsNullException) {
            // empty catch block
        }
    }

    public void testFactoryMethodReturnsNullButNotAnnotatedInEqualsTest() throws Exception {
        try {
            this.tester.testEquals(FactoryMethodReturnsNullButNotAnnotated.class);
        }
        catch (AssertionFailedError expected) {
            return;
        }
        ClassSanityTesterTest.fail((String)"should have failed");
    }

    public void testNoEqualsChecksOnEnum() throws Exception {
        this.tester.testEquals(OneConstantEnum.class);
        this.tester.testEquals(NoConstantEnum.class);
        this.tester.testEquals(TimeUnit.class);
    }

    public void testNoEqualsChecksOnInterface() throws Exception {
        this.tester.testEquals(Runnable.class);
    }

    public void testNoEqualsChecksOnAnnotation() throws Exception {
        this.tester.testEquals(Nullable.class);
    }

    public void testGoodNulls() throws Exception {
        this.tester.testNulls(GoodNulls.class);
    }

    public void testNoNullCheckNeededDespitNotInstantiable() throws Exception {
        this.tester.doTestNulls(NoNullCheckNeededDespitNotInstantiable.class, NullPointerTester.Visibility.PACKAGE);
    }

    public void testNulls_interface() {
        this.tester.testNulls(AnInterface.class);
    }

    public void testNulls_abstractClass() {
        this.tester.testNulls(AnAbstractClass.class);
    }

    public void testNulls_enum() throws Exception {
        this.tester.testNulls(OneConstantEnum.class);
        this.tester.testNulls(NoConstantEnum.class);
        this.tester.testNulls(TimeUnit.class);
    }

    public void testNulls_parameterOptionalNotInstantiable() throws Exception {
        this.tester.testNulls(ConstructorParameterWithOptionalNotInstantiable.class);
    }

    public void testEnumFailsToCheckNull() throws Exception {
        try {
            this.tester.testNulls(EnumFailsToCheckNull.class);
        }
        catch (AssertionFailedError expected) {
            return;
        }
        ClassSanityTesterTest.fail((String)"should have failed");
    }

    public void testNoNullChecksOnInterface() throws Exception {
        this.tester.testNulls(Runnable.class);
    }

    public void testNoNullChecksOnAnnotation() throws Exception {
        this.tester.testNulls(Nullable.class);
    }

    public void testBadNulls() throws Exception {
        try {
            this.tester.testNulls(BadNulls.class);
        }
        catch (AssertionFailedError expected) {
            return;
        }
        ClassSanityTesterTest.fail((String)"should have failed");
    }

    public void testInstantiate_factoryMethodReturnsNullButNotAnnotated() throws Exception {
        try {
            this.tester.instantiate(FactoryMethodReturnsNullButNotAnnotated.class);
        }
        catch (AssertionFailedError expected) {
            Truth.assertThat((String)expected.getMessage()).contains((CharSequence)"@Nullable");
            return;
        }
        ClassSanityTesterTest.fail((String)"should have failed");
    }

    public void testInstantiate_factoryMethodReturnsNullAndAnnotated() throws Exception {
        try {
            this.tester.instantiate(FactoryMethodReturnsNullAndAnnotated.class);
            ClassSanityTesterTest.fail((String)"should have failed");
        }
        catch (ClassSanityTester.FactoryMethodReturnsNullException factoryMethodReturnsNullException) {
            // empty catch block
        }
    }

    public void testInstantiate_factoryMethodAcceptsNull() throws Exception {
        ClassSanityTesterTest.assertNull((Object)((FactoryMethodAcceptsNull)this.tester.instantiate(FactoryMethodAcceptsNull.class)).name);
    }

    public void testInstantiate_factoryMethodDoesNotAcceptNull() throws Exception {
        ClassSanityTesterTest.assertNotNull((Object)((FactoryMethodDoesNotAcceptNull)this.tester.instantiate(FactoryMethodDoesNotAcceptNull.class)).name);
    }

    public void testInstantiate_constructorAcceptsNull() throws Exception {
        ClassSanityTesterTest.assertNull((Object)((ConstructorAcceptsNull)this.tester.instantiate(ConstructorAcceptsNull.class)).name);
    }

    public void testInstantiate_constructorDoesNotAcceptNull() throws Exception {
        ClassSanityTesterTest.assertNotNull((Object)((ConstructorDoesNotAcceptNull)this.tester.instantiate(ConstructorDoesNotAcceptNull.class)).name);
    }

    public void testInstantiate_notInstantiable() throws Exception {
        ClassSanityTesterTest.assertNull((Object)this.tester.instantiate(NotInstantiable.class));
    }

    public void testInstantiate_noConstantEnum() throws Exception {
        ClassSanityTesterTest.assertNull((Object)this.tester.instantiate(NoConstantEnum.class));
    }

    public void testInstantiate_oneConstantEnum() throws Exception {
        ClassSanityTesterTest.assertEquals((Object)((Object)OneConstantEnum.A), (Object)this.tester.instantiate(OneConstantEnum.class));
    }

    public void testInstantiate_interface() throws Exception {
        ClassSanityTesterTest.assertNull((Object)this.tester.instantiate(Runnable.class));
    }

    public void testInstantiate_abstractClass() throws Exception {
        ClassSanityTesterTest.assertNull((Object)this.tester.instantiate(AbstractList.class));
    }

    public void testInstantiate_annotation() throws Exception {
        ClassSanityTesterTest.assertNull((Object)this.tester.instantiate(Nullable.class));
    }

    public void testInstantiate_setDefault() throws Exception {
        NotInstantiable x = new NotInstantiable();
        this.tester.setDefault(NotInstantiable.class, (Object)x);
        ClassSanityTesterTest.assertNotNull((Object)this.tester.instantiate(ConstructorParameterNotInstantiable.class));
    }

    public void testSetDistinctValues_equalInstances() {
        try {
            this.tester.setDistinctValues(String.class, (Object)"", (Object)"");
            ClassSanityTesterTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInstantiate_setDistinctValues() throws Exception {
        NotInstantiable x = new NotInstantiable();
        NotInstantiable y = new NotInstantiable();
        this.tester.setDistinctValues(NotInstantiable.class, (Object)x, (Object)y);
        ClassSanityTesterTest.assertNotNull((Object)this.tester.instantiate(ConstructorParameterNotInstantiable.class));
        this.tester.testEquals(ConstructorParameterMapOfNotInstantiable.class);
    }

    public void testInstantiate_setSampleInstances_empty() throws Exception {
        this.tester.setSampleInstances(NotInstantiable.class, (Iterable)ImmutableList.of());
        try {
            this.tester.instantiate(ConstructorParameterNotInstantiable.class);
            ClassSanityTesterTest.fail();
        }
        catch (ClassSanityTester.ParameterNotInstantiableException parameterNotInstantiableException) {
            // empty catch block
        }
    }

    public void testInstantiate_constructorThrows() throws Exception {
        try {
            this.tester.instantiate(ConstructorThrows.class);
            ClassSanityTesterTest.fail();
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public void testInstantiate_factoryMethodThrows() throws Exception {
        try {
            this.tester.instantiate(FactoryMethodThrows.class);
            ClassSanityTesterTest.fail();
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public void testInstantiate_constructorParameterNotInstantiable() throws Exception {
        try {
            this.tester.instantiate(ConstructorParameterNotInstantiable.class);
            ClassSanityTesterTest.fail();
        }
        catch (ClassSanityTester.ParameterNotInstantiableException parameterNotInstantiableException) {
            // empty catch block
        }
    }

    public void testInstantiate_factoryMethodParameterNotInstantiable() throws Exception {
        try {
            this.tester.instantiate(FactoryMethodParameterNotInstantiable.class);
            ClassSanityTesterTest.fail();
        }
        catch (ClassSanityTester.ParameterNotInstantiableException parameterNotInstantiableException) {
            // empty catch block
        }
    }

    public void testInstantiate_instantiableFactoryMethodChosen() throws Exception {
        ClassSanityTesterTest.assertEquals((String)"good", (String)((InstantiableFactoryMethodChosen)this.tester.instantiate(InstantiableFactoryMethodChosen.class)).name);
    }

    public void testInterfaceProxySerializable() throws Exception {
        SerializableTester.reserializeAndAssert((Object)this.tester.instantiate(HasAnInterface.class));
    }

    public void testReturnValuesFromAnotherPackageIgnoredForNullTests() throws Exception {
        new ClassSanityTester().forAllPublicStaticMethods(JdkObjectFactory.class).testNulls();
    }

    public void testInstantiate_instantiableConstructorChosen() throws Exception {
        ClassSanityTesterTest.assertEquals((String)"good", (String)((InstantiableConstructorChosen)this.tester.instantiate(InstantiableConstructorChosen.class)).name);
    }

    public void testEquals_setOfNonInstantiable() throws Exception {
        try {
            new ClassSanityTester().doTestEquals(SetWrapper.class);
            ClassSanityTesterTest.fail();
        }
        catch (ClassSanityTester.ParameterNotInstantiableException parameterNotInstantiableException) {
            // empty catch block
        }
    }

    private static class NoPublicStaticMethods {
        private NoPublicStaticMethods() {
        }

        static String notPublic() {
            return "";
        }
    }

    private static abstract class AnAbstractClass {
        public AnAbstractClass(String s) {
        }

        public void failsToCheckNull(String s) {
        }
    }

    private static interface AnInterface {
    }

    private static enum EnumFailsToCheckNull {
        A;


        public void failToCheckNull(String s) {
        }
    }

    private static enum OneConstantEnum {
        A;

    }

    private static enum NoConstantEnum {

    }

    static class NotInstantiable {
        private NotInstantiable() {
        }
    }

    static class FactoryMethodThrows {
        private FactoryMethodThrows() {
        }

        public static FactoryMethodThrows create() {
            throw new RuntimeException();
        }
    }

    static class ConstructorThrows {
        public ConstructorThrows() {
            throw new RuntimeException();
        }
    }

    static class FactoryMethodParameterNotInstantiable {
        private FactoryMethodParameterNotInstantiable() {
        }

        static FactoryMethodParameterNotInstantiable create(NotInstantiable x) {
            return new FactoryMethodParameterNotInstantiable();
        }
    }

    static class ConstructorParameterSingleValue {
        public ConstructorParameterSingleValue(Singleton s) {
        }

        public boolean equals(Object obj) {
            return obj instanceof ConstructorParameterSingleValue;
        }

        public int hashCode() {
            return 1;
        }

        public static class Singleton {
            public static final Singleton INSTANCE = new Singleton();

            private Singleton() {
            }
        }
    }

    static class ConstructorParameterWithOptionalNotInstantiable {
        public ConstructorParameterWithOptionalNotInstantiable(Optional<NotInstantiable> x) {
            Preconditions.checkNotNull(x);
        }

        public boolean equals(@Nullable Object obj) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    }

    static class ConstructorParameterMapOfNotInstantiable {
        private final Map<NotInstantiable, NotInstantiable> m;

        public ConstructorParameterMapOfNotInstantiable(Map<NotInstantiable, NotInstantiable> m) {
            this.m = (Map)Preconditions.checkNotNull(m);
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof ConstructorParameterMapOfNotInstantiable) {
                return this.m.equals(((ConstructorParameterMapOfNotInstantiable)obj).m);
            }
            return false;
        }

        public int hashCode() {
            return this.m.hashCode();
        }
    }

    static class ConstructorParameterNotInstantiable {
        public ConstructorParameterNotInstantiable(NotInstantiable x) {
        }
    }

    static class ConstructorDoesNotAcceptNull {
        final String name;

        ConstructorDoesNotAcceptNull(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
        }
    }

    static class ConstructorAcceptsNull {
        final String name;

        public ConstructorAcceptsNull(@Nullable String name) {
            this.name = name;
        }
    }

    static class FactoryMethodDoesNotAcceptNull {
        final String name;

        private FactoryMethodDoesNotAcceptNull(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
        }

        public static FactoryMethodDoesNotAcceptNull create(String name) {
            return new FactoryMethodDoesNotAcceptNull(name);
        }
    }

    static class FactoryMethodAcceptsNull {
        final String name;

        private FactoryMethodAcceptsNull(String name) {
            this.name = name;
        }

        static FactoryMethodAcceptsNull create(@Nullable String name) {
            return new FactoryMethodAcceptsNull(name);
        }
    }

    static class FactoryMethodReturnsNullAndAnnotated {
        private FactoryMethodReturnsNullAndAnnotated() {
        }

        @Nullable
        public static FactoryMethodReturnsNullAndAnnotated returnsNull() {
            return null;
        }
    }

    static class FactoryMethodReturnsNullButNotAnnotated {
        private FactoryMethodReturnsNullButNotAnnotated() {
        }

        static FactoryMethodReturnsNullButNotAnnotated returnsNull() {
            return null;
        }
    }

    public static class NoNullCheckNeededDespitNotInstantiable {
        public NoNullCheckNeededDespitNotInstantiable(NotInstantiable x) {
            Preconditions.checkNotNull((Object)x);
        }

        void primitiveOnly(int i) {
        }

        void nullableOnly(@Nullable String s) {
        }

        public void noParameter() {
        }

        void primitiveAndNullable(@Nullable String s, int i) {
        }
    }

    public static class BadNulls {
        public void failsToRejectNull(String s) {
        }
    }

    static class GoodNulls {
        public GoodNulls(String s) {
            Preconditions.checkNotNull((Object)s);
        }

        public void rejectNull(String s) {
            Preconditions.checkNotNull((Object)s);
        }
    }

    static class BadEqualsWithParameterizedType {
        public static BadEqualsWithParameterizedType create(ImmutableList<Iterable<? extends String>> s) {
            return new BadEqualsWithParameterizedType();
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof BadEqualsWithParameterizedType;
        }

        public int hashCode() {
            return 0;
        }
    }

    public static class ReferentialEquality {
    }

    static class UsesEnum {
        private final TimeUnit s;

        public UsesEnum(TimeUnit s) {
            this.s = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)s)));
        }

        public int hashCode() {
            return this.s.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof UsesEnum) {
                UsesEnum that = (UsesEnum)obj;
                return this.s == that.s;
            }
            return false;
        }
    }

    static class UsesReferentialEquality {
        private final ReferentialEquality s;

        public UsesReferentialEquality(ReferentialEquality s) {
            this.s = (ReferentialEquality)Preconditions.checkNotNull((Object)s);
        }

        public int hashCode() {
            return this.s.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof UsesReferentialEquality) {
                UsesReferentialEquality that = (UsesReferentialEquality)obj;
                return this.s == that.s;
            }
            return false;
        }
    }

    static class SameListInstance {
        private final List<?> s;

        public SameListInstance(List<?> s) {
            this.s = (List)Preconditions.checkNotNull(s);
        }

        public int hashCode() {
            return System.identityHashCode(this.s);
        }

        public boolean equals(Object obj) {
            if (obj instanceof SameListInstance) {
                SameListInstance that = (SameListInstance)obj;
                return this.s == that.s;
            }
            return false;
        }
    }

    static class SameInterfaceInstance {
        private final Runnable s;

        public SameInterfaceInstance(Runnable s) {
            this.s = (Runnable)Preconditions.checkNotNull((Object)s);
        }

        public int hashCode() {
            return this.s.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SameInterfaceInstance) {
                SameInterfaceInstance that = (SameInterfaceInstance)obj;
                return this.s == that.s;
            }
            return false;
        }
    }

    static class SameObjectInstance {
        private final Object s;

        public SameObjectInstance(Object s) {
            this.s = Preconditions.checkNotNull((Object)s);
        }

        public int hashCode() {
            return this.s.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SameObjectInstance) {
                SameObjectInstance that = (SameObjectInstance)obj;
                return this.s == that.s;
            }
            return false;
        }
    }

    static class SameStringInstance {
        private final String s;

        public SameStringInstance(String s) {
            this.s = (String)Preconditions.checkNotNull((Object)s);
        }

        public int hashCode() {
            return this.s.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SameStringInstance) {
                SameStringInstance that = (SameStringInstance)obj;
                return this.s == that.s;
            }
            return false;
        }
    }

    static class SameBooleanInstance {
        private final Boolean i;

        public SameBooleanInstance(Boolean i) {
            this.i = (Boolean)Preconditions.checkNotNull((Object)i);
        }

        public int hashCode() {
            return this.i.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SameBooleanInstance) {
                SameBooleanInstance that = (SameBooleanInstance)obj;
                return this.i == that.i;
            }
            return false;
        }
    }

    static class SameCharacterInstance {
        private final Character i;

        public SameCharacterInstance(Character i) {
            this.i = (Character)Preconditions.checkNotNull((Object)i);
        }

        public int hashCode() {
            return this.i.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SameCharacterInstance) {
                SameCharacterInstance that = (SameCharacterInstance)obj;
                return this.i == that.i;
            }
            return false;
        }
    }

    static class SameByteInstance {
        private final Byte i;

        public SameByteInstance(Byte i) {
            this.i = (Byte)Preconditions.checkNotNull((Object)i);
        }

        public int hashCode() {
            return this.i.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SameByteInstance) {
                SameByteInstance that = (SameByteInstance)obj;
                return this.i == that.i;
            }
            return false;
        }
    }

    static class SameShortInstance {
        private final Short i;

        public SameShortInstance(Short i) {
            this.i = (Short)Preconditions.checkNotNull((Object)i);
        }

        public int hashCode() {
            return this.i.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SameShortInstance) {
                SameShortInstance that = (SameShortInstance)obj;
                return this.i == that.i;
            }
            return false;
        }
    }

    static class SameDoubleInstance {
        private final Double i;

        public SameDoubleInstance(Double i) {
            this.i = (Double)Preconditions.checkNotNull((Object)i);
        }

        public int hashCode() {
            return this.i.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SameDoubleInstance) {
                SameDoubleInstance that = (SameDoubleInstance)obj;
                return this.i == that.i;
            }
            return false;
        }
    }

    static class SameFloatInstance {
        private final Float i;

        public SameFloatInstance(Float i) {
            this.i = (Float)Preconditions.checkNotNull((Object)i);
        }

        public int hashCode() {
            return this.i.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SameFloatInstance) {
                SameFloatInstance that = (SameFloatInstance)obj;
                return this.i == that.i;
            }
            return false;
        }
    }

    static class SameLongInstance {
        private final Long i;

        public SameLongInstance(Long i) {
            this.i = (Long)Preconditions.checkNotNull((Object)i);
        }

        public int hashCode() {
            return this.i.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SameLongInstance) {
                SameLongInstance that = (SameLongInstance)obj;
                return this.i == that.i;
            }
            return false;
        }
    }

    static class SameIntegerInstance {
        private final Integer i;

        public SameIntegerInstance(Integer i) {
            this.i = (Integer)Preconditions.checkNotNull((Object)i);
        }

        public int hashCode() {
            return this.i.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SameIntegerInstance) {
                SameIntegerInstance that = (SameIntegerInstance)obj;
                return this.i == that.i;
            }
            return false;
        }
    }

    static class BadEquals {
        public static BadEquals create(@Nullable String s) {
            return new BadEquals();
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof BadEquals;
        }

        public int hashCode() {
            return 0;
        }
    }

    static class GoodEquals {
        private final String a;
        private final int b;

        private GoodEquals(String a, int b) {
            this.a = (String)Preconditions.checkNotNull((Object)a);
            this.b = b;
        }

        GoodEquals(NotInstantiable x) {
            this.a = "x";
            this.b = -1;
        }

        public GoodEquals(NotInstantiable x, int b) {
            this.a = "x";
            this.b = b;
        }

        static GoodEquals create(int a, int b) {
            throw new RuntimeException();
        }

        @Nullable
        public static GoodEquals createMayReturnNull(int a, int b) {
            return null;
        }

        static GoodEquals create(String a, int b) {
            return new GoodEquals(a, b);
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof GoodEquals) {
                GoodEquals that = (GoodEquals)obj;
                return this.a.equals(that.a) && this.b == that.b;
            }
            return false;
        }

        public int hashCode() {
            return 0;
        }
    }

    static class InstantiableConstructorChosen {
        final String name;

        public InstantiableConstructorChosen(String name) {
            Preconditions.checkNotNull((Object)name);
            this.name = "good";
        }

        public InstantiableConstructorChosen(NotInstantiable x) {
            Preconditions.checkNotNull((Object)x);
            this.name = "x1";
        }

        public static InstantiableFactoryMethodChosen create(NotInstantiable x) {
            return new InstantiableFactoryMethodChosen(x);
        }
    }

    private static class SetWrapper
    extends Wrapper {
        public SetWrapper(Set<NotInstantiable> wrapped) {
            super(wrapped);
        }
    }

    private static abstract class Wrapper {
        private final Object wrapped;

        Wrapper(Object wrapped) {
            this.wrapped = Preconditions.checkNotNull((Object)wrapped);
        }

        public boolean equals(@Nullable Object obj) {
            if (this.getClass().isInstance(obj)) {
                Wrapper that = (Wrapper)obj;
                return this.wrapped.equals(that.wrapped);
            }
            return false;
        }

        public int hashCode() {
            return this.wrapped.hashCode();
        }

        public String toString() {
            return this.wrapped.toString();
        }
    }

    static class InstantiableFactoryMethodChosen {
        final String name;

        private InstantiableFactoryMethodChosen(String name) {
            this.name = name;
        }

        public InstantiableFactoryMethodChosen(NotInstantiable x) {
            Preconditions.checkNotNull((Object)x);
            this.name = "x1";
        }

        public static InstantiableFactoryMethodChosen create(NotInstantiable x) {
            return new InstantiableFactoryMethodChosen(x);
        }

        public static InstantiableFactoryMethodChosen create(String s) {
            Preconditions.checkNotNull((Object)s);
            return new InstantiableFactoryMethodChosen("good");
        }
    }

    static class HasAnInterface
    implements Serializable {
        private final AnInterface i;

        public HasAnInterface(AnInterface i) {
            this.i = i;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof HasAnInterface) {
                HasAnInterface that = (HasAnInterface)obj;
                return this.i.equals(that.i);
            }
            return false;
        }

        public int hashCode() {
            return this.i.hashCode();
        }
    }

    private static class JdkObjectFactory {
        private JdkObjectFactory() {
        }

        public static Object create() {
            return new ArrayList();
        }
    }

    public static class FactoryThatReturnsNullAndAnnotated {
        @Nullable
        public static Object bad() {
            return null;
        }
    }

    public static class FactoryThatReturnsNullButNotAnnotated {
        public static Object bad() {
            return null;
        }
    }

    public static class GoodEqualsAndSerialiableFactory {
        public static Object good(AnInterface s) {
            return Functions.constant((Object)s);
        }
    }

    public static class BadSerializableFactory {
        public static Object bad() {
            return new Serializable(){
                private final Object notSerializable = new Object();
            };
        }
    }

    public static class GoodSerializableFactory {
        public static Object good(Runnable r) {
            return r;
        }

        public static Object good(AnInterface i) {
            return i;
        }
    }

    public static class BadNullsFactory {
        public static Object bad(String a) {
            return new BadNulls();
        }
    }

    private static class GoodNullsFactory {
        private GoodNullsFactory() {
        }

        public static Object good(String s) {
            return new GoodNulls(s);
        }
    }

    private static class BadEqualsFactory {
        private BadEqualsFactory() {
        }

        public static Object bad(String a, int b, @Nullable OneConstantEnum oneConstantOnly) {
            return new GoodEquals(a, b);
        }
    }

    public static class GoodEqualsFactory {
        public static Object good(String a, int b, OneConstantEnum oneConstantOnly, @Nullable NoConstantEnum noConstant) {
            return new GoodEquals(a, b);
        }

        public Object badIgnored() {
            return new BadEquals();
        }

        public int returnsInt() {
            throw new UnsupportedOperationException();
        }

        public void voidMethod() {
            throw new UnsupportedOperationException();
        }

        static Object badButNotPublic() {
            return new BadEquals();
        }
    }
}

