/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.testing.EqualsTester;
import java.util.Collection;
import java.util.Set;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

@GwtCompatible
public class EqualsTesterTest
extends TestCase {
    private ValidTestObject reference;
    private EqualsTester equalsTester;
    private ValidTestObject equalObject1;
    private ValidTestObject equalObject2;
    private ValidTestObject notEqualObject1;

    public void setUp() throws Exception {
        super.setUp();
        this.reference = new ValidTestObject(1, 2);
        this.equalsTester = new EqualsTester();
        this.equalObject1 = new ValidTestObject(1, 2);
        this.equalObject2 = new ValidTestObject(1, 2);
        this.notEqualObject1 = new ValidTestObject(0, 2);
    }

    public void testAddNullReference() {
        try {
            this.equalsTester.addEqualityGroup(new Object[]{null});
            EqualsTesterTest.fail((String)"Should fail on null reference");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddTwoEqualObjectsAtOnceWithNull() {
        try {
            this.equalsTester.addEqualityGroup(new Object[]{this.reference, this.equalObject1, null});
            EqualsTesterTest.fail((String)"Should fail on null equal object");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddNullEqualObject() {
        try {
            this.equalsTester.addEqualityGroup(new Object[]{this.reference, null});
            EqualsTesterTest.fail((String)"Should fail on null equal object");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddEqualObjectWithOArgConstructor() {
        this.equalsTester.addEqualityGroup(new Object[]{this.equalObject1, this.notEqualObject1});
        try {
            this.equalsTester.testEquals();
        }
        catch (AssertionFailedError e) {
            EqualsTesterTest.assertErrorMessage(e, this.equalObject1 + " [group 1, item 1] must be Object#equals to " + this.notEqualObject1 + " [group 1, item 2]");
            return;
        }
        EqualsTesterTest.fail((String)"Should get not equal to equal object error");
    }

    public void testTestEqualsEmptyLists() {
        this.equalsTester.addEqualityGroup(new Object[]{this.reference});
        this.equalsTester.testEquals();
    }

    public void testTestEqualsEqualsObjects() {
        this.equalsTester.addEqualityGroup(new Object[]{this.reference, this.equalObject1, this.equalObject2});
        this.equalsTester.testEquals();
    }

    public void testNonreflexiveEquals() {
        NonReflexiveObject obj = new NonReflexiveObject();
        this.equalsTester.addEqualityGroup(new Object[]{obj});
        try {
            this.equalsTester.testEquals();
        }
        catch (AssertionFailedError e) {
            EqualsTesterTest.assertErrorMessage(e, obj + " must be Object#equals to itself");
            return;
        }
        EqualsTesterTest.fail((String)"Should get non-reflexive error");
    }

    public void testInvalidEqualsNull() {
        InvalidEqualsNullObject obj = new InvalidEqualsNullObject();
        this.equalsTester.addEqualityGroup(new Object[]{obj});
        try {
            this.equalsTester.testEquals();
        }
        catch (AssertionFailedError e) {
            EqualsTesterTest.assertErrorMessage(e, obj + " must not be Object#equals to null");
            return;
        }
        EqualsTesterTest.fail((String)"Should get equal to null error");
    }

    public void testInvalidEqualsIncompatibleClass() {
        InvalidEqualsIncompatibleClassObject obj = new InvalidEqualsIncompatibleClassObject();
        this.equalsTester.addEqualityGroup(new Object[]{obj});
        try {
            this.equalsTester.testEquals();
        }
        catch (AssertionFailedError e) {
            EqualsTesterTest.assertErrorMessage(e, obj + " must not be Object#equals to an arbitrary object of another class");
            return;
        }
        EqualsTesterTest.fail((String)"Should get equal to incompatible class error");
    }

    public void testInvalidNotEqualsEqualObject() {
        this.equalsTester.addEqualityGroup(new Object[]{this.reference, this.notEqualObject1});
        try {
            this.equalsTester.testEquals();
        }
        catch (AssertionFailedError e) {
            EqualsTesterTest.assertErrorMessage(e, this.reference + " [group 1, item 1]");
            EqualsTesterTest.assertErrorMessage(e, this.notEqualObject1 + " [group 1, item 2]");
            return;
        }
        EqualsTesterTest.fail((String)"Should get not equal to equal object error");
    }

    public void testInvalidHashCode() {
        InvalidHashCodeObject a = new InvalidHashCodeObject(1, 2);
        InvalidHashCodeObject b = new InvalidHashCodeObject(1, 2);
        this.equalsTester.addEqualityGroup(new Object[]{a, b});
        try {
            this.equalsTester.testEquals();
        }
        catch (AssertionFailedError e) {
            EqualsTesterTest.assertErrorMessage(e, "the Object#hashCode (" + a.hashCode() + ") of " + a + " [group 1, item 1] must be equal to the Object#hashCode (" + b.hashCode() + ") of " + b);
            return;
        }
        EqualsTesterTest.fail((String)"Should get invalid hashCode error");
    }

    public void testNullEqualityGroup() {
        EqualsTester tester = new EqualsTester();
        try {
            tester.addEqualityGroup((Object[])null);
            EqualsTesterTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testNullObjectInEqualityGroup() {
        EqualsTester tester = new EqualsTester();
        try {
            tester.addEqualityGroup(new Object[]{1, null, 3});
            EqualsTesterTest.fail();
        }
        catch (NullPointerException e) {
            EqualsTesterTest.assertErrorMessage(e, "at index 1");
        }
    }

    public void testSymmetryBroken() {
        EqualsTester tester = new EqualsTester().addEqualityGroup(new Object[]{EqualsTesterTest.named("foo").addPeers("bar"), EqualsTesterTest.named("bar")});
        try {
            tester.testEquals();
        }
        catch (AssertionFailedError e) {
            EqualsTesterTest.assertErrorMessage(e, "bar [group 1, item 2] must be Object#equals to foo [group 1, item 1]");
            return;
        }
        EqualsTesterTest.fail((String)"should failed because symmetry is broken");
    }

    public void testTransitivityBrokenInEqualityGroup() {
        EqualsTester tester = new EqualsTester().addEqualityGroup(new Object[]{EqualsTesterTest.named("foo").addPeers("bar", "baz"), EqualsTesterTest.named("bar").addPeers("foo"), EqualsTesterTest.named("baz").addPeers("foo")});
        try {
            tester.testEquals();
        }
        catch (AssertionFailedError e) {
            EqualsTesterTest.assertErrorMessage(e, "bar [group 1, item 2] must be Object#equals to baz [group 1, item 3]");
            return;
        }
        EqualsTesterTest.fail((String)"should failed because transitivity is broken");
    }

    public void testUnequalObjectsInEqualityGroup() {
        EqualsTester tester = new EqualsTester().addEqualityGroup(new Object[]{EqualsTesterTest.named("foo"), EqualsTesterTest.named("bar")});
        try {
            tester.testEquals();
        }
        catch (AssertionFailedError e) {
            EqualsTesterTest.assertErrorMessage(e, "foo [group 1, item 1] must be Object#equals to bar [group 1, item 2]");
            return;
        }
        EqualsTesterTest.fail((String)"should failed because of unequal objects in the same equality group");
    }

    public void testTransitivityBrokenAcrossEqualityGroups() {
        EqualsTester tester = new EqualsTester().addEqualityGroup(new Object[]{EqualsTesterTest.named("foo").addPeers("bar"), EqualsTesterTest.named("bar").addPeers("foo", "x")}).addEqualityGroup(new Object[]{EqualsTesterTest.named("baz").addPeers("x"), EqualsTesterTest.named("x").addPeers("baz", "bar")});
        try {
            tester.testEquals();
        }
        catch (AssertionFailedError e) {
            EqualsTesterTest.assertErrorMessage(e, "bar [group 1, item 2] must not be Object#equals to x [group 2, item 2]");
            return;
        }
        EqualsTesterTest.fail((String)"should failed because transitivity is broken");
    }

    public void testEqualityGroups() {
        new EqualsTester().addEqualityGroup(new Object[]{EqualsTesterTest.named("foo").addPeers("bar"), EqualsTesterTest.named("bar").addPeers("foo")}).addEqualityGroup(new Object[]{EqualsTesterTest.named("baz"), EqualsTesterTest.named("baz")}).testEquals();
    }

    private static void assertErrorMessage(Throwable e, String message) {
        if (!e.getMessage().contains(message)) {
            EqualsTesterTest.fail((String)("expected <" + e.getMessage() + "> to contain <" + message + ">"));
        }
    }

    private static NamedObject named(String name) {
        return new NamedObject(name);
    }

    private static class NamedObject {
        private final Set<String> peerNames = Sets.newHashSet();
        private final String name;

        NamedObject(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
        }

        NamedObject addPeers(String ... names) {
            this.peerNames.addAll((Collection<String>)ImmutableList.copyOf((Object[])names));
            return this;
        }

        public boolean equals(Object obj) {
            if (obj instanceof NamedObject) {
                NamedObject that = (NamedObject)obj;
                return this.name.equals(that.name) || this.peerNames.contains(that.name);
            }
            return false;
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class InvalidEqualsIncompatibleClassObject {
        private InvalidEqualsIncompatibleClassObject() {
        }

        public boolean equals(Object o) {
            return o != null;
        }

        public int hashCode() {
            return 0;
        }
    }

    private static class InvalidEqualsNullObject {
        private InvalidEqualsNullObject() {
        }

        public boolean equals(Object o) {
            return o == this || o == null;
        }

        public int hashCode() {
            return 0;
        }
    }

    private static class NonReflexiveObject {
        private NonReflexiveObject() {
        }

        public boolean equals(Object o) {
            return false;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class InvalidHashCodeObject {
        private int aspect1;
        private int aspect2;

        InvalidHashCodeObject(int aspect1, int aspect2) {
            this.aspect1 = aspect1;
            this.aspect2 = aspect2;
        }

        public boolean equals(Object o) {
            if (!(o instanceof InvalidHashCodeObject)) {
                return false;
            }
            InvalidHashCodeObject other = (InvalidHashCodeObject)o;
            if (this.aspect1 != other.aspect1) {
                return false;
            }
            return this.aspect2 == other.aspect2;
        }
    }

    private static class ValidTestObject {
        private int aspect1;
        private int aspect2;

        ValidTestObject(int aspect1, int aspect2) {
            this.aspect1 = aspect1;
            this.aspect2 = aspect2;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ValidTestObject)) {
                return false;
            }
            ValidTestObject other = (ValidTestObject)o;
            if (this.aspect1 != other.aspect1) {
                return false;
            }
            return this.aspect2 == other.aspect2;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.aspect1;
            result = 37 * result + this.aspect2;
            return result;
        }
    }
}

