/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.testing.GcFinalization;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.SettableFuture;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;

public class GcFinalizationTest
extends TestCase {
    public void testAwait_CountDownLatch() {
        final CountDownLatch latch = new CountDownLatch(1);
        Object x = new Object(){

            protected void finalize() {
                latch.countDown();
            }
        };
        x = null;
        GcFinalization.await((CountDownLatch)latch);
        GcFinalizationTest.assertEquals((long)0L, (long)latch.getCount());
    }

    public void testAwaitDone_Future() {
        final SettableFuture future = SettableFuture.create();
        Object x = new Object(){

            protected void finalize() {
                future.set(null);
            }
        };
        x = null;
        GcFinalization.awaitDone((Future)future);
        GcFinalizationTest.assertTrue((boolean)future.isDone());
        GcFinalizationTest.assertFalse((boolean)future.isCancelled());
    }

    public void testAwaitDone_Future_Cancel() {
        final SettableFuture future = SettableFuture.create();
        Object x = new Object(){

            protected void finalize() {
                future.cancel(false);
            }
        };
        x = null;
        GcFinalization.awaitDone((Future)future);
        GcFinalizationTest.assertTrue((boolean)future.isDone());
        GcFinalizationTest.assertTrue((boolean)future.isCancelled());
    }

    public void testAwaitClear() {
        WeakReference<Object> ref = new WeakReference<Object>(new Object());
        GcFinalization.awaitClear(ref);
        GcFinalizationTest.assertNull(ref.get());
    }

    public void testAwaitDone_FinalizationPredicate() {
        final WeakHashMap<Object, Boolean> map = new WeakHashMap<Object, Boolean>();
        map.put(new Object(), Boolean.TRUE);
        GcFinalization.awaitDone((GcFinalization.FinalizationPredicate)new GcFinalization.FinalizationPredicate(){

            public boolean isDone() {
                return map.isEmpty();
            }
        });
        GcFinalizationTest.assertTrue((boolean)map.isEmpty());
    }

    void assertWrapsInterruptedException(RuntimeException e) {
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Unexpected interrupt");
        Truth.assertThat((Throwable)e.getCause()).isInstanceOf(InterruptedException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAwait_CountDownLatch_Interrupted() {
        Interruptenator interruptenator = new Interruptenator(Thread.currentThread());
        try {
            CountDownLatch latch = new CountDownLatch(1);
            try {
                GcFinalization.await((CountDownLatch)latch);
                GcFinalizationTest.fail((String)"should throw");
            }
            catch (RuntimeException expected) {
                this.assertWrapsInterruptedException(expected);
            }
        }
        finally {
            interruptenator.shutdown();
            Thread.interrupted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAwaitDone_Future_Interrupted_Interrupted() {
        Interruptenator interruptenator = new Interruptenator(Thread.currentThread());
        try {
            SettableFuture future = SettableFuture.create();
            try {
                GcFinalization.awaitDone((Future)future);
                GcFinalizationTest.fail((String)"should throw");
            }
            catch (RuntimeException expected) {
                this.assertWrapsInterruptedException(expected);
            }
        }
        finally {
            interruptenator.shutdown();
            Thread.interrupted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAwaitClear_Interrupted() {
        Interruptenator interruptenator = new Interruptenator(Thread.currentThread());
        try {
            WeakReference<Boolean> ref = new WeakReference<Boolean>(Boolean.TRUE);
            try {
                GcFinalization.awaitClear(ref);
                GcFinalizationTest.fail((String)"should throw");
            }
            catch (RuntimeException expected) {
                this.assertWrapsInterruptedException(expected);
            }
        }
        finally {
            interruptenator.shutdown();
            Thread.interrupted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAwaitDone_FinalizationPredicate_Interrupted() {
        Interruptenator interruptenator = new Interruptenator(Thread.currentThread());
        try {
            try {
                GcFinalization.awaitDone((GcFinalization.FinalizationPredicate)new GcFinalization.FinalizationPredicate(){

                    public boolean isDone() {
                        return false;
                    }
                });
                GcFinalizationTest.fail((String)"should throw");
            }
            catch (RuntimeException expected) {
                this.assertWrapsInterruptedException(expected);
            }
        }
        finally {
            interruptenator.shutdown();
            Thread.interrupted();
        }
    }

    public void testAwaitFullGc() {
        final CountDownLatch finalizerRan = new CountDownLatch(1);
        WeakReference<6> ref = new WeakReference<6>(new Object(){

            protected void finalize() {
                finalizerRan.countDown();
            }
        });
        GcFinalization.awaitFullGc();
        GcFinalizationTest.assertEquals((long)0L, (long)finalizerRan.getCount());
        GcFinalizationTest.assertNull(ref.get());
    }

    class Interruptenator
    extends Thread {
        final AtomicBoolean shutdown;

        Interruptenator(Thread interruptee) {
            this(interruptee, new AtomicBoolean(false));
        }

        Interruptenator(final Thread interruptee, final AtomicBoolean shutdown) {
            super(new Runnable(){

                @Override
                public void run() {
                    while (!shutdown.get()) {
                        interruptee.interrupt();
                        Thread.yield();
                    }
                }
            });
            this.shutdown = shutdown;
            this.start();
        }

        void shutdown() {
            this.shutdown.set(true);
            while (this.isAlive()) {
                Thread.yield();
            }
        }
    }
}

