/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Table;
import com.google.common.reflect.TypeToken;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.anotherpackage.SomeClassThatDoesNotUseNullable;
import com.google.common.truth.Truth;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class NullPointerTesterTest
extends TestCase {
    private static final String[] STATIC_ONE_ARG_METHODS_SHOULD_PASS = new String[]{"staticOneArgCorrectlyThrowsNpe", "staticOneArgNullableCorrectlyDoesNotThrowNPE", "staticOneArgNullableCorrectlyThrowsOtherThanNPE", "staticOneArgNullableThrowsNPE"};
    private static final String[] STATIC_ONE_ARG_METHODS_SHOULD_FAIL = new String[]{"staticOneArgThrowsOtherThanNpe", "staticOneArgShouldThrowNpeButDoesnt"};
    private static final String[] NONSTATIC_ONE_ARG_METHODS_SHOULD_PASS = new String[]{"oneArgCorrectlyThrowsNpe", "oneArgNullableCorrectlyDoesNotThrowNPE", "oneArgNullableCorrectlyThrowsOtherThanNPE", "oneArgNullableThrowsNPE"};
    private static final String[] NONSTATIC_ONE_ARG_METHODS_SHOULD_FAIL = new String[]{"oneArgThrowsOtherThanNpe", "oneArgShouldThrowNpeButDoesnt"};

    public void testDontAcceptIae() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(ThrowsNpe.class);
        tester.testAllPublicStaticMethods(ThrowsUoe.class);
        try {
            tester.testAllPublicStaticMethods(ThrowsIae.class);
        }
        catch (AssertionFailedError expected) {
            return;
        }
        NullPointerTesterTest.fail();
    }

    public void testStaticOneArgMethodsThatShouldPass() throws Exception {
        for (String methodName : STATIC_ONE_ARG_METHODS_SHOULD_PASS) {
            Method method = OneArg.class.getMethod(methodName, String.class);
            try {
                new NullPointerTester().testMethodParameter((Object)new OneArg(), method, 0);
            }
            catch (AssertionFailedError unexpected) {
                NullPointerTesterTest.fail((String)("Should not have flagged method " + methodName));
            }
        }
    }

    public void testStaticOneArgMethodsThatShouldFail() throws Exception {
        for (String methodName : STATIC_ONE_ARG_METHODS_SHOULD_FAIL) {
            Method method = OneArg.class.getMethod(methodName, String.class);
            boolean foundProblem = false;
            try {
                new NullPointerTester().testMethodParameter((Object)new OneArg(), method, 0);
            }
            catch (AssertionFailedError expected) {
                foundProblem = true;
            }
            NullPointerTesterTest.assertTrue((String)("Should report error in method " + methodName), (boolean)foundProblem);
        }
    }

    public void testNonStaticOneArgMethodsThatShouldPass() throws Exception {
        OneArg foo = new OneArg();
        for (String methodName : NONSTATIC_ONE_ARG_METHODS_SHOULD_PASS) {
            Method method = OneArg.class.getMethod(methodName, String.class);
            try {
                new NullPointerTester().testMethodParameter((Object)foo, method, 0);
            }
            catch (AssertionFailedError unexpected) {
                NullPointerTesterTest.fail((String)("Should not have flagged method " + methodName));
            }
        }
    }

    public void testNonStaticOneArgMethodsThatShouldFail() throws Exception {
        OneArg foo = new OneArg();
        for (String methodName : NONSTATIC_ONE_ARG_METHODS_SHOULD_FAIL) {
            Method method = OneArg.class.getMethod(methodName, String.class);
            boolean foundProblem = false;
            try {
                new NullPointerTester().testMethodParameter((Object)foo, method, 0);
            }
            catch (AssertionFailedError expected) {
                foundProblem = true;
            }
            NullPointerTesterTest.assertTrue((String)("Should report error in method " + methodName), (boolean)foundProblem);
        }
    }

    public void verifyBarPass(Method method, TwoArg bar) {
        try {
            new NullPointerTester().testMethod((Object)bar, method);
        }
        catch (AssertionFailedError incorrectError) {
            String errorMessage = NullPointerTesterTest.rootLocaleFormat("Should not have flagged method %s for %s", method.getName(), bar);
            NullPointerTesterTest.assertNull((String)errorMessage, (Object)((Object)incorrectError));
        }
    }

    public void verifyBarFail(Method method, TwoArg bar) {
        try {
            new NullPointerTester().testMethod((Object)bar, method);
        }
        catch (AssertionFailedError expected) {
            return;
        }
        String errorMessage = NullPointerTesterTest.rootLocaleFormat("Should have flagged method %s for %s", method.getName(), bar);
        NullPointerTesterTest.fail((String)errorMessage);
    }

    public void testTwoArgNormalNormal() throws Exception {
        Method method = TwoArg.class.getMethod("normalNormal", String.class, Integer.class);
        for (TwoArg.Action first : TwoArg.Action.values()) {
            for (TwoArg.Action second : TwoArg.Action.values()) {
                TwoArg bar = new TwoArg(first, second);
                if (first.equals((Object)TwoArg.Action.THROW_A_NPE) && second.equals((Object)TwoArg.Action.THROW_A_NPE)) {
                    this.verifyBarPass(method, bar);
                    continue;
                }
                this.verifyBarFail(method, bar);
            }
        }
    }

    public void testTwoArgNormalNullable() throws Exception {
        Method method = TwoArg.class.getMethod("normalNullable", String.class, Integer.class);
        for (TwoArg.Action first : TwoArg.Action.values()) {
            for (TwoArg.Action second : TwoArg.Action.values()) {
                TwoArg bar = new TwoArg(first, second);
                if (first.equals((Object)TwoArg.Action.THROW_A_NPE)) {
                    this.verifyBarPass(method, bar);
                    continue;
                }
                this.verifyBarFail(method, bar);
            }
        }
    }

    public void testTwoArgNullableNormal() throws Exception {
        Method method = TwoArg.class.getMethod("nullableNormal", String.class, Integer.class);
        for (TwoArg.Action first : TwoArg.Action.values()) {
            for (TwoArg.Action second : TwoArg.Action.values()) {
                TwoArg bar = new TwoArg(first, second);
                if (second.equals((Object)TwoArg.Action.THROW_A_NPE)) {
                    this.verifyBarPass(method, bar);
                    continue;
                }
                this.verifyBarFail(method, bar);
            }
        }
    }

    public void testTwoArgNullableNullable() throws Exception {
        Method method = TwoArg.class.getMethod("nullableNullable", String.class, Integer.class);
        for (TwoArg.Action first : TwoArg.Action.values()) {
            for (TwoArg.Action second : TwoArg.Action.values()) {
                TwoArg bar = new TwoArg(first, second);
                this.verifyBarPass(method, bar);
            }
        }
    }

    public void testGoodClass() {
        NullPointerTesterTest.shouldPass(new PassObject());
    }

    public void testFailOneArgDoesntThrowNpe() {
        NullPointerTesterTest.shouldFail(new FailOneArgDoesntThrowNPE());
    }

    public void testFailOneArgThrowsWrongType() {
        NullPointerTesterTest.shouldFail(new FailOneArgThrowsWrongType());
    }

    public void testPassOneNullableArgThrowsNPE() {
        NullPointerTesterTest.shouldPass(new PassOneNullableArgThrowsNPE());
    }

    public void testFailTwoArgsFirstArgDoesntThrowNPE() {
        NullPointerTesterTest.shouldFail(new FailTwoArgsFirstArgDoesntThrowNPE());
    }

    public void testFailTwoArgsFirstArgThrowsWrongType() {
        NullPointerTesterTest.shouldFail(new FailTwoArgsFirstArgThrowsWrongType());
    }

    public void testFailTwoArgsSecondArgDoesntThrowNPE() {
        NullPointerTesterTest.shouldFail(new FailTwoArgsSecondArgDoesntThrowNPE());
    }

    public void testFailTwoArgsSecondArgThrowsWrongType() {
        NullPointerTesterTest.shouldFail(new FailTwoArgsSecondArgThrowsWrongType());
    }

    public void testFailTwoMixedArgsFirstArgDoesntThrowNPE() {
        NullPointerTesterTest.shouldFail(new FailTwoMixedArgsFirstArgDoesntThrowNPE());
    }

    public void testFailTwoMixedArgsFirstArgThrowsWrongType() {
        NullPointerTesterTest.shouldFail(new FailTwoMixedArgsFirstArgThrowsWrongType());
    }

    public void testPassTwoMixedArgsNullableArgThrowsNPE() {
        NullPointerTesterTest.shouldPass(new PassTwoMixedArgsNullableArgThrowsNPE());
    }

    public void testPassTwoMixedArgSecondNullableArgThrowsOther() {
        NullPointerTesterTest.shouldPass(new PassTwoMixedArgSecondNullableArgThrowsOther());
    }

    public void testFailTwoMixedArgsSecondArgDoesntThrowNPE() {
        NullPointerTesterTest.shouldFail(new FailTwoMixedArgsSecondArgDoesntThrowNPE());
    }

    public void testFailTwoMixedArgsSecondArgThrowsWrongType() {
        NullPointerTesterTest.shouldFail(new FailTwoMixedArgsSecondArgThrowsWrongType());
    }

    public void testPassTwoNullableArgsFirstThrowsNPE() {
        NullPointerTesterTest.shouldPass(new PassTwoNullableArgsFirstThrowsNPE());
    }

    public void testPassTwoNullableArgsFirstThrowsOther() {
        NullPointerTesterTest.shouldPass(new PassTwoNullableArgsFirstThrowsOther());
    }

    public void testPassTwoNullableArgsSecondThrowsNPE() {
        NullPointerTesterTest.shouldPass(new PassTwoNullableArgsSecondThrowsNPE());
    }

    public void testPassTwoNullableArgsSecondThrowsOther() {
        NullPointerTesterTest.shouldPass(new PassTwoNullableArgsSecondThrowsOther());
    }

    public void testPassTwoNullableArgsNeitherThrowsAnything() {
        NullPointerTesterTest.shouldPass(new PassTwoNullableArgsNeitherThrowsAnything());
    }

    public void testSubclassWithBadSuperclass() {
        NullPointerTesterTest.shouldFail(new SubclassWithBadSuperclass());
    }

    public void testSubclassWithBadSuperclassForPackagePrivateMethod() {
        NullPointerTesterTest.shouldFail(new SubclassWithBadSuperclassForPackagePrivate(), NullPointerTester.Visibility.PACKAGE);
    }

    public void testSubclassWithBadSuperclassForPackageProtectedMethod() {
        NullPointerTesterTest.shouldFail(new SubclassWithBadSuperclassForProtected(), NullPointerTester.Visibility.PROTECTED);
    }

    public void testSubclassThatOverridesBadSuperclassMethod() {
        NullPointerTesterTest.shouldPass(new SubclassThatOverridesBadSuperclassMethod());
    }

    public void testSubclassOverridesTheWrongMethod() {
        NullPointerTesterTest.shouldFail(new SubclassOverridesTheWrongMethod());
    }

    public void testClassThatFailsToThrowForStatic() {
        NullPointerTesterTest.shouldFail(ClassThatFailsToThrowForStatic.class);
    }

    public void testSubclassThatFailsToThrowForStatic() {
        NullPointerTesterTest.shouldFail(SubclassThatFailsToThrowForStatic.class);
    }

    public void testSubclassThatTriesToOverrideBadStaticMethod() {
        NullPointerTesterTest.shouldFail(SubclassThatTriesToOverrideBadStaticMethod.class);
    }

    public void testCanCreateDefault() {
        NullPointerTesterTest.shouldPass(new CanCreateDefault());
    }

    public void testCannotCreateDefault() {
        NullPointerTesterTest.shouldFail(new CannotCreateDefault());
    }

    private static void shouldPass(Object instance, NullPointerTester.Visibility visibility) {
        new NullPointerTester().testInstanceMethods(instance, visibility);
    }

    private static void shouldPass(Object instance) {
        NullPointerTesterTest.shouldPass(instance, NullPointerTester.Visibility.PACKAGE);
        NullPointerTesterTest.shouldPass(instance, NullPointerTester.Visibility.PROTECTED);
        NullPointerTesterTest.shouldPass(instance, NullPointerTester.Visibility.PUBLIC);
    }

    private static void shouldFail(Object instance, NullPointerTester.Visibility visibility) {
        try {
            new NullPointerTester().testInstanceMethods(instance, visibility);
        }
        catch (AssertionFailedError expected) {
            return;
        }
        NullPointerTesterTest.fail((String)("Should detect problem in " + instance.getClass().getSimpleName()));
    }

    private static void shouldFail(Object instance) {
        NullPointerTesterTest.shouldFail(instance, NullPointerTester.Visibility.PACKAGE);
        NullPointerTesterTest.shouldFail(instance, NullPointerTester.Visibility.PROTECTED);
        NullPointerTesterTest.shouldFail(instance, NullPointerTester.Visibility.PUBLIC);
    }

    private static void shouldFail(Class<?> cls, NullPointerTester.Visibility visibility) {
        try {
            new NullPointerTester().testStaticMethods(cls, visibility);
        }
        catch (AssertionFailedError expected) {
            return;
        }
        NullPointerTesterTest.fail((String)("Should detect problem in " + cls.getSimpleName()));
    }

    private static void shouldFail(Class<?> cls) {
        NullPointerTesterTest.shouldFail(cls, NullPointerTester.Visibility.PACKAGE);
    }

    public void testPrivateClass() {
        NullPointerTester tester = new NullPointerTester();
        for (Constructor<?> constructor : PrivateClassWithPrivateConstructor.class.getDeclaredConstructors()) {
            tester.testConstructor(constructor);
        }
    }

    public void testBridgeMethodIgnored() {
        new NullPointerTester().testAllPublicInstanceMethods((Object)new StringFoo());
    }

    public void testDefaultValues() {
        new AllDefaultValuesChecker().check();
    }

    public void testObjectArrayDefaultValue() {
        new ObjectArrayDefaultValueChecker().check();
    }

    public void testStringArrayDefaultValue() {
        new StringArrayDefaultValueChecker().check();
    }

    public void testIntArrayDefaultValue() {
        new IntArrayDefaultValueChecker().check();
    }

    public void testEmptyEnumDefaultValue() {
        new EmptyEnumDefaultValueChecker().check();
    }

    public void testGenericClassDefaultValue() {
        new GenericClassTypeDefaultValueChecker().check();
    }

    public void testNonGenericClassDefaultValue() {
        new NonGenericClassTypeDefaultValueChecker().check();
    }

    public void testGenericTypeTokenDefaultValue() {
        new GenericTypeTokenDefaultValueChecker().check();
    }

    public void testNonGenericTypeTokenDefaultValue() {
        new NonGenericTypeTokenDefaultValueChecker().check();
    }

    public void testGenericInterfaceDefaultValue() {
        new GenericInterfaceDefaultValueChecker().check();
    }

    public void testNullRejectingInterfaceDefaultValue() {
        new NullRejectingInterfaceDefaultValueChecker().check();
    }

    public void testMultipleInterfacesDefaultValue() {
        new MultipleInterfacesDefaultValueChecker().check();
    }

    public void testGenericInterfaceReturnedByGenericMethod() {
        new GenericInterface2DefaultValueChecker().check();
    }

    public void testGenericTypeResolvedForDefaultValue() {
        new GenericDefaultValueResolvedToStringChecker().check();
    }

    public void testDefaultValueResolvedForPackagePrivateMethod() {
        new DefaultValueForPackagePrivateMethodResolvedToStringChecker().check();
    }

    public void testConverterDefaultValue() {
        new ConverterDefaultValueChecker().check();
    }

    public void testVisibility_public() throws Exception {
        NullPointerTesterTest.assertFalse((boolean)NullPointerTester.Visibility.PUBLIC.isVisible((Member)VisibilityMethods.class.getDeclaredMethod("privateMethod", new Class[0])));
        NullPointerTesterTest.assertFalse((boolean)NullPointerTester.Visibility.PUBLIC.isVisible((Member)VisibilityMethods.class.getDeclaredMethod("packagePrivateMethod", new Class[0])));
        NullPointerTesterTest.assertFalse((boolean)NullPointerTester.Visibility.PUBLIC.isVisible((Member)VisibilityMethods.class.getDeclaredMethod("protectedMethod", new Class[0])));
        NullPointerTesterTest.assertTrue((boolean)NullPointerTester.Visibility.PUBLIC.isVisible((Member)VisibilityMethods.class.getDeclaredMethod("publicMethod", new Class[0])));
    }

    public void testVisibility_protected() throws Exception {
        NullPointerTesterTest.assertFalse((boolean)NullPointerTester.Visibility.PROTECTED.isVisible((Member)VisibilityMethods.class.getDeclaredMethod("privateMethod", new Class[0])));
        NullPointerTesterTest.assertFalse((boolean)NullPointerTester.Visibility.PROTECTED.isVisible((Member)VisibilityMethods.class.getDeclaredMethod("packagePrivateMethod", new Class[0])));
        NullPointerTesterTest.assertTrue((boolean)NullPointerTester.Visibility.PROTECTED.isVisible((Member)VisibilityMethods.class.getDeclaredMethod("protectedMethod", new Class[0])));
        NullPointerTesterTest.assertTrue((boolean)NullPointerTester.Visibility.PROTECTED.isVisible((Member)VisibilityMethods.class.getDeclaredMethod("publicMethod", new Class[0])));
    }

    public void testVisibility_package() throws Exception {
        NullPointerTesterTest.assertFalse((boolean)NullPointerTester.Visibility.PACKAGE.isVisible((Member)VisibilityMethods.class.getDeclaredMethod("privateMethod", new Class[0])));
        NullPointerTesterTest.assertTrue((boolean)NullPointerTester.Visibility.PACKAGE.isVisible((Member)VisibilityMethods.class.getDeclaredMethod("packagePrivateMethod", new Class[0])));
        NullPointerTesterTest.assertTrue((boolean)NullPointerTester.Visibility.PACKAGE.isVisible((Member)VisibilityMethods.class.getDeclaredMethod("protectedMethod", new Class[0])));
        NullPointerTesterTest.assertTrue((boolean)NullPointerTester.Visibility.PACKAGE.isVisible((Member)VisibilityMethods.class.getDeclaredMethod("publicMethod", new Class[0])));
    }

    public void testNonStaticInnerClass() {
        try {
            new NullPointerTester().testAllPublicConstructors(Inner.class);
            NullPointerTesterTest.fail();
        }
        catch (IllegalArgumentException expected) {
            Truth.assertThat((String)expected.getMessage()).contains((CharSequence)"inner class");
        }
    }

    private static String rootLocaleFormat(String format, Object ... args) {
        return String.format(Locale.ROOT, format, args);
    }

    private class Inner {
        public Inner(String s) {
            Preconditions.checkNotNull((Object)s);
        }
    }

    private static class VisibilityMethods {
        private VisibilityMethods() {
        }

        private void privateMethod() {
        }

        void packagePrivateMethod() {
        }

        protected void protectedMethod() {
        }

        public void publicMethod() {
        }
    }

    private static class ConverterDefaultValueChecker
    extends DefaultValueChecker {
        private ConverterDefaultValueChecker() {
        }

        public void checkArray(Converter<String, Integer> c, String s) {
            this.calledWith(c, s);
        }

        void check() {
            this.runTester();
            Converter defaultConverter = (Converter)this.getDefaultParameterValue(0);
            Assert.assertEquals((Object)0, (Object)defaultConverter.convert((Object)"anything"));
            Assert.assertEquals((String)"", (String)((String)defaultConverter.reverse().convert((Object)123)));
            Assert.assertNull((Object)defaultConverter.convert(null));
            Assert.assertNull((Object)defaultConverter.reverse().convert(null));
        }
    }

    private static class DefaultValueForPackagePrivateMethodResolvedToStringChecker
    extends AbstractGenericDefaultValueForPackagePrivateMethodChecker<String> {
        private DefaultValueForPackagePrivateMethodResolvedToStringChecker() {
        }

        void check() {
            this.runTester();
            Assert.assertEquals((Object)"", (Object)this.getDefaultParameterValue(0));
        }
    }

    private static abstract class AbstractGenericDefaultValueForPackagePrivateMethodChecker<T>
    extends DefaultValueChecker {
        private AbstractGenericDefaultValueForPackagePrivateMethodChecker() {
        }

        void checkGeneric(T value, String s) {
            this.calledWith(value, s);
        }
    }

    private static class GenericDefaultValueResolvedToStringChecker
    extends AbstractGenericDefaultValueChecker<String> {
        private GenericDefaultValueResolvedToStringChecker() {
        }

        void check() {
            this.runTester();
            Assert.assertEquals((Object)"", (Object)this.getDefaultParameterValue(0));
        }
    }

    private static abstract class AbstractGenericDefaultValueChecker<T>
    extends DefaultValueChecker {
        private AbstractGenericDefaultValueChecker() {
        }

        public void checkGeneric(T value, String s) {
            this.calledWith(value, s);
        }
    }

    private static class GenericInterface2DefaultValueChecker
    extends DefaultValueChecker {
        private GenericInterface2DefaultValueChecker() {
        }

        public void checkArray(FromTo<String, FromTo<Integer, String>> f, String s) {
            this.calledWith(f, s);
        }

        void check() {
            this.runTester();
            FromTo defaultFunction = (FromTo)this.getDefaultParameterValue(0);
            FromTo returnValue = (FromTo)defaultFunction.apply(null);
            Assert.assertEquals((Object)"", (Object)returnValue.apply(null));
        }
    }

    private static class MultipleInterfacesDefaultValueChecker
    extends DefaultValueChecker {
        private MultipleInterfacesDefaultValueChecker() {
        }

        public <T extends FromTo<String, Integer> & Supplier<Long>> void checkArray(T f, String s) {
            this.calledWith(f, s);
        }

        void check() {
            this.runTester();
            FromTo defaultFunction = (FromTo)this.getDefaultParameterValue(0);
            Assert.assertEquals((Object)0, (Object)defaultFunction.apply(null));
            Supplier defaultSupplier = (Supplier)defaultFunction;
            Assert.assertEquals((Object)0L, (Object)defaultSupplier.get());
        }
    }

    private static class NullRejectingInterfaceDefaultValueChecker
    extends DefaultValueChecker {
        private NullRejectingInterfaceDefaultValueChecker() {
        }

        public void checkArray(NullRejectingFromTo<String, Integer> f, String s) {
            this.calledWith(f, s);
        }

        void check() {
            this.runTester();
            NullRejectingFromTo defaultFunction = (NullRejectingFromTo)this.getDefaultParameterValue(0);
            Assert.assertNotNull((Object)defaultFunction);
            try {
                defaultFunction.apply(null);
                Assert.fail((String)"Proxy Should have rejected null");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private static interface NullRejectingFromTo<F, T>
    extends Function<F, T> {
        public T apply(F var1);
    }

    private static class GenericInterfaceDefaultValueChecker
    extends DefaultValueChecker {
        private GenericInterfaceDefaultValueChecker() {
        }

        public void checkArray(FromTo<String, Integer> f, String s) {
            this.calledWith(f, s);
        }

        void check() {
            this.runTester();
            FromTo defaultFunction = (FromTo)this.getDefaultParameterValue(0);
            Assert.assertEquals((Object)0, (Object)defaultFunction.apply(null));
        }
    }

    private static interface FromTo<F, T>
    extends Function<F, T> {
    }

    private static class NonGenericTypeTokenDefaultValueChecker
    extends DefaultValueChecker {
        private NonGenericTypeTokenDefaultValueChecker() {
        }

        public void checkArray(TypeToken type, String s) {
            this.calledWith(type, s);
        }

        void check() {
            this.runTester();
            TypeToken defaultType = (TypeToken)this.getDefaultParameterValue(0);
            Assert.assertEquals((Object)new TypeToken<Object>(){}, (Object)defaultType);
        }
    }

    private static class GenericTypeTokenDefaultValueChecker
    extends DefaultValueChecker {
        private GenericTypeTokenDefaultValueChecker() {
        }

        public void checkArray(TypeToken<? extends List<? super Number>> type, String s) {
            this.calledWith(type, s);
        }

        void check() {
            this.runTester();
            TypeToken defaultType = (TypeToken)this.getDefaultParameterValue(0);
            Assert.assertTrue((boolean)new TypeToken<List<? super Number>>(){}.isSupertypeOf(defaultType));
        }
    }

    private static class NonGenericClassTypeDefaultValueChecker
    extends DefaultValueChecker {
        private NonGenericClassTypeDefaultValueChecker() {
        }

        public void checkArray(Class cls, String s) {
            this.calledWith(cls, s);
        }

        void check() {
            this.runTester();
            Class defaultClass = (Class)this.getDefaultParameterValue(0);
            Assert.assertEquals(Object.class, (Object)defaultClass);
        }
    }

    private static class GenericClassTypeDefaultValueChecker
    extends DefaultValueChecker {
        private GenericClassTypeDefaultValueChecker() {
        }

        public void checkArray(Class<? extends List<?>> cls, String s) {
            this.calledWith(cls, s);
        }

        void check() {
            this.runTester();
            Class defaultClass = (Class)this.getDefaultParameterValue(0);
            Assert.assertEquals(List.class, (Object)defaultClass);
        }
    }

    private static class EmptyEnumDefaultValueChecker
    extends DefaultValueChecker {
        private EmptyEnumDefaultValueChecker() {
        }

        public void checkArray(EmptyEnum object, String s) {
            this.calledWith(new Object[]{object, s});
        }

        void check() {
            try {
                this.runTester();
            }
            catch (AssertionError expected) {
                return;
            }
            Assert.fail((String)"Should have failed because enum has no constant");
        }
    }

    private static enum EmptyEnum {

    }

    private static class IntArrayDefaultValueChecker
    extends DefaultValueChecker {
        private IntArrayDefaultValueChecker() {
        }

        public void checkArray(int[] array, String s) {
            this.calledWith(array, s);
        }

        void check() {
            this.runTester();
            int[] defaultArray = (int[])this.getDefaultParameterValue(0);
            Assert.assertEquals((int)0, (int)defaultArray.length);
        }
    }

    private static class StringArrayDefaultValueChecker
    extends DefaultValueChecker {
        private StringArrayDefaultValueChecker() {
        }

        public void checkArray(String[] array, String s) {
            this.calledWith(array, s);
        }

        void check() {
            this.runTester();
            Object[] defaultArray = (String[])this.getDefaultParameterValue(0);
            Truth.assertThat((Object[])defaultArray).isEmpty();
        }
    }

    private static class ObjectArrayDefaultValueChecker
    extends DefaultValueChecker {
        private ObjectArrayDefaultValueChecker() {
        }

        public void checkArray(Object[] array, String s) {
            this.calledWith(array, s);
        }

        void check() {
            this.runTester();
            Object[] defaultArray = (Object[])this.getDefaultParameterValue(0);
            Truth.assertThat((Object[])defaultArray).isEmpty();
        }
    }

    private static class AllDefaultValuesChecker
    extends DefaultValueChecker {
        private AllDefaultValuesChecker() {
        }

        public void checkDefaultValuesForTheseTypes(Gender gender, Integer integer, int i, String string, CharSequence charSequence, List<String> list, ImmutableList<Integer> immutableList, Map<String, Integer> map, ImmutableMap<String, String> immutableMap, Set<String> set, ImmutableSet<Integer> immutableSet, SortedSet<Number> sortedSet, ImmutableSortedSet<Number> immutableSortedSet, Multiset<String> multiset, ImmutableMultiset<Integer> immutableMultiset, Multimap<String, Integer> multimap, ImmutableMultimap<String, Integer> immutableMultimap, Table<String, Integer, Exception> table, ImmutableTable<Integer, String, Exception> immutableTable) {
            this.calledWith(new Object[]{gender, integer, i, string, charSequence, list, immutableList, map, immutableMap, set, immutableSet, sortedSet, immutableSortedSet, multiset, immutableMultiset, multimap, immutableMultimap, table, immutableTable});
        }

        final void check() {
            this.runTester().assertNonNullValues(new Object[]{Gender.MALE, 0, 0, "", "", ImmutableList.of(), ImmutableList.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableSet.of(), ImmutableSet.of(), ImmutableSortedSet.of(), ImmutableSortedSet.of(), ImmutableMultiset.of(), ImmutableMultiset.of(), ImmutableMultimap.of(), ImmutableMultimap.of(), ImmutableTable.of(), ImmutableTable.of()});
        }
    }

    private static enum Gender {
        MALE,
        FEMALE;

    }

    private static abstract class DefaultValueChecker {
        private final Map<Integer, Object> arguments = Maps.newHashMap();

        private DefaultValueChecker() {
        }

        final DefaultValueChecker runTester() {
            new NullPointerTester().testInstanceMethods((Object)this, NullPointerTester.Visibility.PACKAGE);
            return this;
        }

        final void assertNonNullValues(Object ... expectedValues) {
            Assert.assertEquals((int)expectedValues.length, (int)this.arguments.size());
            for (int i = 0; i < expectedValues.length; ++i) {
                Assert.assertEquals((String)("Default value for parameter #" + i), (Object)expectedValues[i], (Object)this.arguments.get(i));
            }
        }

        final Object getDefaultParameterValue(int position) {
            return this.arguments.get(position);
        }

        final void calledWith(Object ... args) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                this.arguments.put(i, args[i]);
            }
            for (Object arg : args) {
                Preconditions.checkNotNull((Object)arg);
            }
        }
    }

    private static class StringFoo
    implements Foo<String> {
        private StringFoo() {
        }

        @Override
        public void doSomething(String bar, Integer baz) {
            Preconditions.checkNotNull((Object)bar);
            Preconditions.checkNotNull((Object)baz);
        }
    }

    private static interface Foo<T> {
        public void doSomething(T var1, Integer var2);
    }

    private static class PrivateClassWithPrivateConstructor {
        private PrivateClassWithPrivateConstructor(@Nullable Integer argument) {
        }
    }

    private static class CannotCreateDefault {
        private CannotCreateDefault() {
        }

        public void foo(HardToCreate ignored, String required) {
            Preconditions.checkNotNull((Object)ignored);
            Preconditions.checkNotNull((Object)required);
        }
    }

    private static class CanCreateDefault {
        private CanCreateDefault() {
        }

        public void foo(@Nullable HardToCreate ignored, String required) {
            Preconditions.checkNotNull((Object)required);
        }
    }

    private static final class HardToCreate {
        private HardToCreate(HardToCreate x) {
        }
    }

    private static class SubclassThatTriesToOverrideBadStaticMethod
    extends ClassThatFailsToThrowForStatic {
        private SubclassThatTriesToOverrideBadStaticMethod() {
        }

        static void staticOneArg(@Nullable String s) {
        }
    }

    private static class SubclassThatFailsToThrowForStatic
    extends ClassThatFailsToThrowForStatic {
        private SubclassThatFailsToThrowForStatic() {
        }
    }

    private static class ClassThatFailsToThrowForStatic {
        private ClassThatFailsToThrowForStatic() {
        }

        static void staticOneArg(String s) {
        }
    }

    private static class SubclassOverridesTheWrongMethod
    extends BaseClassThatFailsToThrow {
        private SubclassOverridesTheWrongMethod() {
        }

        public void oneArg(@Nullable CharSequence s) {
        }
    }

    private static class SubclassThatOverridesBadSuperclassMethod
    extends BaseClassThatFailsToThrow {
        private SubclassThatOverridesBadSuperclassMethod() {
        }

        @Override
        public void oneArg(@Nullable String s) {
        }
    }

    private static class SubclassWithBadSuperclassForProtected
    extends BaseClassThatFailsToThrowForProtected {
        private SubclassWithBadSuperclassForProtected() {
        }
    }

    private static abstract class BaseClassThatFailsToThrowForProtected {
        private BaseClassThatFailsToThrowForProtected() {
        }

        protected void protectedOneArg(String s) {
        }
    }

    private static class SubclassWithBadSuperclassForPackagePrivate
    extends BaseClassThatFailsToThrowForPackagePrivate {
        private SubclassWithBadSuperclassForPackagePrivate() {
        }
    }

    private static abstract class BaseClassThatFailsToThrowForPackagePrivate {
        private BaseClassThatFailsToThrowForPackagePrivate() {
        }

        void packagePrivateOneArg(String s) {
        }
    }

    private static class SubclassWithBadSuperclass
    extends BaseClassThatFailsToThrow {
        private SubclassWithBadSuperclass() {
        }
    }

    private static abstract class BaseClassThatFailsToThrow {
        private BaseClassThatFailsToThrow() {
        }

        public void oneArg(String s) {
        }
    }

    private static class PassTwoNullableArgsNeitherThrowsAnything
    extends PassObject {
        private PassTwoNullableArgsNeitherThrowsAnything() {
        }

        @Override
        public void twoNullableArgs(@Nullable String s, @Nullable Integer i) {
        }
    }

    private static class PassTwoNullableArgsSecondThrowsOther
    extends PassObject {
        private PassTwoNullableArgsSecondThrowsOther() {
        }

        @Override
        public void twoNullableArgs(@Nullable String s, @Nullable Integer i) {
            PassTwoNullableArgsSecondThrowsOther.doThrow(i);
        }
    }

    private static class PassTwoNullableArgsSecondThrowsNPE
    extends PassObject {
        private PassTwoNullableArgsSecondThrowsNPE() {
        }

        @Override
        public void twoNullableArgs(@Nullable String s, @Nullable Integer i) {
            i.intValue();
        }
    }

    private static class PassTwoNullableArgsFirstThrowsOther
    extends PassObject {
        private PassTwoNullableArgsFirstThrowsOther() {
        }

        @Override
        public void twoNullableArgs(@Nullable String s, @Nullable Integer i) {
            PassTwoNullableArgsFirstThrowsOther.doThrow(s);
        }
    }

    private static class PassTwoNullableArgsFirstThrowsNPE
    extends PassObject {
        private PassTwoNullableArgsFirstThrowsNPE() {
        }

        @Override
        public void twoNullableArgs(@Nullable String s, @Nullable Integer i) {
            Preconditions.checkNotNull((Object)s);
        }
    }

    private static class FailTwoMixedArgsSecondArgThrowsWrongType
    extends PassObject {
        private FailTwoMixedArgsSecondArgThrowsWrongType() {
        }

        @Override
        public void twoMixedArgs(@Nullable Integer i, String s) {
            FailTwoMixedArgsSecondArgThrowsWrongType.doThrow(s);
        }
    }

    private static class FailTwoMixedArgsSecondArgDoesntThrowNPE
    extends PassObject {
        private FailTwoMixedArgsSecondArgDoesntThrowNPE() {
        }

        @Override
        public void twoMixedArgs(@Nullable Integer i, String s) {
        }
    }

    private static class PassTwoMixedArgSecondNullableArgThrowsOther
    extends PassObject {
        private PassTwoMixedArgSecondNullableArgThrowsOther() {
        }

        @Override
        public void twoMixedArgs(String s, @Nullable Integer i) {
            Preconditions.checkNotNull((Object)s);
            PassTwoMixedArgSecondNullableArgThrowsOther.doThrow(i);
        }
    }

    private static class PassTwoMixedArgsNullableArgThrowsNPE
    extends PassObject {
        private PassTwoMixedArgsNullableArgThrowsNPE() {
        }

        @Override
        public void twoMixedArgs(String s, @Nullable Integer i) {
            Preconditions.checkNotNull((Object)s);
            i.intValue();
        }
    }

    private static class FailTwoMixedArgsFirstArgThrowsWrongType
    extends PassObject {
        private FailTwoMixedArgsFirstArgThrowsWrongType() {
        }

        @Override
        public void twoMixedArgs(String s, @Nullable Integer i) {
            FailTwoMixedArgsFirstArgThrowsWrongType.doThrow(s);
        }
    }

    private static class FailTwoMixedArgsFirstArgDoesntThrowNPE
    extends PassObject {
        private FailTwoMixedArgsFirstArgDoesntThrowNPE() {
        }

        @Override
        public void twoMixedArgs(String s, @Nullable Integer i) {
        }
    }

    private static class FailTwoArgsSecondArgThrowsWrongType
    extends PassObject {
        private FailTwoArgsSecondArgThrowsWrongType() {
        }

        @Override
        public void twoArg(String s, Integer i) {
            Preconditions.checkNotNull((Object)s);
            FailTwoArgsSecondArgThrowsWrongType.doThrow(i);
        }
    }

    private static class FailTwoArgsSecondArgDoesntThrowNPE
    extends PassObject {
        private FailTwoArgsSecondArgDoesntThrowNPE() {
        }

        @Override
        public void twoArg(String s, Integer i) {
            Preconditions.checkNotNull((Object)s);
        }
    }

    private static class FailTwoArgsFirstArgThrowsWrongType
    extends PassObject {
        private FailTwoArgsFirstArgThrowsWrongType() {
        }

        @Override
        public void twoArg(String s, Integer i) {
            FailTwoArgsFirstArgThrowsWrongType.doThrow(s);
            i.intValue();
        }
    }

    private static class FailTwoArgsFirstArgDoesntThrowNPE
    extends PassObject {
        private FailTwoArgsFirstArgDoesntThrowNPE() {
        }

        @Override
        public void twoArg(String s, Integer i) {
            i.intValue();
        }
    }

    private static class PassOneNullableArgThrowsNPE
    extends PassObject {
        private PassOneNullableArgThrowsNPE() {
        }

        @Override
        public void oneNullableArg(@Nullable String s) {
            Preconditions.checkNotNull((Object)s);
        }
    }

    private static class FailOneArgThrowsWrongType
    extends PassObject {
        private FailOneArgThrowsWrongType() {
        }

        @Override
        public void oneArg(String s) {
            FailOneArgThrowsWrongType.doThrow(s);
        }
    }

    private static class FailOneArgDoesntThrowNPE
    extends PassObject {
        private FailOneArgDoesntThrowNPE() {
        }

        @Override
        public void oneArg(String s) {
        }
    }

    private static class PassObject
    extends SomeClassThatDoesNotUseNullable {
        private PassObject() {
        }

        public static void doThrow(Object arg) {
            if (arg == null) {
                throw new FooException();
            }
        }

        public void noArg() {
        }

        public void oneArg(String s) {
            Preconditions.checkNotNull((Object)s);
        }

        void packagePrivateOneArg(String s) {
            Preconditions.checkNotNull((Object)s);
        }

        protected void protectedOneArg(String s) {
            Preconditions.checkNotNull((Object)s);
        }

        public void oneNullableArg(@Nullable String s) {
        }

        public void oneNullableArgThrows(@Nullable String s) {
            PassObject.doThrow(s);
        }

        public void twoArg(String s, Integer i) {
            Preconditions.checkNotNull((Object)s);
            i.intValue();
        }

        public void twoMixedArgs(String s, @Nullable Integer i) {
            Preconditions.checkNotNull((Object)s);
        }

        public void twoMixedArgsThrows(String s, @Nullable Integer i) {
            Preconditions.checkNotNull((Object)s);
            PassObject.doThrow(i);
        }

        public void twoMixedArgs(@Nullable Integer i, String s) {
            Preconditions.checkNotNull((Object)s);
        }

        public void twoMixedArgsThrows(@Nullable Integer i, String s) {
            Preconditions.checkNotNull((Object)s);
            PassObject.doThrow(i);
        }

        public void twoNullableArgs(@Nullable String s, @Nullable Integer i) {
        }

        public void twoNullableArgsThrowsFirstArg(@Nullable String s, @Nullable Integer i) {
            PassObject.doThrow(s);
        }

        public void twoNullableArgsThrowsSecondArg(@Nullable String s, @Nullable Integer i) {
            PassObject.doThrow(i);
        }

        public static void staticOneArg(String s) {
            Preconditions.checkNotNull((Object)s);
        }

        public static void staticOneNullableArg(@Nullable String s) {
        }

        public static void staticOneNullableArgThrows(@Nullable String s) {
            PassObject.doThrow(s);
        }
    }

    public static class TwoArg {
        Action actionWhenFirstParamIsNull;
        Action actionWhenSecondParamIsNull;

        public TwoArg(Action actionWhenFirstParamIsNull, Action actionWhenSecondParamIsNull) {
            this.actionWhenFirstParamIsNull = actionWhenFirstParamIsNull;
            this.actionWhenSecondParamIsNull = actionWhenSecondParamIsNull;
        }

        public void reactToNullParameters(Object first, Object second) {
            if (first == null) {
                this.actionWhenFirstParamIsNull.act();
            }
            if (second == null) {
                this.actionWhenSecondParamIsNull.act();
            }
        }

        public void normalNormal(String first, Integer second) {
            this.reactToNullParameters(first, second);
        }

        public void normalNullable(String first, @Nullable Integer second) {
            this.reactToNullParameters(first, second);
        }

        public void nullableNormal(@Nullable String first, Integer second) {
            this.reactToNullParameters(first, second);
        }

        public void nullableNullable(@Nullable String first, @Nullable Integer second) {
            this.reactToNullParameters(first, second);
        }

        public String toString() {
            return NullPointerTesterTest.rootLocaleFormat("Bar(%s, %s)", new Object[]{this.actionWhenFirstParamIsNull, this.actionWhenSecondParamIsNull});
        }

        public static enum Action {
            THROW_A_NPE{

                @Override
                public void act() {
                    throw new NullPointerException();
                }
            }
            ,
            THROW_OTHER{

                @Override
                public void act() {
                    throw new FooException();
                }
            }
            ,
            JUST_RETURN{

                @Override
                public void act() {
                }
            };


            public abstract void act();
        }
    }

    private static class ThrowsSomethingElse {
        private ThrowsSomethingElse() {
        }

        public static void christenPoodle(String name) {
            throw new RuntimeException();
        }
    }

    private static class ThrowsUoe {
        private ThrowsUoe() {
        }

        public static void christenPoodle(String name) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ThrowsNpe {
        private ThrowsNpe() {
        }

        public static void christenPoodle(String name) {
            Preconditions.checkNotNull((Object)name);
        }
    }

    private static class ThrowsIae {
        private ThrowsIae() {
        }

        public static void christenPoodle(String name) {
            Preconditions.checkArgument((name != null ? 1 : 0) != 0);
        }
    }

    public static class OneArg {
        public static void staticOneArgCorrectlyThrowsNpe(String s) {
            Preconditions.checkNotNull((Object)s);
        }

        public static void staticOneArgThrowsOtherThanNpe(String s) {
            throw new FooException();
        }

        public static void staticOneArgShouldThrowNpeButDoesnt(String s) {
        }

        public static void staticOneArgNullableCorrectlyDoesNotThrowNPE(@Nullable String s) {
        }

        public static void staticOneArgNullableCorrectlyThrowsOtherThanNPE(@Nullable String s) {
            throw new FooException();
        }

        public static void staticOneArgNullableThrowsNPE(@Nullable String s) {
            Preconditions.checkNotNull((Object)s);
        }

        public void oneArgCorrectlyThrowsNpe(String s) {
            Preconditions.checkNotNull((Object)s);
        }

        public void oneArgThrowsOtherThanNpe(String s) {
            throw new FooException();
        }

        public void oneArgShouldThrowNpeButDoesnt(String s) {
        }

        public void oneArgNullableCorrectlyDoesNotThrowNPE(@Nullable String s) {
        }

        public void oneArgNullableCorrectlyThrowsOtherThanNPE(@Nullable String s) {
            throw new FooException();
        }

        public void oneArgNullableThrowsNPE(@Nullable String s) {
            Preconditions.checkNotNull((Object)s);
        }
    }

    public static class FooException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

