/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.testing.SerializableTester;
import java.io.Serializable;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class SerializableTesterTest
extends TestCase {
    public void testStringAssertions() {
        String original = "hello world";
        String copy = (String)SerializableTester.reserializeAndAssert((Object)original);
        SerializableTesterTest.assertEquals((String)original, (String)copy);
        SerializableTesterTest.assertNotSame((Object)original, (Object)copy);
    }

    public void testClassWhichDoesNotImplementEquals() {
        ClassWhichDoesNotImplementEquals orig = new ClassWhichDoesNotImplementEquals();
        boolean errorNotThrown = false;
        try {
            SerializableTester.reserializeAndAssert((Object)orig);
            errorNotThrown = true;
        }
        catch (AssertionFailedError error) {
            SerializableTesterTest.assertContains("must be Object#equals to", error.getMessage());
        }
        SerializableTesterTest.assertFalse((boolean)errorNotThrown);
    }

    public void testClassWhichIsAlwaysEqualButHasDifferentHashcodes() {
        ClassWhichIsAlwaysEqualButHasDifferentHashcodes orig = new ClassWhichIsAlwaysEqualButHasDifferentHashcodes();
        boolean errorNotThrown = false;
        try {
            SerializableTester.reserializeAndAssert((Object)orig);
            errorNotThrown = true;
        }
        catch (AssertionFailedError error) {
            SerializableTesterTest.assertContains("must be equal to the Object#hashCode", error.getMessage());
        }
        SerializableTesterTest.assertFalse((boolean)errorNotThrown);
    }

    public void testObjectWhichIsEqualButChangesClass() {
        ObjectWhichIsEqualButChangesClass orig = new ObjectWhichIsEqualButChangesClass();
        boolean errorNotThrown = false;
        try {
            SerializableTester.reserializeAndAssert((Object)orig);
            errorNotThrown = true;
        }
        catch (AssertionFailedError error) {
            SerializableTesterTest.assertContains("expected:<class ", error.getMessage());
        }
        SerializableTesterTest.assertFalse((boolean)errorNotThrown);
    }

    private static void assertContains(String expectedSubstring, String actual) {
        if (!actual.contains(expectedSubstring)) {
            SerializableTesterTest.fail((String)("expected <" + actual + "> to contain <" + expectedSubstring + ">"));
        }
    }

    private static class ObjectWhichIsEqualButChangesClass
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private ObjectWhichIsEqualButChangesClass() {
        }

        public boolean equals(Object other) {
            return other instanceof ObjectWhichIsEqualButChangesClass || other instanceof OtherForm;
        }

        public int hashCode() {
            return 1;
        }

        private Object writeReplace() {
            return new OtherForm();
        }

        private static class OtherForm
        implements Serializable {
            private OtherForm() {
            }

            public boolean equals(Object other) {
                return other instanceof ObjectWhichIsEqualButChangesClass || other instanceof OtherForm;
            }

            public int hashCode() {
                return 1;
            }
        }
    }

    private static class ClassWhichIsAlwaysEqualButHasDifferentHashcodes
    implements Serializable {
        private static final long serialVersionUID = 2L;

        private ClassWhichIsAlwaysEqualButHasDifferentHashcodes() {
        }

        public boolean equals(Object other) {
            return other instanceof ClassWhichIsAlwaysEqualButHasDifferentHashcodes;
        }
    }

    private static class ClassWhichDoesNotImplementEquals
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private ClassWhichDoesNotImplementEquals() {
        }
    }
}

