/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.testing.ClusterException;
import com.google.common.testing.TearDown;
import com.google.common.testing.TearDownStack;
import com.google.common.truth.Truth;
import junit.framework.Assert;
import junit.framework.TestCase;

@GwtCompatible
public class TearDownStackTest
extends TestCase {
    private TearDownStack tearDownStack = new TearDownStack();

    public void testSingleTearDown() throws Exception {
        TearDownStack stack = this.buildTearDownStack();
        SimpleTearDown tearDown = new SimpleTearDown();
        stack.addTearDown((TearDown)tearDown);
        TearDownStackTest.assertEquals((boolean)false, (boolean)tearDown.ran);
        stack.runTearDown();
        TearDownStackTest.assertEquals((String)"tearDown should have run", (boolean)true, (boolean)tearDown.ran);
    }

    public void testMultipleTearDownsHappenInOrder() throws Exception {
        TearDownStack stack = this.buildTearDownStack();
        final SimpleTearDown tearDownOne = new SimpleTearDown();
        stack.addTearDown((TearDown)tearDownOne);
        Callback callback = new Callback(){

            @Override
            public void run() {
                Assert.assertEquals((String)"tearDownTwo should have been run before tearDownOne", (boolean)false, (boolean)tearDownOne.ran);
            }
        };
        SimpleTearDown tearDownTwo = new SimpleTearDown(callback);
        stack.addTearDown((TearDown)tearDownTwo);
        TearDownStackTest.assertEquals((boolean)false, (boolean)tearDownOne.ran);
        TearDownStackTest.assertEquals((boolean)false, (boolean)tearDownTwo.ran);
        stack.runTearDown();
        TearDownStackTest.assertEquals((String)"tearDownOne should have run", (boolean)true, (boolean)tearDownOne.ran);
        TearDownStackTest.assertEquals((String)"tearDownTwo should have run", (boolean)true, (boolean)tearDownTwo.ran);
    }

    public void testThrowingTearDown() throws Exception {
        TearDownStack stack = this.buildTearDownStack();
        ThrowingTearDown tearDownOne = new ThrowingTearDown("one");
        stack.addTearDown((TearDown)tearDownOne);
        ThrowingTearDown tearDownTwo = new ThrowingTearDown("two");
        stack.addTearDown((TearDown)tearDownTwo);
        TearDownStackTest.assertEquals((boolean)false, (boolean)tearDownOne.ran);
        TearDownStackTest.assertEquals((boolean)false, (boolean)tearDownTwo.ran);
        try {
            stack.runTearDown();
            TearDownStackTest.fail((String)"runTearDown should have thrown an exception");
        }
        catch (ClusterException expected) {
            Truth.assertThat((Throwable)expected.getCause()).hasMessage("two");
        }
        catch (RuntimeException e) {
            throw new RuntimeException("A ClusterException should have been thrown, rather than a " + e.getClass().getName(), e);
        }
        TearDownStackTest.assertEquals((boolean)true, (boolean)tearDownOne.ran);
        TearDownStackTest.assertEquals((boolean)true, (boolean)tearDownTwo.ran);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runBare() throws Throwable {
        try {
            this.setUp();
            this.runTest();
        }
        finally {
            this.tearDown();
        }
    }

    protected void tearDown() {
        this.tearDownStack.runTearDown();
    }

    private TearDownStack buildTearDownStack() {
        final TearDownStack result = new TearDownStack();
        this.tearDownStack.addTearDown(new TearDown(){

            public void tearDown() throws Exception {
                Assert.assertEquals((String)"The test should have cleared the stack (say, by virtue of running runTearDown)", (int)0, (int)result.stack.size());
            }
        });
        return result;
    }

    private static interface Callback {
        public void run();
    }

    private static final class SimpleTearDown
    implements TearDown {
        boolean ran = false;
        Callback callback = null;

        public SimpleTearDown() {
        }

        public SimpleTearDown(Callback callback) {
            this.callback = callback;
        }

        public void tearDown() throws Exception {
            if (this.callback != null) {
                this.callback.run();
            }
            this.ran = true;
        }
    }

    private static final class ThrowingTearDown
    implements TearDown {
        private final String id;
        boolean ran = false;

        ThrowingTearDown(String id) {
            this.id = id;
        }

        public void tearDown() throws Exception {
            this.ran = true;
            throw new RuntimeException(this.id);
        }
    }
}

