/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.testing.TearDown;
import com.google.common.testing.TearDownStack;
import com.google.common.testing.TestLogHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import junit.framework.TestCase;

public class TestLogHandlerTest
extends TestCase {
    private TestLogHandler handler;
    private TearDownStack stack = new TearDownStack();
    static final Exception EXCEPTION = new Exception();

    protected void setUp() throws Exception {
        super.setUp();
        this.handler = new TestLogHandler();
        ExampleClassUnderTest.logger.addHandler((Handler)this.handler);
        ExampleClassUnderTest.logger.setUseParentHandlers(false);
        this.stack.addTearDown(new TearDown(){

            public void tearDown() throws Exception {
                ExampleClassUnderTest.logger.setUseParentHandlers(true);
                ExampleClassUnderTest.logger.removeHandler((Handler)TestLogHandlerTest.this.handler);
            }
        });
    }

    public void test() throws Exception {
        TestLogHandlerTest.assertTrue((boolean)this.handler.getStoredLogRecords().isEmpty());
        ExampleClassUnderTest.foo();
        LogRecord record = (LogRecord)this.handler.getStoredLogRecords().get(0);
        TestLogHandlerTest.assertEquals((Object)Level.INFO, (Object)record.getLevel());
        TestLogHandlerTest.assertEquals((String)"message", (String)record.getMessage());
        TestLogHandlerTest.assertSame((Object)EXCEPTION, (Object)record.getThrown());
    }

    public void testConcurrentModification() throws Exception {
        TestLogHandlerTest.assertTrue((boolean)this.handler.getStoredLogRecords().isEmpty());
        ExampleClassUnderTest.foo();
        ExampleClassUnderTest.foo();
        for (LogRecord unused : this.handler.getStoredLogRecords()) {
            ExampleClassUnderTest.foo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runBare() throws Throwable {
        try {
            this.setUp();
            this.runTest();
        }
        finally {
            this.tearDown();
        }
    }

    protected void tearDown() {
        this.stack.runTearDown();
    }

    static class ExampleClassUnderTest {
        static final Logger logger = Logger.getLogger(ExampleClassUnderTest.class.getName());

        ExampleClassUnderTest() {
        }

        static void foo() {
            logger.log(Level.INFO, "message", EXCEPTION);
        }
    }
}

