/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing.anotherpackage;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Ordering;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.google.common.testing.ForwardingWrapperTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import junit.framework.TestCase;

public class ForwardingWrapperTesterTest
extends TestCase {
    private final ForwardingWrapperTester tester = new ForwardingWrapperTester();

    public void testGoodForwarder() {
        this.tester.testForwarding(Arithmetic.class, (Function)new Function<Arithmetic, Arithmetic>(){

            public Arithmetic apply(Arithmetic arithmetic) {
                return new ForwardingArithmetic(arithmetic);
            }
        });
        this.tester.testForwarding(ParameterTypesDifferent.class, (Function)new Function<ParameterTypesDifferent, ParameterTypesDifferent>(){

            public ParameterTypesDifferent apply(ParameterTypesDifferent delegate) {
                return new ParameterTypesDifferentForwarder(delegate);
            }
        });
    }

    public void testVoidMethodForwarding() {
        this.tester.testForwarding(Runnable.class, (Function)new Function<Runnable, Runnable>(){

            public Runnable apply(Runnable runnable) {
                return new ForwardingRunnable(runnable);
            }
        });
    }

    public void testToStringForwarding() {
        this.tester.testForwarding(Runnable.class, (Function)new Function<Runnable, Runnable>(){

            public Runnable apply(final Runnable runnable) {
                return new ForwardingRunnable(runnable){

                    @Override
                    public String toString() {
                        return runnable.toString();
                    }
                };
            }
        });
    }

    public void testFailsToForwardToString() {
        this.assertFailure(Runnable.class, new Function<Runnable, Runnable>(){

            public Runnable apply(Runnable runnable) {
                return new ForwardingRunnable(runnable){

                    @Override
                    public String toString() {
                        return "";
                    }
                };
            }
        }, "toString()");
    }

    public void testFailsToForwardHashCode() {
        this.tester.includingEquals();
        this.assertFailure(Runnable.class, new Function<Runnable, Runnable>(){

            public Runnable apply(final Runnable runnable) {
                return new ForwardingRunnable(runnable){

                    public boolean equals(Object o) {
                        if (o instanceof ForwardingRunnable) {
                            ForwardingRunnable that = (ForwardingRunnable)o;
                            return runnable.equals(that.runnable);
                        }
                        return false;
                    }
                };
            }
        }, "Runnable");
    }

    public void testEqualsAndHashCodeForwarded() {
        this.tester.includingEquals();
        this.tester.testForwarding(Runnable.class, (Function)new Function<Runnable, Runnable>(){

            public Runnable apply(final Runnable runnable) {
                return new ForwardingRunnable(runnable){

                    public boolean equals(Object o) {
                        if (o instanceof ForwardingRunnable) {
                            ForwardingRunnable that = (ForwardingRunnable)o;
                            return runnable.equals(that.runnable);
                        }
                        return false;
                    }

                    public int hashCode() {
                        return runnable.hashCode();
                    }
                };
            }
        });
    }

    public void testFailsToForwardEquals() {
        this.tester.includingEquals();
        this.assertFailure(Runnable.class, new Function<Runnable, Runnable>(){

            public Runnable apply(final Runnable runnable) {
                return new ForwardingRunnable(runnable){

                    public int hashCode() {
                        return runnable.hashCode();
                    }
                };
            }
        }, "Runnable");
    }

    public void testFailsToForward() {
        this.assertFailure(Runnable.class, new Function<Runnable, Runnable>(){

            public Runnable apply(Runnable runnable) {
                return new ForwardingRunnable(runnable){

                    @Override
                    public void run() {
                    }
                };
            }
        }, "run()", "Failed to forward");
    }

    public void testRedundantForwarding() {
        this.assertFailure(Runnable.class, new Function<Runnable, Runnable>(){

            public Runnable apply(final Runnable runnable) {
                return new Runnable(){

                    @Override
                    public void run() {
                        runnable.run();
                        runnable.run();
                    }
                };
            }
        }, "run()", "invoked more than once");
    }

    public void testFailsToForwardParameters() {
        this.assertFailure(Adder.class, new Function<Adder, Adder>(){

            public Adder apply(Adder adder) {
                return new FailsToForwardParameters(adder);
            }
        }, "add(", "Parameter #0");
    }

    public void testForwardsToTheWrongMethod() {
        this.assertFailure(Arithmetic.class, new Function<Arithmetic, Arithmetic>(){

            public Arithmetic apply(Arithmetic adder) {
                return new ForwardsToTheWrongMethod(adder);
            }
        }, "minus");
    }

    public void testFailsToForwardReturnValue() {
        this.assertFailure(Adder.class, new Function<Adder, Adder>(){

            public Adder apply(Adder adder) {
                return new FailsToForwardReturnValue(adder);
            }
        }, "add(", "Return value");
    }

    public void testFailsToPropagateException() {
        this.assertFailure(Adder.class, new Function<Adder, Adder>(){

            public Adder apply(Adder adder) {
                return new FailsToPropagageException(adder);
            }
        }, "add(", "exception");
    }

    public void testNotInterfaceType() {
        try {
            new ForwardingWrapperTester().testForwarding(String.class, Functions.identity());
            ForwardingWrapperTesterTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNulls() {
        new NullPointerTester().setDefault(Class.class, Runnable.class).testAllPublicInstanceMethods((Object)new ForwardingWrapperTester());
    }

    private <T> void assertFailure(Class<T> interfaceType, Function<T, ? extends T> wrapperFunction, String ... expectedMessages) {
        try {
            this.tester.testForwarding(interfaceType, wrapperFunction);
        }
        catch (AssertionError expected) {
            for (String message : expectedMessages) {
                Truth.assertThat((String)((Throwable)((Object)expected)).getMessage()).contains((CharSequence)message);
            }
            return;
        }
        ForwardingWrapperTesterTest.fail((String)"expected failure not reported");
    }

    public void testCovariantReturn() {
        new ForwardingWrapperTester().testForwarding(Sub.class, (Function)new Function<Sub, Sub>(){

            public Sub apply(Sub sub) {
                return new ForwardingSub(sub);
            }
        });
    }

    public void testExplicitEqualsAndHashCodeNotDelegatedByDefault() {
        new ForwardingWrapperTester().testForwarding(Equals.class, NoDelegateToEquals.WRAPPER);
    }

    public void testExplicitEqualsAndHashCodeDelegatedWhenExplicitlyAsked() {
        try {
            new ForwardingWrapperTester().includingEquals().testForwarding(Equals.class, NoDelegateToEquals.WRAPPER);
        }
        catch (AssertionError expected) {
            return;
        }
        ForwardingWrapperTesterTest.fail((String)"Should have failed");
    }

    public void testChainingCalls() {
        this.tester.testForwarding(ChainingCalls.class, (Function)new Function<ChainingCalls, ChainingCalls>(){

            public ChainingCalls apply(ChainingCalls delegate) {
                return new ForwardingChainingCalls(delegate);
            }
        });
    }

    private static class ForwardingChainingCalls
    implements ChainingCalls {
        final ChainingCalls delegate;

        ForwardingChainingCalls(ChainingCalls delegate) {
            this.delegate = delegate;
        }

        @Override
        public ForwardingChainingCalls chainingCall() {
            this.delegate.chainingCall();
            return this;
        }

        @Override
        public ChainingCalls nonChainingCall() {
            return this.delegate.nonChainingCall();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private static interface ChainingCalls {
        public ChainingCalls chainingCall();

        public ChainingCalls nonChainingCall();
    }

    private static class NoDelegateToEquals
    implements Equals {
        private static Function<Equals, Equals> WRAPPER = new Function<Equals, Equals>(){

            public NoDelegateToEquals apply(Equals delegate) {
                return new NoDelegateToEquals(delegate);
            }
        };
        private final Equals delegate;

        NoDelegateToEquals(Equals delegate) {
            this.delegate = delegate;
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }
    }

    private static interface Equals {
        public boolean equals(Object var1);

        public int hashCode();

        public String toString();
    }

    private static class ForwardingSub
    implements Sub {
        private final Sub delegate;

        ForwardingSub(Sub delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getId() {
            return this.delegate.getId();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    static interface Sub
    extends Base {
        @Override
        public String getId();
    }

    static interface Base {
        public CharSequence getId();
    }

    private static class ParameterTypesDifferentForwarder
    implements ParameterTypesDifferent {
        private final ParameterTypesDifferent delegate;

        public ParameterTypesDifferentForwarder(ParameterTypesDifferent delegate) {
            this.delegate = delegate;
        }

        @Override
        public void foo(String s, Runnable r, Number n, Iterable<?> it, boolean b, Equivalence<String> eq, Exception e, InputStream in, Comparable<?> c, Ordering<Integer> ord, Charset charset, TimeUnit unit, Class<?> cls, Joiner joiner, Pattern pattern, UnsignedInteger ui, UnsignedLong ul, StringBuilder sb, Predicate<?> pred, Function<?, ?> func, Object obj) {
            this.delegate.foo(s, r, n, it, b, eq, e, in, c, ord, charset, unit, cls, joiner, pattern, ui, ul, sb, pred, func, obj);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private static interface ParameterTypesDifferent {
        public void foo(String var1, Runnable var2, Number var3, Iterable<?> var4, boolean var5, Equivalence<String> var6, Exception var7, InputStream var8, Comparable<?> var9, Ordering<Integer> var10, Charset var11, TimeUnit var12, Class<?> var13, Joiner var14, Pattern var15, UnsignedInteger var16, UnsignedLong var17, StringBuilder var18, Predicate<?> var19, Function<?, ?> var20, Object var21);
    }

    private static class ForwardsToTheWrongMethod
    implements Arithmetic {
        private final Arithmetic arithmetic;

        ForwardsToTheWrongMethod(Arithmetic arithmetic) {
            this.arithmetic = arithmetic;
        }

        @Override
        public int minus(int a, int b) {
            return this.arithmetic.add(b, a);
        }

        @Override
        public int add(int a, int b) {
            return this.arithmetic.add(b, a);
        }

        public String toString() {
            return this.arithmetic.toString();
        }
    }

    public static interface Arithmetic
    extends Adder {
        public int minus(int var1, int var2);
    }

    private static class FailsToPropagageException
    implements Adder {
        private final Adder adder;

        FailsToPropagageException(Adder adder) {
            this.adder = adder;
        }

        @Override
        public int add(int a, int b) {
            try {
                return this.adder.add(a, b);
            }
            catch (Exception e) {
                return 0;
            }
        }

        public String toString() {
            return this.adder.toString();
        }
    }

    private static class FailsToForwardReturnValue
    implements Adder {
        private final Adder adder;

        FailsToForwardReturnValue(Adder adder) {
            this.adder = adder;
        }

        @Override
        public int add(int a, int b) {
            return this.adder.add(a, b) + 1;
        }

        public String toString() {
            return this.adder.toString();
        }
    }

    private static class FailsToForwardParameters
    implements Adder {
        private final Adder adder;

        FailsToForwardParameters(Adder adder) {
            this.adder = adder;
        }

        @Override
        public int add(int a, int b) {
            return this.adder.add(b, a);
        }

        public String toString() {
            return this.adder.toString();
        }
    }

    private static class ForwardingArithmetic
    implements Arithmetic {
        private final Arithmetic arithmetic;

        public ForwardingArithmetic(Arithmetic arithmetic) {
            this.arithmetic = arithmetic;
        }

        @Override
        public int add(int a, int b) {
            return this.arithmetic.add(a, b);
        }

        @Override
        public int minus(int a, int b) {
            return this.arithmetic.minus(a, b);
        }

        public String toString() {
            return this.arithmetic.toString();
        }
    }

    private static interface Adder {
        public int add(int var1, int var2);
    }

    private class ForwardingRunnable
    implements Runnable {
        private final Runnable runnable;

        ForwardingRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            this.runnable.run();
        }

        public String toString() {
            return this.runnable.toString();
        }
    }
}

