/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent.testing;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AbstractListeningExecutorService;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.testing.SameThreadScheduledExecutorService;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

@Beta
@GwtIncompatible
public final class TestingExecutors {
    private TestingExecutors() {
    }

    public static ListeningScheduledExecutorService noOpScheduledExecutor() {
        return new NoOpScheduledExecutorService();
    }

    public static SameThreadScheduledExecutorService sameThreadScheduledExecutor() {
        return new SameThreadScheduledExecutorService();
    }

    private static final class NoOpScheduledExecutorService
    extends AbstractListeningExecutorService
    implements ListeningScheduledExecutorService {
        private volatile boolean shutdown;

        private NoOpScheduledExecutorService() {
        }

        public void shutdown() {
            this.shutdown = true;
        }

        public List<Runnable> shutdownNow() {
            this.shutdown();
            return ImmutableList.of();
        }

        public boolean isShutdown() {
            return this.shutdown;
        }

        public boolean isTerminated() {
            return this.shutdown;
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return true;
        }

        public void execute(Runnable runnable) {
        }

        public <V> ListenableScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return NeverScheduledFuture.create();
        }

        public ListenableScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return NeverScheduledFuture.create();
        }

        public ListenableScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return NeverScheduledFuture.create();
        }

        public ListenableScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return NeverScheduledFuture.create();
        }

        private static class NeverScheduledFuture<V>
        extends AbstractFuture<V>
        implements ListenableScheduledFuture<V> {
            private NeverScheduledFuture() {
            }

            static <V> NeverScheduledFuture<V> create() {
                return new NeverScheduledFuture<V>();
            }

            public long getDelay(TimeUnit unit) {
                return Long.MAX_VALUE;
            }

            public int compareTo(Delayed other) {
                return Longs.compare((long)this.getDelay(TimeUnit.NANOSECONDS), (long)other.getDelay(TimeUnit.NANOSECONDS));
            }
        }
    }
}

