/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.caliper.runner.CaliperMain;
import com.google.common.base.CharMatcher;
import java.util.BitSet;
import java.util.Random;

public class WhitespaceMatcherBenchmark {
    private static final int STRING_LENGTH = 10000;
    private static final String OLD_WHITESPACE_TABLE = "\u0001\u0000\u00a0\u0000\u0000\u0000\u0000\u0000\u0000\t\n\u000b\f\r\u0000\u0000\u2028\u2029\u0000\u0000\u0000\u0000\u0000\u202f\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000 \u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u3000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0085\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u0000\u0000\u0000\u0000\u0000\u205f\u1680\u0000\u0000\u180e\u0000\u0000\u0000";
    public static final CharMatcher OLD_WHITESPACE = new CharMatcher(){

        public boolean matches(char c) {
            return WhitespaceMatcherBenchmark.OLD_WHITESPACE_TABLE.charAt(c % 79) == c;
        }
    };
    @Param
    private boolean useNew;
    @Param(value={"20", "50", "80"})
    private int percentMatching;
    private String teststring;
    private CharMatcher matcher;

    public static void main(String[] args) throws Exception {
        CaliperMain.main(WhitespaceMatcherBenchmark.class, (String[])new String[0]);
    }

    @BeforeExperiment
    protected void setUp() {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < OLD_WHITESPACE_TABLE.length(); ++i) {
            bitSet.set(OLD_WHITESPACE_TABLE.charAt(i));
        }
        bitSet.clear(0);
        bitSet.clear(1);
        this.matcher = this.useNew ? CharMatcher.WHITESPACE : OLD_WHITESPACE;
        this.teststring = WhitespaceMatcherBenchmark.newTestString(new Random(1L), bitSet, this.percentMatching);
    }

    @Benchmark
    public int countIn(int reps) {
        int result = 0;
        CharMatcher matcher = this.matcher;
        String teststring = this.teststring;
        for (int i = 0; i < reps; ++i) {
            result += matcher.countIn((CharSequence)teststring);
        }
        return result;
    }

    @Benchmark
    public int collapseFrom(int reps) {
        int result = 0;
        CharMatcher matcher = this.matcher;
        String teststring = this.teststring;
        for (int i = 0; i < reps; ++i) {
            result += System.identityHashCode(matcher.collapseFrom((CharSequence)teststring, ' '));
        }
        return result;
    }

    private static String allMatchingChars(BitSet bitSet) {
        char[] result = new char[bitSet.cardinality()];
        int c = bitSet.nextSetBit(0);
        for (int j = 0; j < result.length; ++j) {
            result[j] = (char)c;
            c = bitSet.nextSetBit(c + 1);
        }
        return new String(result);
    }

    private static String newTestString(Random random, BitSet bitSet, int percentMatching) {
        String allMatchingChars = WhitespaceMatcherBenchmark.allMatchingChars(bitSet);
        char[] result = new char[10000];
        for (int i = 0; i < result.length; ++i) {
            result[i] = allMatchingChars.charAt(random.nextInt(allMatchingChars.length()));
        }
        int remaining = (int)((double)((100 - percentMatching) * result.length) / 100.0 + 0.5);
        while (remaining > 0) {
            int pos;
            char c = (char)random.nextInt();
            if (!bitSet.get(c) || !bitSet.get(result[pos = random.nextInt(result.length)])) continue;
            result[pos] = c;
            --remaining;
        }
        return new String(result);
    }
}

