/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;

public class ComparatorDelegationOverheadBenchmark {
    private final Integer[][] inputArrays = new Integer[256][];
    @Param(value={"10000"})
    int n;
    private static final Comparator<Integer> NATURAL_INTEGER = new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            return o1.compareTo(o2);
        }
    };

    @BeforeExperiment
    void setUp() throws Exception {
        Random rng = new Random();
        for (int i = 0; i < 256; ++i) {
            Integer[] array = new Integer[this.n];
            for (int j = 0; j < this.n; ++j) {
                array[j] = rng.nextInt();
            }
            this.inputArrays[i] = array;
        }
    }

    @Benchmark
    int arraysSortNoComparator(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            Object[] copy = (Integer[])this.inputArrays[i & 0xFF].clone();
            Arrays.sort(copy);
            tmp += ((Integer)copy[0]).intValue();
        }
        return tmp;
    }

    @Benchmark
    int arraysSortOrderingNatural(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            Integer[] copy = (Integer[])this.inputArrays[i & 0xFF].clone();
            Arrays.sort(copy, Ordering.natural());
            tmp += copy[0].intValue();
        }
        return tmp;
    }

    @Benchmark
    int arraysSortOrderingFromNatural(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            Integer[] copy = (Integer[])this.inputArrays[i & 0xFF].clone();
            Arrays.sort(copy, Ordering.from(NATURAL_INTEGER));
            tmp += copy[0].intValue();
        }
        return tmp;
    }
}

