/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;

public class ConcurrentHashMultisetBasherTest
extends TestCase {
    public void testAddAndRemove_ConcurrentHashMap() throws Exception {
        this.testAddAndRemove(new ConcurrentHashMap<String, AtomicInteger>());
    }

    public void testAddAndRemove_ConcurrentSkipListMap() throws Exception {
        this.testAddAndRemove(new ConcurrentSkipListMap<String, AtomicInteger>());
    }

    public void testAddAndRemove_MapMakerMap() throws Exception {
        MapMaker mapMaker = new MapMaker();
        mapMaker.useCustomMap = true;
        this.testAddAndRemove(mapMaker.makeMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAddAndRemove(ConcurrentMap<String, AtomicInteger> map) throws ExecutionException, InterruptedException {
        final ConcurrentHashMultiset multiset = new ConcurrentHashMultiset(map);
        int nThreads = 20;
        int tasksPerThread = 10;
        int nTasks = nThreads * tasksPerThread;
        ExecutorService pool = Executors.newFixedThreadPool(nThreads);
        ImmutableList keys = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
        try {
            ArrayList futures = Lists.newArrayListWithExpectedSize((int)nTasks);
            for (int i = 0; i < nTasks; ++i) {
                futures.add(pool.submit(new MutateTask(multiset, keys)));
            }
            int[] deltas = new int[3];
            for (Future future : futures) {
                int[] taskDeltas = (int[])future.get();
                for (int i = 0; i < deltas.length; ++i) {
                    int n = i;
                    deltas[n] = deltas[n] + taskDeltas[i];
                }
            }
            List actualCounts = Lists.transform((List)keys, (Function)new Function<String, Integer>(){

                public Integer apply(String key) {
                    return multiset.count((Object)key);
                }
            });
            ConcurrentHashMultisetBasherTest.assertEquals((String)"Counts not as expected", (Object)Ints.asList((int[])deltas), (Object)actualCounts);
        }
        finally {
            pool.shutdownNow();
        }
        for (AtomicInteger value : map.values()) {
            ConcurrentHashMultisetBasherTest.assertTrue((String)"map should not contain a zero", (value.get() != 0 ? 1 : 0) != 0);
        }
    }

    private static class MutateTask
    implements Callable<int[]> {
        private final ConcurrentHashMultiset<String> multiset;
        private final ImmutableList<String> keys;
        private final Random random = new Random();

        private MutateTask(ConcurrentHashMultiset<String> multiset, ImmutableList<String> keys) {
            this.multiset = multiset;
            this.keys = keys;
        }

        @Override
        public int[] call() throws Exception {
            int iterations = 100000;
            int nKeys = this.keys.size();
            int[] deltas = new int[nKeys];
            Operation[] operations = Operation.values();
            block7: for (int i = 0; i < iterations; ++i) {
                int keyIndex = this.random.nextInt(nKeys);
                String key = (String)this.keys.get(keyIndex);
                Operation op = operations[this.random.nextInt(operations.length)];
                switch (op) {
                    case ADD: {
                        int delta = this.random.nextInt(10);
                        this.multiset.add((Object)key, delta);
                        int n = keyIndex;
                        deltas[n] = deltas[n] + delta;
                        continue block7;
                    }
                    case SET_COUNT: {
                        int newValue = this.random.nextInt(3);
                        int oldValue = this.multiset.setCount((Object)key, newValue);
                        int n = keyIndex;
                        deltas[n] = deltas[n] + (newValue - oldValue);
                        continue block7;
                    }
                    case SET_COUNT_IF: {
                        int newValue = this.random.nextInt(3);
                        int oldValue = this.multiset.count((Object)key);
                        if (!this.multiset.setCount((Object)key, oldValue, newValue)) continue block7;
                        int n = keyIndex;
                        deltas[n] = deltas[n] + (newValue - oldValue);
                        continue block7;
                    }
                    case REMOVE: {
                        int delta = this.random.nextInt(6);
                        int oldValue = this.multiset.remove((Object)key, delta);
                        int n = keyIndex;
                        deltas[n] = deltas[n] - Math.min(delta, oldValue);
                        continue block7;
                    }
                    case REMOVE_EXACTLY: {
                        int delta = this.random.nextInt(5);
                        if (!this.multiset.removeExactly((Object)key, delta)) continue block7;
                        int n = keyIndex;
                        deltas[n] = deltas[n] - delta;
                        continue block7;
                    }
                }
            }
            return deltas;
        }

        private static enum Operation {
            ADD,
            SET_COUNT,
            SET_COUNT_IF,
            REMOVE,
            REMOVE_EXACTLY;

        }
    }
}

