/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.MapConstraint;
import com.google.common.collect.MapConstraints;
import com.google.common.collect.MapConstraintsTest;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.BiMapTestSuiteBuilder;
import com.google.common.collect.testing.google.TestBiMapGenerator;
import com.google.common.collect.testing.google.TestStringBiMapGenerator;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class ConstrainedBiMapTest
extends TestCase {
    private static final String TEST_KEY = "42";
    private static final String TEST_VALUE = "test";
    private static final MapConstraint<String, String> TEST_CONSTRAINT = new TestConstraint();

    @GwtIncompatible(value="suite")
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((BiMapTestSuiteBuilder)((BiMapTestSuiteBuilder)BiMapTestSuiteBuilder.using((TestBiMapGenerator)new ConstrainedBiMapGenerator()).named("Maps.constrainedBiMap[HashBiMap]")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.GENERAL_PURPOSE, MapFeature.REJECTS_DUPLICATES_AT_CREATION})).createTestSuite());
        suite.addTestSuite(ConstrainedBiMapTest.class);
        return suite;
    }

    public void testPutWithForbiddenKeyForbiddenValue() {
        BiMap map = MapConstraints.constrainedBiMap((BiMap)HashBiMap.create(), TEST_CONSTRAINT);
        try {
            map.put((Object)TEST_KEY, (Object)TEST_VALUE);
            ConstrainedBiMapTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPutWithForbiddenKeyAllowedValue() {
        BiMap map = MapConstraints.constrainedBiMap((BiMap)HashBiMap.create(), TEST_CONSTRAINT);
        try {
            map.put((Object)TEST_KEY, (Object)"allowed");
            ConstrainedBiMapTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPutWithAllowedKeyForbiddenValue() {
        BiMap map = MapConstraints.constrainedBiMap((BiMap)HashBiMap.create(), TEST_CONSTRAINT);
        try {
            map.put((Object)"allowed", (Object)TEST_VALUE);
            ConstrainedBiMapTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static final class TestConstraint
    implements MapConstraint<String, String> {
        private static final long serialVersionUID = 0L;

        private TestConstraint() {
        }

        public void checkKeyValue(String key, String value) {
            if (ConstrainedBiMapTest.TEST_KEY.equals(key)) {
                throw new MapConstraintsTest.TestKeyException();
            }
            if (ConstrainedBiMapTest.TEST_VALUE.equals(value)) {
                throw new MapConstraintsTest.TestValueException();
            }
        }
    }

    public static final class ConstrainedBiMapGenerator
    extends TestStringBiMapGenerator {
        protected BiMap<String, String> create(Map.Entry<String, String>[] entries) {
            BiMap bimap = MapConstraints.constrainedBiMap((BiMap)HashBiMap.create(), (MapConstraint)TEST_CONSTRAINT);
            for (Map.Entry<String, String> entry : entries) {
                Preconditions.checkArgument((!bimap.containsKey((Object)entry.getKey()) ? 1 : 0) != 0);
                bimap.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            return bimap;
        }
    }
}

