/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ForwardingSortedSet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.testing.EqualsTester;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import junit.framework.TestCase;

public class FilteredCollectionsTest
extends TestCase {
    private static final Predicate<Integer> EVEN = new Predicate<Integer>(){

        public boolean apply(Integer input) {
            return input % 2 == 0;
        }
    };
    private static final Predicate<Integer> PRIME_DIGIT = Predicates.in((Collection)ImmutableSet.of((Object)2, (Object)3, (Object)5, (Object)7));
    private static final ImmutableList<? extends List<Integer>> SAMPLE_INPUTS = ImmutableList.of((Object)ImmutableList.of(), (Object)ImmutableList.of((Object)1), (Object)ImmutableList.of((Object)2), (Object)ImmutableList.of((Object)2, (Object)3), (Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)3, (Object)5), (Object)ImmutableList.of((Object)2, (Object)4), (Object)ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)5, (Object)6, (Object)8, (Object)9));

    public void testNoop() {
    }

    public static final class SetsFilterNavigableSetTest
    extends AbstractFilteredNavigableSetTest {
        @Override
        NavigableSet<Integer> createUnfiltered(Iterable<Integer> contents) {
            return Sets.newTreeSet(contents);
        }

        @Override
        NavigableSet<Integer> filter(NavigableSet<Integer> elements, Predicate<? super Integer> predicate) {
            return Sets.filter(elements, predicate);
        }
    }

    public static final class SetsFilterSortedSetTest
    extends AbstractFilteredSortedSetTest<SortedSet<Integer>> {
        @Override
        SortedSet<Integer> createUnfiltered(Iterable<Integer> contents) {
            final TreeSet result = Sets.newTreeSet(contents);
            return new ForwardingSortedSet<Integer>(){

                protected SortedSet<Integer> delegate() {
                    return result;
                }
            };
        }

        @Override
        SortedSet<Integer> filter(SortedSet<Integer> elements, Predicate<? super Integer> predicate) {
            return Sets.filter(elements, predicate);
        }
    }

    public static final class SetsFilterHashSetTest
    extends AbstractFilteredSetTest<Set<Integer>> {
        @Override
        Set<Integer> createUnfiltered(Iterable<Integer> contents) {
            return Sets.newHashSet(contents);
        }

        @Override
        Set<Integer> filter(Set<Integer> elements, Predicate<? super Integer> predicate) {
            return Sets.filter(elements, predicate);
        }
    }

    public static final class Collections2FilterArrayListTest
    extends AbstractFilteredCollectionTest<Collection<Integer>> {
        @Override
        Collection<Integer> createUnfiltered(Iterable<Integer> contents) {
            return Lists.newArrayList(contents);
        }

        @Override
        Collection<Integer> filter(Collection<Integer> elements, Predicate<? super Integer> predicate) {
            return Collections2.filter(elements, predicate);
        }
    }

    public static final class IterablesFilterArrayListTest
    extends AbstractFilteredIterableTest<Iterable<Integer>> {
        @Override
        Iterable<Integer> createUnfiltered(Iterable<Integer> contents) {
            return Lists.newArrayList(contents);
        }

        @Override
        Iterable<Integer> filter(Iterable<Integer> elements, Predicate<? super Integer> predicate) {
            return Iterables.filter(elements, predicate);
        }
    }

    public static abstract class AbstractFilteredNavigableSetTest
    extends AbstractFilteredSortedSetTest<NavigableSet<Integer>> {
        public void testNavigableHeadSet() {
            for (List contents : SAMPLE_INPUTS) {
                for (int i = 0; i < 10; ++i) {
                    Iterator i$ = ImmutableList.of((Object)true, (Object)false).iterator();
                    while (i$.hasNext()) {
                        boolean inclusive = (Boolean)i$.next();
                        AbstractFilteredNavigableSetTest.assertEquals(this.filter(((NavigableSet)this.createUnfiltered(contents)).headSet(i, inclusive), (Predicate<Integer>)EVEN), ((NavigableSet)this.filter(this.createUnfiltered(contents), (Predicate<Integer>)EVEN)).headSet(i, inclusive));
                    }
                }
            }
        }

        public void testNavigableTailSet() {
            for (List contents : SAMPLE_INPUTS) {
                for (int i = 0; i < 10; ++i) {
                    Iterator i$ = ImmutableList.of((Object)true, (Object)false).iterator();
                    while (i$.hasNext()) {
                        boolean inclusive = (Boolean)i$.next();
                        AbstractFilteredNavigableSetTest.assertEquals(this.filter(((NavigableSet)this.createUnfiltered(contents)).tailSet(i, inclusive), (Predicate<Integer>)EVEN), ((NavigableSet)this.filter(this.createUnfiltered(contents), (Predicate<Integer>)EVEN)).tailSet(i, inclusive));
                    }
                }
            }
        }

        public void testNavigableSubSet() {
            for (List contents : SAMPLE_INPUTS) {
                for (int i = 0; i < 10; ++i) {
                    for (int j = i + 1; j < 10; ++j) {
                        Iterator i$ = ImmutableList.of((Object)true, (Object)false).iterator();
                        while (i$.hasNext()) {
                            boolean fromInclusive = (Boolean)i$.next();
                            Iterator i$2 = ImmutableList.of((Object)true, (Object)false).iterator();
                            while (i$2.hasNext()) {
                                boolean toInclusive = (Boolean)i$2.next();
                                NavigableSet<Integer> filterSubset = this.filter(((NavigableSet)this.createUnfiltered(contents)).subSet(i, fromInclusive, j, toInclusive), (Predicate<Integer>)EVEN);
                                NavigableSet<Integer> subsetFilter = ((NavigableSet)this.filter(this.createUnfiltered(contents), (Predicate<Integer>)EVEN)).subSet(i, fromInclusive, j, toInclusive);
                                AbstractFilteredNavigableSetTest.assertEquals(filterSubset, subsetFilter);
                            }
                        }
                    }
                }
            }
        }

        public void testDescendingSet() {
            for (List contents : SAMPLE_INPUTS) {
                NavigableSet filtered = (NavigableSet)this.filter(this.createUnfiltered(contents), (Predicate<Integer>)EVEN);
                NavigableSet unfiltered = (NavigableSet)this.createUnfiltered(filtered);
                Truth.assertThat(filtered.descendingSet()).containsExactlyElementsIn(unfiltered.descendingSet()).inOrder();
            }
        }

        public void testPollFirst() {
            for (List contents : SAMPLE_INPUTS) {
                NavigableSet filtered = (NavigableSet)this.filter(this.createUnfiltered(contents), (Predicate<Integer>)EVEN);
                NavigableSet unfiltered = (NavigableSet)this.createUnfiltered(filtered);
                AbstractFilteredNavigableSetTest.assertEquals(unfiltered.pollFirst(), filtered.pollFirst());
                AbstractFilteredNavigableSetTest.assertEquals((Object)unfiltered, (Object)filtered);
            }
        }

        public void testPollLast() {
            for (List contents : SAMPLE_INPUTS) {
                NavigableSet filtered = (NavigableSet)this.filter(this.createUnfiltered(contents), (Predicate<Integer>)EVEN);
                NavigableSet unfiltered = (NavigableSet)this.createUnfiltered(filtered);
                AbstractFilteredNavigableSetTest.assertEquals(unfiltered.pollLast(), filtered.pollLast());
                AbstractFilteredNavigableSetTest.assertEquals((Object)unfiltered, (Object)filtered);
            }
        }

        public void testNavigation() {
            for (List contents : SAMPLE_INPUTS) {
                NavigableSet filtered = (NavigableSet)this.filter(this.createUnfiltered(contents), (Predicate<Integer>)EVEN);
                NavigableSet unfiltered = (NavigableSet)this.createUnfiltered(filtered);
                for (int i = 0; i < 10; ++i) {
                    AbstractFilteredNavigableSetTest.assertEquals((Object)unfiltered.lower(i), (Object)filtered.lower(i));
                    AbstractFilteredNavigableSetTest.assertEquals((Object)unfiltered.floor(i), (Object)filtered.floor(i));
                    AbstractFilteredNavigableSetTest.assertEquals((Object)unfiltered.ceiling(i), (Object)filtered.ceiling(i));
                    AbstractFilteredNavigableSetTest.assertEquals((Object)unfiltered.higher(i), (Object)filtered.higher(i));
                }
            }
        }
    }

    public static abstract class AbstractFilteredSortedSetTest<C extends SortedSet<Integer>>
    extends AbstractFilteredSetTest<C> {
        public void testFirst() {
            for (List contents : SAMPLE_INPUTS) {
                SortedSet filtered = (SortedSet)this.filter(this.createUnfiltered(contents), (Predicate<Integer>)EVEN);
                try {
                    Integer first = (Integer)filtered.first();
                    AbstractFilteredSortedSetTest.assertFalse((boolean)filtered.isEmpty());
                    AbstractFilteredSortedSetTest.assertEquals((Object)Ordering.natural().min((Iterable)filtered), (Object)first);
                }
                catch (NoSuchElementException e) {
                    AbstractFilteredSortedSetTest.assertTrue((boolean)filtered.isEmpty());
                }
            }
        }

        public void testLast() {
            for (List contents : SAMPLE_INPUTS) {
                SortedSet filtered = (SortedSet)this.filter(this.createUnfiltered(contents), (Predicate<Integer>)EVEN);
                try {
                    Integer first = (Integer)filtered.last();
                    AbstractFilteredSortedSetTest.assertFalse((boolean)filtered.isEmpty());
                    AbstractFilteredSortedSetTest.assertEquals((Object)Ordering.natural().max((Iterable)filtered), (Object)first);
                }
                catch (NoSuchElementException e) {
                    AbstractFilteredSortedSetTest.assertTrue((boolean)filtered.isEmpty());
                }
            }
        }

        public void testHeadSet() {
            for (List contents : SAMPLE_INPUTS) {
                for (int i = 0; i < 10; ++i) {
                    AbstractFilteredSortedSetTest.assertEquals(this.filter(((SortedSet)this.createUnfiltered(contents)).headSet(i), (Predicate<Integer>)EVEN), ((SortedSet)this.filter(this.createUnfiltered(contents), (Predicate<Integer>)EVEN)).headSet(i));
                }
            }
        }

        public void testTailSet() {
            for (List contents : SAMPLE_INPUTS) {
                for (int i = 0; i < 10; ++i) {
                    AbstractFilteredSortedSetTest.assertEquals(this.filter(((SortedSet)this.createUnfiltered(contents)).tailSet(i), (Predicate<Integer>)EVEN), ((SortedSet)this.filter(this.createUnfiltered(contents), (Predicate<Integer>)EVEN)).tailSet(i));
                }
            }
        }

        public void testSubSet() {
            for (List contents : SAMPLE_INPUTS) {
                for (int i = 0; i < 10; ++i) {
                    for (int j = i; j < 10; ++j) {
                        AbstractFilteredSortedSetTest.assertEquals(this.filter(((SortedSet)this.createUnfiltered(contents)).subSet(i, j), (Predicate<Integer>)EVEN), ((SortedSet)this.filter(this.createUnfiltered(contents), (Predicate<Integer>)EVEN)).subSet(i, j));
                    }
                }
            }
        }
    }

    public static abstract class AbstractFilteredSetTest<C extends Set<Integer>>
    extends AbstractFilteredCollectionTest<C> {
        public void testEqualsAndHashCode() {
            for (List contents : SAMPLE_INPUTS) {
                HashSet expected = Sets.newHashSet();
                for (Integer i : contents) {
                    if (!EVEN.apply((Object)i)) continue;
                    expected.add(i);
                }
                new EqualsTester().addEqualityGroup(new Object[]{expected, this.filter(this.createUnfiltered(contents), (Predicate<Integer>)EVEN)}).testEquals();
            }
        }
    }

    public static abstract class AbstractFilteredCollectionTest<C extends Collection<Integer>>
    extends AbstractFilteredIterableTest<C> {
        public void testReadsThroughAdd() {
            for (List contents : SAMPLE_INPUTS) {
                Collection unfiltered = (Collection)this.createUnfiltered(contents);
                Collection filterThenAdd = this.filter(unfiltered, (Predicate<Integer>)EVEN);
                unfiltered.add(4);
                ArrayList target = Lists.newArrayList((Iterable)contents);
                target.add(4);
                Collection addThenFilter = (Collection)this.filter(this.createUnfiltered(target), (Predicate<Integer>)EVEN);
                Truth.assertThat((Collection)filterThenAdd).containsExactlyElementsIn((Iterable)addThenFilter);
            }
        }

        public void testAdd() {
            for (List contents : SAMPLE_INPUTS) {
                for (int toAdd = 0; toAdd < 10; ++toAdd) {
                    boolean expectedResult = ((Collection)this.createUnfiltered(contents)).add(toAdd);
                    Collection filtered = (Collection)this.filter(this.createUnfiltered(contents), (Predicate<Integer>)EVEN);
                    try {
                        AbstractFilteredCollectionTest.assertEquals((boolean)expectedResult, (boolean)filtered.add(toAdd));
                        AbstractFilteredCollectionTest.assertTrue((boolean)EVEN.apply((Object)toAdd));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        AbstractFilteredCollectionTest.assertFalse((boolean)EVEN.apply((Object)toAdd));
                    }
                }
            }
        }

        public void testRemove() {
            for (List contents : SAMPLE_INPUTS) {
                for (int toRemove = 0; toRemove < 10; ++toRemove) {
                    AbstractFilteredCollectionTest.assertEquals((contents.contains(toRemove) && EVEN.apply((Object)toRemove) ? 1 : 0) != 0, (boolean)((Collection)this.filter(this.createUnfiltered(contents), (Predicate<Integer>)EVEN)).remove(toRemove));
                }
            }
        }

        public void testContains() {
            for (List contents : SAMPLE_INPUTS) {
                for (int i = 0; i < 10; ++i) {
                    AbstractFilteredCollectionTest.assertEquals((EVEN.apply((Object)i) && contents.contains(i) ? 1 : 0) != 0, (boolean)((Collection)this.filter(this.createUnfiltered(contents), (Predicate<Integer>)EVEN)).contains(i));
                }
            }
        }

        public void testContainsOnDifferentType() {
            for (List contents : SAMPLE_INPUTS) {
                AbstractFilteredCollectionTest.assertFalse((boolean)((Collection)this.filter(this.createUnfiltered(contents), (Predicate<Integer>)EVEN)).contains(new Object()));
            }
        }

        public void testAddAllFailsAtomically() {
            ImmutableList toAdd = ImmutableList.of((Object)2, (Object)4, (Object)3);
            for (List contents : SAMPLE_INPUTS) {
                Collection filtered = (Collection)this.filter(this.createUnfiltered(contents), (Predicate<Integer>)EVEN);
                Collection filteredToModify = (Collection)this.filter(this.createUnfiltered(contents), (Predicate<Integer>)EVEN);
                try {
                    filteredToModify.addAll(toAdd);
                    AbstractFilteredCollectionTest.fail((String)"Expected IllegalArgumentException");
                }
                catch (IllegalArgumentException expected) {
                    // empty catch block
                }
                Truth.assertThat((Collection)filteredToModify).containsExactlyElementsIn((Iterable)filtered);
            }
        }

        public void testAddToFilterFiltered() {
            for (List contents : SAMPLE_INPUTS) {
                Collection unfiltered = (Collection)this.createUnfiltered(contents);
                Collection filtered1 = this.filter(unfiltered, (Predicate<Integer>)EVEN);
                Collection filtered2 = this.filter(filtered1, (Predicate<Integer>)PRIME_DIGIT);
                try {
                    filtered2.add(4);
                    AbstractFilteredCollectionTest.fail((String)"Expected IllegalArgumentException");
                }
                catch (IllegalArgumentException expected) {
                    // empty catch block
                }
                try {
                    filtered2.add(3);
                    AbstractFilteredCollectionTest.fail((String)"Expected IllegalArgumentException");
                }
                catch (IllegalArgumentException expected) {
                    // empty catch block
                }
                filtered2.add(2);
            }
        }

        public void testClearFilterFiltered() {
            for (List contents : SAMPLE_INPUTS) {
                Collection unfiltered = (Collection)this.createUnfiltered(contents);
                Collection filtered1 = this.filter(unfiltered, (Predicate<Integer>)EVEN);
                Collection filtered2 = this.filter(filtered1, (Predicate<Integer>)PRIME_DIGIT);
                Collection inverseFiltered = (Collection)this.filter(this.createUnfiltered(contents), (Predicate<Integer>)Predicates.not((Predicate)Predicates.and((Predicate)EVEN, (Predicate)PRIME_DIGIT)));
                filtered2.clear();
                Truth.assertThat((Collection)unfiltered).containsExactlyElementsIn((Iterable)inverseFiltered);
            }
        }
    }

    public static abstract class AbstractFilteredIterableTest<C extends Iterable<Integer>>
    extends TestCase {
        abstract C createUnfiltered(Iterable<Integer> var1);

        abstract C filter(C var1, Predicate<? super Integer> var2);

        public void testIterationOrderPreserved() {
            for (List contents : SAMPLE_INPUTS) {
                C unfiltered = this.createUnfiltered(contents);
                C filtered = this.filter(unfiltered, (Predicate<Integer>)EVEN);
                Iterator filteredItr = filtered.iterator();
                for (Integer i : unfiltered) {
                    if (!EVEN.apply((Object)i)) continue;
                    AbstractFilteredIterableTest.assertTrue((boolean)filteredItr.hasNext());
                    AbstractFilteredIterableTest.assertEquals((Object)i, filteredItr.next());
                }
                AbstractFilteredIterableTest.assertFalse((boolean)filteredItr.hasNext());
            }
        }
    }
}

