/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.AbstractIteratorTester;
import com.google.common.collect.testing.IteratorFeature;
import com.google.common.collect.testing.IteratorTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class FluentIterableTest
extends TestCase {
    @GwtIncompatible(value="NullPointerTester")
    public void testNullPointerExceptions() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(FluentIterable.class);
    }

    public void testFrom() {
        FluentIterableTest.assertEquals((Object)ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4), (Object)Lists.newArrayList((Iterable)FluentIterable.from((Iterable)ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4))));
    }

    public void testFrom_alreadyFluentIterable() {
        FluentIterable iterable = FluentIterable.from(Arrays.asList(1));
        FluentIterableTest.assertSame((Object)iterable, (Object)FluentIterable.from((FluentIterable)iterable));
    }

    public void testOfArray() {
        FluentIterableTest.assertEquals((Object)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4"), (Object)Lists.newArrayList((Iterable)FluentIterable.of((Object[])new Object[]{"1", "2", "3", "4"})));
    }

    public void testSize1Collection() {
        FluentIterableTest.assertEquals((int)1, (int)FluentIterable.from(Arrays.asList("a")).size());
    }

    public void testSize2NonCollection() {
        Iterable<Integer> iterable = new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return Arrays.asList(0, 1).iterator();
            }
        };
        FluentIterableTest.assertEquals((int)2, (int)FluentIterable.from((Iterable)iterable).size());
    }

    public void testSize_collectionDoesntIterate() {
        List<Integer> nums = Arrays.asList(1, 2, 3, 4, 5);
        ArrayList<Integer> collection = new ArrayList<Integer>(nums){

            @Override
            public Iterator<Integer> iterator() {
                throw new AssertionFailedError("Don't iterate me!");
            }
        };
        FluentIterableTest.assertEquals((int)5, (int)FluentIterable.from((Iterable)collection).size());
    }

    public void testContains_nullSetYes() {
        HashSet set = Sets.newHashSet((Object[])new String[]{"a", null, "b"});
        FluentIterableTest.assertTrue((boolean)FluentIterable.from((Iterable)set).contains(null));
    }

    public void testContains_nullSetNo() {
        ImmutableSortedSet set = ImmutableSortedSet.of((Comparable)((Object)"a"), (Comparable)((Object)"b"));
        FluentIterableTest.assertFalse((boolean)FluentIterable.from((Iterable)set).contains(null));
    }

    public void testContains_nullIterableYes() {
        Iterable<String> iterable = FluentIterableTest.iterable("a", null, "b");
        FluentIterableTest.assertTrue((boolean)FluentIterable.from(iterable).contains(null));
    }

    public void testContains_nullIterableNo() {
        Iterable<String> iterable = FluentIterableTest.iterable("a", "b");
        FluentIterableTest.assertFalse((boolean)FluentIterable.from(iterable).contains(null));
    }

    public void testContains_nonNullSetYes() {
        HashSet set = Sets.newHashSet((Object[])new String[]{"a", null, "b"});
        FluentIterableTest.assertTrue((boolean)FluentIterable.from((Iterable)set).contains((Object)"b"));
    }

    public void testContains_nonNullSetNo() {
        HashSet set = Sets.newHashSet((Object[])new String[]{"a", "b"});
        FluentIterableTest.assertFalse((boolean)FluentIterable.from((Iterable)set).contains((Object)"c"));
    }

    public void testContains_nonNullIterableYes() {
        Iterable<String> set = FluentIterableTest.iterable("a", null, "b");
        FluentIterableTest.assertTrue((boolean)FluentIterable.from(set).contains((Object)"b"));
    }

    public void testContains_nonNullIterableNo() {
        Iterable<String> iterable = FluentIterableTest.iterable("a", "b");
        FluentIterableTest.assertFalse((boolean)FluentIterable.from(iterable).contains((Object)"c"));
    }

    public void testCycle() {
        FluentIterable cycle = FluentIterable.from(Arrays.asList("a", "b")).cycle();
        int howManyChecked = 0;
        for (String string : cycle) {
            String expected = howManyChecked % 2 == 0 ? "a" : "b";
            FluentIterableTest.assertEquals((String)expected, (String)string);
            if (howManyChecked++ != 5) continue;
            break;
        }
        FluentIterableTest.assertEquals((String)"a", (String)((String)cycle.iterator().next()));
    }

    public void testCycle_removingAllElementsStopsCycle() {
        FluentIterable cycle = FluentIterableTest.fluent(1, 2).cycle();
        Iterator iterator = cycle.iterator();
        iterator.next();
        iterator.remove();
        iterator.next();
        iterator.remove();
        FluentIterableTest.assertFalse((boolean)iterator.hasNext());
        FluentIterableTest.assertFalse((boolean)cycle.iterator().hasNext());
    }

    public void testAppend() {
        FluentIterable result = FluentIterable.from(Arrays.asList(1, 2, 3)).append((Iterable)Lists.newArrayList((Object[])new Integer[]{4, 5, 6}));
        FluentIterableTest.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 6), (Object)Lists.newArrayList((Iterable)result));
        FluentIterableTest.assertEquals((String)"[1, 2, 3, 4, 5, 6]", (String)result.toString());
        result = FluentIterable.from(Arrays.asList(1, 2, 3)).append((Object[])new Integer[]{4, 5, 6});
        FluentIterableTest.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 6), (Object)Lists.newArrayList((Iterable)result));
        FluentIterableTest.assertEquals((String)"[1, 2, 3, 4, 5, 6]", (String)result.toString());
    }

    public void testAppend_emptyList() {
        FluentIterable result = FluentIterable.from(Arrays.asList(1, 2, 3)).append((Iterable)Lists.newArrayList());
        FluentIterableTest.assertEquals(Arrays.asList(1, 2, 3), (Object)Lists.newArrayList((Iterable)result));
    }

    public void testAppend_nullPointerException() {
        try {
            FluentIterable.from(Arrays.asList(1, 2)).append((Iterable)null);
            FluentIterableTest.fail((String)"Appending null iterable should throw NPE.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testFilter() {
        FluentIterable filtered = FluentIterable.from(Arrays.asList("foo", "bar")).filter(Predicates.equalTo((Object)"foo"));
        List<String> expected = Collections.singletonList("foo");
        ArrayList actual = Lists.newArrayList((Iterable)filtered);
        FluentIterableTest.assertEquals(expected, (Object)actual);
        FluentIterableTest.assertCanIterateAgain(filtered);
        FluentIterableTest.assertEquals((String)"[foo]", (String)filtered.toString());
    }

    @GwtIncompatible(value="Iterables.filter(Iterable, Class)")
    public void testFilterByType() throws Exception {
        HasBoth hasBoth = new HasBoth();
        FluentIterable alist = FluentIterable.from(Arrays.asList(new TypeA(), new TypeA(), hasBoth, new TypeA()));
        FluentIterable blist = alist.filter(TypeB.class);
        Truth.assertThat((Iterable)blist).containsExactly(new Object[]{hasBoth}).inOrder();
    }

    public void testAnyMatch() {
        ArrayList list = Lists.newArrayList();
        FluentIterable iterable = FluentIterable.from((Iterable)list);
        Predicate predicate = Predicates.equalTo((Object)"pants");
        FluentIterableTest.assertFalse((boolean)iterable.anyMatch(predicate));
        list.add("cool");
        FluentIterableTest.assertFalse((boolean)iterable.anyMatch(predicate));
        list.add("pants");
        FluentIterableTest.assertTrue((boolean)iterable.anyMatch(predicate));
    }

    public void testAllMatch() {
        ArrayList list = Lists.newArrayList();
        FluentIterable iterable = FluentIterable.from((Iterable)list);
        Predicate predicate = Predicates.equalTo((Object)"cool");
        FluentIterableTest.assertTrue((boolean)iterable.allMatch(predicate));
        list.add("cool");
        FluentIterableTest.assertTrue((boolean)iterable.allMatch(predicate));
        list.add("pants");
        FluentIterableTest.assertFalse((boolean)iterable.allMatch(predicate));
    }

    public void testFirstMatch() {
        FluentIterable iterable = FluentIterable.from((Iterable)Lists.newArrayList((Object[])new String[]{"cool", "pants"}));
        Truth.assertThat((Optional)iterable.firstMatch(Predicates.equalTo((Object)"cool"))).hasValue((Object)"cool");
        Truth.assertThat((Optional)iterable.firstMatch(Predicates.equalTo((Object)"pants"))).hasValue((Object)"pants");
        Truth.assertThat((Optional)iterable.firstMatch(Predicates.alwaysFalse())).isAbsent();
        Truth.assertThat((Optional)iterable.firstMatch(Predicates.alwaysTrue())).hasValue((Object)"cool");
    }

    public void testTransformWith() {
        List<String> input = Arrays.asList("1", "2", "3");
        FluentIterable iterable = FluentIterable.from(input).transform((Function)new IntegerValueOfFunction());
        FluentIterableTest.assertEquals(Arrays.asList(1, 2, 3), (Object)Lists.newArrayList((Iterable)iterable));
        FluentIterableTest.assertCanIterateAgain(iterable);
        FluentIterableTest.assertEquals((String)"[1, 2, 3]", (String)iterable.toString());
    }

    public void testTransformWith_poorlyBehavedTransform() {
        List<String> input = Arrays.asList("1", null, "3");
        FluentIterable iterable = FluentIterable.from(input).transform((Function)new IntegerValueOfFunction());
        Iterator resultIterator = iterable.iterator();
        resultIterator.next();
        try {
            resultIterator.next();
            FluentIterableTest.fail((String)"Transforming null to int should throw NumberFormatException");
        }
        catch (NumberFormatException expected) {
            // empty catch block
        }
    }

    public void testTransformWith_nullFriendlyTransform() {
        List<Integer> input = Arrays.asList(1, 2, null, 3);
        FluentIterable result = FluentIterable.from(input).transform((Function)new StringValueOfFunction());
        FluentIterableTest.assertEquals(Arrays.asList("1", "2", "null", "3"), (Object)Lists.newArrayList((Iterable)result));
    }

    public void testTransformAndConcat() {
        List<Integer> input = Arrays.asList(1, 2, 3);
        FluentIterable result = FluentIterable.from(input).transformAndConcat((Function)new RepeatedStringValueOfFunction());
        FluentIterableTest.assertEquals(Arrays.asList("1", "1", "2", "2", "3", "3"), (Object)Lists.newArrayList((Iterable)result));
    }

    public void testTransformAndConcat_wildcardFunctionGenerics() {
        List<Integer> input = Arrays.asList(1, 2, 3);
        FluentIterable.from(input).transformAndConcat((Function)new RepeatedStringValueOfWildcardFunction());
    }

    public void testFirst_list() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        Truth.assertThat((Optional)FluentIterable.from((Iterable)list).first()).hasValue((Object)"a");
    }

    public void testFirst_null() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{null, "a", "b"});
        try {
            FluentIterable.from((Iterable)list).first();
            FluentIterableTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testFirst_emptyList() {
        List list = Collections.emptyList();
        Truth.assertThat((Optional)FluentIterable.from(list).first()).isAbsent();
    }

    public void testFirst_sortedSet() {
        ImmutableSortedSet sortedSet = ImmutableSortedSet.of((Comparable)((Object)"b"), (Comparable)((Object)"c"), (Comparable)((Object)"a"));
        Truth.assertThat((Optional)FluentIterable.from((Iterable)sortedSet).first()).hasValue((Object)"a");
    }

    public void testFirst_emptySortedSet() {
        ImmutableSortedSet sortedSet = ImmutableSortedSet.of();
        Truth.assertThat((Optional)FluentIterable.from((Iterable)sortedSet).first()).isAbsent();
    }

    public void testFirst_iterable() {
        ImmutableSet set = ImmutableSet.of((Object)"a", (Object)"b", (Object)"c");
        Truth.assertThat((Optional)FluentIterable.from((Iterable)set).first()).hasValue((Object)"a");
    }

    public void testFirst_emptyIterable() {
        HashSet set = Sets.newHashSet();
        Truth.assertThat((Optional)FluentIterable.from((Iterable)set).first()).isAbsent();
    }

    public void testLast_list() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        Truth.assertThat((Optional)FluentIterable.from((Iterable)list).last()).hasValue((Object)"c");
    }

    public void testLast_null() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", null});
        try {
            FluentIterable.from((Iterable)list).last();
            FluentIterableTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testLast_emptyList() {
        List list = Collections.emptyList();
        Truth.assertThat((Optional)FluentIterable.from(list).last()).isAbsent();
    }

    public void testLast_sortedSet() {
        ImmutableSortedSet sortedSet = ImmutableSortedSet.of((Comparable)((Object)"b"), (Comparable)((Object)"c"), (Comparable)((Object)"a"));
        Truth.assertThat((Optional)FluentIterable.from((Iterable)sortedSet).last()).hasValue((Object)"c");
    }

    public void testLast_emptySortedSet() {
        ImmutableSortedSet sortedSet = ImmutableSortedSet.of();
        Truth.assertThat((Optional)FluentIterable.from((Iterable)sortedSet).last()).isAbsent();
    }

    public void testLast_iterable() {
        ImmutableSet set = ImmutableSet.of((Object)"a", (Object)"b", (Object)"c");
        Truth.assertThat((Optional)FluentIterable.from((Iterable)set).last()).hasValue((Object)"c");
    }

    public void testLast_emptyIterable() {
        HashSet set = Sets.newHashSet();
        Truth.assertThat((Optional)FluentIterable.from((Iterable)set).last()).isAbsent();
    }

    public void testSkip_simple() {
        ImmutableSet set = ImmutableSet.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e");
        FluentIterableTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"c", "d", "e"}), (Object)Lists.newArrayList((Iterable)FluentIterable.from((Iterable)set).skip(2)));
        FluentIterableTest.assertEquals((String)"[c, d, e]", (String)FluentIterable.from((Iterable)set).skip(2).toString());
    }

    public void testSkip_simpleList() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e"});
        FluentIterableTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"c", "d", "e"}), (Object)Lists.newArrayList((Iterable)FluentIterable.from((Iterable)list).skip(2)));
        FluentIterableTest.assertEquals((String)"[c, d, e]", (String)FluentIterable.from((Iterable)list).skip(2).toString());
    }

    public void testSkip_pastEnd() {
        ImmutableSet set = ImmutableSet.of((Object)"a", (Object)"b");
        FluentIterableTest.assertEquals(Collections.emptyList(), (Object)Lists.newArrayList((Iterable)FluentIterable.from((Iterable)set).skip(20)));
    }

    public void testSkip_pastEndList() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b"});
        FluentIterableTest.assertEquals(Collections.emptyList(), (Object)Lists.newArrayList((Iterable)FluentIterable.from((Iterable)list).skip(20)));
    }

    public void testSkip_skipNone() {
        ImmutableSet set = ImmutableSet.of((Object)"a", (Object)"b");
        FluentIterableTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b"}), (Object)Lists.newArrayList((Iterable)FluentIterable.from((Iterable)set).skip(0)));
    }

    public void testSkip_skipNoneList() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b"});
        FluentIterableTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b"}), (Object)Lists.newArrayList((Iterable)FluentIterable.from((Iterable)list).skip(0)));
    }

    public void testSkip_iterator() throws Exception {
        new IteratorTester<Integer>(5, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)Lists.newArrayList((Object[])new Integer[]{2, 3}), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<Integer> newTargetIterator() {
                LinkedHashSet collection = Sets.newLinkedHashSet();
                Collections.addAll(collection, 1, 2, 3);
                return FluentIterable.from((Iterable)collection).skip(1).iterator();
            }
        }.test();
    }

    public void testSkip_iteratorList() throws Exception {
        new IteratorTester<Integer>(5, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)Lists.newArrayList((Object[])new Integer[]{2, 3}), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<Integer> newTargetIterator() {
                return FluentIterable.from((Iterable)Lists.newArrayList((Object[])new Integer[]{1, 2, 3})).skip(1).iterator();
            }
        }.test();
    }

    public void testSkip_nonStructurallyModifiedList() throws Exception {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        FluentIterable tail = FluentIterable.from((Iterable)list).skip(1);
        Iterator tailIterator = tail.iterator();
        list.set(2, "c2");
        FluentIterableTest.assertEquals((String)"b", (String)((String)tailIterator.next()));
        FluentIterableTest.assertEquals((String)"c2", (String)((String)tailIterator.next()));
        FluentIterableTest.assertFalse((boolean)tailIterator.hasNext());
    }

    public void testSkip_structurallyModifiedSkipSome() throws Exception {
        LinkedHashSet set = Sets.newLinkedHashSet();
        Collections.addAll(set, "a", "b", "c");
        FluentIterable tail = FluentIterable.from((Iterable)set).skip(1);
        set.remove("b");
        set.addAll(Lists.newArrayList((Object[])new String[]{"X", "Y", "Z"}));
        Truth.assertThat((Iterable)tail).containsExactly(new Object[]{"c", "X", "Y", "Z"}).inOrder();
    }

    public void testSkip_structurallyModifiedSkipSomeList() throws Exception {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        FluentIterable tail = FluentIterable.from((Iterable)list).skip(1);
        list.subList(1, 3).clear();
        list.addAll(0, Lists.newArrayList((Object[])new String[]{"X", "Y", "Z"}));
        Truth.assertThat((Iterable)tail).containsExactly(new Object[]{"Y", "Z", "a"}).inOrder();
    }

    public void testSkip_structurallyModifiedSkipAll() throws Exception {
        LinkedHashSet set = Sets.newLinkedHashSet();
        Collections.addAll(set, "a", "b", "c");
        FluentIterable tail = FluentIterable.from((Iterable)set).skip(2);
        set.remove("a");
        set.remove("b");
        FluentIterableTest.assertFalse((boolean)tail.iterator().hasNext());
    }

    public void testSkip_structurallyModifiedSkipAllList() throws Exception {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        FluentIterable tail = FluentIterable.from((Iterable)list).skip(2);
        list.subList(0, 2).clear();
        Truth.assertThat((Iterable)tail).isEmpty();
    }

    public void testSkip_illegalArgument() {
        try {
            FluentIterable.from(Arrays.asList("a", "b", "c")).skip(-1);
            FluentIterableTest.fail((String)"Skipping negative number of elements should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testLimit() {
        ArrayList iterable = Lists.newArrayList((Object[])new String[]{"foo", "bar", "baz"});
        FluentIterable limited = FluentIterable.from((Iterable)iterable).limit(2);
        FluentIterableTest.assertEquals((Object)ImmutableList.of((Object)"foo", (Object)"bar"), (Object)Lists.newArrayList((Iterable)limited));
        FluentIterableTest.assertCanIterateAgain(limited);
        FluentIterableTest.assertEquals((String)"[foo, bar]", (String)limited.toString());
    }

    public void testLimit_illegalArgument() {
        try {
            FluentIterable.from((Iterable)Lists.newArrayList((Object[])new String[]{"a", "b", "c"})).limit(-1);
            FluentIterableTest.fail((String)"Passing negative number to limit(...) method should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIsEmpty() {
        FluentIterableTest.assertTrue((boolean)FluentIterable.from(Collections.emptyList()).isEmpty());
        FluentIterableTest.assertFalse((boolean)FluentIterable.from((Iterable)Lists.newArrayList((Object[])new String[]{"foo"})).isEmpty());
    }

    public void testToList() {
        FluentIterableTest.assertEquals((Object)Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4}), (Object)FluentIterableTest.fluent(1, 2, 3, 4).toList());
    }

    public void testToList_empty() {
        FluentIterableTest.assertTrue((boolean)FluentIterableTest.fluent(new Integer[0]).toList().isEmpty());
    }

    public void testToSortedList_withComparator() {
        FluentIterableTest.assertEquals((Object)Lists.newArrayList((Object[])new Integer[]{4, 3, 2, 1}), (Object)FluentIterableTest.fluent(4, 1, 3, 2).toSortedList((Comparator)Ordering.natural().reverse()));
    }

    public void testToSortedList_withDuplicates() {
        FluentIterableTest.assertEquals((Object)Lists.newArrayList((Object[])new Integer[]{4, 3, 1, 1}), (Object)FluentIterableTest.fluent(1, 4, 1, 3).toSortedList((Comparator)Ordering.natural().reverse()));
    }

    public void testToSet() {
        Truth.assertThat((Collection)FluentIterableTest.fluent(1, 2, 3, 4).toSet()).containsExactly(new Object[]{1, 2, 3, 4}).inOrder();
    }

    public void testToSet_removeDuplicates() {
        Truth.assertThat((Collection)FluentIterableTest.fluent(1, 2, 1, 2).toSet()).containsExactly(new Object[]{1, 2}).inOrder();
    }

    public void testToSet_empty() {
        FluentIterableTest.assertTrue((boolean)FluentIterableTest.fluent(new Integer[0]).toSet().isEmpty());
    }

    public void testToSortedSet() {
        Truth.assertThat((Collection)FluentIterableTest.fluent(1, 4, 2, 3).toSortedSet((Comparator)Ordering.natural().reverse())).containsExactly(new Object[]{4, 3, 2, 1}).inOrder();
    }

    public void testToSortedSet_removeDuplicates() {
        Truth.assertThat((Collection)FluentIterableTest.fluent(1, 4, 1, 3).toSortedSet((Comparator)Ordering.natural().reverse())).containsExactly(new Object[]{4, 3, 1}).inOrder();
    }

    public void testToMultiset() {
        Truth.assertThat((Multiset)FluentIterableTest.fluent(1, 2, 1, 3, 2, 4).toMultiset()).containsExactly(new Object[]{1, 1, 2, 2, 3, 4}).inOrder();
    }

    public void testToMultiset_empty() {
        Truth.assertThat((Multiset)FluentIterableTest.fluent(new Integer[0]).toMultiset()).isEmpty();
    }

    public void testToMap() {
        Truth.assertThat((Collection)FluentIterableTest.fluent(1, 2, 3).toMap(Functions.toStringFunction()).entrySet()).containsExactly(new Object[]{Maps.immutableEntry((Object)1, (Object)"1"), Maps.immutableEntry((Object)2, (Object)"2"), Maps.immutableEntry((Object)3, (Object)"3")}).inOrder();
    }

    public void testToMap_nullKey() {
        try {
            FluentIterableTest.fluent(1, null, 2).toMap(Functions.constant((Object)"foo"));
            FluentIterableTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToMap_nullValue() {
        try {
            FluentIterableTest.fluent(1, 2, 3).toMap(Functions.constant(null));
            FluentIterableTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testIndex() {
        ImmutableListMultimap expected = ImmutableListMultimap.builder().putAll((Object)3, (Object[])new String[]{"one", "two"}).put((Object)5, (Object)"three").put((Object)4, (Object)"four").build();
        ImmutableListMultimap index = FluentIterable.from(Arrays.asList("one", "two", "three", "four")).index((Function)new Function<String, Integer>(){

            public Integer apply(String input) {
                return input.length();
            }
        });
        FluentIterableTest.assertEquals((Object)expected, (Object)index);
    }

    public void testIndex_nullKey() {
        try {
            FluentIterableTest.fluent(1, 2, 3).index(Functions.constant(null));
            FluentIterableTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testIndex_nullValue() {
        try {
            FluentIterableTest.fluent(1, null, 2).index(Functions.constant((Object)"foo"));
            FluentIterableTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testUniqueIndex() {
        ImmutableMap expected = ImmutableMap.of((Object)3, (Object)"two", (Object)5, (Object)"three", (Object)4, (Object)"four");
        ImmutableMap index = FluentIterable.from(Arrays.asList("two", "three", "four")).uniqueIndex((Function)new Function<String, Integer>(){

            public Integer apply(String input) {
                return input.length();
            }
        });
        FluentIterableTest.assertEquals((Object)expected, (Object)index);
    }

    public void testUniqueIndex_duplicateKey() {
        try {
            FluentIterable.from(Arrays.asList("one", "two", "three", "four")).uniqueIndex((Function)new Function<String, Integer>(){

                public Integer apply(String input) {
                    return input.length();
                }
            });
            FluentIterableTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testUniqueIndex_nullKey() {
        try {
            FluentIterableTest.fluent(1, 2, 3).uniqueIndex(Functions.constant(null));
            FluentIterableTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testUniqueIndex_nullValue() {
        try {
            FluentIterableTest.fluent(1, null, 2).uniqueIndex((Function)new Function<Integer, Object>(){

                public Object apply(@Nullable Integer input) {
                    return String.valueOf(input);
                }
            });
            FluentIterableTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopyInto_List() {
        Truth.assertThat((List)((List)FluentIterableTest.fluent(1, 3, 5).copyInto((Collection)Lists.newArrayList((Object[])new Integer[]{1, 2})))).containsExactly(new Object[]{1, 2, 1, 3, 5}).inOrder();
    }

    public void testCopyInto_Set() {
        Truth.assertThat((Collection)FluentIterableTest.fluent(1, 3, 5).copyInto((Collection)Sets.newHashSet((Object[])new Integer[]{1, 2}))).containsExactly(new Object[]{1, 2, 3, 5});
    }

    public void testCopyInto_SetAllDuplicates() {
        Truth.assertThat((Collection)FluentIterableTest.fluent(1, 3, 5).copyInto((Collection)Sets.newHashSet((Object[])new Integer[]{1, 2, 3, 5}))).containsExactly(new Object[]{1, 2, 3, 5});
    }

    public void testCopyInto_NonCollection() {
        ArrayList list = Lists.newArrayList((Object[])new Integer[]{1, 2, 3});
        final ArrayList iterList = Lists.newArrayList((Object[])new Integer[]{9, 8, 7});
        Iterable<Integer> iterable = new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return iterList.iterator();
            }
        };
        Truth.assertThat((List)((List)FluentIterable.from((Iterable)iterable).copyInto((Collection)list))).containsExactly(new Object[]{1, 2, 3, 9, 8, 7}).inOrder();
    }

    public void testJoin() {
        FluentIterableTest.assertEquals((String)"2,1,3,4", (String)FluentIterableTest.fluent(2, 1, 3, 4).join(Joiner.on((String)",")));
    }

    public void testJoin_empty() {
        FluentIterableTest.assertEquals((String)"", (String)FluentIterableTest.fluent(new Integer[0]).join(Joiner.on((String)",")));
    }

    public void testGet() {
        FluentIterableTest.assertEquals((String)"a", (String)((String)FluentIterable.from((Iterable)Lists.newArrayList((Object[])new String[]{"a", "b", "c"})).get(0)));
        FluentIterableTest.assertEquals((String)"b", (String)((String)FluentIterable.from((Iterable)Lists.newArrayList((Object[])new String[]{"a", "b", "c"})).get(1)));
        FluentIterableTest.assertEquals((String)"c", (String)((String)FluentIterable.from((Iterable)Lists.newArrayList((Object[])new String[]{"a", "b", "c"})).get(2)));
    }

    public void testGet_outOfBounds() {
        try {
            FluentIterable.from((Iterable)Lists.newArrayList((Object[])new String[]{"a", "b", "c"})).get(-1);
            FluentIterableTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        try {
            FluentIterable.from((Iterable)Lists.newArrayList((Object[])new String[]{"a", "b", "c"})).get(3);
            FluentIterableTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private static void assertCanIterateAgain(Iterable<?> iterable) {
        for (Object obj : iterable) {
        }
    }

    private static FluentIterable<Integer> fluent(Integer ... elements) {
        return FluentIterable.from((Iterable)Lists.newArrayList((Object[])elements));
    }

    private static Iterable<String> iterable(String ... elements) {
        final List<String> list = Arrays.asList(elements);
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return list.iterator();
            }
        };
    }

    private static final class RepeatedStringValueOfWildcardFunction
    implements Function<Integer, List<? extends String>> {
        private RepeatedStringValueOfWildcardFunction() {
        }

        public List<String> apply(Integer from) {
            String value = String.valueOf(from);
            return ImmutableList.of((Object)value, (Object)value);
        }
    }

    private static final class RepeatedStringValueOfFunction
    implements Function<Integer, List<String>> {
        private RepeatedStringValueOfFunction() {
        }

        public List<String> apply(Integer from) {
            String value = String.valueOf(from);
            return ImmutableList.of((Object)value, (Object)value);
        }
    }

    private static final class StringValueOfFunction
    implements Function<Integer, String> {
        private StringValueOfFunction() {
        }

        public String apply(Integer from) {
            return String.valueOf(from);
        }
    }

    private static final class IntegerValueOfFunction
    implements Function<String, Integer> {
        private IntegerValueOfFunction() {
        }

        public Integer apply(String from) {
            return Integer.valueOf(from);
        }
    }

    private static class HasBoth
    extends TypeA
    implements TypeB {
        private HasBoth() {
        }
    }

    private static interface TypeB {
    }

    private static class TypeA {
        private TypeA() {
        }
    }
}

