/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ForwardingSetTest;
import com.google.common.collect.ForwardingSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.SafeTreeSet;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestStringSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ForwardingSortedSetTest
extends ForwardingSetTest {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ForwardingSortedSetTest.class);
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return new StandardImplForwardingSortedSet(new SafeTreeSet(Arrays.asList(elements)));
            }

            public List<String> order(List<String> insertionOrder) {
                return Lists.newArrayList((Iterable)Sets.newTreeSet(insertionOrder));
            }
        }).named("ForwardingSortedSet[SafeTreeSet] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.GENERAL_PURPOSE})).createTestSuite());
        return suite;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        final SortedSet sortedSet = this.createProxyInstance(SortedSet.class);
        this.forward = new ForwardingSortedSet<String>(){

            protected SortedSet<String> delegate() {
                return sortedSet;
            }
        };
    }

    public void testComparator() {
        this.forward().comparator();
        ForwardingSortedSetTest.assertEquals((String)"[comparator]", (String)this.getCalls());
    }

    public void testFirst() {
        this.forward().first();
        ForwardingSortedSetTest.assertEquals((String)"[first]", (String)this.getCalls());
    }

    public void testHeadSet_K() {
        this.forward().headSet("asdf");
        ForwardingSortedSetTest.assertEquals((String)"[headSet(Object)]", (String)this.getCalls());
    }

    public void testLast() {
        this.forward().last();
        ForwardingSortedSetTest.assertEquals((String)"[last]", (String)this.getCalls());
    }

    public void testSubSet_K_K() {
        this.forward().subSet("first", "last");
        ForwardingSortedSetTest.assertEquals((String)"[subSet(Object,Object)]", (String)this.getCalls());
    }

    public void testTailSet_K() {
        this.forward().tailSet("last");
        ForwardingSortedSetTest.assertEquals((String)"[tailSet(Object)]", (String)this.getCalls());
    }

    SortedSet<String> forward() {
        return (SortedSet)super.forward();
    }

    static class StandardImplForwardingSortedSet<T>
    extends ForwardingSortedSet<T> {
        private final SortedSet<T> backingSet;

        StandardImplForwardingSortedSet(SortedSet<T> backingSet) {
            this.backingSet = backingSet;
        }

        protected SortedSet<T> delegate() {
            return this.backingSet;
        }

        public boolean equals(Object object) {
            return this.standardEquals(object);
        }

        public int hashCode() {
            return this.standardHashCode();
        }

        public boolean addAll(Collection<? extends T> collection) {
            return this.standardAddAll(collection);
        }

        public void clear() {
            this.standardClear();
        }

        public boolean contains(Object object) {
            return this.standardContains(object);
        }

        public boolean containsAll(Collection<?> collection) {
            return this.standardContainsAll(collection);
        }

        public boolean remove(Object object) {
            return this.standardRemove(object);
        }

        public boolean removeAll(Collection<?> collection) {
            return this.standardRemoveAll(collection);
        }

        public boolean retainAll(Collection<?> collection) {
            return this.standardRetainAll(collection);
        }

        public Object[] toArray() {
            return this.standardToArray();
        }

        public <T> T[] toArray(T[] array) {
            return this.standardToArray(array);
        }

        public String toString() {
            return this.standardToString();
        }

        public SortedSet<T> subSet(T fromElement, T toElement) {
            return this.standardSubSet(fromElement, toElement);
        }
    }
}

