/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.AbstractTableTest;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;

@GwtCompatible(emulated=true)
public class HashBasedTableTest
extends AbstractTableTest {
    @Override
    protected Table<String, Integer, Character> create(Object ... data) {
        HashBasedTable table = HashBasedTable.create();
        table.put((Object)"foo", (Object)4, (Object)Character.valueOf('a'));
        table.put((Object)"cat", (Object)1, (Object)Character.valueOf('b'));
        table.clear();
        this.populate((Table<String, Integer, Character>)table, data);
        return table;
    }

    public void testCreateWithValidSizes() {
        HashBasedTable table1 = HashBasedTable.create((int)100, (int)20);
        table1.put((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
        HashBasedTableTest.assertEquals((Object)Character.valueOf('a'), (Object)table1.get((Object)"foo", (Object)1));
        HashBasedTable table2 = HashBasedTable.create((int)100, (int)0);
        table2.put((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
        HashBasedTableTest.assertEquals((Object)Character.valueOf('a'), (Object)table2.get((Object)"foo", (Object)1));
        HashBasedTable table3 = HashBasedTable.create((int)0, (int)20);
        table3.put((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
        HashBasedTableTest.assertEquals((Object)Character.valueOf('a'), (Object)table3.get((Object)"foo", (Object)1));
        HashBasedTable table4 = HashBasedTable.create((int)0, (int)0);
        table4.put((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
        HashBasedTableTest.assertEquals((Object)Character.valueOf('a'), (Object)table4.get((Object)"foo", (Object)1));
    }

    public void testCreateWithInvalidSizes() {
        try {
            HashBasedTable.create((int)100, (int)-5);
            HashBasedTableTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            HashBasedTable.create((int)-5, (int)20);
            HashBasedTableTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreateCopy() {
        Table<String, Integer, Character> original = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        HashBasedTable copy = HashBasedTable.create(original);
        HashBasedTableTest.assertEquals(original, (Object)copy);
        HashBasedTableTest.assertEquals((Object)Character.valueOf('a'), (Object)copy.get((Object)"foo", (Object)1));
    }

    @GwtIncompatible(value="SerializableTester")
    public void testSerialization() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        SerializableTester.reserializeAndAssert((Object)this.table);
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNullPointerStatic() {
        new NullPointerTester().testAllPublicStaticMethods(HashBasedTable.class);
    }
}

