/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.testing.SerializableTester;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import junit.framework.TestCase;

@GwtIncompatible(value="NavigableMap")
public class ImmutableRangeMapTest
extends TestCase {
    private static final ImmutableList<Range<Integer>> RANGES;
    private static final int MIN_BOUND = 0;
    private static final int MAX_BOUND = 10;

    public void testBuilderRejectsEmptyRanges() {
        for (int i = 0; i <= 10; ++i) {
            ImmutableRangeMap.Builder builder = ImmutableRangeMap.builder();
            try {
                builder.put(Range.closedOpen((Comparable)Integer.valueOf(i), (Comparable)Integer.valueOf(i)), (Object)1);
                ImmutableRangeMapTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException expected) {
                // empty catch block
            }
            try {
                builder.put(Range.openClosed((Comparable)Integer.valueOf(i), (Comparable)Integer.valueOf(i)), (Object)1);
                ImmutableRangeMapTest.fail((String)"Expected IllegalArgumentException");
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void testOverlapRejection() {
        for (Range range1 : RANGES) {
            for (Range range2 : RANGES) {
                boolean expectRejection = range1.isConnected(range2) && !range1.intersection(range2).isEmpty();
                ImmutableRangeMap.Builder builder = ImmutableRangeMap.builder();
                builder.put(range1, (Object)1);
                try {
                    builder.put(range2, (Object)2);
                    ImmutableRangeMapTest.assertFalse((boolean)expectRejection);
                }
                catch (IllegalArgumentException e) {
                    ImmutableRangeMapTest.assertTrue((boolean)expectRejection);
                }
            }
        }
    }

    public void testGet() {
        for (Range range1 : RANGES) {
            for (Range range2 : RANGES) {
                if (range1.isConnected(range2) && !range1.intersection(range2).isEmpty()) continue;
                ImmutableRangeMap rangeMap = ImmutableRangeMap.builder().put(range1, (Object)1).put(range2, (Object)2).build();
                for (int i = 0; i <= 10; ++i) {
                    Integer expectedValue = null;
                    if (range1.contains((Comparable)Integer.valueOf(i))) {
                        expectedValue = 1;
                    } else if (range2.contains((Comparable)Integer.valueOf(i))) {
                        expectedValue = 2;
                    }
                    ImmutableRangeMapTest.assertEquals((Object)expectedValue, (Object)rangeMap.get((Comparable)Integer.valueOf(i)));
                }
            }
        }
    }

    public void testSpanEmpty() {
        try {
            ImmutableRangeMap.of().span();
            ImmutableRangeMapTest.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testSpanSingleRange() {
        for (Range range : RANGES) {
            ImmutableRangeMap rangemap = ImmutableRangeMap.builder().put(range, (Object)1).build();
            ImmutableRangeMapTest.assertEquals((Object)range, (Object)rangemap.span());
        }
    }

    public void testSpanTwoRanges() {
        for (Range range1 : RANGES) {
            for (Range range2 : RANGES) {
                if (range1.isConnected(range2) && !range1.intersection(range2).isEmpty()) continue;
                ImmutableRangeMap rangemap = ImmutableRangeMap.builder().put(range1, (Object)1).put(range2, (Object)2).build();
                ImmutableRangeMapTest.assertEquals((Object)range1.span(range2), (Object)rangemap.span());
            }
        }
    }

    public void testGetEntry() {
        for (Range range1 : RANGES) {
            for (Range range2 : RANGES) {
                if (range1.isConnected(range2) && !range1.intersection(range2).isEmpty()) continue;
                ImmutableRangeMap rangeMap = ImmutableRangeMap.builder().put(range1, (Object)1).put(range2, (Object)2).build();
                for (int i = 0; i <= 10; ++i) {
                    Map.Entry expectedEntry = null;
                    if (range1.contains((Comparable)Integer.valueOf(i))) {
                        expectedEntry = Maps.immutableEntry((Object)range1, (Object)1);
                    } else if (range2.contains((Comparable)Integer.valueOf(i))) {
                        expectedEntry = Maps.immutableEntry((Object)range2, (Object)2);
                    }
                    ImmutableRangeMapTest.assertEquals((Object)expectedEntry, (Object)rangeMap.getEntry((Comparable)Integer.valueOf(i)));
                }
            }
        }
    }

    public void testGetLargeRangeMap() {
        ImmutableRangeMap.Builder builder = ImmutableRangeMap.builder();
        for (int i = 0; i < 100; ++i) {
            builder.put(Range.closedOpen((Comparable)Integer.valueOf(i), (Comparable)Integer.valueOf(i + 1)), (Object)i);
        }
        ImmutableRangeMap map = builder.build();
        for (int i = 0; i < 100; ++i) {
            ImmutableRangeMapTest.assertEquals((Object)i, (Object)map.get((Comparable)Integer.valueOf(i)));
        }
    }

    public void testAsMapOfRanges() {
        for (Range range1 : RANGES) {
            for (Range range2 : RANGES) {
                if (range1.isConnected(range2) && !range1.intersection(range2).isEmpty()) continue;
                ImmutableRangeMap rangeMap = ImmutableRangeMap.builder().put(range1, (Object)1).put(range2, (Object)2).build();
                ImmutableMap expectedAsMap = ImmutableMap.of((Object)range1, (Object)1, (Object)range2, (Object)2);
                ImmutableMap asMap = rangeMap.asMapOfRanges();
                ImmutableMap descendingMap = rangeMap.asDescendingMapOfRanges();
                ImmutableRangeMapTest.assertEquals((Object)expectedAsMap, (Object)asMap);
                ImmutableRangeMapTest.assertEquals((Object)expectedAsMap, (Object)descendingMap);
                SerializableTester.reserializeAndAssert((Object)asMap);
                SerializableTester.reserializeAndAssert((Object)descendingMap);
                ImmutableRangeMapTest.assertEquals((Object)ImmutableList.copyOf((Collection)asMap.entrySet()).reverse(), (Object)ImmutableList.copyOf((Collection)descendingMap.entrySet()));
                for (Range query : RANGES) {
                    ImmutableRangeMapTest.assertEquals((Object)expectedAsMap.get((Object)query), (Object)asMap.get((Object)query));
                }
            }
        }
    }

    public void testSubRangeMap() {
        for (Range range1 : RANGES) {
            for (Range range2 : RANGES) {
                if (range1.isConnected(range2) && !range1.intersection(range2).isEmpty()) continue;
                for (Range subRange : RANGES) {
                    ImmutableRangeMap rangeMap = ImmutableRangeMap.builder().put(range1, (Object)1).put(range2, (Object)2).build();
                    ImmutableRangeMap.Builder expectedBuilder = ImmutableRangeMap.builder();
                    for (Map.Entry entry : rangeMap.asMapOfRanges().entrySet()) {
                        if (!((Range)entry.getKey()).isConnected(subRange) || ((Range)entry.getKey()).intersection(subRange).isEmpty()) continue;
                        expectedBuilder.put(((Range)entry.getKey()).intersection(subRange), entry.getValue());
                    }
                    ImmutableRangeMap expected = expectedBuilder.build();
                    ImmutableRangeMapTest.assertEquals((Object)expected, (Object)rangeMap.subRangeMap(subRange));
                }
            }
        }
    }

    public void testSerialization() {
        ImmutableRangeMap emptyRangeMap = ImmutableRangeMap.of();
        SerializableTester.reserializeAndAssert((Object)emptyRangeMap);
        ImmutableRangeMap nonEmptyRangeMap = new ImmutableRangeMap.Builder().put(Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(4)), (Object)5).put(Range.open((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(7)), (Object)3).put(Range.closedOpen((Comparable)Integer.valueOf(8), (Comparable)Integer.valueOf(10)), (Object)4).put(Range.openClosed((Comparable)Integer.valueOf(15), (Comparable)Integer.valueOf(17)), (Object)2).build();
        ImmutableMap test = nonEmptyRangeMap.asMapOfRanges();
        for (Range range : test.keySet()) {
            SerializableTester.reserializeAndAssert((Object)range);
        }
        SerializableTester.reserializeAndAssert((Object)test.keySet());
        SerializableTester.reserializeAndAssert((Object)nonEmptyRangeMap);
    }

    static {
        int i;
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)Range.all());
        for (i = 0; i <= 10; ++i) {
            for (BoundType type : BoundType.values()) {
                builder.add((Object)Range.upTo((Comparable)Integer.valueOf(i), (BoundType)type));
                builder.add((Object)Range.downTo((Comparable)Integer.valueOf(i), (BoundType)type));
            }
        }
        for (i = 0; i <= 10; ++i) {
            for (int j = i + 1; j <= 10; ++j) {
                for (BoundType lowerType : BoundType.values()) {
                    for (BoundType upperType : BoundType.values()) {
                        if (i == j & lowerType == BoundType.OPEN & upperType == BoundType.OPEN) continue;
                        builder.add((Object)Range.range((Comparable)Integer.valueOf(i), (BoundType)lowerType, (Comparable)Integer.valueOf(j), (BoundType)upperType));
                    }
                }
            }
        }
        RANGES = builder.build();
    }
}

