/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;

public class IteratorBenchmark {
    @Param(value={"0", "1", "16", "256", "4096", "65536"})
    int size;
    Object[] array;
    ArrayList<Object> arrayList;
    LinkedList<Object> linkedList;

    @BeforeExperiment
    void setUp() {
        this.array = new Object[this.size];
        this.arrayList = Lists.newArrayListWithCapacity((int)this.size);
        this.linkedList = Lists.newLinkedList();
        for (int i = 0; i < this.size; ++i) {
            Object value;
            this.array[i] = value = new Object();
            this.arrayList.add(value);
            this.linkedList.add(value);
        }
    }

    @Benchmark
    int arrayIndexed(int reps) {
        int sum = 0;
        for (int i = 0; i < reps; ++i) {
            for (int index = 0; index < this.size; ++index) {
                sum += this.array[index].hashCode();
            }
        }
        return sum;
    }

    @Benchmark
    int arrayIndexedLength(int reps) {
        int sum = 0;
        for (int i = 0; i < reps; ++i) {
            for (int index = 0; index < this.array.length; ++index) {
                sum += this.array[index].hashCode();
            }
        }
        return sum;
    }

    @Benchmark
    int arrayFor(int reps) {
        int sum = 0;
        for (int i = 0; i < reps; ++i) {
            for (Object value : this.array) {
                sum += value.hashCode();
            }
        }
        return sum;
    }

    @Benchmark
    int arrayListIndexed(int reps) {
        int sum = 0;
        for (int i = 0; i < reps; ++i) {
            for (int index = 0; index < this.size; ++index) {
                sum += this.arrayList.get(index).hashCode();
            }
        }
        return sum;
    }

    @Benchmark
    int arrayListIndexedLength(int reps) {
        int sum = 0;
        for (int i = 0; i < reps; ++i) {
            for (int index = 0; index < this.arrayList.size(); ++index) {
                sum += this.arrayList.get(index).hashCode();
            }
        }
        return sum;
    }

    @Benchmark
    int arrayListFor(int reps) {
        int sum = 0;
        for (int i = 0; i < reps; ++i) {
            for (Object value : this.arrayList) {
                sum += value.hashCode();
            }
        }
        return sum;
    }

    @Benchmark
    int arrayListToArrayFor(int reps) {
        int sum = 0;
        for (int i = 0; i < reps; ++i) {
            for (Object value : this.arrayList.toArray()) {
                sum += value.hashCode();
            }
        }
        return sum;
    }

    @Benchmark
    int linkedListFor(int reps) {
        int sum = 0;
        for (int i = 0; i < reps; ++i) {
            for (Object e : this.linkedList) {
                sum += e.hashCode();
            }
        }
        return sum;
    }

    @Benchmark
    int linkedListToArrayFor(int reps) {
        int sum = 0;
        for (int i = 0; i < reps; ++i) {
            for (Object value : this.linkedList.toArray()) {
                sum += value.hashCode();
            }
        }
        return sum;
    }
}

