/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.collect.CollectionBenchmarkSampleData;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.SpecialRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class MapBenchmark {
    @Param(value={"Hash", "LinkedHM", "MapMaker1", "Immutable"})
    private Impl impl;
    @Param(value={"5", "50", "500", "5000", "50000"})
    private int size;
    @Param(value={"0.9"})
    private double hitRate;
    @Param(value={"true"})
    private boolean isUserTypeFast;
    @Param(value={""})
    private SpecialRandom random;
    @Param(value={"false"})
    private boolean sortedData;
    private CollectionBenchmarkSampleData.Element[] queries;
    private Map<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element> mapToTest;
    private Collection<CollectionBenchmarkSampleData.Element> values;

    @BeforeExperiment
    void setUp() {
        CollectionBenchmarkSampleData sampleData = new CollectionBenchmarkSampleData(this.isUserTypeFast, this.random, this.hitRate, this.size);
        if (this.sortedData) {
            ArrayList valueList = Lists.newArrayList(sampleData.getValuesInSet());
            Collections.sort(valueList);
            this.values = valueList;
        } else {
            this.values = sampleData.getValuesInSet();
        }
        this.mapToTest = this.impl.create(this.values);
        this.queries = sampleData.getQueries();
    }

    @Benchmark
    boolean get(int reps) {
        Map<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element> map = this.mapToTest;
        CollectionBenchmarkSampleData.Element[] queries = this.queries;
        int mask = queries.length - 1;
        boolean dummy = false;
        for (int i = 0; i < reps; ++i) {
            dummy ^= map.get(queries[i & mask]) != null;
        }
        return dummy;
    }

    @Benchmark
    int createAndPopulate(int reps) {
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            dummy += this.impl.create(this.values).size();
        }
        return dummy;
    }

    @Benchmark
    boolean iterateWithEntrySet(int reps) {
        Map<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element> map = this.mapToTest;
        boolean dummy = false;
        for (int i = 0; i < reps; ++i) {
            for (Map.Entry<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element> entry : map.entrySet()) {
                dummy ^= entry.getKey() != entry.getValue();
            }
        }
        return dummy;
    }

    @Benchmark
    boolean iterateWithKeySetAndGet(int reps) {
        Map<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element> map = this.mapToTest;
        boolean dummy = false;
        for (int i = 0; i < reps; ++i) {
            for (CollectionBenchmarkSampleData.Element key : map.keySet()) {
                CollectionBenchmarkSampleData.Element value;
                dummy ^= key != (value = map.get(key));
            }
        }
        return dummy;
    }

    public static enum Impl {
        Hash{

            @Override
            Map<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element> create(Collection<CollectionBenchmarkSampleData.Element> keys) {
                HashMap map = Maps.newHashMap();
                for (CollectionBenchmarkSampleData.Element element : keys) {
                    map.put(element, element);
                }
                return map;
            }
        }
        ,
        LinkedHM{

            @Override
            Map<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element> create(Collection<CollectionBenchmarkSampleData.Element> keys) {
                LinkedHashMap map = Maps.newLinkedHashMap();
                for (CollectionBenchmarkSampleData.Element element : keys) {
                    map.put(element, element);
                }
                return map;
            }
        }
        ,
        UnmodHM{

            @Override
            Map<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element> create(Collection<CollectionBenchmarkSampleData.Element> keys) {
                return Collections.unmodifiableMap(Hash.create(keys));
            }
        }
        ,
        SyncHM{

            @Override
            Map<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element> create(Collection<CollectionBenchmarkSampleData.Element> keys) {
                return Collections.synchronizedMap(Hash.create(keys));
            }
        }
        ,
        Tree{

            @Override
            Map<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element> create(Collection<CollectionBenchmarkSampleData.Element> keys) {
                TreeMap map = Maps.newTreeMap();
                for (CollectionBenchmarkSampleData.Element element : keys) {
                    map.put(element, element);
                }
                return map;
            }
        }
        ,
        SkipList{

            @Override
            Map<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element> create(Collection<CollectionBenchmarkSampleData.Element> keys) {
                ConcurrentSkipListMap<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element> map = new ConcurrentSkipListMap<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element>();
                for (CollectionBenchmarkSampleData.Element element : keys) {
                    map.put(element, element);
                }
                return map;
            }
        }
        ,
        ConcurrentHM1{

            @Override
            Map<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element> create(Collection<CollectionBenchmarkSampleData.Element> keys) {
                ConcurrentHashMap<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element> map = new ConcurrentHashMap<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element>(keys.size(), 0.75f, 1);
                for (CollectionBenchmarkSampleData.Element element : keys) {
                    map.put(element, element);
                }
                return map;
            }
        }
        ,
        ConcurrentHM16{

            @Override
            Map<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element> create(Collection<CollectionBenchmarkSampleData.Element> keys) {
                ConcurrentHashMap<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element> map = new ConcurrentHashMap<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element>(keys.size(), 0.75f, 16);
                for (CollectionBenchmarkSampleData.Element element : keys) {
                    map.put(element, element);
                }
                return map;
            }
        }
        ,
        MapMaker1{

            @Override
            Map<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element> create(Collection<CollectionBenchmarkSampleData.Element> keys) {
                ConcurrentMap map = new MapMaker().concurrencyLevel(1).makeMap();
                for (CollectionBenchmarkSampleData.Element element : keys) {
                    map.put(element, element);
                }
                return map;
            }
        }
        ,
        MapMaker16{

            @Override
            Map<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element> create(Collection<CollectionBenchmarkSampleData.Element> keys) {
                ConcurrentMap map = new MapMaker().concurrencyLevel(16).makeMap();
                for (CollectionBenchmarkSampleData.Element element : keys) {
                    map.put(element, element);
                }
                return map;
            }
        }
        ,
        Immutable{

            @Override
            Map<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element> create(Collection<CollectionBenchmarkSampleData.Element> keys) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (CollectionBenchmarkSampleData.Element element : keys) {
                    builder.put((Object)element, (Object)element);
                }
                return builder.build();
            }
        }
        ,
        ImmutableSorted{

            @Override
            Map<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element> create(Collection<CollectionBenchmarkSampleData.Element> keys) {
                ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
                for (CollectionBenchmarkSampleData.Element element : keys) {
                    builder.put((Object)element, (Object)element);
                }
                return builder.build();
            }
        };


        abstract Map<CollectionBenchmarkSampleData.Element, CollectionBenchmarkSampleData.Element> create(Collection<CollectionBenchmarkSampleData.Element> var1);
    }
}

