/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.caliper.AfterExperiment;
import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import com.google.common.primitives.Ints;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public class MapMakerSingleThreadBenchmark {
    @Param(value={"1000", "2000"})
    int maximumSize;
    @Param(value={"5000"})
    int distinctKeys;
    @Param(value={"4"})
    int segments;
    @Param(value={"2.5"})
    double concentration;
    Random random = new Random();
    Map<Integer, Integer> cache;
    int max;
    static AtomicLong requests = new AtomicLong(0L);
    static AtomicLong misses = new AtomicLong(0L);

    @BeforeExperiment
    void setUp() {
        this.max = Ints.checkedCast((long)((long)Math.pow(this.distinctKeys, this.concentration)));
        this.cache = new MapMaker().concurrencyLevel(this.segments).maximumSize(this.maximumSize).makeComputingMap((Function)new Function<Integer, Integer>(){

            public Integer apply(Integer from) {
                return (int)misses.incrementAndGet();
            }
        });
        while (this.cache.get(this.nextRandomKey()) < this.maximumSize) {
        }
        requests.set(0L);
        misses.set(0L);
    }

    @Benchmark
    int time(int reps) {
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            dummy += this.cache.get(this.nextRandomKey()).intValue();
        }
        requests.addAndGet(reps);
        return dummy;
    }

    private int nextRandomKey() {
        int a = this.random.nextInt(this.max);
        return (int)Math.pow(a, 1.0 / this.concentration);
    }

    @AfterExperiment
    void tearDown() {
        double req = requests.get();
        double hit = req - (double)misses.get();
        System.out.println("hit rate: " + hit / req);
    }
}

