/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.BiMap;
import com.google.common.collect.ForwardingSortedMap;
import com.google.common.collect.ForwardingSortedSet;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.NavigableMapTestSuiteBuilder;
import com.google.common.collect.testing.SafeTreeMap;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.SortedMapTestSuiteBuilder;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.TestSortedMapGenerator;
import com.google.common.collect.testing.TestStringMapGenerator;
import com.google.common.collect.testing.TestStringSortedMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.BiMapTestSuiteBuilder;
import com.google.common.collect.testing.google.TestBiMapGenerator;
import com.google.common.collect.testing.google.TestStringBiMapGenerator;
import com.google.common.io.BaseEncoding;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class MapsCollectionTest
extends TestCase {
    static final Predicate<String> FILTER_KEYS = new Predicate<String>(){

        public boolean apply(@Nullable String string) {
            return !"banana".equals(string) && !"eggplant".equals(string);
        }
    };
    static final Predicate<String> FILTER_VALUES = new Predicate<String>(){

        public boolean apply(@Nullable String string) {
            return !"toast".equals(string) && !"spam".equals(string);
        }
    };
    static final Predicate<Map.Entry<String, String>> FILTER_ENTRIES = new Predicate<Map.Entry<String, String>>(){

        public boolean apply(Map.Entry<String, String> entry) {
            return !Helpers.mapEntry((Object)"banana", (Object)"toast").equals(entry) && !Helpers.mapEntry((Object)"eggplant", (Object)"spam").equals(entry);
        }
    };
    static final Predicate<Map.Entry<String, String>> FILTER_ENTRIES_1 = new Predicate<Map.Entry<String, String>>(){

        public boolean apply(Map.Entry<String, String> entry) {
            return !Helpers.mapEntry((Object)"banana", (Object)"toast").equals(entry);
        }
    };
    static final Predicate<Map.Entry<String, String>> FILTER_ENTRIES_2 = new Predicate<Map.Entry<String, String>>(){

        public boolean apply(Map.Entry<String, String> entry) {
            return !Helpers.mapEntry((Object)"eggplant", (Object)"spam").equals(entry);
        }
    };
    static final Map<String, String> ENTRIES_TO_FILTER = ImmutableMap.of((Object)"banana", (Object)"toast", (Object)"eggplant", (Object)"spam");
    static final Predicate<Map.Entry<String, String>> NOT_NULL_ENTRY = new Predicate<Map.Entry<String, String>>(){

        public boolean apply(Map.Entry<String, String> entry) {
            return entry.getKey() != null && entry.getValue() != null;
        }
    };
    private static final Function<String, String> DECODE_FUNCTION = new Function<String, String>(){

        public String apply(String input) {
            return new String(BaseEncoding.base64().decode((CharSequence)input), Charsets.UTF_8);
        }
    };
    private static final Maps.EntryTransformer<String, String, String> DECODE_ENTRY_TRANSFORMER = new Maps.EntryTransformer<String, String, String>(){

        public String transformEntry(String key, String value) {
            return (String)DECODE_FUNCTION.apply((Object)value);
        }
    };

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)NavigableMapTestSuiteBuilder.using((TestSortedMapGenerator)new TestStringSortedMapGenerator(){

            protected SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
                SafeTreeMap map = new SafeTreeMap();
                MapsCollectionTest.putEntries((Map<String, String>)map, entries);
                return Maps.unmodifiableNavigableMap((NavigableMap)map);
            }
        }).named("unmodifiableNavigableMap[SafeTreeMap]")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.ALLOWS_NULL_VALUES, CollectionFeature.SERIALIZABLE})).createTestSuite());
        suite.addTest((Test)((BiMapTestSuiteBuilder)((BiMapTestSuiteBuilder)BiMapTestSuiteBuilder.using((TestBiMapGenerator)new TestStringBiMapGenerator(){

            protected BiMap<String, String> create(Map.Entry<String, String>[] entries) {
                HashBiMap bimap = HashBiMap.create((int)entries.length);
                for (Map.Entry<String, String> entry : entries) {
                    Preconditions.checkArgument((!bimap.containsKey((Object)entry.getKey()) ? 1 : 0) != 0);
                    bimap.put((Object)entry.getKey(), (Object)entry.getValue());
                }
                return Maps.unmodifiableBiMap((BiMap)bimap);
            }
        }).named("unmodifiableBiMap[HashBiMap]")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.REJECTS_DUPLICATES_AT_CREATION, CollectionFeature.SERIALIZABLE})).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new TestMapGenerator<String, Integer>(){

            public SampleElements<Map.Entry<String, Integer>> samples() {
                return new SampleElements((Object)Helpers.mapEntry((Object)"x", (Object)1), (Object)Helpers.mapEntry((Object)"xxx", (Object)3), (Object)Helpers.mapEntry((Object)"xx", (Object)2), (Object)Helpers.mapEntry((Object)"xxxx", (Object)4), (Object)Helpers.mapEntry((Object)"aaaaa", (Object)5));
            }

            public Map<String, Integer> create(Object ... elements) {
                LinkedHashSet set = Sets.newLinkedHashSet();
                for (Object e : elements) {
                    Map.Entry entry = (Map.Entry)e;
                    Preconditions.checkNotNull(entry.getValue());
                    set.add((String)Preconditions.checkNotNull(entry.getKey()));
                }
                return Maps.asMap((Set)set, (Function)new Function<String, Integer>(){

                    public Integer apply(String input) {
                        return input.length();
                    }
                });
            }

            public Map.Entry<String, Integer>[] createArray(int length) {
                return new Map.Entry[length];
            }

            public Iterable<Map.Entry<String, Integer>> order(List<Map.Entry<String, Integer>> insertionOrder) {
                return insertionOrder;
            }

            public String[] createKeyArray(int length) {
                return new String[length];
            }

            public Integer[] createValueArray(int length) {
                return new Integer[length];
            }
        }).named("Maps.asMap[Set, Function]")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.SUPPORTS_REMOVE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE})).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)SortedMapTestSuiteBuilder.using((TestMapGenerator)new TestMapGenerator<String, Integer>(){

            public String[] createKeyArray(int length) {
                return new String[length];
            }

            public Integer[] createValueArray(int length) {
                return new Integer[length];
            }

            public SampleElements<Map.Entry<String, Integer>> samples() {
                return new SampleElements((Object)Helpers.mapEntry((Object)"a", (Object)1), (Object)Helpers.mapEntry((Object)"aa", (Object)2), (Object)Helpers.mapEntry((Object)"aba", (Object)3), (Object)Helpers.mapEntry((Object)"bbbb", (Object)4), (Object)Helpers.mapEntry((Object)"ccccc", (Object)5));
            }

            public SortedMap<String, Integer> create(Object ... elements) {
                NonNavigableSortedSet set = new NonNavigableSortedSet();
                for (Object e : elements) {
                    Map.Entry entry = (Map.Entry)e;
                    Preconditions.checkNotNull(entry.getValue());
                    set.add((String)Preconditions.checkNotNull(entry.getKey()));
                }
                return Maps.asMap((SortedSet)((Object)set), (Function)new Function<String, Integer>(){

                    public Integer apply(String input) {
                        return input.length();
                    }
                });
            }

            public Map.Entry<String, Integer>[] createArray(int length) {
                return new Map.Entry[length];
            }

            public Iterable<Map.Entry<String, Integer>> order(List<Map.Entry<String, Integer>> insertionOrder) {
                Collections.sort(insertionOrder, new Comparator<Map.Entry<String, Integer>>(){

                    @Override
                    public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                        return o1.getKey().compareTo(o2.getKey());
                    }
                });
                return insertionOrder;
            }
        }).named("Maps.asMap[SortedSet, Function]")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, MapFeature.SUPPORTS_REMOVE})).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)NavigableMapTestSuiteBuilder.using((TestMapGenerator)new TestMapGenerator<String, Integer>(){

            public String[] createKeyArray(int length) {
                return new String[length];
            }

            public Integer[] createValueArray(int length) {
                return new Integer[length];
            }

            public SampleElements<Map.Entry<String, Integer>> samples() {
                return new SampleElements((Object)Helpers.mapEntry((Object)"a", (Object)1), (Object)Helpers.mapEntry((Object)"aa", (Object)2), (Object)Helpers.mapEntry((Object)"aba", (Object)3), (Object)Helpers.mapEntry((Object)"bbbb", (Object)4), (Object)Helpers.mapEntry((Object)"ccccc", (Object)5));
            }

            public NavigableMap<String, Integer> create(Object ... elements) {
                TreeSet set = Sets.newTreeSet((Comparator)Ordering.natural());
                for (Object e : elements) {
                    Map.Entry entry = (Map.Entry)e;
                    Preconditions.checkNotNull(entry.getValue());
                    set.add((String)Preconditions.checkNotNull(entry.getKey()));
                }
                return Maps.asMap((NavigableSet)set, (Function)new Function<String, Integer>(){

                    public Integer apply(String input) {
                        return input.length();
                    }
                });
            }

            public Map.Entry<String, Integer>[] createArray(int length) {
                return new Map.Entry[length];
            }

            public Iterable<Map.Entry<String, Integer>> order(List<Map.Entry<String, Integer>> insertionOrder) {
                Collections.sort(insertionOrder, new Comparator<Map.Entry<String, Integer>>(){

                    @Override
                    public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                        return o1.getKey().compareTo(o2.getKey());
                    }
                });
                return insertionOrder;
            }
        }).named("Maps.asMap[NavigableSet, Function]")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.SUPPORTS_REMOVE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE})).createTestSuite());
        suite.addTest((Test)MapsCollectionTest.filterSuite());
        suite.addTest((Test)MapsCollectionTest.transformSuite());
        return suite;
    }

    static TestSuite filterSuite() {
        TestSuite suite = new TestSuite("Filter");
        suite.addTest((Test)MapsCollectionTest.filterMapSuite());
        suite.addTest((Test)MapsCollectionTest.filterBiMapSuite());
        suite.addTest((Test)MapsCollectionTest.filterSortedMapSuite());
        suite.addTest((Test)MapsCollectionTest.filterNavigableMapSuite());
        return suite;
    }

    static TestSuite filterMapSuite() {
        TestSuite suite = new TestSuite("FilterMap");
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new TestStringMapGenerator(){

            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                HashMap map = Maps.newHashMap();
                MapsCollectionTest.putEntries(map, entries);
                map.putAll(ENTRIES_TO_FILTER);
                return Maps.filterKeys((Map)map, FILTER_KEYS);
            }
        }).named("Maps.filterKeys[Map, Predicate]")).withFeatures(new Feature[]{MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.GENERAL_PURPOSE, CollectionSize.ANY})).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new TestStringMapGenerator(){

            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                HashMap map = Maps.newHashMap();
                MapsCollectionTest.putEntries(map, entries);
                map.putAll(ENTRIES_TO_FILTER);
                return Maps.filterValues((Map)map, FILTER_VALUES);
            }
        }).named("Maps.filterValues[Map, Predicate]")).withFeatures(new Feature[]{MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.GENERAL_PURPOSE, CollectionSize.ANY})).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new TestStringMapGenerator(){

            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                HashMap map = Maps.newHashMap();
                MapsCollectionTest.putEntries(map, entries);
                map.putAll(ENTRIES_TO_FILTER);
                return Maps.filterEntries((Map)map, FILTER_ENTRIES);
            }
        }).named("Maps.filterEntries[Map, Predicate]")).withFeatures(new Feature[]{MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.GENERAL_PURPOSE, CollectionSize.ANY})).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new TestStringMapGenerator(){

            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                Map map = Maps.newHashMap();
                MapsCollectionTest.putEntries(map, entries);
                map.putAll(ENTRIES_TO_FILTER);
                map = Maps.filterEntries((Map)map, FILTER_ENTRIES_1);
                return Maps.filterEntries((Map)map, FILTER_ENTRIES_2);
            }
        }).named("Maps.filterEntries[Maps.filterEntries[Map, Predicate], Predicate]")).withFeatures(new Feature[]{MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.GENERAL_PURPOSE, CollectionSize.ANY})).createTestSuite());
        return suite;
    }

    static TestSuite filterBiMapSuite() {
        TestSuite suite = new TestSuite("FilterBiMap");
        suite.addTest((Test)((BiMapTestSuiteBuilder)((BiMapTestSuiteBuilder)BiMapTestSuiteBuilder.using((TestBiMapGenerator)new TestStringBiMapGenerator(){

            protected BiMap<String, String> create(Map.Entry<String, String>[] entries) {
                HashBiMap map = HashBiMap.create();
                MapsCollectionTest.putEntries((Map<String, String>)map, entries);
                map.putAll(ENTRIES_TO_FILTER);
                return Maps.filterKeys((BiMap)map, FILTER_KEYS);
            }
        }).named("Maps.filterKeys[BiMap, Predicate]")).withFeatures(new Feature[]{MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.GENERAL_PURPOSE, CollectionSize.ANY})).createTestSuite());
        suite.addTest((Test)((BiMapTestSuiteBuilder)((BiMapTestSuiteBuilder)BiMapTestSuiteBuilder.using((TestBiMapGenerator)new TestStringBiMapGenerator(){

            protected BiMap<String, String> create(Map.Entry<String, String>[] entries) {
                HashBiMap map = HashBiMap.create();
                MapsCollectionTest.putEntries((Map<String, String>)map, entries);
                map.putAll(ENTRIES_TO_FILTER);
                return Maps.filterValues((BiMap)map, FILTER_VALUES);
            }
        }).named("Maps.filterValues[BiMap, Predicate]")).withFeatures(new Feature[]{MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.GENERAL_PURPOSE, CollectionSize.ANY})).createTestSuite());
        suite.addTest((Test)((BiMapTestSuiteBuilder)((BiMapTestSuiteBuilder)BiMapTestSuiteBuilder.using((TestBiMapGenerator)new TestStringBiMapGenerator(){

            protected BiMap<String, String> create(Map.Entry<String, String>[] entries) {
                HashBiMap map = HashBiMap.create();
                MapsCollectionTest.putEntries((Map<String, String>)map, entries);
                map.putAll(ENTRIES_TO_FILTER);
                return Maps.filterEntries((BiMap)map, FILTER_ENTRIES);
            }
        }).named("Maps.filterEntries[BiMap, Predicate]")).withFeatures(new Feature[]{MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.GENERAL_PURPOSE, CollectionSize.ANY})).createTestSuite());
        return suite;
    }

    static TestSuite filterSortedMapSuite() {
        TestSuite suite = new TestSuite("FilterSortedMap");
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)SortedMapTestSuiteBuilder.using((TestSortedMapGenerator)new TestStringSortedMapGenerator(){

            protected SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
                NonNavigableSortedMap map = new NonNavigableSortedMap();
                MapsCollectionTest.putEntries((Map<String, String>)((Object)map), entries);
                map.putAll(ENTRIES_TO_FILTER);
                return Maps.filterKeys((SortedMap)((Object)map), FILTER_KEYS);
            }
        }).named("Maps.filterKeys[SortedMap, Predicate]")).withFeatures(new Feature[]{MapFeature.ALLOWS_NULL_VALUES, MapFeature.GENERAL_PURPOSE, CollectionSize.ANY})).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)SortedMapTestSuiteBuilder.using((TestSortedMapGenerator)new TestStringSortedMapGenerator(){

            protected SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
                NonNavigableSortedMap map = new NonNavigableSortedMap();
                MapsCollectionTest.putEntries((Map<String, String>)((Object)map), entries);
                map.putAll(ENTRIES_TO_FILTER);
                return Maps.filterValues((SortedMap)((Object)map), FILTER_VALUES);
            }
        }).named("Maps.filterValues[SortedMap, Predicate]")).withFeatures(new Feature[]{MapFeature.ALLOWS_NULL_VALUES, MapFeature.GENERAL_PURPOSE, CollectionSize.ANY})).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)SortedMapTestSuiteBuilder.using((TestSortedMapGenerator)new TestStringSortedMapGenerator(){

            protected SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
                NonNavigableSortedMap map = new NonNavigableSortedMap();
                MapsCollectionTest.putEntries((Map<String, String>)((Object)map), entries);
                map.putAll(ENTRIES_TO_FILTER);
                return Maps.filterEntries((SortedMap)((Object)map), FILTER_ENTRIES);
            }
        }).named("Maps.filterEntries[SortedMap, Predicate]")).withFeatures(new Feature[]{MapFeature.ALLOWS_NULL_VALUES, MapFeature.GENERAL_PURPOSE, CollectionSize.ANY})).createTestSuite());
        return suite;
    }

    static TestSuite filterNavigableMapSuite() {
        TestSuite suite = new TestSuite("FilterNavigableMap");
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)NavigableMapTestSuiteBuilder.using((TestSortedMapGenerator)new TestStringSortedMapGenerator(){

            protected NavigableMap<String, String> create(Map.Entry<String, String>[] entries) {
                SafeTreeMap map = new SafeTreeMap();
                MapsCollectionTest.putEntries((Map<String, String>)map, entries);
                map.put("banana", "toast");
                map.put("eggplant", "spam");
                return Maps.filterKeys((NavigableMap)map, FILTER_KEYS);
            }
        }).named("Maps.filterKeys[NavigableMap, Predicate]")).withFeatures(new Feature[]{MapFeature.ALLOWS_NULL_VALUES, MapFeature.GENERAL_PURPOSE, CollectionSize.ANY})).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)NavigableMapTestSuiteBuilder.using((TestSortedMapGenerator)new TestStringSortedMapGenerator(){

            protected NavigableMap<String, String> create(Map.Entry<String, String>[] entries) {
                SafeTreeMap map = new SafeTreeMap();
                MapsCollectionTest.putEntries((Map<String, String>)map, entries);
                map.put("banana", "toast");
                map.put("eggplant", "spam");
                return Maps.filterValues((NavigableMap)map, FILTER_VALUES);
            }
        }).named("Maps.filterValues[NavigableMap, Predicate]")).withFeatures(new Feature[]{MapFeature.ALLOWS_NULL_VALUES, MapFeature.GENERAL_PURPOSE, CollectionSize.ANY})).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)NavigableMapTestSuiteBuilder.using((TestSortedMapGenerator)new TestStringSortedMapGenerator(){

            protected NavigableMap<String, String> create(Map.Entry<String, String>[] entries) {
                SafeTreeMap map = new SafeTreeMap();
                MapsCollectionTest.putEntries((Map<String, String>)map, entries);
                map.put("banana", "toast");
                map.put("eggplant", "spam");
                return Maps.filterEntries((NavigableMap)map, FILTER_ENTRIES);
            }
        }).named("Maps.filterEntries[NavigableMap, Predicate]")).withFeatures(new Feature[]{MapFeature.ALLOWS_NULL_VALUES, MapFeature.GENERAL_PURPOSE, CollectionSize.ANY})).createTestSuite());
        return suite;
    }

    static void putEntries(Map<String, String> map, Map.Entry<String, String>[] entries) {
        for (Map.Entry<String, String> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    private static String encode(String str) {
        return BaseEncoding.base64().encode(str.getBytes(Charsets.UTF_8));
    }

    static TestSuite transformSuite() {
        TestSuite suite = new TestSuite("Maps.transform");
        suite.addTest((Test)MapsCollectionTest.transformMapSuite());
        suite.addTest((Test)MapsCollectionTest.transformSortedMapSuite());
        suite.addTest((Test)MapsCollectionTest.transformNavigableMapSuite());
        return suite;
    }

    static TestSuite transformMapSuite() {
        TestSuite suite = new TestSuite("TransformMap");
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new TestStringMapGenerator(){

            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                LinkedHashMap map = Maps.newLinkedHashMap();
                for (Map.Entry<String, String> entry : entries) {
                    map.put(entry.getKey(), MapsCollectionTest.encode(entry.getValue()));
                }
                return Maps.transformValues((Map)map, (Function)DECODE_FUNCTION);
            }
        }).named("Maps.transformValues[Map, Function]")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.SUPPORTS_REMOVE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE})).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new TestStringMapGenerator(){

            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                LinkedHashMap map = Maps.newLinkedHashMap();
                for (Map.Entry<String, String> entry : entries) {
                    map.put(entry.getKey(), MapsCollectionTest.encode(entry.getValue()));
                }
                return Maps.transformEntries((Map)map, (Maps.EntryTransformer)DECODE_ENTRY_TRANSFORMER);
            }
        }).named("Maps.transformEntries[Map, EntryTransformer]")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.SUPPORTS_REMOVE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE})).createTestSuite());
        return suite;
    }

    static TestSuite transformSortedMapSuite() {
        TestSuite suite = new TestSuite("TransformSortedMap");
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)SortedMapTestSuiteBuilder.using((TestSortedMapGenerator)new TestStringSortedMapGenerator(){

            protected SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
                NonNavigableSortedMap map = new NonNavigableSortedMap();
                for (Map.Entry<String, String> entry : entries) {
                    map.put(entry.getKey(), MapsCollectionTest.encode(entry.getValue()));
                }
                return Maps.transformValues((SortedMap)((Object)map), (Function)DECODE_FUNCTION);
            }
        }).named("Maps.transformValues[SortedMap, Function]")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, MapFeature.SUPPORTS_REMOVE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE})).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)SortedMapTestSuiteBuilder.using((TestSortedMapGenerator)new TestStringSortedMapGenerator(){

            protected SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
                NonNavigableSortedMap map = new NonNavigableSortedMap();
                for (Map.Entry<String, String> entry : entries) {
                    map.put(entry.getKey(), MapsCollectionTest.encode(entry.getValue()));
                }
                return Maps.transformEntries((SortedMap)((Object)map), (Maps.EntryTransformer)DECODE_ENTRY_TRANSFORMER);
            }
        }).named("Maps.transformEntries[SortedMap, EntryTransformer]")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, MapFeature.SUPPORTS_REMOVE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE})).createTestSuite());
        return suite;
    }

    static TestSuite transformNavigableMapSuite() {
        TestSuite suite = new TestSuite("TransformNavigableMap");
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)NavigableMapTestSuiteBuilder.using((TestSortedMapGenerator)new TestStringSortedMapGenerator(){

            protected NavigableMap<String, String> create(Map.Entry<String, String>[] entries) {
                SafeTreeMap map = new SafeTreeMap();
                for (Map.Entry<String, String> entry : entries) {
                    map.put(entry.getKey(), MapsCollectionTest.encode(entry.getValue()));
                }
                return Maps.transformValues((NavigableMap)map, (Function)DECODE_FUNCTION);
            }
        }).named("Maps.transformValues[NavigableMap, Function]")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, MapFeature.SUPPORTS_REMOVE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE})).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)NavigableMapTestSuiteBuilder.using((TestSortedMapGenerator)new TestStringSortedMapGenerator(){

            protected NavigableMap<String, String> create(Map.Entry<String, String>[] entries) {
                SafeTreeMap map = new SafeTreeMap();
                for (Map.Entry<String, String> entry : entries) {
                    map.put(entry.getKey(), MapsCollectionTest.encode(entry.getValue()));
                }
                return Maps.transformEntries((NavigableMap)map, (Maps.EntryTransformer)DECODE_ENTRY_TRANSFORMER);
            }
        }).named("Maps.transformEntries[NavigableMap, EntryTransformer]")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, MapFeature.SUPPORTS_REMOVE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE})).createTestSuite());
        return suite;
    }

    private static class NonNavigableSortedMap
    extends ForwardingSortedMap<String, String> {
        private final SortedMap<String, String> delegate = new SafeTreeMap((Comparator)Ordering.natural());

        private NonNavigableSortedMap() {
        }

        protected SortedMap<String, String> delegate() {
            return this.delegate;
        }
    }

    private static class NonNavigableSortedSet
    extends ForwardingSortedSet<String> {
        private final SortedSet<String> delegate = Sets.newTreeSet((Comparator)Ordering.natural());

        private NonNavigableSortedSet() {
        }

        protected SortedSet<String> delegate() {
            return this.delegate;
        }
    }
}

