/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Converter;
import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.BiMap;
import com.google.common.collect.ForwardingSortedMap;
import com.google.common.collect.ForwardingSortedSet;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.LegacyComparable;
import com.google.common.collect.Lists;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.SetsTest;
import com.google.common.collect.SortedMapDifference;
import com.google.common.collect.SuppressUnderAndroid;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.testing.Helpers;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class MapsTest
extends TestCase {
    private static final Comparator<Integer> SOME_COMPARATOR = Collections.reverseOrder();
    private static final Map<Integer, Integer> EMPTY = Collections.emptyMap();
    private static final Map<Integer, Integer> SINGLETON = Collections.singletonMap(1, 2);
    private static final SortedMap<Integer, Integer> SORTED_EMPTY = Maps.newTreeMap();
    private static final SortedMap<Integer, Integer> SORTED_SINGLETON = ImmutableSortedMap.of((Comparable)Integer.valueOf(1), (Object)2);
    private static final Function<String, Integer> LENGTH_FUNCTION = new Function<String, Integer>(){

        public Integer apply(String input) {
            return input.length();
        }
    };
    private static final BiMap<Integer, String> INT_TO_STRING_MAP = new ImmutableBiMap.Builder().put((Object)1, (Object)"one").put((Object)2, (Object)"two").put((Object)3, (Object)"three").build();
    private static final Predicate<String> NOT_LENGTH_3 = new Predicate<String>(){

        public boolean apply(String input) {
            return input == null || input.length() != 3;
        }
    };
    private static final Predicate<Integer> EVEN = new Predicate<Integer>(){

        public boolean apply(Integer input) {
            return input == null || input % 2 == 0;
        }
    };
    private static final Predicate<Map.Entry<String, Integer>> CORRECT_LENGTH = new Predicate<Map.Entry<String, Integer>>(){

        public boolean apply(Map.Entry<String, Integer> input) {
            return input.getKey().length() == input.getValue().intValue();
        }
    };
    private static final Function<Integer, Double> SQRT_FUNCTION = new Function<Integer, Double>(){

        public Double apply(Integer in) {
            return Math.sqrt(in.intValue());
        }
    };

    public void testHashMap() {
        HashMap map = Maps.newHashMap();
        MapsTest.assertEquals(Collections.emptyMap(), (Object)map);
    }

    public void testHashMapWithInitialMap() {
        TreeMap<String, Integer> original = new TreeMap<String, Integer>();
        original.put("a", 1);
        original.put("b", 2);
        original.put("c", 3);
        HashMap map = Maps.newHashMap(original);
        MapsTest.assertEquals(original, (Object)map);
    }

    public void testHashMapGeneralizesTypes() {
        TreeMap<String, Integer> original = new TreeMap<String, Integer>();
        original.put("a", 1);
        original.put("b", 2);
        original.put("c", 3);
        HashMap map = Maps.newHashMap(original);
        MapsTest.assertEquals(original, (Object)map);
    }

    public void testCapacityForNegativeSizeFails() {
        try {
            Maps.capacity((int)-1);
            MapsTest.fail((String)"Negative expected size must result in IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible(value="reflection")
    @SuppressUnderAndroid
    public void testNewHashMapWithExpectedSize_wontGrow() throws Exception {
        MapsTest.assertTrue((MapsTest.bucketsOf(Maps.newHashMapWithExpectedSize((int)0)) <= 1 ? 1 : 0) != 0);
        for (int size = 1; size < 200; ++size) {
            MapsTest.assertWontGrow(size, Maps.newHashMapWithExpectedSize((int)size), Maps.newHashMapWithExpectedSize((int)size));
        }
    }

    @GwtIncompatible(value="reflection")
    @SuppressUnderAndroid
    public void testNewLinkedHashMapWithExpectedSize_wontGrow() throws Exception {
        MapsTest.assertTrue((MapsTest.bucketsOf(Maps.newLinkedHashMapWithExpectedSize((int)0)) <= 1 ? 1 : 0) != 0);
        for (int size = 1; size < 200; ++size) {
            MapsTest.assertWontGrow(size, Maps.newLinkedHashMapWithExpectedSize((int)size), Maps.newLinkedHashMapWithExpectedSize((int)size));
        }
    }

    @GwtIncompatible(value="reflection")
    private static void assertWontGrow(int size, HashMap<Object, Object> map1, HashMap<Object, Object> map2) throws Exception {
        map1.put(0, null);
        int initialBuckets = MapsTest.bucketsOf(map1);
        for (int i = 1; i < size; ++i) {
            map1.put(i, null);
        }
        ((IntegerSubject)Truth.assertThat((Integer)MapsTest.bucketsOf(map1)).named("table size after adding " + size + " elements")).isEqualTo((long)initialBuckets);
        map2.putAll(map1);
        ((IntegerSubject)Truth.assertThat((Integer)MapsTest.bucketsOf(map1)).named("table size after adding " + size + " elements")).isEqualTo((long)initialBuckets);
    }

    @GwtIncompatible(value="reflection")
    private static int bucketsOf(HashMap<?, ?> hashMap) throws Exception {
        Field tableField = HashMap.class.getDeclaredField("table");
        tableField.setAccessible(true);
        Object[] table = (Object[])tableField.get(hashMap);
        return table == null ? 0 : table.length;
    }

    public void testCapacityForLargeSizes() {
        int[] largeExpectedSizes;
        for (int expectedSize : largeExpectedSizes = new int[]{0x3FFFFFFE, 0x3FFFFFFF, 0x40000000, 0x7FFFFFFE, Integer.MAX_VALUE}) {
            int capacity = Maps.capacity((int)expectedSize);
            MapsTest.assertTrue((String)("capacity (" + capacity + ") must be >= expectedSize (" + expectedSize + ")"), (capacity >= expectedSize ? 1 : 0) != 0);
        }
    }

    public void testLinkedHashMap() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        MapsTest.assertEquals(Collections.emptyMap(), (Object)map);
    }

    public void testLinkedHashMapWithInitialMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(){
            {
                this.put("Hello", "World");
                this.put("first", "second");
                this.put("polygene", "lubricants");
                this.put("alpha", "betical");
            }
        };
        LinkedHashMap copy = Maps.newLinkedHashMap((Map)map);
        Iterator iter = copy.entrySet().iterator();
        MapsTest.assertTrue((boolean)iter.hasNext());
        Map.Entry entry = iter.next();
        MapsTest.assertEquals((String)"Hello", (String)((String)entry.getKey()));
        MapsTest.assertEquals((String)"World", (String)((String)entry.getValue()));
        MapsTest.assertTrue((boolean)iter.hasNext());
        entry = iter.next();
        MapsTest.assertEquals((String)"first", (String)((String)entry.getKey()));
        MapsTest.assertEquals((String)"second", (String)((String)entry.getValue()));
        MapsTest.assertTrue((boolean)iter.hasNext());
        entry = iter.next();
        MapsTest.assertEquals((String)"polygene", (String)((String)entry.getKey()));
        MapsTest.assertEquals((String)"lubricants", (String)((String)entry.getValue()));
        MapsTest.assertTrue((boolean)iter.hasNext());
        entry = iter.next();
        MapsTest.assertEquals((String)"alpha", (String)((String)entry.getKey()));
        MapsTest.assertEquals((String)"betical", (String)((String)entry.getValue()));
        MapsTest.assertFalse((boolean)iter.hasNext());
    }

    public void testLinkedHashMapGeneralizesTypes() {
        LinkedHashMap<String, Integer> original = new LinkedHashMap<String, Integer>();
        original.put("a", 1);
        original.put("b", 2);
        original.put("c", 3);
        LinkedHashMap map = Maps.newLinkedHashMap(original);
        MapsTest.assertEquals(original, (Object)map);
    }

    public void testIdentityHashMap() {
        IdentityHashMap map = Maps.newIdentityHashMap();
        MapsTest.assertEquals(Collections.emptyMap(), (Object)map);
    }

    public void testConcurrentMap() {
        ConcurrentMap map = Maps.newConcurrentMap();
        MapsTest.assertEquals(Collections.emptyMap(), (Object)map);
    }

    public void testTreeMap() {
        TreeMap map = Maps.newTreeMap();
        MapsTest.assertEquals(Collections.emptyMap(), (Object)map);
        MapsTest.assertNull(map.comparator());
    }

    public void testTreeMapDerived() {
        TreeMap map = Maps.newTreeMap();
        MapsTest.assertEquals(Collections.emptyMap(), (Object)map);
        map.put(new SetsTest.Derived("foo"), 1);
        map.put(new SetsTest.Derived("bar"), 2);
        Truth.assertThat(map.keySet()).containsExactly(new Object[]{new SetsTest.Derived("bar"), new SetsTest.Derived("foo")}).inOrder();
        Truth.assertThat(map.values()).containsExactly(new Object[]{2, 1}).inOrder();
        MapsTest.assertNull(map.comparator());
    }

    public void testTreeMapNonGeneric() {
        TreeMap map = Maps.newTreeMap();
        MapsTest.assertEquals(Collections.emptyMap(), (Object)map);
        map.put(new LegacyComparable("foo"), 1);
        map.put(new LegacyComparable("bar"), 2);
        Truth.assertThat(map.keySet()).containsExactly(new Object[]{new LegacyComparable("bar"), new LegacyComparable("foo")}).inOrder();
        Truth.assertThat(map.values()).containsExactly(new Object[]{2, 1}).inOrder();
        MapsTest.assertNull(map.comparator());
    }

    public void testTreeMapWithComparator() {
        TreeMap map = Maps.newTreeMap(SOME_COMPARATOR);
        MapsTest.assertEquals(Collections.emptyMap(), (Object)map);
        MapsTest.assertSame(SOME_COMPARATOR, map.comparator());
    }

    public void testTreeMapWithInitialMap() {
        TreeMap map = Maps.newTreeMap();
        map.put(5, 10);
        map.put(3, 20);
        map.put(1, 30);
        TreeMap copy = Maps.newTreeMap((SortedMap)map);
        MapsTest.assertEquals((Object)copy, (Object)map);
        MapsTest.assertSame(copy.comparator(), map.comparator());
    }

    public void testEnumMap() {
        EnumMap map = Maps.newEnumMap(SomeEnum.class);
        MapsTest.assertEquals(Collections.emptyMap(), (Object)map);
        map.put(SomeEnum.SOME_INSTANCE, 0);
        MapsTest.assertEquals(Collections.singletonMap(SomeEnum.SOME_INSTANCE, 0), (Object)map);
    }

    public void testEnumMapNullClass() {
        try {
            Maps.newEnumMap((Class)null);
            MapsTest.fail((String)"no exception thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testEnumMapWithInitialEnumMap() {
        EnumMap original = Maps.newEnumMap(SomeEnum.class);
        original.put(SomeEnum.SOME_INSTANCE, 0);
        EnumMap copy = Maps.newEnumMap((Map)original);
        MapsTest.assertEquals((Object)original, (Object)copy);
    }

    public void testEnumMapWithInitialEmptyEnumMap() {
        EnumMap original = Maps.newEnumMap(SomeEnum.class);
        EnumMap copy = Maps.newEnumMap((Map)original);
        MapsTest.assertEquals((Object)original, (Object)copy);
        MapsTest.assertNotSame((Object)original, (Object)copy);
    }

    public void testEnumMapWithInitialMap() {
        HashMap original = Maps.newHashMap();
        original.put(SomeEnum.SOME_INSTANCE, 0);
        EnumMap copy = Maps.newEnumMap((Map)original);
        MapsTest.assertEquals((Object)original, (Object)copy);
    }

    public void testEnumMapWithInitialEmptyMap() {
        HashMap original = Maps.newHashMap();
        try {
            Maps.newEnumMap((Map)original);
            MapsTest.fail((String)"Empty map must result in an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToStringImplWithNullKeys() throws Exception {
        HashMap hashmap = Maps.newHashMap();
        hashmap.put("foo", "bar");
        hashmap.put(null, "baz");
        MapsTest.assertEquals((String)((Object)hashmap).toString(), (String)Maps.toStringImpl((Map)hashmap));
    }

    public void testToStringImplWithNullValues() throws Exception {
        HashMap hashmap = Maps.newHashMap();
        hashmap.put("foo", "bar");
        hashmap.put("baz", null);
        MapsTest.assertEquals((String)((Object)hashmap).toString(), (String)Maps.toStringImpl((Map)hashmap));
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNullPointerExceptions() {
        new NullPointerTester().testAllPublicStaticMethods(Maps.class);
    }

    public void testMapDifferenceEmptyEmpty() {
        MapDifference diff = Maps.difference(EMPTY, EMPTY);
        MapsTest.assertTrue((boolean)diff.areEqual());
        MapsTest.assertEquals(EMPTY, (Object)diff.entriesOnlyOnLeft());
        MapsTest.assertEquals(EMPTY, (Object)diff.entriesOnlyOnRight());
        MapsTest.assertEquals(EMPTY, (Object)diff.entriesInCommon());
        MapsTest.assertEquals(EMPTY, (Object)diff.entriesDiffering());
        MapsTest.assertEquals((String)"equal", (String)diff.toString());
    }

    public void testMapDifferenceEmptySingleton() {
        MapDifference diff = Maps.difference(EMPTY, SINGLETON);
        MapsTest.assertFalse((boolean)diff.areEqual());
        MapsTest.assertEquals(EMPTY, (Object)diff.entriesOnlyOnLeft());
        MapsTest.assertEquals(SINGLETON, (Object)diff.entriesOnlyOnRight());
        MapsTest.assertEquals(EMPTY, (Object)diff.entriesInCommon());
        MapsTest.assertEquals(EMPTY, (Object)diff.entriesDiffering());
        MapsTest.assertEquals((String)"not equal: only on right={1=2}", (String)diff.toString());
    }

    public void testMapDifferenceSingletonEmpty() {
        MapDifference diff = Maps.difference(SINGLETON, EMPTY);
        MapsTest.assertFalse((boolean)diff.areEqual());
        MapsTest.assertEquals(SINGLETON, (Object)diff.entriesOnlyOnLeft());
        MapsTest.assertEquals(EMPTY, (Object)diff.entriesOnlyOnRight());
        MapsTest.assertEquals(EMPTY, (Object)diff.entriesInCommon());
        MapsTest.assertEquals(EMPTY, (Object)diff.entriesDiffering());
        MapsTest.assertEquals((String)"not equal: only on left={1=2}", (String)diff.toString());
    }

    public void testMapDifferenceTypical() {
        ImmutableMap left = ImmutableMap.of((Object)1, (Object)"a", (Object)2, (Object)"b", (Object)3, (Object)"c", (Object)4, (Object)"d", (Object)5, (Object)"e");
        ImmutableMap right = ImmutableMap.of((Object)1, (Object)"a", (Object)3, (Object)"f", (Object)5, (Object)"g", (Object)6, (Object)"z");
        MapDifference diff1 = Maps.difference((Map)left, (Map)right);
        MapsTest.assertFalse((boolean)diff1.areEqual());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)2, (Object)"b", (Object)4, (Object)"d"), (Object)diff1.entriesOnlyOnLeft());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)6, (Object)"z"), (Object)diff1.entriesOnlyOnRight());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)"a"), (Object)diff1.entriesInCommon());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)3, (Object)Maps.ValueDifferenceImpl.create((Object)"c", (Object)"f"), (Object)5, (Object)Maps.ValueDifferenceImpl.create((Object)"e", (Object)"g")), (Object)diff1.entriesDiffering());
        MapsTest.assertEquals((String)"not equal: only on left={2=b, 4=d}: only on right={6=z}: value differences={3=(c, f), 5=(e, g)}", (String)diff1.toString());
        MapDifference diff2 = Maps.difference((Map)right, (Map)left);
        MapsTest.assertFalse((boolean)diff2.areEqual());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)6, (Object)"z"), (Object)diff2.entriesOnlyOnLeft());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)2, (Object)"b", (Object)4, (Object)"d"), (Object)diff2.entriesOnlyOnRight());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)"a"), (Object)diff2.entriesInCommon());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)3, (Object)Maps.ValueDifferenceImpl.create((Object)"f", (Object)"c"), (Object)5, (Object)Maps.ValueDifferenceImpl.create((Object)"g", (Object)"e")), (Object)diff2.entriesDiffering());
        MapsTest.assertEquals((String)"not equal: only on left={6=z}: only on right={2=b, 4=d}: value differences={3=(f, c), 5=(g, e)}", (String)diff2.toString());
    }

    public void testMapDifferenceEquals() {
        ImmutableMap left = ImmutableMap.of((Object)1, (Object)"a", (Object)2, (Object)"b", (Object)3, (Object)"c", (Object)4, (Object)"d", (Object)5, (Object)"e");
        ImmutableMap right = ImmutableMap.of((Object)1, (Object)"a", (Object)3, (Object)"f", (Object)5, (Object)"g", (Object)6, (Object)"z");
        ImmutableMap right2 = ImmutableMap.of((Object)1, (Object)"a", (Object)3, (Object)"h", (Object)5, (Object)"g", (Object)6, (Object)"z");
        MapDifference original = Maps.difference((Map)left, (Map)right);
        MapDifference same = Maps.difference((Map)left, (Map)right);
        MapDifference reverse = Maps.difference((Map)right, (Map)left);
        MapDifference diff2 = Maps.difference((Map)left, (Map)right2);
        new EqualsTester().addEqualityGroup(new Object[]{original, same}).addEqualityGroup(new Object[]{reverse}).addEqualityGroup(new Object[]{diff2}).testEquals();
    }

    public void testMapDifferencePredicateTypical() {
        ImmutableMap left = ImmutableMap.of((Object)1, (Object)"a", (Object)2, (Object)"b", (Object)3, (Object)"c", (Object)4, (Object)"d", (Object)5, (Object)"e");
        ImmutableMap right = ImmutableMap.of((Object)1, (Object)"A", (Object)3, (Object)"F", (Object)5, (Object)"G", (Object)6, (Object)"Z");
        Equivalence caseInsensitiveEquivalence = Equivalence.equals().onResultOf((Function)new Function<String, String>(){

            public String apply(String input) {
                return input.toLowerCase();
            }
        });
        MapDifference diff1 = Maps.difference((Map)left, (Map)right, (Equivalence)caseInsensitiveEquivalence);
        MapsTest.assertFalse((boolean)diff1.areEqual());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)2, (Object)"b", (Object)4, (Object)"d"), (Object)diff1.entriesOnlyOnLeft());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)6, (Object)"Z"), (Object)diff1.entriesOnlyOnRight());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)"a"), (Object)diff1.entriesInCommon());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)3, (Object)Maps.ValueDifferenceImpl.create((Object)"c", (Object)"F"), (Object)5, (Object)Maps.ValueDifferenceImpl.create((Object)"e", (Object)"G")), (Object)diff1.entriesDiffering());
        MapsTest.assertEquals((String)"not equal: only on left={2=b, 4=d}: only on right={6=Z}: value differences={3=(c, F), 5=(e, G)}", (String)diff1.toString());
        MapDifference diff2 = Maps.difference((Map)right, (Map)left, (Equivalence)caseInsensitiveEquivalence);
        MapsTest.assertFalse((boolean)diff2.areEqual());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)6, (Object)"Z"), (Object)diff2.entriesOnlyOnLeft());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)2, (Object)"b", (Object)4, (Object)"d"), (Object)diff2.entriesOnlyOnRight());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)"A"), (Object)diff2.entriesInCommon());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)3, (Object)Maps.ValueDifferenceImpl.create((Object)"F", (Object)"c"), (Object)5, (Object)Maps.ValueDifferenceImpl.create((Object)"G", (Object)"e")), (Object)diff2.entriesDiffering());
        MapsTest.assertEquals((String)"not equal: only on left={6=Z}: only on right={2=b, 4=d}: value differences={3=(F, c), 5=(G, e)}", (String)diff2.toString());
    }

    public void testMapDifferenceOfSortedMapIsSorted() {
        SortedMap<Integer, Integer> map = SORTED_SINGLETON;
        MapDifference difference = Maps.difference(map, EMPTY);
        MapsTest.assertTrue((boolean)(difference instanceof SortedMapDifference));
    }

    public void testSortedMapDifferenceEmptyEmpty() {
        SortedMapDifference diff = Maps.difference(SORTED_EMPTY, SORTED_EMPTY);
        MapsTest.assertTrue((boolean)diff.areEqual());
        MapsTest.assertEquals(SORTED_EMPTY, (Object)diff.entriesOnlyOnLeft());
        MapsTest.assertEquals(SORTED_EMPTY, (Object)diff.entriesOnlyOnRight());
        MapsTest.assertEquals(SORTED_EMPTY, (Object)diff.entriesInCommon());
        MapsTest.assertEquals(SORTED_EMPTY, (Object)diff.entriesDiffering());
        MapsTest.assertEquals((String)"equal", (String)diff.toString());
    }

    public void testSortedMapDifferenceEmptySingleton() {
        SortedMapDifference diff = Maps.difference(SORTED_EMPTY, SORTED_SINGLETON);
        MapsTest.assertFalse((boolean)diff.areEqual());
        MapsTest.assertEquals(SORTED_EMPTY, (Object)diff.entriesOnlyOnLeft());
        MapsTest.assertEquals(SORTED_SINGLETON, (Object)diff.entriesOnlyOnRight());
        MapsTest.assertEquals(SORTED_EMPTY, (Object)diff.entriesInCommon());
        MapsTest.assertEquals(SORTED_EMPTY, (Object)diff.entriesDiffering());
        MapsTest.assertEquals((String)"not equal: only on right={1=2}", (String)diff.toString());
    }

    public void testSortedMapDifferenceSingletonEmpty() {
        SortedMapDifference diff = Maps.difference(SORTED_SINGLETON, SORTED_EMPTY);
        MapsTest.assertFalse((boolean)diff.areEqual());
        MapsTest.assertEquals(SORTED_SINGLETON, (Object)diff.entriesOnlyOnLeft());
        MapsTest.assertEquals(SORTED_EMPTY, (Object)diff.entriesOnlyOnRight());
        MapsTest.assertEquals(SORTED_EMPTY, (Object)diff.entriesInCommon());
        MapsTest.assertEquals(SORTED_EMPTY, (Object)diff.entriesDiffering());
        MapsTest.assertEquals((String)"not equal: only on left={1=2}", (String)diff.toString());
    }

    public void testSortedMapDifferenceTypical() {
        ImmutableSortedMap left = ImmutableSortedMap.reverseOrder().put((Object)1, (Object)"a").put((Object)2, (Object)"b").put((Object)3, (Object)"c").put((Object)4, (Object)"d").put((Object)5, (Object)"e").build();
        ImmutableSortedMap right = ImmutableSortedMap.of((Comparable)Integer.valueOf(1), (Object)"a", (Comparable)Integer.valueOf(3), (Object)"f", (Comparable)Integer.valueOf(5), (Object)"g", (Comparable)Integer.valueOf(6), (Object)"z");
        SortedMapDifference diff1 = Maps.difference((SortedMap)left, (Map)right);
        MapsTest.assertFalse((boolean)diff1.areEqual());
        Truth.assertThat(diff1.entriesOnlyOnLeft().entrySet()).containsExactly(new Object[]{Maps.immutableEntry((Object)4, (Object)"d"), Maps.immutableEntry((Object)2, (Object)"b")}).inOrder();
        Truth.assertThat(diff1.entriesOnlyOnRight().entrySet()).contains((Object)Maps.immutableEntry((Object)6, (Object)"z"));
        Truth.assertThat(diff1.entriesInCommon().entrySet()).contains((Object)Maps.immutableEntry((Object)1, (Object)"a"));
        Truth.assertThat(diff1.entriesDiffering().entrySet()).containsExactly(new Object[]{Maps.immutableEntry((Object)5, (Object)Maps.ValueDifferenceImpl.create((Object)"e", (Object)"g")), Maps.immutableEntry((Object)3, (Object)Maps.ValueDifferenceImpl.create((Object)"c", (Object)"f"))}).inOrder();
        MapsTest.assertEquals((String)"not equal: only on left={4=d, 2=b}: only on right={6=z}: value differences={5=(e, g), 3=(c, f)}", (String)diff1.toString());
        SortedMapDifference diff2 = Maps.difference((SortedMap)right, (Map)left);
        MapsTest.assertFalse((boolean)diff2.areEqual());
        Truth.assertThat(diff2.entriesOnlyOnLeft().entrySet()).contains((Object)Maps.immutableEntry((Object)6, (Object)"z"));
        Truth.assertThat(diff2.entriesOnlyOnRight().entrySet()).containsExactly(new Object[]{Maps.immutableEntry((Object)2, (Object)"b"), Maps.immutableEntry((Object)4, (Object)"d")}).inOrder();
        Truth.assertThat(diff1.entriesInCommon().entrySet()).contains((Object)Maps.immutableEntry((Object)1, (Object)"a"));
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)3, (Object)Maps.ValueDifferenceImpl.create((Object)"f", (Object)"c"), (Object)5, (Object)Maps.ValueDifferenceImpl.create((Object)"g", (Object)"e")), (Object)diff2.entriesDiffering());
        MapsTest.assertEquals((String)"not equal: only on left={6=z}: only on right={2=b, 4=d}: value differences={3=(f, c), 5=(g, e)}", (String)diff2.toString());
    }

    public void testSortedMapDifferenceImmutable() {
        TreeMap left = Maps.newTreeMap((SortedMap)ImmutableSortedMap.of((Comparable)Integer.valueOf(1), (Object)"a", (Comparable)Integer.valueOf(2), (Object)"b", (Comparable)Integer.valueOf(3), (Object)"c", (Comparable)Integer.valueOf(4), (Object)"d", (Comparable)Integer.valueOf(5), (Object)"e"));
        TreeMap right = Maps.newTreeMap((SortedMap)ImmutableSortedMap.of((Comparable)Integer.valueOf(1), (Object)"a", (Comparable)Integer.valueOf(3), (Object)"f", (Comparable)Integer.valueOf(5), (Object)"g", (Comparable)Integer.valueOf(6), (Object)"z"));
        SortedMapDifference diff1 = Maps.difference((SortedMap)left, (Map)right);
        left.put(6, "z");
        MapsTest.assertFalse((boolean)diff1.areEqual());
        Truth.assertThat(diff1.entriesOnlyOnLeft().entrySet()).containsExactly(new Object[]{Maps.immutableEntry((Object)2, (Object)"b"), Maps.immutableEntry((Object)4, (Object)"d")}).inOrder();
        Truth.assertThat(diff1.entriesOnlyOnRight().entrySet()).contains((Object)Maps.immutableEntry((Object)6, (Object)"z"));
        Truth.assertThat(diff1.entriesInCommon().entrySet()).contains((Object)Maps.immutableEntry((Object)1, (Object)"a"));
        Truth.assertThat(diff1.entriesDiffering().entrySet()).containsExactly(new Object[]{Maps.immutableEntry((Object)3, (Object)Maps.ValueDifferenceImpl.create((Object)"c", (Object)"f")), Maps.immutableEntry((Object)5, (Object)Maps.ValueDifferenceImpl.create((Object)"e", (Object)"g"))}).inOrder();
        try {
            diff1.entriesInCommon().put(7, "x");
            MapsTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            diff1.entriesOnlyOnLeft().put(7, "x");
            MapsTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            diff1.entriesOnlyOnRight().put(7, "x");
            MapsTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
    }

    public void testSortedMapDifferenceEquals() {
        ImmutableSortedMap left = ImmutableSortedMap.of((Comparable)Integer.valueOf(1), (Object)"a", (Comparable)Integer.valueOf(2), (Object)"b", (Comparable)Integer.valueOf(3), (Object)"c", (Comparable)Integer.valueOf(4), (Object)"d", (Comparable)Integer.valueOf(5), (Object)"e");
        ImmutableSortedMap right = ImmutableSortedMap.of((Comparable)Integer.valueOf(1), (Object)"a", (Comparable)Integer.valueOf(3), (Object)"f", (Comparable)Integer.valueOf(5), (Object)"g", (Comparable)Integer.valueOf(6), (Object)"z");
        ImmutableSortedMap right2 = ImmutableSortedMap.of((Comparable)Integer.valueOf(1), (Object)"a", (Comparable)Integer.valueOf(3), (Object)"h", (Comparable)Integer.valueOf(5), (Object)"g", (Comparable)Integer.valueOf(6), (Object)"z");
        SortedMapDifference original = Maps.difference((SortedMap)left, (Map)right);
        SortedMapDifference same = Maps.difference((SortedMap)left, (Map)right);
        SortedMapDifference reverse = Maps.difference((SortedMap)right, (Map)left);
        SortedMapDifference diff2 = Maps.difference((SortedMap)left, (Map)right2);
        new EqualsTester().addEqualityGroup(new Object[]{original, same}).addEqualityGroup(new Object[]{reverse}).addEqualityGroup(new Object[]{diff2}).testEquals();
    }

    public void testAsMap() {
        ImmutableSet strings = ImmutableSet.of((Object)"one", (Object)"two", (Object)"three");
        Map map = Maps.asMap((Set)strings, LENGTH_FUNCTION);
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)"one", (Object)3, (Object)"two", (Object)3, (Object)"three", (Object)5), (Object)map);
        MapsTest.assertEquals((Object)5, map.get("three"));
        MapsTest.assertNull(map.get("five"));
        Truth.assertThat(map.entrySet()).containsExactly(new Object[]{Helpers.mapEntry((Object)"one", (Object)3), Helpers.mapEntry((Object)"two", (Object)3), Helpers.mapEntry((Object)"three", (Object)5)}).inOrder();
    }

    public void testAsMapReadsThrough() {
        LinkedHashSet strings = Sets.newLinkedHashSet();
        Collections.addAll(strings, "one", "two", "three");
        Map map = Maps.asMap((Set)strings, LENGTH_FUNCTION);
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)"one", (Object)3, (Object)"two", (Object)3, (Object)"three", (Object)5), (Object)map);
        MapsTest.assertNull(map.get("four"));
        strings.add("four");
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)"one", (Object)3, (Object)"two", (Object)3, (Object)"three", (Object)5, (Object)"four", (Object)4), (Object)map);
        MapsTest.assertEquals((Object)4, map.get("four"));
    }

    public void testAsMapWritesThrough() {
        LinkedHashSet strings = Sets.newLinkedHashSet();
        Collections.addAll(strings, "one", "two", "three");
        Map map = Maps.asMap((Set)strings, LENGTH_FUNCTION);
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)"one", (Object)3, (Object)"two", (Object)3, (Object)"three", (Object)5), (Object)map);
        MapsTest.assertEquals((Object)3, map.remove("two"));
        Truth.assertThat((Collection)strings).containsExactly(new Object[]{"one", "three"}).inOrder();
    }

    public void testAsMapEmpty() {
        ImmutableSet strings = ImmutableSet.of();
        Map map = Maps.asMap((Set)strings, LENGTH_FUNCTION);
        Truth.assertThat(map.entrySet()).isEmpty();
        MapsTest.assertTrue((boolean)map.isEmpty());
        MapsTest.assertNull(map.get("five"));
    }

    public void testAsMapReturnsSortedMapForSortedSetInput() {
        NonNavigableSortedSet set = new NonNavigableSortedSet();
        MapsTest.assertTrue((boolean)(Maps.asMap((Set)((Object)set), (Function)Functions.identity()) instanceof SortedMap));
    }

    public void testAsMapSorted() {
        NonNavigableSortedSet strings = new NonNavigableSortedSet();
        Collections.addAll(strings, new String[]{"one", "two", "three"});
        SortedMap map = Maps.asMap((SortedSet)((Object)strings), LENGTH_FUNCTION);
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)"one", (Object)3, (Object)"two", (Object)3, (Object)"three", (Object)5), (Object)map);
        MapsTest.assertEquals((Object)5, map.get("three"));
        MapsTest.assertNull(map.get("five"));
        Truth.assertThat(map.entrySet()).containsExactly(new Object[]{Helpers.mapEntry((Object)"one", (Object)3), Helpers.mapEntry((Object)"three", (Object)5), Helpers.mapEntry((Object)"two", (Object)3)}).inOrder();
        Truth.assertThat(map.tailMap("onea").entrySet()).containsExactly(new Object[]{Helpers.mapEntry((Object)"three", (Object)5), Helpers.mapEntry((Object)"two", (Object)3)}).inOrder();
        Truth.assertThat(map.subMap("one", "two").entrySet()).containsExactly(new Object[]{Helpers.mapEntry((Object)"one", (Object)3), Helpers.mapEntry((Object)"three", (Object)5)}).inOrder();
    }

    public void testAsMapSortedReadsThrough() {
        NonNavigableSortedSet strings = new NonNavigableSortedSet();
        Collections.addAll(strings, new String[]{"one", "two", "three"});
        SortedMap map = Maps.asMap((SortedSet)((Object)strings), LENGTH_FUNCTION);
        MapsTest.assertNull(map.comparator());
        MapsTest.assertEquals((Object)ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)3, (Comparable)((Object)"two"), (Object)3, (Comparable)((Object)"three"), (Object)5), (Object)map);
        MapsTest.assertNull(map.get("four"));
        strings.add("four");
        MapsTest.assertEquals((Object)ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)3, (Comparable)((Object)"two"), (Object)3, (Comparable)((Object)"three"), (Object)5, (Comparable)((Object)"four"), (Object)4), (Object)map);
        MapsTest.assertEquals((Object)4, map.get("four"));
        SortedMap headMap = map.headMap("two");
        MapsTest.assertEquals((Object)ImmutableSortedMap.of((Comparable)((Object)"four"), (Object)4, (Comparable)((Object)"one"), (Object)3, (Comparable)((Object)"three"), (Object)5), headMap);
        strings.add("five");
        strings.remove("one");
        MapsTest.assertEquals((Object)ImmutableSortedMap.of((Comparable)((Object)"five"), (Object)4, (Comparable)((Object)"four"), (Object)4, (Comparable)((Object)"three"), (Object)5), headMap);
        Truth.assertThat(map.entrySet()).containsExactly(new Object[]{Helpers.mapEntry((Object)"five", (Object)4), Helpers.mapEntry((Object)"four", (Object)4), Helpers.mapEntry((Object)"three", (Object)5), Helpers.mapEntry((Object)"two", (Object)3)}).inOrder();
    }

    public void testAsMapSortedWritesThrough() {
        NonNavigableSortedSet strings = new NonNavigableSortedSet();
        Collections.addAll(strings, new String[]{"one", "two", "three"});
        SortedMap map = Maps.asMap((SortedSet)((Object)strings), LENGTH_FUNCTION);
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)"one", (Object)3, (Object)"two", (Object)3, (Object)"three", (Object)5), (Object)map);
        MapsTest.assertEquals((Object)3, map.remove("two"));
        Truth.assertThat((Collection)((Object)strings)).containsExactly(new Object[]{"one", "three"}).inOrder();
    }

    public void testAsMapSortedSubViewKeySetsDoNotSupportAdd() {
        SortedMap map = Maps.asMap((SortedSet)((Object)new NonNavigableSortedSet()), LENGTH_FUNCTION);
        try {
            map.subMap("a", "z").keySet().add("a");
            MapsTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            map.tailMap("a").keySet().add("a");
            MapsTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            map.headMap("r").keySet().add("a");
            MapsTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            map.headMap("r").tailMap("m").keySet().add("a");
            MapsTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testAsMapSortedEmpty() {
        NonNavigableSortedSet strings = new NonNavigableSortedSet();
        SortedMap map = Maps.asMap((SortedSet)((Object)strings), LENGTH_FUNCTION);
        Truth.assertThat(map.entrySet()).isEmpty();
        MapsTest.assertTrue((boolean)map.isEmpty());
        MapsTest.assertNull(map.get("five"));
    }

    @GwtIncompatible(value="NavigableMap")
    public void testAsMapReturnsNavigableMapForNavigableSetInput() {
        TreeSet set = Sets.newTreeSet();
        MapsTest.assertTrue((boolean)(Maps.asMap((Set)set, (Function)Functions.identity()) instanceof NavigableMap));
    }

    @GwtIncompatible(value="NavigableMap")
    public void testAsMapNavigable() {
        TreeSet strings = Sets.newTreeSet(Arrays.asList("one", "two", "three"));
        NavigableMap map = Maps.asMap((NavigableSet)strings, LENGTH_FUNCTION);
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)"one", (Object)3, (Object)"two", (Object)3, (Object)"three", (Object)5), (Object)map);
        MapsTest.assertEquals((Object)5, map.get("three"));
        MapsTest.assertNull(map.get("five"));
        Truth.assertThat(map.entrySet()).containsExactly(new Object[]{Helpers.mapEntry((Object)"one", (Object)3), Helpers.mapEntry((Object)"three", (Object)5), Helpers.mapEntry((Object)"two", (Object)3)}).inOrder();
        Truth.assertThat(map.tailMap("onea").entrySet()).containsExactly(new Object[]{Helpers.mapEntry((Object)"three", (Object)5), Helpers.mapEntry((Object)"two", (Object)3)}).inOrder();
        Truth.assertThat(map.subMap("one", "two").entrySet()).containsExactly(new Object[]{Helpers.mapEntry((Object)"one", (Object)3), Helpers.mapEntry((Object)"three", (Object)5)}).inOrder();
        MapsTest.assertEquals((Object)ImmutableSortedMap.of((Comparable)((Object)"two"), (Object)3, (Comparable)((Object)"three"), (Object)5), map.tailMap("three", true));
        MapsTest.assertEquals((Object)ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)3, (Comparable)((Object)"three"), (Object)5), map.headMap("two", false));
        MapsTest.assertEquals((Object)ImmutableSortedMap.of((Comparable)((Object)"three"), (Object)5), map.subMap("one", false, "tr", true));
        MapsTest.assertEquals((String)"three", (String)map.higherKey("one"));
        MapsTest.assertEquals((String)"three", (String)map.higherKey("r"));
        MapsTest.assertEquals((String)"three", (String)map.ceilingKey("r"));
        MapsTest.assertEquals((String)"one", (String)map.ceilingKey("one"));
        MapsTest.assertEquals((Object)Helpers.mapEntry((Object)"three", (Object)5), map.higherEntry("one"));
        MapsTest.assertEquals((Object)Helpers.mapEntry((Object)"one", (Object)3), map.ceilingEntry("one"));
        MapsTest.assertEquals((String)"one", (String)map.lowerKey("three"));
        MapsTest.assertEquals((String)"one", (String)map.lowerKey("r"));
        MapsTest.assertEquals((String)"one", (String)map.floorKey("r"));
        MapsTest.assertEquals((String)"three", (String)map.floorKey("three"));
        Truth.assertThat(map.descendingMap().entrySet()).containsExactly(new Object[]{Helpers.mapEntry((Object)"two", (Object)3), Helpers.mapEntry((Object)"three", (Object)5), Helpers.mapEntry((Object)"one", (Object)3)}).inOrder();
        MapsTest.assertEquals(map.headMap("three", true), map.descendingMap().tailMap("three", true));
        Truth.assertThat(map.tailMap("three", false).entrySet()).contains((Object)Helpers.mapEntry((Object)"two", (Object)3));
        MapsTest.assertNull(map.tailMap("three", true).lowerEntry("three"));
        Truth.assertThat(map.headMap("two", false).values()).containsExactly(new Object[]{3, 5}).inOrder();
        Truth.assertThat(map.headMap("two", false).descendingMap().values()).containsExactly(new Object[]{5, 3}).inOrder();
        Truth.assertThat(map.descendingKeySet()).containsExactly(new Object[]{"two", "three", "one"}).inOrder();
        MapsTest.assertEquals((Object)Helpers.mapEntry((Object)"one", (Object)3), map.pollFirstEntry());
        MapsTest.assertEquals((Object)Helpers.mapEntry((Object)"two", (Object)3), map.pollLastEntry());
        MapsTest.assertEquals((int)1, (int)map.size());
    }

    @GwtIncompatible(value="NavigableMap")
    public void testAsMapNavigableReadsThrough() {
        TreeSet strings = Sets.newTreeSet();
        Collections.addAll(strings, "one", "two", "three");
        NavigableMap map = Maps.asMap((NavigableSet)strings, LENGTH_FUNCTION);
        MapsTest.assertNull(map.comparator());
        MapsTest.assertEquals((Object)ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)3, (Comparable)((Object)"two"), (Object)3, (Comparable)((Object)"three"), (Object)5), (Object)map);
        MapsTest.assertNull(map.get("four"));
        strings.add("four");
        MapsTest.assertEquals((Object)ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)3, (Comparable)((Object)"two"), (Object)3, (Comparable)((Object)"three"), (Object)5, (Comparable)((Object)"four"), (Object)4), (Object)map);
        MapsTest.assertEquals((Object)4, map.get("four"));
        SortedMap headMap = map.headMap("two");
        MapsTest.assertEquals((Object)ImmutableSortedMap.of((Comparable)((Object)"four"), (Object)4, (Comparable)((Object)"one"), (Object)3, (Comparable)((Object)"three"), (Object)5), headMap);
        strings.add("five");
        strings.remove("one");
        MapsTest.assertEquals((Object)ImmutableSortedMap.of((Comparable)((Object)"five"), (Object)4, (Comparable)((Object)"four"), (Object)4, (Comparable)((Object)"three"), (Object)5), headMap);
        Truth.assertThat(map.entrySet()).containsExactly(new Object[]{Helpers.mapEntry((Object)"five", (Object)4), Helpers.mapEntry((Object)"four", (Object)4), Helpers.mapEntry((Object)"three", (Object)5), Helpers.mapEntry((Object)"two", (Object)3)}).inOrder();
        NavigableMap tailMap = map.tailMap("s", true);
        NavigableMap subMap = map.subMap("a", true, "t", false);
        strings.add("six");
        strings.remove("two");
        Truth.assertThat(tailMap.entrySet()).containsExactly(new Object[]{Helpers.mapEntry((Object)"six", (Object)3), Helpers.mapEntry((Object)"three", (Object)5)}).inOrder();
        Truth.assertThat(subMap.entrySet()).containsExactly(new Object[]{Helpers.mapEntry((Object)"five", (Object)4), Helpers.mapEntry((Object)"four", (Object)4), Helpers.mapEntry((Object)"six", (Object)3)}).inOrder();
    }

    @GwtIncompatible(value="NavigableMap")
    public void testAsMapNavigableWritesThrough() {
        TreeSet strings = Sets.newTreeSet();
        Collections.addAll(strings, "one", "two", "three");
        NavigableMap map = Maps.asMap((NavigableSet)strings, LENGTH_FUNCTION);
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)"one", (Object)3, (Object)"two", (Object)3, (Object)"three", (Object)5), (Object)map);
        MapsTest.assertEquals((Object)3, map.remove("two"));
        Truth.assertThat((Collection)strings).containsExactly(new Object[]{"one", "three"}).inOrder();
        MapsTest.assertEquals((Object)Helpers.mapEntry((Object)"three", (Object)5), map.subMap("one", false, "zzz", true).pollLastEntry());
        Truth.assertThat((Collection)strings).contains((Object)"one");
    }

    @GwtIncompatible(value="NavigableMap")
    public void testAsMapNavigableSubViewKeySetsDoNotSupportAdd() {
        NavigableMap map = Maps.asMap((NavigableSet)Sets.newTreeSet(), LENGTH_FUNCTION);
        try {
            map.descendingKeySet().add("a");
            MapsTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            map.subMap("a", true, "z", false).keySet().add("a");
            MapsTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            map.tailMap("a", true).keySet().add("a");
            MapsTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            map.headMap("r", true).keySet().add("a");
            MapsTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            map.headMap("r", false).tailMap("m", true).keySet().add("a");
            MapsTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @GwtIncompatible(value="NavigableMap")
    public void testAsMapNavigableEmpty() {
        ImmutableSortedSet strings = ImmutableSortedSet.of();
        NavigableMap map = Maps.asMap((NavigableSet)strings, LENGTH_FUNCTION);
        Truth.assertThat(map.entrySet()).isEmpty();
        MapsTest.assertTrue((boolean)map.isEmpty());
        MapsTest.assertNull(map.get("five"));
    }

    public void testToMap() {
        ImmutableList strings = ImmutableList.of((Object)"one", (Object)"two", (Object)"three");
        ImmutableMap map = Maps.toMap((Iterable)strings, LENGTH_FUNCTION);
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)"one", (Object)3, (Object)"two", (Object)3, (Object)"three", (Object)5), (Object)map);
        Truth.assertThat((Collection)map.entrySet()).containsExactly(new Object[]{Helpers.mapEntry((Object)"one", (Object)3), Helpers.mapEntry((Object)"two", (Object)3), Helpers.mapEntry((Object)"three", (Object)5)}).inOrder();
    }

    public void testToMapIterator() {
        UnmodifiableIterator strings = ImmutableList.of((Object)"one", (Object)"two", (Object)"three").iterator();
        ImmutableMap map = Maps.toMap((Iterator)strings, LENGTH_FUNCTION);
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)"one", (Object)3, (Object)"two", (Object)3, (Object)"three", (Object)5), (Object)map);
        Truth.assertThat((Collection)map.entrySet()).containsExactly(new Object[]{Helpers.mapEntry((Object)"one", (Object)3), Helpers.mapEntry((Object)"two", (Object)3), Helpers.mapEntry((Object)"three", (Object)5)}).inOrder();
    }

    public void testToMapWithDuplicateKeys() {
        ImmutableList strings = ImmutableList.of((Object)"one", (Object)"two", (Object)"three", (Object)"two", (Object)"one");
        ImmutableMap map = Maps.toMap((Iterable)strings, LENGTH_FUNCTION);
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)"one", (Object)3, (Object)"two", (Object)3, (Object)"three", (Object)5), (Object)map);
        Truth.assertThat((Collection)map.entrySet()).containsExactly(new Object[]{Helpers.mapEntry((Object)"one", (Object)3), Helpers.mapEntry((Object)"two", (Object)3), Helpers.mapEntry((Object)"three", (Object)5)}).inOrder();
    }

    public void testToMapWithNullKeys() {
        List<String> strings = Arrays.asList("one", null, "three");
        try {
            Maps.toMap(strings, (Function)Functions.constant((Object)"foo"));
            MapsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToMapWithNullValues() {
        ImmutableList strings = ImmutableList.of((Object)"one", (Object)"two", (Object)"three");
        try {
            Maps.toMap((Iterable)strings, (Function)Functions.constant(null));
            MapsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testUniqueIndexCollection() {
        ImmutableMap outputMap = Maps.uniqueIndex((Iterable)INT_TO_STRING_MAP.values(), (Function)Functions.forMap((Map)INT_TO_STRING_MAP.inverse()));
        MapsTest.assertEquals(INT_TO_STRING_MAP, (Object)outputMap);
    }

    public void testUniqueIndexIterable() {
        ImmutableMap outputMap = Maps.uniqueIndex((Iterable)new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return INT_TO_STRING_MAP.values().iterator();
            }
        }, (Function)Functions.forMap((Map)INT_TO_STRING_MAP.inverse()));
        MapsTest.assertEquals(INT_TO_STRING_MAP, (Object)outputMap);
    }

    public void testUniqueIndexIterator() {
        ImmutableMap outputMap = Maps.uniqueIndex(INT_TO_STRING_MAP.values().iterator(), (Function)Functions.forMap((Map)INT_TO_STRING_MAP.inverse()));
        MapsTest.assertEquals(INT_TO_STRING_MAP, (Object)outputMap);
    }

    public void testUniqueIndexDuplicates() {
        try {
            Maps.uniqueIndex((Iterable)ImmutableSet.of((Object)"one", (Object)"uno"), (Function)Functions.constant((Object)1));
            MapsTest.fail();
        }
        catch (IllegalArgumentException expected) {
            Truth.assertThat((String)expected.getMessage()).contains((CharSequence)"Multimaps.index");
        }
    }

    public void testUniqueIndexNullValue() {
        ArrayList listWithNull = Lists.newArrayList((Object[])new String[]{null});
        try {
            Maps.uniqueIndex((Iterable)listWithNull, (Function)Functions.constant((Object)1));
            MapsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testUniqueIndexNullKey() {
        ArrayList oneStringList = Lists.newArrayList((Object[])new String[]{"foo"});
        try {
            Maps.uniqueIndex((Iterable)oneStringList, (Function)Functions.constant(null));
            MapsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @GwtIncompatible(value="Maps.fromProperties")
    public void testFromProperties() throws IOException {
        Properties testProp = new Properties();
        ImmutableMap result = Maps.fromProperties((Properties)testProp);
        MapsTest.assertTrue((boolean)result.isEmpty());
        testProp.setProperty("first", "true");
        result = Maps.fromProperties((Properties)testProp);
        MapsTest.assertEquals((String)"true", (String)((String)result.get("first")));
        MapsTest.assertEquals((int)1, (int)result.size());
        testProp.setProperty("second", "null");
        result = Maps.fromProperties((Properties)testProp);
        MapsTest.assertEquals((String)"true", (String)((String)result.get("first")));
        MapsTest.assertEquals((String)"null", (String)((String)result.get("second")));
        MapsTest.assertEquals((int)2, (int)result.size());
        String props = "test\n second = 2\n Third item :   a short  phrase   ";
        testProp.load(new StringReader(props));
        result = Maps.fromProperties((Properties)testProp);
        MapsTest.assertEquals((int)4, (int)result.size());
        MapsTest.assertEquals((String)"true", (String)((String)result.get("first")));
        MapsTest.assertEquals((String)"", (String)((String)result.get("test")));
        MapsTest.assertEquals((String)"2", (String)((String)result.get("second")));
        MapsTest.assertEquals((String)"item :   a short  phrase   ", (String)((String)result.get("Third")));
        MapsTest.assertFalse((boolean)result.containsKey("not here"));
        result = Maps.fromProperties((Properties)System.getProperties());
        MapsTest.assertTrue((boolean)result.containsKey("java.version"));
        testProp = new Properties(System.getProperties());
        String override = "test\njava.version : hidden";
        testProp.load(new StringReader(override));
        result = Maps.fromProperties((Properties)testProp);
        MapsTest.assertTrue((result.size() > 2 ? 1 : 0) != 0);
        MapsTest.assertEquals((String)"", (String)((String)result.get("test")));
        MapsTest.assertEquals((String)"hidden", (String)((String)result.get("java.version")));
        MapsTest.assertNotSame((Object)System.getProperty("java.version"), result.get("java.version"));
    }

    @GwtIncompatible(value="Maps.fromProperties")
    public void testFromPropertiesNullKey() {
        Properties properties = new Properties(){

            @Override
            public Enumeration<?> propertyNames() {
                return Iterators.asEnumeration(Arrays.asList(null, "first", "second").iterator());
            }
        };
        properties.setProperty("first", "true");
        properties.setProperty("second", "null");
        try {
            Maps.fromProperties((Properties)properties);
            MapsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @GwtIncompatible(value="Maps.fromProperties")
    public void testFromPropertiesNonStringKeys() {
        Properties properties = new Properties(){

            @Override
            public Enumeration<?> propertyNames() {
                return Iterators.asEnumeration(Arrays.asList(123, "first").iterator());
            }
        };
        try {
            Maps.fromProperties((Properties)properties);
            MapsTest.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void testAsConverter_nominal() throws Exception {
        ImmutableBiMap biMap = ImmutableBiMap.of((Object)"one", (Object)1, (Object)"two", (Object)2);
        Converter converter = Maps.asConverter((BiMap)biMap);
        for (Map.Entry entry : biMap.entrySet()) {
            MapsTest.assertSame(entry.getValue(), (Object)converter.convert(entry.getKey()));
        }
    }

    public void testAsConverter_inverse() throws Exception {
        ImmutableBiMap biMap = ImmutableBiMap.of((Object)"one", (Object)1, (Object)"two", (Object)2);
        Converter converter = Maps.asConverter((BiMap)biMap);
        for (Map.Entry entry : biMap.entrySet()) {
            MapsTest.assertSame(entry.getKey(), (Object)converter.reverse().convert(entry.getValue()));
        }
    }

    public void testAsConverter_noMapping() throws Exception {
        ImmutableBiMap biMap = ImmutableBiMap.of((Object)"one", (Object)1, (Object)"two", (Object)2);
        Converter converter = Maps.asConverter((BiMap)biMap);
        try {
            converter.convert((Object)"three");
            MapsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAsConverter_nullConversions() throws Exception {
        ImmutableBiMap biMap = ImmutableBiMap.of((Object)"one", (Object)1, (Object)"two", (Object)2);
        Converter converter = Maps.asConverter((BiMap)biMap);
        MapsTest.assertNull((Object)converter.convert(null));
        MapsTest.assertNull((Object)converter.reverse().convert(null));
    }

    public void testAsConverter_isAView() throws Exception {
        HashBiMap biMap = HashBiMap.create();
        biMap.put((Object)"one", (Object)1);
        biMap.put((Object)"two", (Object)2);
        Converter converter = Maps.asConverter((BiMap)biMap);
        MapsTest.assertSame((Object)1, (Object)converter.convert((Object)"one"));
        MapsTest.assertSame((Object)2, (Object)converter.convert((Object)"two"));
        try {
            converter.convert((Object)"three");
            MapsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        biMap.put((Object)"three", (Object)3);
        MapsTest.assertSame((Object)1, (Object)converter.convert((Object)"one"));
        MapsTest.assertSame((Object)2, (Object)converter.convert((Object)"two"));
        MapsTest.assertSame((Object)3, (Object)converter.convert((Object)"three"));
    }

    public void testAsConverter_withNullMapping() throws Exception {
        HashBiMap biMap = HashBiMap.create();
        biMap.put((Object)"one", (Object)1);
        biMap.put((Object)"two", (Object)2);
        biMap.put((Object)"three", null);
        try {
            Maps.asConverter((BiMap)biMap).convert((Object)"three");
            MapsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAsConverter_toString() {
        ImmutableBiMap biMap = ImmutableBiMap.of((Object)"one", (Object)1, (Object)"two", (Object)2);
        Converter converter = Maps.asConverter((BiMap)biMap);
        MapsTest.assertEquals((String)"Maps.asConverter({one=1, two=2})", (String)converter.toString());
    }

    public void testAsConverter_serialization() {
        ImmutableBiMap biMap = ImmutableBiMap.of((Object)"one", (Object)1, (Object)"two", (Object)2);
        Converter converter = Maps.asConverter((BiMap)biMap);
        SerializableTester.reserializeAndAssert((Object)converter);
    }

    public void testUnmodifiableBiMap() {
        HashBiMap mod = HashBiMap.create();
        mod.put((Object)1, (Object)"one");
        mod.put((Object)2, (Object)"two");
        mod.put((Object)3, (Object)"three");
        BiMap unmod = Maps.unmodifiableBiMap((BiMap)mod);
        MapsTest.assertSame((Object)unmod.inverse(), (Object)unmod.inverse());
        MapsTest.assertSame((Object)unmod, (Object)unmod.inverse().inverse());
        mod.put((Object)4, (Object)"four");
        MapsTest.assertEquals((boolean)true, (boolean)((String)unmod.get((Object)4)).equals("four"));
        MapsTest.assertEquals((boolean)true, (boolean)((Number)unmod.inverse().get((Object)"four")).equals(4));
        try {
            unmod.put((Object)4, (Object)"four");
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            unmod.forcePut((Object)4, (Object)"four");
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            unmod.putAll(Collections.singletonMap(4, "four"));
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        BiMap inverse = unmod.inverse();
        try {
            inverse.put((Object)"four", (Object)4);
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            inverse.forcePut((Object)"four", (Object)4);
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            inverse.putAll(Collections.singletonMap("four", 4));
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        Set values = unmod.values();
        try {
            values.remove("four");
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        Set entries = unmod.entrySet();
        Map.Entry entry = (Map.Entry)entries.iterator().next();
        try {
            entry.setValue("four");
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        Map.Entry entry2 = (Map.Entry)entries.toArray()[0];
        try {
            entry2.setValue("four");
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
    }

    public void testImmutableEntry() {
        Map.Entry e = Maps.immutableEntry((Object)"foo", (Object)1);
        MapsTest.assertEquals((String)"foo", (String)((String)e.getKey()));
        MapsTest.assertEquals((int)1, (int)((Integer)e.getValue()));
        try {
            e.setValue(2);
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        MapsTest.assertEquals((String)"foo=1", (String)e.toString());
        MapsTest.assertEquals((int)101575, (int)e.hashCode());
    }

    public void testImmutableEntryNull() {
        Map.Entry e = Maps.immutableEntry((Object)null, (Object)null);
        MapsTest.assertNull(e.getKey());
        MapsTest.assertNull(e.getValue());
        try {
            e.setValue(null);
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        MapsTest.assertEquals((String)"null=null", (String)e.toString());
        MapsTest.assertEquals((int)0, (int)e.hashCode());
    }

    public void testSynchronizedBiMap() {
        HashBiMap bimap = HashBiMap.create();
        bimap.put((Object)"one", (Object)1);
        BiMap sync = Maps.synchronizedBiMap((BiMap)bimap);
        bimap.put((Object)"two", (Object)2);
        sync.put((Object)"three", (Object)3);
        MapsTest.assertEquals((Object)ImmutableSet.of((Object)1, (Object)2, (Object)3), (Object)bimap.inverse().keySet());
        MapsTest.assertEquals((Object)ImmutableSet.of((Object)1, (Object)2, (Object)3), (Object)sync.inverse().keySet());
    }

    public void testTransformValues() {
        ImmutableMap map = ImmutableMap.of((Object)"a", (Object)4, (Object)"b", (Object)9);
        Map transformed = Maps.transformValues((Map)map, SQRT_FUNCTION);
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)2.0, (Object)"b", (Object)3.0), (Object)transformed);
    }

    public void testTransformValuesSecretlySorted() {
        SortedMap map = MapsTest.sortedNotNavigable(ImmutableSortedMap.of((Comparable)((Object)"a"), (Object)4, (Comparable)((Object)"b"), (Object)9));
        Map transformed = Maps.transformValues(map, SQRT_FUNCTION);
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)2.0, (Object)"b", (Object)3.0), (Object)transformed);
        MapsTest.assertTrue((boolean)(transformed instanceof SortedMap));
    }

    @GwtIncompatible(value="NavigableMap")
    public void testTransformValuesSecretlyNavigable() {
        ImmutableSortedMap map = ImmutableSortedMap.of((Comparable)((Object)"a"), (Object)4, (Comparable)((Object)"b"), (Object)9);
        Map transformed = Maps.transformValues((Map)map, SQRT_FUNCTION);
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)2.0, (Object)"b", (Object)3.0), (Object)transformed);
        MapsTest.assertTrue((boolean)(transformed instanceof NavigableMap));
        transformed = Maps.transformValues((SortedMap)((SortedMap)map), SQRT_FUNCTION);
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)2.0, (Object)"b", (Object)3.0), (Object)transformed);
        MapsTest.assertTrue((boolean)(transformed instanceof NavigableMap));
    }

    public void testTransformEntries() {
        ImmutableMap map = ImmutableMap.of((Object)"a", (Object)"4", (Object)"b", (Object)"9");
        Maps.EntryTransformer<String, String, String> concat = new Maps.EntryTransformer<String, String, String>(){

            public String transformEntry(String key, String value) {
                return key + value;
            }
        };
        Map transformed = Maps.transformEntries((Map)map, (Maps.EntryTransformer)concat);
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)"a4", (Object)"b", (Object)"b9"), (Object)transformed);
    }

    public void testTransformEntriesSecretlySorted() {
        ImmutableSortedMap map = ImmutableSortedMap.of((Comparable)((Object)"a"), (Object)"4", (Comparable)((Object)"b"), (Object)"9");
        Maps.EntryTransformer<String, String, String> concat = new Maps.EntryTransformer<String, String, String>(){

            public String transformEntry(String key, String value) {
                return key + value;
            }
        };
        Map transformed = Maps.transformEntries((Map)map, (Maps.EntryTransformer)concat);
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)"a4", (Object)"b", (Object)"b9"), (Object)transformed);
        MapsTest.assertTrue((boolean)(transformed instanceof SortedMap));
    }

    @GwtIncompatible(value="NavigableMap")
    public void testTransformEntriesSecretlyNavigable() {
        ImmutableSortedMap map = ImmutableSortedMap.of((Comparable)((Object)"a"), (Object)"4", (Comparable)((Object)"b"), (Object)"9");
        Maps.EntryTransformer<String, String, String> concat = new Maps.EntryTransformer<String, String, String>(){

            public String transformEntry(String key, String value) {
                return key + value;
            }
        };
        Map transformed = Maps.transformEntries((Map)map, (Maps.EntryTransformer)concat);
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)"a4", (Object)"b", (Object)"b9"), (Object)transformed);
        MapsTest.assertTrue((boolean)(transformed instanceof NavigableMap));
        transformed = Maps.transformEntries((SortedMap)((SortedMap)map), (Maps.EntryTransformer)concat);
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)"a4", (Object)"b", (Object)"b9"), (Object)transformed);
        MapsTest.assertTrue((boolean)(transformed instanceof NavigableMap));
    }

    public void testTransformEntriesGenerics() {
        ImmutableMap map1 = ImmutableMap.of((Object)1, (Object)2);
        ImmutableMap map2 = ImmutableMap.of((Object)1, (Object)2);
        ImmutableMap map3 = ImmutableMap.of((Object)1, (Object)2);
        ImmutableMap map4 = ImmutableMap.of((Object)1, (Object)2);
        ImmutableMap map5 = ImmutableMap.of((Object)1, (Object)2);
        ImmutableMap map6 = ImmutableMap.of((Object)1, (Object)2);
        ImmutableMap map7 = ImmutableMap.of((Object)1, (Object)2);
        ImmutableMap map8 = ImmutableMap.of((Object)1, (Object)2);
        ImmutableMap map9 = ImmutableMap.of((Object)1, (Object)2);
        ImmutableMap map0 = ImmutableMap.of((Object)1, (Object)2);
        Maps.EntryTransformer<Number, Number, Double> transformer = new Maps.EntryTransformer<Number, Number, Double>(){

            public Double transformEntry(Number key, Number value) {
                return key.doubleValue() + value.doubleValue();
            }
        };
        Map numberKeyed = Maps.transformEntries((Map)map5, (Maps.EntryTransformer)transformer);
        numberKeyed = Maps.transformEntries((Map)map6, (Maps.EntryTransformer)transformer);
        Map integerKeyed = Maps.transformEntries((Map)map8, (Maps.EntryTransformer)transformer);
        integerKeyed = Maps.transformEntries((Map)map9, (Maps.EntryTransformer)transformer);
        Map wildcarded = Maps.transformEntries((Map)map0, (Maps.EntryTransformer)transformer);
    }

    public void testTransformEntriesExample() {
        ImmutableMap options = ImmutableMap.of((Object)"verbose", (Object)true, (Object)"sort", (Object)false);
        Maps.EntryTransformer<String, Boolean, String> flagPrefixer = new Maps.EntryTransformer<String, Boolean, String>(){

            public String transformEntry(String key, Boolean value) {
                return value != false ? key : "no" + key;
            }
        };
        Map transformed = Maps.transformEntries((Map)options, (Maps.EntryTransformer)flagPrefixer);
        MapsTest.assertEquals((String)"{verbose=verbose, sort=nosort}", (String)transformed.toString());
    }

    private static <K, V> SortedMap<K, V> sortedNotNavigable(final SortedMap<K, V> map) {
        return new ForwardingSortedMap<K, V>(){

            protected SortedMap<K, V> delegate() {
                return map;
            }
        };
    }

    public void testSortedMapTransformValues() {
        SortedMap map = MapsTest.sortedNotNavigable(ImmutableSortedMap.of((Comparable)((Object)"a"), (Object)4, (Comparable)((Object)"b"), (Object)9));
        SortedMap transformed = Maps.transformValues(map, SQRT_FUNCTION);
        MapsTest.assertEquals((Object)ImmutableSortedMap.of((Comparable)((Object)"a"), (Object)2.0, (Comparable)((Object)"b"), (Object)3.0), (Object)transformed);
    }

    @GwtIncompatible(value="NavigableMap")
    public void testNavigableMapTransformValues() {
        ImmutableSortedMap map = ImmutableSortedMap.of((Comparable)((Object)"a"), (Object)4, (Comparable)((Object)"b"), (Object)9);
        NavigableMap transformed = Maps.transformValues((NavigableMap)map, SQRT_FUNCTION);
        MapsTest.assertEquals((Object)ImmutableSortedMap.of((Comparable)((Object)"a"), (Object)2.0, (Comparable)((Object)"b"), (Object)3.0), (Object)transformed);
    }

    public void testSortedMapTransformEntries() {
        SortedMap map = MapsTest.sortedNotNavigable(ImmutableSortedMap.of((Comparable)((Object)"a"), (Object)"4", (Comparable)((Object)"b"), (Object)"9"));
        Maps.EntryTransformer<String, String, String> concat = new Maps.EntryTransformer<String, String, String>(){

            public String transformEntry(String key, String value) {
                return key + value;
            }
        };
        SortedMap transformed = Maps.transformEntries(map, (Maps.EntryTransformer)concat);
        MapsTest.assertEquals((Object)ImmutableSortedMap.of((Comparable)((Object)"a"), (Object)"a4", (Comparable)((Object)"b"), (Object)"b9"), (Object)transformed);
    }

    @GwtIncompatible(value="NavigableMap")
    public void testNavigableMapTransformEntries() {
        ImmutableSortedMap map = ImmutableSortedMap.of((Comparable)((Object)"a"), (Object)"4", (Comparable)((Object)"b"), (Object)"9");
        Maps.EntryTransformer<String, String, String> concat = new Maps.EntryTransformer<String, String, String>(){

            public String transformEntry(String key, String value) {
                return key + value;
            }
        };
        NavigableMap transformed = Maps.transformEntries((NavigableMap)map, (Maps.EntryTransformer)concat);
        MapsTest.assertEquals((Object)ImmutableSortedMap.of((Comparable)((Object)"a"), (Object)"a4", (Comparable)((Object)"b"), (Object)"b9"), (Object)transformed);
    }

    @GwtIncompatible(value="NavigableMap")
    public void testUnmodifiableNavigableMap() {
        TreeMap mod = Maps.newTreeMap();
        mod.put(1, "one");
        mod.put(2, "two");
        mod.put(3, "three");
        NavigableMap unmod = Maps.unmodifiableNavigableMap((NavigableMap)mod);
        mod.put(4, "four");
        MapsTest.assertEquals((String)"four", (String)((String)unmod.get(4)));
        MapsTest.assertEquals((String)"four", (String)((String)unmod.descendingMap().get(4)));
        this.ensureNotDirectlyModifiable(unmod);
        this.ensureNotDirectlyModifiable(unmod.descendingMap());
        this.ensureNotDirectlyModifiable(unmod.headMap(2, true));
        this.ensureNotDirectlyModifiable(unmod.subMap(1, true, 3, true));
        this.ensureNotDirectlyModifiable(unmod.tailMap(2, true));
        Collection values = unmod.values();
        try {
            values.add("4");
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            values.remove("four");
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            values.removeAll(Collections.singleton("four"));
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            values.retainAll(Collections.singleton("four"));
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            Iterator iterator = values.iterator();
            iterator.next();
            iterator.remove();
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        Set entries = unmod.entrySet();
        try {
            Iterator iterator = entries.iterator();
            iterator.next();
            iterator.remove();
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        Map.Entry<Object, String> entry = entries.iterator().next();
        try {
            entry.setValue("four");
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        entry = unmod.lowerEntry(1);
        MapsTest.assertNull(entry);
        entry = unmod.floorEntry(2);
        try {
            entry.setValue("four");
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        entry = unmod.ceilingEntry(2);
        try {
            entry.setValue("four");
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        entry = unmod.lowerEntry(2);
        try {
            entry.setValue("four");
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        entry = unmod.higherEntry(2);
        try {
            entry.setValue("four");
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        entry = unmod.firstEntry();
        try {
            entry.setValue("four");
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        entry = unmod.lastEntry();
        try {
            entry.setValue("four");
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        Map.Entry entry2 = (Map.Entry)entries.toArray()[0];
        try {
            entry2.setValue("four");
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
    }

    @GwtIncompatible(value="NavigableMap")
    void ensureNotDirectlyModifiable(NavigableMap<Integer, String> unmod) {
        try {
            unmod.put(4, "four");
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            unmod.putAll(Collections.singletonMap(4, "four"));
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            unmod.remove("four");
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            unmod.pollFirstEntry();
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            unmod.pollLastEntry();
            MapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static class FilteredBiMapTest
    extends FilteredMapTest {
        BiMap<String, Integer> createUnfiltered() {
            return HashBiMap.create();
        }

        public void testFilterKeysIdentifiesBiMap() {
            BiMap<String, Integer> map = this.createUnfiltered();
            FilteredBiMapTest.assertTrue((boolean)(Maps.filterKeys(map, (Predicate)NOT_LENGTH_3) instanceof BiMap));
        }

        public void testFilterValuesIdentifiesBiMap() {
            BiMap<String, Integer> map = this.createUnfiltered();
            FilteredBiMapTest.assertTrue((boolean)(Maps.filterValues(map, (Predicate)EVEN) instanceof BiMap));
        }

        public void testFilterEntriesIdentifiesBiMap() {
            BiMap<String, Integer> map = this.createUnfiltered();
            FilteredBiMapTest.assertTrue((boolean)(Maps.filterEntries(map, (Predicate)CORRECT_LENGTH) instanceof BiMap));
        }
    }

    public static class FilteredSortedMapTest
    extends FilteredMapTest {
        SortedMap<String, Integer> createUnfiltered() {
            return Maps.newTreeMap();
        }

        public void testFilterKeysIdentifiesSortedMap() {
            Map map = this.createUnfiltered();
            FilteredSortedMapTest.assertTrue((boolean)(Maps.filterKeys((Map)map, (Predicate)NOT_LENGTH_3) instanceof SortedMap));
        }

        public void testFilterValuesIdentifiesSortedMap() {
            Map map = this.createUnfiltered();
            FilteredSortedMapTest.assertTrue((boolean)(Maps.filterValues((Map)map, (Predicate)EVEN) instanceof SortedMap));
        }

        public void testFilterEntriesIdentifiesSortedMap() {
            Map map = this.createUnfiltered();
            FilteredSortedMapTest.assertTrue((boolean)(Maps.filterEntries((Map)map, (Predicate)CORRECT_LENGTH) instanceof SortedMap));
        }

        public void testFirstAndLastKeyFilteredMap() {
            Map unfiltered = this.createUnfiltered();
            unfiltered.put("apple", 2);
            unfiltered.put("banana", 6);
            unfiltered.put("cat", 3);
            unfiltered.put("dog", 5);
            SortedMap filtered = Maps.filterEntries((SortedMap)unfiltered, (Predicate)CORRECT_LENGTH);
            FilteredSortedMapTest.assertEquals((String)"banana", (String)((String)filtered.firstKey()));
            FilteredSortedMapTest.assertEquals((String)"cat", (String)((String)filtered.lastKey()));
        }

        public void testHeadSubTailMap_FilteredMap() {
            Map unfiltered = this.createUnfiltered();
            unfiltered.put("apple", 2);
            unfiltered.put("banana", 6);
            unfiltered.put("cat", 4);
            unfiltered.put("dog", 3);
            SortedMap filtered = Maps.filterEntries((SortedMap)unfiltered, (Predicate)CORRECT_LENGTH);
            FilteredSortedMapTest.assertEquals((Object)ImmutableMap.of((Object)"banana", (Object)6), filtered.headMap("dog"));
            FilteredSortedMapTest.assertEquals((Object)ImmutableMap.of(), filtered.headMap("banana"));
            FilteredSortedMapTest.assertEquals((Object)ImmutableMap.of((Object)"banana", (Object)6, (Object)"dog", (Object)3), filtered.headMap("emu"));
            FilteredSortedMapTest.assertEquals((Object)ImmutableMap.of((Object)"banana", (Object)6), filtered.subMap("banana", "dog"));
            FilteredSortedMapTest.assertEquals((Object)ImmutableMap.of((Object)"dog", (Object)3), filtered.subMap("cat", "emu"));
            FilteredSortedMapTest.assertEquals((Object)ImmutableMap.of((Object)"dog", (Object)3), filtered.tailMap("cat"));
            FilteredSortedMapTest.assertEquals((Object)ImmutableMap.of((Object)"banana", (Object)6, (Object)"dog", (Object)3), filtered.tailMap("banana"));
        }
    }

    public static class FilteredMapTest
    extends TestCase {
        Map<String, Integer> createUnfiltered() {
            return Maps.newHashMap();
        }

        public void testFilteredKeysIllegalPut() {
            Map<String, Integer> unfiltered = this.createUnfiltered();
            Map filtered = Maps.filterKeys(unfiltered, (Predicate)NOT_LENGTH_3);
            filtered.put("a", 1);
            filtered.put("b", 2);
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2), (Object)filtered);
            try {
                filtered.put("yyy", 3);
                FilteredMapTest.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void testFilteredKeysIllegalPutAll() {
            Map<String, Integer> unfiltered = this.createUnfiltered();
            Map filtered = Maps.filterKeys(unfiltered, (Predicate)NOT_LENGTH_3);
            filtered.put("a", 1);
            filtered.put("b", 2);
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2), (Object)filtered);
            try {
                filtered.putAll(ImmutableMap.of((Object)"c", (Object)3, (Object)"zzz", (Object)4, (Object)"b", (Object)5));
                FilteredMapTest.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2), (Object)filtered);
        }

        public void testFilteredKeysFilteredReflectsBackingChanges() {
            Map<String, Integer> unfiltered = this.createUnfiltered();
            Map filtered = Maps.filterKeys(unfiltered, (Predicate)NOT_LENGTH_3);
            unfiltered.put("two", 2);
            unfiltered.put("three", 3);
            unfiltered.put("four", 4);
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"two", (Object)2, (Object)"three", (Object)3, (Object)"four", (Object)4), unfiltered);
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"three", (Object)3, (Object)"four", (Object)4), (Object)filtered);
            unfiltered.remove("three");
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"two", (Object)2, (Object)"four", (Object)4), unfiltered);
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"four", (Object)4), (Object)filtered);
            unfiltered.clear();
            FilteredMapTest.assertEquals((Object)ImmutableMap.of(), unfiltered);
            FilteredMapTest.assertEquals((Object)ImmutableMap.of(), (Object)filtered);
        }

        public void testFilteredValuesIllegalPut() {
            Map<String, Integer> unfiltered = this.createUnfiltered();
            Map filtered = Maps.filterValues(unfiltered, (Predicate)EVEN);
            filtered.put("a", 2);
            unfiltered.put("b", 4);
            unfiltered.put("c", 5);
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)2, (Object)"b", (Object)4), (Object)filtered);
            try {
                filtered.put("yyy", 3);
                FilteredMapTest.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)2, (Object)"b", (Object)4), (Object)filtered);
        }

        public void testFilteredValuesIllegalPutAll() {
            Map<String, Integer> unfiltered = this.createUnfiltered();
            Map filtered = Maps.filterValues(unfiltered, (Predicate)EVEN);
            filtered.put("a", 2);
            unfiltered.put("b", 4);
            unfiltered.put("c", 5);
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)2, (Object)"b", (Object)4), (Object)filtered);
            try {
                filtered.putAll(ImmutableMap.of((Object)"c", (Object)4, (Object)"zzz", (Object)5, (Object)"b", (Object)6));
                FilteredMapTest.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)2, (Object)"b", (Object)4), (Object)filtered);
        }

        public void testFilteredValuesIllegalSetValue() {
            Map<String, Integer> unfiltered = this.createUnfiltered();
            Map filtered = Maps.filterValues(unfiltered, (Predicate)EVEN);
            filtered.put("a", 2);
            filtered.put("b", 4);
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)2, (Object)"b", (Object)4), (Object)filtered);
            Map.Entry entry = filtered.entrySet().iterator().next();
            try {
                entry.setValue(5);
                FilteredMapTest.fail();
            }
            catch (IllegalArgumentException expected) {
                // empty catch block
            }
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)2, (Object)"b", (Object)4), (Object)filtered);
        }

        public void testFilteredValuesClear() {
            Map<String, Integer> unfiltered = this.createUnfiltered();
            unfiltered.put("one", 1);
            unfiltered.put("two", 2);
            unfiltered.put("three", 3);
            unfiltered.put("four", 4);
            Map filtered = Maps.filterValues(unfiltered, (Predicate)EVEN);
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3, (Object)"four", (Object)4), unfiltered);
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"two", (Object)2, (Object)"four", (Object)4), (Object)filtered);
            filtered.clear();
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"one", (Object)1, (Object)"three", (Object)3), unfiltered);
            FilteredMapTest.assertTrue((boolean)filtered.isEmpty());
        }

        public void testFilteredEntriesIllegalPut() {
            Map<String, Integer> unfiltered = this.createUnfiltered();
            unfiltered.put("cat", 3);
            unfiltered.put("dog", 2);
            unfiltered.put("horse", 5);
            Map filtered = Maps.filterEntries(unfiltered, (Predicate)CORRECT_LENGTH);
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"cat", (Object)3, (Object)"horse", (Object)5), (Object)filtered);
            filtered.put("chicken", 7);
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"cat", (Object)3, (Object)"horse", (Object)5, (Object)"chicken", (Object)7), (Object)filtered);
            try {
                filtered.put("cow", 7);
                FilteredMapTest.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"cat", (Object)3, (Object)"horse", (Object)5, (Object)"chicken", (Object)7), (Object)filtered);
        }

        public void testFilteredEntriesIllegalPutAll() {
            Map<String, Integer> unfiltered = this.createUnfiltered();
            unfiltered.put("cat", 3);
            unfiltered.put("dog", 2);
            unfiltered.put("horse", 5);
            Map filtered = Maps.filterEntries(unfiltered, (Predicate)CORRECT_LENGTH);
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"cat", (Object)3, (Object)"horse", (Object)5), (Object)filtered);
            filtered.put("chicken", 7);
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"cat", (Object)3, (Object)"horse", (Object)5, (Object)"chicken", (Object)7), (Object)filtered);
            try {
                filtered.putAll(ImmutableMap.of((Object)"sheep", (Object)5, (Object)"cow", (Object)7));
                FilteredMapTest.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"cat", (Object)3, (Object)"horse", (Object)5, (Object)"chicken", (Object)7), (Object)filtered);
        }

        public void testFilteredEntriesObjectPredicate() {
            Map<String, Integer> unfiltered = this.createUnfiltered();
            unfiltered.put("cat", 3);
            unfiltered.put("dog", 2);
            unfiltered.put("horse", 5);
            Predicate predicate = Predicates.alwaysFalse();
            Map filtered = Maps.filterEntries(unfiltered, (Predicate)predicate);
            FilteredMapTest.assertTrue((boolean)filtered.isEmpty());
        }

        public void testFilteredEntriesWildCardEntryPredicate() {
            Map<String, Integer> unfiltered = this.createUnfiltered();
            unfiltered.put("cat", 3);
            unfiltered.put("dog", 2);
            unfiltered.put("horse", 5);
            Predicate predicate = new Predicate<Map.Entry<?, ?>>(){

                public boolean apply(Map.Entry<?, ?> input) {
                    return "cat".equals(input.getKey()) || Integer.valueOf(2) == input.getValue();
                }
            };
            Map filtered = Maps.filterEntries(unfiltered, (Predicate)predicate);
            FilteredMapTest.assertEquals((Object)ImmutableMap.of((Object)"cat", (Object)3, (Object)"dog", (Object)2), (Object)filtered);
        }
    }

    private static class NonNavigableSortedSet
    extends ForwardingSortedSet<String> {
        private final SortedSet<String> delegate = Sets.newTreeSet();

        private NonNavigableSortedSet() {
        }

        protected SortedSet<String> delegate() {
            return this.delegate;
        }
    }

    public static enum SomeEnum {
        SOME_INSTANCE;

    }
}

