/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.AbstractIteratorTester;
import com.google.common.collect.testing.IteratorFeature;
import com.google.common.collect.testing.IteratorTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import junit.framework.TestCase;

public class MinMaxPriorityQueueTest
extends TestCase {
    private Ordering<Integer> SOME_COMPARATOR = Ordering.natural().reverse();
    private static final List<Integer> NUMBERS = ImmutableList.of((Object)4, (Object)8, (Object)15, (Object)16, (Object)23, (Object)42);

    public void testCreation_simple() {
        MinMaxPriorityQueue queue = MinMaxPriorityQueue.create();
        MinMaxPriorityQueueTest.assertEquals((int)11, (int)queue.capacity());
        MinMaxPriorityQueueTest.checkUnbounded((MinMaxPriorityQueue<Integer>)queue);
        MinMaxPriorityQueueTest.checkNatural((MinMaxPriorityQueue<Integer>)queue);
    }

    public void testCreation_comparator() {
        MinMaxPriorityQueue queue = MinMaxPriorityQueue.orderedBy(this.SOME_COMPARATOR).create();
        MinMaxPriorityQueueTest.assertEquals((int)11, (int)queue.capacity());
        MinMaxPriorityQueueTest.checkUnbounded((MinMaxPriorityQueue<Integer>)queue);
        MinMaxPriorityQueueTest.assertSame(this.SOME_COMPARATOR, (Object)queue.comparator());
    }

    public void testCreation_expectedSize() {
        MinMaxPriorityQueue queue = MinMaxPriorityQueue.expectedSize((int)8).create();
        MinMaxPriorityQueueTest.assertEquals((int)8, (int)queue.capacity());
        MinMaxPriorityQueueTest.checkUnbounded((MinMaxPriorityQueue<Integer>)queue);
        MinMaxPriorityQueueTest.checkNatural((MinMaxPriorityQueue<Integer>)queue);
    }

    public void testCreation_expectedSize_comparator() {
        MinMaxPriorityQueue queue = MinMaxPriorityQueue.orderedBy(this.SOME_COMPARATOR).expectedSize(8).create();
        MinMaxPriorityQueueTest.assertEquals((int)8, (int)queue.capacity());
        MinMaxPriorityQueueTest.checkUnbounded((MinMaxPriorityQueue<Integer>)queue);
        MinMaxPriorityQueueTest.assertSame(this.SOME_COMPARATOR, (Object)queue.comparator());
    }

    public void testCreation_maximumSize() {
        MinMaxPriorityQueue queue = MinMaxPriorityQueue.maximumSize((int)42).create();
        MinMaxPriorityQueueTest.assertEquals((int)11, (int)queue.capacity());
        MinMaxPriorityQueueTest.assertEquals((int)42, (int)queue.maximumSize);
        MinMaxPriorityQueueTest.checkNatural((MinMaxPriorityQueue<Integer>)queue);
    }

    public void testCreation_comparator_maximumSize() {
        MinMaxPriorityQueue queue = MinMaxPriorityQueue.orderedBy(this.SOME_COMPARATOR).maximumSize(42).create();
        MinMaxPriorityQueueTest.assertEquals((int)11, (int)queue.capacity());
        MinMaxPriorityQueueTest.assertEquals((int)42, (int)queue.maximumSize);
        MinMaxPriorityQueueTest.assertSame(this.SOME_COMPARATOR, (Object)queue.comparator());
    }

    public void testCreation_expectedSize_maximumSize() {
        MinMaxPriorityQueue queue = MinMaxPriorityQueue.expectedSize((int)8).maximumSize(42).create();
        MinMaxPriorityQueueTest.assertEquals((int)8, (int)queue.capacity());
        MinMaxPriorityQueueTest.assertEquals((int)42, (int)queue.maximumSize);
        MinMaxPriorityQueueTest.checkNatural((MinMaxPriorityQueue<Integer>)queue);
    }

    public void testCreation_withContents() {
        MinMaxPriorityQueue queue = MinMaxPriorityQueue.create(NUMBERS);
        MinMaxPriorityQueueTest.assertEquals((int)6, (int)queue.size());
        MinMaxPriorityQueueTest.assertEquals((int)11, (int)queue.capacity());
        MinMaxPriorityQueueTest.checkUnbounded((MinMaxPriorityQueue<Integer>)queue);
        MinMaxPriorityQueueTest.checkNatural((MinMaxPriorityQueue<Integer>)queue);
    }

    public void testCreation_comparator_withContents() {
        MinMaxPriorityQueue queue = MinMaxPriorityQueue.orderedBy(this.SOME_COMPARATOR).create(NUMBERS);
        MinMaxPriorityQueueTest.assertEquals((int)6, (int)queue.size());
        MinMaxPriorityQueueTest.assertEquals((int)11, (int)queue.capacity());
        MinMaxPriorityQueueTest.checkUnbounded((MinMaxPriorityQueue<Integer>)queue);
        MinMaxPriorityQueueTest.assertSame(this.SOME_COMPARATOR, (Object)queue.comparator());
    }

    public void testCreation_expectedSize_withContents() {
        MinMaxPriorityQueue queue = MinMaxPriorityQueue.expectedSize((int)8).create(NUMBERS);
        MinMaxPriorityQueueTest.assertEquals((int)6, (int)queue.size());
        MinMaxPriorityQueueTest.assertEquals((int)8, (int)queue.capacity());
        MinMaxPriorityQueueTest.checkUnbounded((MinMaxPriorityQueue<Integer>)queue);
        MinMaxPriorityQueueTest.checkNatural((MinMaxPriorityQueue<Integer>)queue);
    }

    public void testCreation_maximumSize_withContents() {
        MinMaxPriorityQueue queue = MinMaxPriorityQueue.maximumSize((int)42).create(NUMBERS);
        MinMaxPriorityQueueTest.assertEquals((int)6, (int)queue.size());
        MinMaxPriorityQueueTest.assertEquals((int)11, (int)queue.capacity());
        MinMaxPriorityQueueTest.assertEquals((int)42, (int)queue.maximumSize);
        MinMaxPriorityQueueTest.checkNatural((MinMaxPriorityQueue<Integer>)queue);
    }

    public void testCreation_allOptions() {
        MinMaxPriorityQueue queue = MinMaxPriorityQueue.orderedBy(this.SOME_COMPARATOR).expectedSize(8).maximumSize(42).create(NUMBERS);
        MinMaxPriorityQueueTest.assertEquals((int)6, (int)queue.size());
        MinMaxPriorityQueueTest.assertEquals((int)8, (int)queue.capacity());
        MinMaxPriorityQueueTest.assertEquals((int)42, (int)queue.maximumSize);
        MinMaxPriorityQueueTest.assertSame(this.SOME_COMPARATOR, (Object)queue.comparator());
    }

    private static void checkNatural(MinMaxPriorityQueue<Integer> queue) {
        MinMaxPriorityQueueTest.assertSame((Object)Ordering.natural(), (Object)queue.comparator());
    }

    private static void checkUnbounded(MinMaxPriorityQueue<Integer> queue) {
        MinMaxPriorityQueueTest.assertEquals((int)Integer.MAX_VALUE, (int)queue.maximumSize);
    }

    public void testHeapIntact() {
        Random random = new Random(0L);
        int heapSize = 999;
        int numberOfModifications = 500;
        MinMaxPriorityQueue mmHeap = MinMaxPriorityQueue.expectedSize((int)heapSize).create();
        TreeMap replica = Maps.newTreeMap();
        MinMaxPriorityQueueTest.assertTrue((String)"Empty heap should be OK", (boolean)mmHeap.isIntact());
        for (int i = 0; i < heapSize; ++i) {
            int randomInt = random.nextInt();
            mmHeap.offer((Object)randomInt);
            MinMaxPriorityQueueTest.insertIntoReplica(replica, randomInt);
        }
        MinMaxPriorityQueueTest.assertTrue((String)("MinMaxHeap not intact after " + heapSize + " insertions"), (boolean)mmHeap.isIntact());
        MinMaxPriorityQueueTest.assertEquals((int)heapSize, (int)mmHeap.size());
        int currentHeapSize = heapSize;
        for (int i = 0; i < numberOfModifications; ++i) {
            if (random.nextBoolean()) {
                int randomInt = random.nextInt();
                mmHeap.offer((Object)randomInt);
                MinMaxPriorityQueueTest.insertIntoReplica(replica, randomInt);
                ++currentHeapSize;
                continue;
            }
            if (random.nextBoolean()) {
                MinMaxPriorityQueueTest.removeMinFromReplica(replica, (Integer)mmHeap.poll());
            } else {
                MinMaxPriorityQueueTest.removeMaxFromReplica(replica, (Integer)mmHeap.pollLast());
            }
            for (Integer v : replica.keySet()) {
                MinMaxPriorityQueueTest.assertTrue((String)("MinMax queue has lost " + v), (boolean)mmHeap.contains((Object)v));
            }
            MinMaxPriorityQueueTest.assertTrue((boolean)mmHeap.isIntact());
            MinMaxPriorityQueueTest.assertEquals((int)(--currentHeapSize), (int)mmHeap.size());
        }
        MinMaxPriorityQueueTest.assertEquals((int)currentHeapSize, (int)mmHeap.size());
        MinMaxPriorityQueueTest.assertTrue((String)("Heap not intact after " + numberOfModifications + " random mixture of operations"), (boolean)mmHeap.isIntact());
    }

    public void testSmall() {
        MinMaxPriorityQueue mmHeap = MinMaxPriorityQueue.create();
        mmHeap.add((Object)1);
        mmHeap.add((Object)4);
        mmHeap.add((Object)2);
        mmHeap.add((Object)3);
        MinMaxPriorityQueueTest.assertEquals((int)4, (int)((Integer)mmHeap.pollLast()));
        MinMaxPriorityQueueTest.assertEquals((int)3, (int)((Integer)mmHeap.peekLast()));
        MinMaxPriorityQueueTest.assertEquals((int)3, (int)((Integer)mmHeap.pollLast()));
        MinMaxPriorityQueueTest.assertEquals((int)1, (int)((Integer)mmHeap.peek()));
        MinMaxPriorityQueueTest.assertEquals((int)2, (int)((Integer)mmHeap.peekLast()));
        MinMaxPriorityQueueTest.assertEquals((int)2, (int)((Integer)mmHeap.pollLast()));
        MinMaxPriorityQueueTest.assertEquals((int)1, (int)((Integer)mmHeap.peek()));
        MinMaxPriorityQueueTest.assertEquals((int)1, (int)((Integer)mmHeap.peekLast()));
        MinMaxPriorityQueueTest.assertEquals((int)1, (int)((Integer)mmHeap.pollLast()));
        MinMaxPriorityQueueTest.assertNull((Object)mmHeap.peek());
        MinMaxPriorityQueueTest.assertNull((Object)mmHeap.peekLast());
        MinMaxPriorityQueueTest.assertNull((Object)mmHeap.pollLast());
    }

    public void testSmallMinHeap() {
        MinMaxPriorityQueue mmHeap = MinMaxPriorityQueue.create();
        mmHeap.add((Object)1);
        mmHeap.add((Object)3);
        mmHeap.add((Object)2);
        MinMaxPriorityQueueTest.assertEquals((int)1, (int)((Integer)mmHeap.peek()));
        MinMaxPriorityQueueTest.assertEquals((int)1, (int)((Integer)mmHeap.poll()));
        MinMaxPriorityQueueTest.assertEquals((int)3, (int)((Integer)mmHeap.peekLast()));
        MinMaxPriorityQueueTest.assertEquals((int)2, (int)((Integer)mmHeap.peek()));
        MinMaxPriorityQueueTest.assertEquals((int)2, (int)((Integer)mmHeap.poll()));
        MinMaxPriorityQueueTest.assertEquals((int)3, (int)((Integer)mmHeap.peekLast()));
        MinMaxPriorityQueueTest.assertEquals((int)3, (int)((Integer)mmHeap.peek()));
        MinMaxPriorityQueueTest.assertEquals((int)3, (int)((Integer)mmHeap.poll()));
        MinMaxPriorityQueueTest.assertNull((Object)mmHeap.peekLast());
        MinMaxPriorityQueueTest.assertNull((Object)mmHeap.peek());
        MinMaxPriorityQueueTest.assertNull((Object)mmHeap.poll());
    }

    public void testRemove() {
        MinMaxPriorityQueue mmHeap = MinMaxPriorityQueue.create();
        mmHeap.addAll((Collection)Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 47, 1, 5, 3, 0}));
        MinMaxPriorityQueueTest.assertTrue((String)"Heap is not intact initally", (boolean)mmHeap.isIntact());
        MinMaxPriorityQueueTest.assertEquals((int)9, (int)mmHeap.size());
        mmHeap.remove((Object)5);
        MinMaxPriorityQueueTest.assertEquals((int)8, (int)mmHeap.size());
        MinMaxPriorityQueueTest.assertTrue((String)"Heap is not intact after remove()", (boolean)mmHeap.isIntact());
        MinMaxPriorityQueueTest.assertEquals((int)47, (int)((Integer)mmHeap.pollLast()));
        MinMaxPriorityQueueTest.assertEquals((int)4, (int)((Integer)mmHeap.pollLast()));
        mmHeap.removeAll((Collection)Lists.newArrayList((Object[])new Integer[]{2, 3}));
        MinMaxPriorityQueueTest.assertEquals((int)3, (int)mmHeap.size());
        MinMaxPriorityQueueTest.assertTrue((String)"Heap is not intact after removeAll()", (boolean)mmHeap.isIntact());
    }

    public void testContains() {
        MinMaxPriorityQueue mmHeap = MinMaxPriorityQueue.create();
        mmHeap.addAll((Collection)Lists.newArrayList((Object[])new Integer[]{1, 1, 2}));
        MinMaxPriorityQueueTest.assertEquals((int)3, (int)mmHeap.size());
        MinMaxPriorityQueueTest.assertFalse((String)"Heap does not contain null", (boolean)mmHeap.contains(null));
        MinMaxPriorityQueueTest.assertFalse((String)"Heap does not contain 3", (boolean)mmHeap.contains((Object)3));
        MinMaxPriorityQueueTest.assertFalse((String)"Heap does not contain 3", (boolean)mmHeap.remove((Object)3));
        MinMaxPriorityQueueTest.assertEquals((int)3, (int)mmHeap.size());
        MinMaxPriorityQueueTest.assertTrue((String)"Heap is not intact after remove()", (boolean)mmHeap.isIntact());
        MinMaxPriorityQueueTest.assertTrue((String)"Heap contains two 1's", (boolean)mmHeap.contains((Object)1));
        MinMaxPriorityQueueTest.assertTrue((String)"Heap contains two 1's", (boolean)mmHeap.remove((Object)1));
        MinMaxPriorityQueueTest.assertTrue((String)"Heap contains 1", (boolean)mmHeap.contains((Object)1));
        MinMaxPriorityQueueTest.assertTrue((String)"Heap contains 1", (boolean)mmHeap.remove((Object)1));
        MinMaxPriorityQueueTest.assertFalse((String)"Heap does not contain 1", (boolean)mmHeap.contains((Object)1));
        MinMaxPriorityQueueTest.assertTrue((String)"Heap contains 2", (boolean)mmHeap.remove((Object)2));
        MinMaxPriorityQueueTest.assertEquals((int)0, (int)mmHeap.size());
        MinMaxPriorityQueueTest.assertFalse((String)"Heap does not contain anything", (boolean)mmHeap.contains((Object)1));
        MinMaxPriorityQueueTest.assertFalse((String)"Heap does not contain anything", (boolean)mmHeap.remove((Object)2));
    }

    public void testIteratorPastEndException() {
        MinMaxPriorityQueue mmHeap = MinMaxPriorityQueue.create();
        mmHeap.addAll((Collection)Lists.newArrayList((Object[])new Integer[]{1, 2}));
        Iterator it = mmHeap.iterator();
        MinMaxPriorityQueueTest.assertTrue((String)"Iterator has reached end prematurely", (boolean)it.hasNext());
        it.next();
        it.next();
        try {
            it.next();
            MinMaxPriorityQueueTest.fail((String)"No exception thrown when iterating past end of heap");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testIteratorConcurrentModification() {
        MinMaxPriorityQueue mmHeap = MinMaxPriorityQueue.create();
        mmHeap.addAll((Collection)Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4}));
        Iterator it = mmHeap.iterator();
        MinMaxPriorityQueueTest.assertTrue((String)"Iterator has reached end prematurely", (boolean)it.hasNext());
        it.next();
        it.next();
        mmHeap.remove((Object)4);
        try {
            it.next();
            MinMaxPriorityQueueTest.fail((String)"No exception thrown when iterating a modified heap");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    public void testIteratorRegressionChildlessUncle() {
        ArrayList initial = Lists.newArrayList((Object[])new Integer[]{1, 15, 13, 8, 9, 10, 11, 14});
        MinMaxPriorityQueue q = MinMaxPriorityQueue.create((Iterable)initial);
        MinMaxPriorityQueueTest.assertTrue((String)("State " + Arrays.toString(q.toArray())), (boolean)q.isIntact());
        q.remove((Object)9);
        q.remove((Object)11);
        q.remove((Object)10);
        ArrayList result = Lists.newArrayListWithCapacity((int)initial.size());
        Iterator iter = q.iterator();
        while (iter.hasNext()) {
            Integer value = (Integer)iter.next();
            result.add(value);
            if (value != 8) continue;
            iter.remove();
        }
        MinMaxPriorityQueueTest.assertTrue((boolean)q.isIntact());
        Truth.assertThat((List)result).containsExactly(new Object[]{1, 15, 13, 8, 14});
    }

    public void testInvalidatingRemove() {
        MinMaxPriorityQueue mmHeap = MinMaxPriorityQueue.create();
        mmHeap.addAll((Collection)Lists.newArrayList((Object[])new Integer[]{1, 20, 1000, 2, 3, 30, 40, 10, 11, 12, 13, 300, 400, 500, 600}));
        MinMaxPriorityQueueTest.assertEquals((int)15, (int)mmHeap.size());
        MinMaxPriorityQueueTest.assertTrue((String)"Heap is not intact initially", (boolean)mmHeap.isIntact());
        mmHeap.remove((Object)12);
        MinMaxPriorityQueueTest.assertEquals((int)14, (int)mmHeap.size());
        MinMaxPriorityQueueTest.assertTrue((String)"Heap is not intact after remove()", (boolean)mmHeap.isIntact());
    }

    public void testInvalidatingRemove2() {
        MinMaxPriorityQueue mmHeap = MinMaxPriorityQueue.create();
        ArrayList values = Lists.newArrayList((Object[])new Integer[]{1, 20, 1000, 2, 3, 30, 40, 10, 11, 12, 13, 300, 400, 500, 600, 4, 5, 6, 7, 8, 9, 4, 5, 200, 250});
        mmHeap.addAll((Collection)values);
        MinMaxPriorityQueueTest.assertEquals((int)25, (int)mmHeap.size());
        MinMaxPriorityQueueTest.assertTrue((String)"Heap is not intact initially", (boolean)mmHeap.isIntact());
        mmHeap.remove((Object)2);
        MinMaxPriorityQueueTest.assertEquals((int)24, (int)mmHeap.size());
        MinMaxPriorityQueueTest.assertTrue((String)"Heap is not intact after remove()", (boolean)mmHeap.isIntact());
        values.removeAll(Lists.newArrayList((Object[])new Integer[]{2}));
        MinMaxPriorityQueueTest.assertEquals((int)values.size(), (int)mmHeap.size());
        MinMaxPriorityQueueTest.assertTrue((boolean)values.containsAll((Collection<?>)mmHeap));
        MinMaxPriorityQueueTest.assertTrue((boolean)mmHeap.containsAll((Collection)values));
    }

    public void testIteratorInvalidatingIteratorRemove() {
        MinMaxPriorityQueue mmHeap = MinMaxPriorityQueue.create();
        mmHeap.addAll((Collection)Lists.newArrayList((Object[])new Integer[]{1, 20, 100, 2, 3, 30, 40}));
        MinMaxPriorityQueueTest.assertEquals((int)7, (int)mmHeap.size());
        MinMaxPriorityQueueTest.assertTrue((String)"Heap is not intact initially", (boolean)mmHeap.isIntact());
        Iterator it = mmHeap.iterator();
        MinMaxPriorityQueueTest.assertEquals((Object)1, it.next());
        MinMaxPriorityQueueTest.assertEquals((Object)20, it.next());
        MinMaxPriorityQueueTest.assertEquals((Object)100, it.next());
        MinMaxPriorityQueueTest.assertEquals((Object)2, it.next());
        it.remove();
        MinMaxPriorityQueueTest.assertFalse((boolean)mmHeap.contains((Object)2));
        MinMaxPriorityQueueTest.assertTrue((boolean)it.hasNext());
        MinMaxPriorityQueueTest.assertEquals((Object)3, it.next());
        MinMaxPriorityQueueTest.assertTrue((boolean)it.hasNext());
        MinMaxPriorityQueueTest.assertEquals((Object)30, it.next());
        MinMaxPriorityQueueTest.assertTrue((boolean)it.hasNext());
        MinMaxPriorityQueueTest.assertEquals((Object)40, it.next());
        MinMaxPriorityQueueTest.assertFalse((boolean)it.hasNext());
        MinMaxPriorityQueueTest.assertEquals((int)6, (int)mmHeap.size());
        MinMaxPriorityQueueTest.assertTrue((String)"Heap is not intact after remove()", (boolean)mmHeap.isIntact());
        MinMaxPriorityQueueTest.assertFalse((boolean)mmHeap.contains((Object)2));
        Integer lastItem = 0;
        Iterator i$ = mmHeap.iterator();
        while (i$.hasNext()) {
            Integer tmp;
            lastItem = tmp = (Integer)i$.next();
        }
        MinMaxPriorityQueueTest.assertEquals((Object)30, (Object)lastItem);
    }

    public void testIteratorInvalidatingIteratorRemove2() {
        MinMaxPriorityQueue mmHeap = MinMaxPriorityQueue.create();
        mmHeap.addAll((Collection)Lists.newArrayList((Object[])new Integer[]{1, 20, 1000, 2, 3, 30, 40, 10, 11, 12, 13, 200, 300, 500, 400}));
        MinMaxPriorityQueueTest.assertTrue((String)"Heap is not intact initially", (boolean)mmHeap.isIntact());
        Iterator it = mmHeap.iterator();
        MinMaxPriorityQueueTest.assertEquals((Object)1, it.next());
        MinMaxPriorityQueueTest.assertEquals((Object)20, it.next());
        MinMaxPriorityQueueTest.assertEquals((Object)1000, it.next());
        MinMaxPriorityQueueTest.assertEquals((Object)2, it.next());
        it.remove();
        MinMaxPriorityQueueTest.assertTrue((String)"Heap is not intact after remove", (boolean)mmHeap.isIntact());
        MinMaxPriorityQueueTest.assertEquals((Object)10, it.next());
        MinMaxPriorityQueueTest.assertEquals((Object)3, it.next());
        it.remove();
        MinMaxPriorityQueueTest.assertTrue((String)"Heap is not intact after remove", (boolean)mmHeap.isIntact());
        MinMaxPriorityQueueTest.assertEquals((Object)12, it.next());
        MinMaxPriorityQueueTest.assertEquals((Object)30, it.next());
        MinMaxPriorityQueueTest.assertEquals((Object)40, it.next());
        MinMaxPriorityQueueTest.assertEquals((Object)11, it.next());
        MinMaxPriorityQueueTest.assertEquals((Object)13, it.next());
        MinMaxPriorityQueueTest.assertEquals((Object)200, it.next());
        MinMaxPriorityQueueTest.assertEquals((Object)300, it.next());
        MinMaxPriorityQueueTest.assertEquals((Object)400, it.next());
        MinMaxPriorityQueueTest.assertEquals((Object)500, it.next());
    }

    public void testRemoveFromStringHeap() {
        MinMaxPriorityQueue mmHeap = MinMaxPriorityQueue.expectedSize((int)5).create();
        Collections.addAll(mmHeap, new String[]{"foo", "bar", "foobar", "barfoo", "larry", "sergey", "eric"});
        MinMaxPriorityQueueTest.assertTrue((String)"Heap is not intact initially", (boolean)mmHeap.isIntact());
        MinMaxPriorityQueueTest.assertEquals((String)"bar", (String)((String)mmHeap.peek()));
        MinMaxPriorityQueueTest.assertEquals((String)"sergey", (String)((String)mmHeap.peekLast()));
        MinMaxPriorityQueueTest.assertEquals((int)7, (int)mmHeap.size());
        MinMaxPriorityQueueTest.assertTrue((String)"Could not remove larry", (boolean)mmHeap.remove((Object)"larry"));
        MinMaxPriorityQueueTest.assertEquals((int)6, (int)mmHeap.size());
        MinMaxPriorityQueueTest.assertFalse((String)"heap contains larry which has been removed", (boolean)mmHeap.contains((Object)"larry"));
        MinMaxPriorityQueueTest.assertTrue((String)"heap does not contain sergey", (boolean)mmHeap.contains((Object)"sergey"));
        MinMaxPriorityQueueTest.assertTrue((String)"Could not remove larry", (boolean)mmHeap.removeAll((Collection)Lists.newArrayList((Object[])new String[]{"sergey", "eric"})));
        MinMaxPriorityQueueTest.assertFalse((String)"Could remove nikesh which is not in the heap", (boolean)mmHeap.remove((Object)"nikesh"));
        MinMaxPriorityQueueTest.assertEquals((int)4, (int)mmHeap.size());
    }

    public void testCreateWithOrdering() {
        MinMaxPriorityQueue mmHeap = MinMaxPriorityQueue.orderedBy((Comparator)Ordering.natural().reverse()).create();
        Collections.addAll(mmHeap, new String[]{"foo", "bar", "foobar", "barfoo", "larry", "sergey", "eric"});
        MinMaxPriorityQueueTest.assertTrue((String)"Heap is not intact initially", (boolean)mmHeap.isIntact());
        MinMaxPriorityQueueTest.assertEquals((String)"sergey", (String)((String)mmHeap.peek()));
        MinMaxPriorityQueueTest.assertEquals((String)"bar", (String)((String)mmHeap.peekLast()));
    }

    public void testCreateWithCapacityAndOrdering() {
        MinMaxPriorityQueue mmHeap = MinMaxPriorityQueue.orderedBy((Comparator)Ordering.natural().reverse()).expectedSize(5).create();
        Collections.addAll(mmHeap, new Integer[]{1, 7, 2, 56, 2, 5, 23, 68, 0, 3});
        MinMaxPriorityQueueTest.assertTrue((String)"Heap is not intact initially", (boolean)mmHeap.isIntact());
        MinMaxPriorityQueueTest.assertEquals((int)68, (int)((Integer)mmHeap.peek()));
        MinMaxPriorityQueueTest.assertEquals((int)0, (int)((Integer)mmHeap.peekLast()));
    }

    private <T extends Comparable<T>> void runIterator(final List<T> values, int steps) throws Exception {
        IteratorTester tester = new IteratorTester<T>(steps, IteratorFeature.MODIFIABLE, Lists.newLinkedList(values), AbstractIteratorTester.KnownOrder.UNKNOWN_ORDER){
            private MinMaxPriorityQueue<T> mmHeap;

            protected Iterator<T> newTargetIterator() {
                this.mmHeap = MinMaxPriorityQueue.create((Iterable)values);
                return this.mmHeap.iterator();
            }

            protected void verify(List<T> elements) {
                Assert.assertEquals((Object)Sets.newHashSet(elements), (Object)Sets.newHashSet((Iterator)this.mmHeap.iterator()));
                Assert.assertTrue((String)("Invalid MinMaxHeap: " + this.mmHeap), (boolean)this.mmHeap.isIntact());
            }
        };
        tester.test();
    }

    public void testIteratorTester() throws Exception {
        Random random = new Random(0L);
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < 3; ++i) {
            list.add(random.nextInt());
        }
        this.runIterator(list, 6);
    }

    public void testIteratorTesterLarger() throws Exception {
        this.runIterator(Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}), 5);
    }

    public void testRemoveAt() {
        int i;
        long seed = new Random().nextLong();
        Random random = new Random(seed);
        int heapSize = 999;
        int numberOfModifications = 500;
        MinMaxPriorityQueue mmHeap = MinMaxPriorityQueue.expectedSize((int)heapSize).create();
        for (i = 0; i < heapSize; ++i) {
            mmHeap.add((Object)random.nextInt());
        }
        for (i = 0; i < numberOfModifications; ++i) {
            mmHeap.removeAt(random.nextInt(mmHeap.size()));
            MinMaxPriorityQueueTest.assertTrue((String)("Modification " + i + " of seed " + seed), (boolean)mmHeap.isIntact());
            mmHeap.add((Object)random.nextInt());
            MinMaxPriorityQueueTest.assertTrue((String)("Modification " + i + " of seed " + seed), (boolean)mmHeap.isIntact());
        }
    }

    public void testRemoveAt_exhaustive() {
        int size = 8;
        ArrayList<Integer> expected = this.createOrderedList(size);
        for (Collection perm : Collections2.permutations(expected)) {
            for (int i = 0; i < perm.size(); ++i) {
                MinMaxPriorityQueue q = MinMaxPriorityQueue.create((Iterable)perm);
                q.removeAt(i);
                MinMaxPriorityQueueTest.assertTrue((String)("Remove at " + i + " perm " + perm), (boolean)q.isIntact());
            }
        }
    }

    public void testCorrectOrdering_regression() {
        MinMaxPriorityQueue q = MinMaxPriorityQueue.create((Iterable)ImmutableList.of((Object)3, (Object)5, (Object)1, (Object)4, (Object)7));
        ImmutableList expected = ImmutableList.of((Object)1, (Object)3, (Object)4, (Object)5, (Object)7);
        ArrayList<Object> actual = new ArrayList<Object>(5);
        for (int i = 0; i < expected.size(); ++i) {
            actual.add(q.pollFirst());
        }
        MinMaxPriorityQueueTest.assertEquals((Object)expected, actual);
    }

    public void testCorrectOrdering_smallHeapsPollFirst() {
        for (int size = 2; size < 16; ++size) {
            for (int attempts = 0; attempts < size * (size - 1); ++attempts) {
                ArrayList<Integer> elements = this.createOrderedList(size);
                ImmutableList expected = ImmutableList.copyOf(elements);
                MinMaxPriorityQueue q = MinMaxPriorityQueue.create();
                long seed = this.insertRandomly(elements, (MinMaxPriorityQueue<Integer>)q);
                while (!q.isEmpty()) {
                    elements.add((Integer)q.pollFirst());
                }
                MinMaxPriorityQueueTest.assertEquals((String)("Using seed " + seed), (Object)expected, elements);
            }
        }
    }

    public void testCorrectOrdering_smallHeapsPollLast() {
        for (int size = 2; size < 16; ++size) {
            for (int attempts = 0; attempts < size * (size - 1); ++attempts) {
                ArrayList<Integer> elements = this.createOrderedList(size);
                ImmutableList expected = ImmutableList.copyOf(elements);
                MinMaxPriorityQueue q = MinMaxPriorityQueue.create();
                long seed = this.insertRandomly(elements, (MinMaxPriorityQueue<Integer>)q);
                while (!q.isEmpty()) {
                    elements.add(0, (Integer)q.pollLast());
                }
                MinMaxPriorityQueueTest.assertEquals((String)("Using seed " + seed), (Object)expected, elements);
            }
        }
    }

    public void testCorrectOrdering_mediumHeapsPollFirst() {
        for (int attempts = 0; attempts < 5000; ++attempts) {
            int size = new Random().nextInt(256) + 16;
            ArrayList<Integer> elements = this.createOrderedList(size);
            ImmutableList expected = ImmutableList.copyOf(elements);
            MinMaxPriorityQueue q = MinMaxPriorityQueue.create();
            long seed = this.insertRandomly(elements, (MinMaxPriorityQueue<Integer>)q);
            while (!q.isEmpty()) {
                elements.add((Integer)q.pollFirst());
            }
            MinMaxPriorityQueueTest.assertEquals((String)("Using seed " + seed), (Object)expected, elements);
        }
    }

    public void testCorrectOrdering_73ElementBug() {
        int size = 73;
        long seed = 7522346378524621981L;
        ArrayList<Integer> elements = this.createOrderedList(size);
        ImmutableList expected = ImmutableList.copyOf(elements);
        MinMaxPriorityQueue q = MinMaxPriorityQueue.create();
        this.insertRandomly(elements, (MinMaxPriorityQueue<Integer>)q, new Random(seed));
        MinMaxPriorityQueueTest.assertTrue((boolean)q.isIntact());
        while (!q.isEmpty()) {
            elements.add((Integer)q.pollFirst());
            MinMaxPriorityQueueTest.assertTrue((String)("State " + Arrays.toString(q.toArray())), (boolean)q.isIntact());
        }
        MinMaxPriorityQueueTest.assertEquals((String)("Using seed " + seed), (Object)expected, elements);
    }

    public void testCorrectOrdering_mediumHeapsPollLast() {
        for (int attempts = 0; attempts < 5000; ++attempts) {
            int size = new Random().nextInt(256) + 16;
            ArrayList<Integer> elements = this.createOrderedList(size);
            ImmutableList expected = ImmutableList.copyOf(elements);
            MinMaxPriorityQueue q = MinMaxPriorityQueue.create();
            long seed = this.insertRandomly(elements, (MinMaxPriorityQueue<Integer>)q);
            while (!q.isEmpty()) {
                elements.add(0, (Integer)q.pollLast());
            }
            MinMaxPriorityQueueTest.assertEquals((String)("Using seed " + seed), (Object)expected, elements);
        }
    }

    public void testCorrectOrdering_randomAccess() {
        Integer element;
        int i;
        long seed = new Random().nextLong();
        Random random = new Random(seed);
        PriorityQueue<Integer> control = new PriorityQueue<Integer>();
        MinMaxPriorityQueue q = MinMaxPriorityQueue.create();
        for (i = 0; i < 73; ++i) {
            element = random.nextInt();
            control.add(element);
            MinMaxPriorityQueueTest.assertTrue((boolean)q.add((Object)element));
        }
        MinMaxPriorityQueueTest.assertTrue((String)("State " + Arrays.toString(q.toArray())), (boolean)q.isIntact());
        for (i = 0; i < 500000; ++i) {
            if (random.nextBoolean()) {
                element = random.nextInt();
                control.add(element);
                q.add((Object)element);
                continue;
            }
            MinMaxPriorityQueueTest.assertEquals((String)("Using seed " + seed), control.poll(), (Object)q.pollFirst());
        }
        while (!control.isEmpty()) {
            MinMaxPriorityQueueTest.assertEquals((String)("Using seed " + seed), control.poll(), (Object)q.pollFirst());
        }
        MinMaxPriorityQueueTest.assertTrue((boolean)q.isEmpty());
    }

    public void testExhaustive_pollAndPush() {
        int size = 8;
        ArrayList<Integer> expected = this.createOrderedList(size);
        for (Collection perm : Collections2.permutations(expected)) {
            MinMaxPriorityQueue q = MinMaxPriorityQueue.create((Iterable)perm);
            ArrayList elements = Lists.newArrayListWithCapacity((int)size);
            while (!q.isEmpty()) {
                Integer next = (Integer)q.pollFirst();
                for (int i = 0; i <= size; ++i) {
                    MinMaxPriorityQueueTest.assertTrue((boolean)q.add((Object)i));
                    MinMaxPriorityQueueTest.assertTrue((boolean)q.add((Object)next));
                    MinMaxPriorityQueueTest.assertTrue((boolean)q.remove((Object)i));
                    MinMaxPriorityQueueTest.assertEquals((Object)next, (Object)q.poll());
                }
                elements.add(next);
            }
            MinMaxPriorityQueueTest.assertEquals((String)("Started with " + perm), expected, (Object)elements);
        }
    }

    public void testRegression_dataCorruption() {
        int size = 8;
        ArrayList<Integer> expected = this.createOrderedList(size);
        MinMaxPriorityQueue q = MinMaxPriorityQueue.create(expected);
        ArrayList contents = Lists.newArrayList(expected);
        ArrayList elements = Lists.newArrayListWithCapacity((int)size);
        while (!q.isEmpty()) {
            Truth.assertThat((Collection)q).containsExactlyElementsIn((Iterable)contents);
            Integer next = (Integer)q.pollFirst();
            contents.remove(next);
            Truth.assertThat((Collection)q).containsExactlyElementsIn((Iterable)contents);
            for (int i = 0; i <= size; ++i) {
                q.add((Object)i);
                contents.add(i);
                Truth.assertThat((Collection)q).containsExactlyElementsIn((Iterable)contents);
                q.add((Object)next);
                contents.add(next);
                Truth.assertThat((Collection)q).containsExactlyElementsIn((Iterable)contents);
                q.remove((Object)i);
                MinMaxPriorityQueueTest.assertTrue((boolean)contents.remove((Object)i));
                Truth.assertThat((Collection)q).containsExactlyElementsIn((Iterable)contents);
                MinMaxPriorityQueueTest.assertEquals((Object)next, (Object)q.poll());
                contents.remove(next);
                Truth.assertThat((Collection)q).containsExactlyElementsIn((Iterable)contents);
            }
            elements.add(next);
        }
        MinMaxPriorityQueueTest.assertEquals(expected, (Object)elements);
    }

    private long insertRandomly(ArrayList<Integer> elements, MinMaxPriorityQueue<Integer> q) {
        long seed = new Random().nextLong();
        Random random = new Random(seed);
        this.insertRandomly(elements, q, random);
        return seed;
    }

    private void insertRandomly(ArrayList<Integer> elements, MinMaxPriorityQueue<Integer> q, Random random) {
        while (!elements.isEmpty()) {
            int selectedIndex = random.nextInt(elements.size());
            q.offer((Object)elements.remove(selectedIndex));
        }
    }

    private ArrayList<Integer> createOrderedList(int size) {
        ArrayList<Integer> elements = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            elements.add(i);
        }
        return elements;
    }

    public void testIsEvenLevel() {
        MinMaxPriorityQueueTest.assertTrue((boolean)MinMaxPriorityQueue.isEvenLevel((int)0));
        MinMaxPriorityQueueTest.assertFalse((boolean)MinMaxPriorityQueue.isEvenLevel((int)1));
        MinMaxPriorityQueueTest.assertFalse((boolean)MinMaxPriorityQueue.isEvenLevel((int)2));
        MinMaxPriorityQueueTest.assertTrue((boolean)MinMaxPriorityQueue.isEvenLevel((int)3));
        MinMaxPriorityQueueTest.assertFalse((boolean)MinMaxPriorityQueue.isEvenLevel((int)1022));
        MinMaxPriorityQueueTest.assertTrue((boolean)MinMaxPriorityQueue.isEvenLevel((int)1023));
        int i = 0x20000000;
        MinMaxPriorityQueueTest.assertTrue((boolean)MinMaxPriorityQueue.isEvenLevel((int)(i - 2)));
        MinMaxPriorityQueueTest.assertFalse((boolean)MinMaxPriorityQueue.isEvenLevel((int)(i - 1)));
        MinMaxPriorityQueueTest.assertFalse((boolean)MinMaxPriorityQueue.isEvenLevel((int)i));
        i = 0x40000000;
        MinMaxPriorityQueueTest.assertFalse((boolean)MinMaxPriorityQueue.isEvenLevel((int)(i - 2)));
        MinMaxPriorityQueueTest.assertTrue((boolean)MinMaxPriorityQueue.isEvenLevel((int)(i - 1)));
        MinMaxPriorityQueueTest.assertTrue((boolean)MinMaxPriorityQueue.isEvenLevel((int)i));
        MinMaxPriorityQueueTest.assertTrue((boolean)MinMaxPriorityQueue.isEvenLevel((int)0x7FFFFFFE));
        MinMaxPriorityQueueTest.assertTrue((boolean)MinMaxPriorityQueue.isEvenLevel((int)0x7FFFFFFE));
        try {
            MinMaxPriorityQueue.isEvenLevel((int)Integer.MAX_VALUE);
            MinMaxPriorityQueueTest.fail((String)"Should overflow");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            MinMaxPriorityQueue.isEvenLevel((int)Integer.MAX_VALUE);
            MinMaxPriorityQueueTest.fail((String)"Should overflow");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            MinMaxPriorityQueue.isEvenLevel((int)Integer.MIN_VALUE);
            MinMaxPriorityQueueTest.fail((String)"Should be negative");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            MinMaxPriorityQueue.isEvenLevel((int)Integer.MIN_VALUE);
            MinMaxPriorityQueueTest.fail((String)"Should be negative");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testNullPointers() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicConstructors(MinMaxPriorityQueue.class);
        tester.testAllPublicStaticMethods(MinMaxPriorityQueue.class);
        tester.testAllPublicInstanceMethods((Object)MinMaxPriorityQueue.create());
    }

    private static void insertIntoReplica(Map<Integer, AtomicInteger> replica, int newValue) {
        if (replica.containsKey(newValue)) {
            replica.get(newValue).incrementAndGet();
        } else {
            replica.put(newValue, new AtomicInteger(1));
        }
    }

    private static void removeMinFromReplica(SortedMap<Integer, AtomicInteger> replica, int minValue) {
        Integer replicatedMinValue = replica.firstKey();
        MinMaxPriorityQueueTest.assertEquals((Object)replicatedMinValue, (Object)minValue);
        MinMaxPriorityQueueTest.removeFromReplica(replica, replicatedMinValue);
    }

    private static void removeMaxFromReplica(SortedMap<Integer, AtomicInteger> replica, int maxValue) {
        Integer replicatedMaxValue = replica.lastKey();
        MinMaxPriorityQueueTest.assertTrue((String)"maxValue is incorrect", (replicatedMaxValue == maxValue ? 1 : 0) != 0);
        MinMaxPriorityQueueTest.removeFromReplica(replica, replicatedMaxValue);
    }

    private static void removeFromReplica(Map<Integer, AtomicInteger> replica, int value) {
        AtomicInteger numOccur = replica.get(value);
        if (numOccur.decrementAndGet() == 0) {
            replica.remove(value);
        }
    }
}

