/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Supplier;
import com.google.common.collect.AbstractTableTest;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

@GwtCompatible
public class NewCustomTableTest
extends AbstractTableTest {
    @Override
    protected Table<String, Integer, Character> create(Object ... data) {
        Supplier<TreeMap<Integer, Character>> factory = new Supplier<TreeMap<Integer, Character>>(){

            public TreeMap<Integer, Character> get() {
                return Maps.newTreeMap();
            }
        };
        LinkedHashMap backingMap = Maps.newLinkedHashMap();
        Table table = Tables.newCustomTable((Map)backingMap, (Supplier)factory);
        this.populate((Table<String, Integer, Character>)table, data);
        return table;
    }

    public void testRowKeySetOrdering() {
        this.table = this.create("foo", 3, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 2, Character.valueOf('c'));
        Truth.assertThat((Collection)this.table.rowKeySet()).containsExactly(new Object[]{"foo", "bar"}).inOrder();
    }

    public void testRowOrdering() {
        this.table = this.create("foo", 3, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 2, Character.valueOf('c'));
        Truth.assertThat(this.table.row((Object)"foo").keySet()).containsExactly(new Object[]{2, 3}).inOrder();
    }
}

