/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public class SortedCopyBenchmark {
    @Param(value={"1", "10", "1000", "1000000"})
    int size;
    @Param
    boolean mutable;
    @Param
    InputOrder inputOrder;
    private ImmutableList<Integer> input;
    private static final Ordering<Integer> ORDERING = Ordering.natural();

    @BeforeExperiment
    void setUp() {
        Preconditions.checkArgument((this.size > 0 ? 1 : 0) != 0, (Object)"empty collection not supported");
        LinkedHashSet<Integer> set = new LinkedHashSet<Integer>(this.size);
        Random random = new Random();
        while (set.size() < this.size) {
            set.add(random.nextInt());
        }
        ArrayList<Integer> list = new ArrayList<Integer>(set);
        this.inputOrder.arrange(list);
        this.input = ImmutableList.copyOf(list);
    }

    @Benchmark
    int collections(int reps) {
        int dummy = 0;
        if (this.mutable) {
            for (int i = 0; i < reps; ++i) {
                ArrayList<Integer> copy = new ArrayList<Integer>((Collection<Integer>)this.input);
                Collections.sort(copy);
                dummy += ((Integer)copy.get(0)).intValue();
            }
        } else {
            for (int i = 0; i < reps; ++i) {
                ArrayList<Integer> copy = new ArrayList<Integer>((Collection<Integer>)this.input);
                Collections.sort(copy);
                dummy += ((Integer)ImmutableList.copyOf(copy).get(0)).intValue();
            }
        }
        return dummy;
    }

    @Benchmark
    int ordering(int reps) {
        int dummy = 0;
        if (this.mutable) {
            for (int i = 0; i < reps; ++i) {
                dummy += ((Integer)ORDERING.sortedCopy(this.input).get(0)).intValue();
            }
        } else {
            for (int i = 0; i < reps; ++i) {
                dummy += ((Integer)ORDERING.immutableSortedCopy(this.input).get(0)).intValue();
            }
        }
        return dummy;
    }

    @Benchmark
    int sortedSet(int reps) {
        int dummy = 0;
        if (this.mutable) {
            for (int i = 0; i < reps; ++i) {
                dummy += new TreeSet<Integer>((Collection<Integer>)this.input).first().intValue();
            }
        } else {
            for (int i = 0; i < reps; ++i) {
                dummy += ((Integer)ImmutableSortedSet.copyOf(this.input).first()).intValue();
            }
        }
        return dummy;
    }

    static enum InputOrder {
        SORTED{

            @Override
            void arrange(List<Integer> list) {
                Collections.sort(list);
            }
        }
        ,
        ALMOST_SORTED{

            @Override
            void arrange(List<Integer> list) {
                Collections.sort(list);
                if (list.size() > 1) {
                    int i = (list.size() - 1) / 2;
                    Collections.swap(list, i, i + 1);
                }
            }
        }
        ,
        RANDOM{

            @Override
            void arrange(List<Integer> list) {
            }
        };


        abstract void arrange(List<Integer> var1);
    }
}

