/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Synchronized;
import com.google.common.testing.SerializableTester;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;

public class SynchronizedMapTest
extends TestCase {
    public final Object mutex = new Integer(1);

    protected <K, V> Map<K, V> create() {
        TestMap inner = new TestMap(new HashMap(), this.mutex);
        Map outer = Synchronized.map(inner, (Object)this.mutex);
        return outer;
    }

    public void testSize() {
        this.create().size();
    }

    public void testIsEmpty() {
        this.create().isEmpty();
    }

    public void testRemove() {
        this.create().remove(null);
    }

    public void testClear() {
        this.create().clear();
    }

    public void testContainsKey() {
        this.create().containsKey(null);
    }

    public void testContainsValue() {
        this.create().containsValue(null);
    }

    public void testGet() {
        this.create().get(null);
    }

    public void testPut() {
        this.create().put(null, null);
    }

    public void testPutAll() {
        this.create().putAll(new HashMap());
    }

    public void testKeySet() {
        Map map = this.create();
        Set keySet = map.keySet();
        SynchronizedMapTest.assertTrue((boolean)(keySet instanceof Synchronized.SynchronizedSet));
        SynchronizedMapTest.assertSame((Object)this.mutex, (Object)((Synchronized.SynchronizedSet)keySet).mutex);
    }

    public void testValues() {
        Map map = this.create();
        Collection values = map.values();
        SynchronizedMapTest.assertTrue((boolean)(values instanceof Synchronized.SynchronizedCollection));
        SynchronizedMapTest.assertSame((Object)this.mutex, (Object)((Synchronized.SynchronizedCollection)values).mutex);
    }

    public void testEntrySet() {
        Map map = this.create();
        Set entrySet = map.entrySet();
        SynchronizedMapTest.assertTrue((boolean)(entrySet instanceof Synchronized.SynchronizedSet));
        SynchronizedMapTest.assertSame((Object)this.mutex, (Object)((Synchronized.SynchronizedSet)entrySet).mutex);
    }

    public void testEquals() {
        this.create().equals(new HashMap());
    }

    public void testHashCode() {
        this.create().hashCode();
    }

    public void testToString() {
        this.create().toString();
    }

    public void testSerialization() {
        SerializableTester.reserializeAndAssert(this.create());
    }

    static class TestMap<K, V>
    extends ForwardingMap<K, V>
    implements Serializable {
        public final Object mutex;
        private Map<K, V> delegate;
        private static final long serialVersionUID = 0L;

        public TestMap(Map<K, V> delegate, Object mutex) {
            Preconditions.checkNotNull((Object)mutex);
            this.delegate = delegate;
            this.mutex = mutex;
        }

        protected Map<K, V> delegate() {
            return this.delegate;
        }

        public int size() {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.size();
        }

        public boolean isEmpty() {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.isEmpty();
        }

        public V remove(Object object) {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return (V)super.remove(object);
        }

        public void clear() {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            super.clear();
        }

        public boolean containsKey(Object key) {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.containsKey(key);
        }

        public boolean containsValue(Object value) {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.containsValue(value);
        }

        public V get(Object key) {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return (V)super.get(key);
        }

        public V put(K key, V value) {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return (V)super.put(key, value);
        }

        public void putAll(Map<? extends K, ? extends V> map) {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            super.putAll(map);
        }

        public Set<K> keySet() {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.keySet();
        }

        public Collection<V> values() {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.values();
        }

        public Set<Map.Entry<K, V>> entrySet() {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.entrySet();
        }

        public boolean equals(Object obj) {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.equals(obj);
        }

        public int hashCode() {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.hashCode();
        }

        public String toString() {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.toString();
        }
    }
}

