/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class TablesTest
extends TestCase {
    @GwtIncompatible(value="SerializableTester")
    public void testImmutableEntrySerialization() {
        Table.Cell entry = Tables.immutableCell((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
        SerializableTester.reserializeAndAssert((Object)entry);
    }

    public void testImmutableEntryToString() {
        Table.Cell entry = Tables.immutableCell((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
        TablesTest.assertEquals((String)"(foo,1)=a", (String)entry.toString());
        Table.Cell nullEntry = Tables.immutableCell(null, null, null);
        TablesTest.assertEquals((String)"(null,null)=null", (String)nullEntry.toString());
    }

    public void testEntryEquals() {
        Table.Cell entry = Tables.immutableCell((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
        new EqualsTester().addEqualityGroup(new Object[]{entry, Tables.immutableCell((Object)"foo", (Object)1, (Object)Character.valueOf('a'))}).addEqualityGroup(new Object[]{Tables.immutableCell((Object)"bar", (Object)1, (Object)Character.valueOf('a'))}).addEqualityGroup(new Object[]{Tables.immutableCell((Object)"foo", (Object)2, (Object)Character.valueOf('a'))}).addEqualityGroup(new Object[]{Tables.immutableCell((Object)"foo", (Object)1, (Object)Character.valueOf('b'))}).addEqualityGroup(new Object[]{Tables.immutableCell(null, null, null)}).testEquals();
    }

    public void testEntryEqualsNull() {
        Table.Cell entry = Tables.immutableCell(null, null, null);
        new EqualsTester().addEqualityGroup(new Object[]{entry, Tables.immutableCell(null, null, null)}).addEqualityGroup(new Object[]{Tables.immutableCell((Object)"bar", null, null)}).addEqualityGroup(new Object[]{Tables.immutableCell(null, (Object)2, null)}).addEqualityGroup(new Object[]{Tables.immutableCell(null, null, (Object)Character.valueOf('b'))}).addEqualityGroup(new Object[]{Tables.immutableCell((Object)"foo", (Object)1, (Object)Character.valueOf('a'))}).testEquals();
    }
}

