/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class TreeMultimapExplicitTest
extends TestCase {
    private static final Comparator<Integer> DECREASING_INT_COMPARATOR = Ordering.natural().reverse().nullsFirst();

    private SetMultimap<String, Integer> create() {
        return TreeMultimap.create((Comparator)StringLength.COMPARATOR, DECREASING_INT_COMPARATOR);
    }

    private TreeMultimap<String, Integer> createPopulate() {
        TreeMultimap multimap = TreeMultimap.create((Comparator)StringLength.COMPARATOR, DECREASING_INT_COMPARATOR);
        multimap.put((Object)"google", (Object)2);
        multimap.put((Object)"google", (Object)6);
        multimap.put(null, (Object)3);
        multimap.put(null, (Object)1);
        multimap.put(null, (Object)7);
        multimap.put((Object)"tree", (Object)0);
        multimap.put((Object)"tree", null);
        return multimap;
    }

    public void testMultimapCreateFromTreeMultimap() {
        TreeMultimap tree = TreeMultimap.create((Comparator)StringLength.COMPARATOR, DECREASING_INT_COMPARATOR);
        tree.put((Object)"google", (Object)2);
        tree.put((Object)"google", (Object)6);
        tree.put((Object)"tree", (Object)0);
        tree.put((Object)"tree", (Object)3);
        Truth.assertThat((Collection)tree.keySet()).containsExactly(new Object[]{"tree", "google"}).inOrder();
        Truth.assertThat((Collection)tree.get((Object)"google")).containsExactly(new Object[]{6, 2}).inOrder();
        TreeMultimap copy = TreeMultimap.create((Multimap)tree);
        TreeMultimapExplicitTest.assertEquals((Object)tree, (Object)copy);
        Truth.assertThat((Collection)copy.keySet()).containsExactly(new Object[]{"google", "tree"}).inOrder();
        Truth.assertThat((Collection)copy.get((Object)"google")).containsExactly(new Object[]{2, 6}).inOrder();
        TreeMultimapExplicitTest.assertEquals((Object)Ordering.natural(), (Object)copy.keyComparator());
        TreeMultimapExplicitTest.assertEquals((Object)Ordering.natural(), (Object)copy.valueComparator());
        TreeMultimapExplicitTest.assertEquals((Object)Ordering.natural(), copy.get((Object)"google").comparator());
    }

    public void testToString() {
        SetMultimap<String, Integer> multimap = this.create();
        multimap.put((Object)"foo", (Object)3);
        multimap.put((Object)"bar", (Object)1);
        multimap.putAll((Object)"foo", Arrays.asList(-1, 2, 4));
        multimap.putAll((Object)"bar", Arrays.asList(2, 3));
        multimap.put((Object)"foo", (Object)1);
        TreeMultimapExplicitTest.assertEquals((String)"{bar=[3, 2, 1], foo=[4, 3, 2, 1, -1]}", (String)multimap.toString());
    }

    public void testGetComparator() {
        TreeMultimap<String, Integer> multimap = this.createPopulate();
        TreeMultimapExplicitTest.assertEquals((Object)StringLength.COMPARATOR, (Object)multimap.keyComparator());
        TreeMultimapExplicitTest.assertEquals(DECREASING_INT_COMPARATOR, (Object)multimap.valueComparator());
    }

    public void testOrderedGet() {
        TreeMultimap<String, Integer> multimap = this.createPopulate();
        Truth.assertThat((Collection)multimap.get(null)).containsExactly(new Object[]{7, 3, 1}).inOrder();
        Truth.assertThat((Collection)multimap.get((Object)"google")).containsExactly(new Object[]{6, 2}).inOrder();
        Truth.assertThat((Collection)multimap.get((Object)"tree")).containsExactly(new Object[]{null, 0}).inOrder();
    }

    public void testOrderedKeySet() {
        TreeMultimap<String, Integer> multimap = this.createPopulate();
        Truth.assertThat((Collection)multimap.keySet()).containsExactly(new Object[]{null, "tree", "google"}).inOrder();
    }

    public void testOrderedAsMapEntries() {
        TreeMultimap<String, Integer> multimap = this.createPopulate();
        Iterator iterator = multimap.asMap().entrySet().iterator();
        Map.Entry entry = iterator.next();
        TreeMultimapExplicitTest.assertEquals(null, (String)((String)entry.getKey()));
        Truth.assertThat((Collection)((Collection)entry.getValue())).containsExactly(new Object[]{7, 3, 1});
        entry = iterator.next();
        TreeMultimapExplicitTest.assertEquals((String)"tree", (String)((String)entry.getKey()));
        Truth.assertThat((Collection)((Collection)entry.getValue())).containsExactly(new Object[]{null, 0});
        entry = iterator.next();
        TreeMultimapExplicitTest.assertEquals((String)"google", (String)((String)entry.getKey()));
        Truth.assertThat((Collection)((Collection)entry.getValue())).containsExactly(new Object[]{6, 2});
    }

    public void testOrderedEntries() {
        TreeMultimap<String, Integer> multimap = this.createPopulate();
        Truth.assertThat((Collection)multimap.entries()).containsExactly(new Object[]{Maps.immutableEntry((Object)null, (Object)7), Maps.immutableEntry((Object)null, (Object)3), Maps.immutableEntry((Object)null, (Object)1), Maps.immutableEntry((Object)"tree", (Object)null), Maps.immutableEntry((Object)"tree", (Object)0), Maps.immutableEntry((Object)"google", (Object)6), Maps.immutableEntry((Object)"google", (Object)2)}).inOrder();
    }

    public void testOrderedValues() {
        TreeMultimap<String, Integer> multimap = this.createPopulate();
        Truth.assertThat((Collection)multimap.values()).containsExactly(new Object[]{7, 3, 1, null, 0, 6, 2}).inOrder();
    }

    public void testComparator() {
        TreeMultimap<String, Integer> multimap = this.createPopulate();
        TreeMultimapExplicitTest.assertEquals(DECREASING_INT_COMPARATOR, multimap.get((Object)"foo").comparator());
        TreeMultimapExplicitTest.assertEquals(DECREASING_INT_COMPARATOR, multimap.get((Object)"missing").comparator());
    }

    public void testMultimapComparators() {
        SetMultimap<String, Integer> multimap = this.create();
        multimap.put((Object)"foo", (Object)3);
        multimap.put((Object)"bar", (Object)1);
        multimap.putAll((Object)"foo", Arrays.asList(-1, 2, 4));
        multimap.putAll((Object)"bar", Arrays.asList(2, 3));
        multimap.put((Object)"foo", (Object)1);
        TreeMultimap copy = TreeMultimap.create((Comparator)StringLength.COMPARATOR, DECREASING_INT_COMPARATOR);
        copy.putAll(multimap);
        TreeMultimapExplicitTest.assertEquals(multimap, (Object)copy);
        TreeMultimapExplicitTest.assertEquals((Object)StringLength.COMPARATOR, (Object)copy.keyComparator());
        TreeMultimapExplicitTest.assertEquals(DECREASING_INT_COMPARATOR, (Object)copy.valueComparator());
    }

    public void testSortedKeySet() {
        TreeMultimap<String, Integer> multimap = this.createPopulate();
        NavigableSet keySet = multimap.keySet();
        TreeMultimapExplicitTest.assertEquals(null, (String)((String)keySet.first()));
        TreeMultimapExplicitTest.assertEquals((String)"google", (String)((String)keySet.last()));
        TreeMultimapExplicitTest.assertEquals((Object)StringLength.COMPARATOR, keySet.comparator());
        TreeMultimapExplicitTest.assertEquals((Object)Sets.newHashSet((Object[])new String[]{null, "tree"}), keySet.headSet("yahoo"));
        TreeMultimapExplicitTest.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"google"}), keySet.tailSet("yahoo"));
        TreeMultimapExplicitTest.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"tree"}), keySet.subSet("ask", "yahoo"));
    }

    @GwtIncompatible(value="SerializableTester")
    public void testExplicitComparatorSerialization() {
        TreeMultimap<String, Integer> multimap = this.createPopulate();
        TreeMultimap copy = (TreeMultimap)SerializableTester.reserializeAndAssert(multimap);
        Truth.assertThat((Collection)copy.values()).containsExactly(new Object[]{7, 3, 1, null, 0, 6, 2}).inOrder();
        Truth.assertThat((Collection)copy.keySet()).containsExactly(new Object[]{null, "tree", "google"}).inOrder();
        TreeMultimapExplicitTest.assertEquals((Object)multimap.keyComparator(), (Object)copy.keyComparator());
        TreeMultimapExplicitTest.assertEquals((Object)multimap.valueComparator(), (Object)copy.valueComparator());
    }

    private static enum StringLength implements Comparator<String>
    {
        COMPARATOR;


        @Override
        public int compare(String first, String second) {
            if (first == second) {
                return 0;
            }
            if (first == null) {
                return -1;
            }
            if (second == null) {
                return 1;
            }
            if (first.length() != second.length()) {
                return first.length() - second.length();
            }
            return first.compareTo(second);
        }
    }
}

