/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.BoundType;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.SuppressUnderAndroid;
import com.google.common.collect.TreeMultiset;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.NavigableSetTestSuiteBuilder;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestStringSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.google.MultisetFeature;
import com.google.common.collect.testing.google.MultisetTestSuiteBuilder;
import com.google.common.collect.testing.google.SortedMultisetTestSuiteBuilder;
import com.google.common.collect.testing.google.TestMultisetGenerator;
import com.google.common.collect.testing.google.TestStringMultisetGenerator;
import com.google.common.truth.Truth;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class TreeMultisetTest
extends TestCase {
    private static final Comparator<String> DEGENERATE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.length() - o2.length();
        }
    };

    @GwtIncompatible(value="suite")
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)SortedMultisetTestSuiteBuilder.using((TestMultisetGenerator)new TestStringMultisetGenerator(){

            protected Multiset<String> create(String[] elements) {
                return TreeMultiset.create(Arrays.asList(elements));
            }

            public List<String> order(List<String> insertionOrder) {
                return Ordering.natural().sortedCopy(insertionOrder);
            }
        }).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.GENERAL_PURPOSE, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES, MultisetFeature.ENTRIES_ARE_VIEWS})).named("TreeMultiset, Ordering.natural")).createTestSuite());
        suite.addTest((Test)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)SortedMultisetTestSuiteBuilder.using((TestMultisetGenerator)new TestStringMultisetGenerator(){

            protected Multiset<String> create(String[] elements) {
                TreeMultiset result = TreeMultiset.create((Comparator)Helpers.NullsBeforeB.INSTANCE);
                Collections.addAll(result, elements);
                return result;
            }

            public List<String> order(List<String> insertionOrder) {
                Collections.sort(insertionOrder, Helpers.NullsBeforeB.INSTANCE);
                return insertionOrder;
            }
        }).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.GENERAL_PURPOSE, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_VALUES, MultisetFeature.ENTRIES_ARE_VIEWS})).named("TreeMultiset, NullsBeforeB")).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)NavigableSetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return TreeMultiset.create(Arrays.asList(elements)).elementSet();
            }

            public List<String> order(List<String> insertionOrder) {
                return Lists.newArrayList((Iterable)Sets.newTreeSet(insertionOrder));
            }
        }).named("TreeMultiset[Ordering.natural].elementSet")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.REMOVE_OPERATIONS, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTestSuite(TreeMultisetTest.class);
        return suite;
    }

    public void testCreate() {
        TreeMultiset multiset = TreeMultiset.create();
        multiset.add((Object)"foo", 2);
        multiset.add((Object)"bar");
        TreeMultisetTest.assertEquals((int)3, (int)multiset.size());
        TreeMultisetTest.assertEquals((int)2, (int)multiset.count((Object)"foo"));
        TreeMultisetTest.assertEquals((Object)Ordering.natural(), (Object)multiset.comparator());
        TreeMultisetTest.assertEquals((String)"[bar, foo x 2]", (String)multiset.toString());
    }

    public void testCreateWithComparator() {
        TreeMultiset multiset = TreeMultiset.create(Collections.reverseOrder());
        multiset.add((Object)"foo", 2);
        multiset.add((Object)"bar");
        TreeMultisetTest.assertEquals((int)3, (int)multiset.size());
        TreeMultisetTest.assertEquals((int)2, (int)multiset.count((Object)"foo"));
        TreeMultisetTest.assertEquals((String)"[foo x 2, bar]", (String)multiset.toString());
    }

    public void testCreateFromIterable() {
        TreeMultiset multiset = TreeMultiset.create(Arrays.asList("foo", "bar", "foo"));
        TreeMultisetTest.assertEquals((int)3, (int)multiset.size());
        TreeMultisetTest.assertEquals((int)2, (int)multiset.count((Object)"foo"));
        TreeMultisetTest.assertEquals((String)"[bar, foo x 2]", (String)multiset.toString());
    }

    public void testToString() {
        TreeMultiset ms = TreeMultiset.create();
        ms.add((Object)"a", 3);
        ms.add((Object)"c", 1);
        ms.add((Object)"b", 2);
        TreeMultisetTest.assertEquals((String)"[a x 3, b x 2, c]", (String)ms.toString());
    }

    public void testElementSetSortedSetMethods() {
        TreeMultiset ms = TreeMultiset.create();
        ms.add((Object)"c", 1);
        ms.add((Object)"a", 3);
        ms.add((Object)"b", 2);
        NavigableSet elementSet = ms.elementSet();
        TreeMultisetTest.assertEquals((String)"a", (String)((String)elementSet.first()));
        TreeMultisetTest.assertEquals((String)"c", (String)((String)elementSet.last()));
        TreeMultisetTest.assertEquals((Object)Ordering.natural(), elementSet.comparator());
        Truth.assertThat(elementSet.headSet("b")).containsExactly(new Object[]{"a"});
        Truth.assertThat(elementSet.tailSet("b")).containsExactly(new Object[]{"b", "c"}).inOrder();
        Truth.assertThat(elementSet.subSet("a", "c")).containsExactly(new Object[]{"a", "b"}).inOrder();
    }

    public void testElementSetSubsetRemove() {
        TreeMultiset ms = TreeMultiset.create();
        ms.add((Object)"a", 1);
        ms.add((Object)"b", 3);
        ms.add((Object)"c", 2);
        ms.add((Object)"d", 1);
        ms.add((Object)"e", 3);
        ms.add((Object)"f", 2);
        NavigableSet elementSet = ms.elementSet();
        Truth.assertThat((Collection)elementSet).containsExactly(new Object[]{"a", "b", "c", "d", "e", "f"}).inOrder();
        SortedSet<String> subset = elementSet.subSet("b", "f");
        Truth.assertThat(subset).containsExactly(new Object[]{"b", "c", "d", "e"}).inOrder();
        TreeMultisetTest.assertTrue((boolean)subset.remove("c"));
        Truth.assertThat((Collection)elementSet).containsExactly(new Object[]{"a", "b", "d", "e", "f"}).inOrder();
        Truth.assertThat(subset).containsExactly(new Object[]{"b", "d", "e"}).inOrder();
        TreeMultisetTest.assertEquals((int)10, (int)ms.size());
        TreeMultisetTest.assertFalse((boolean)subset.remove("a"));
        Truth.assertThat((Collection)elementSet).containsExactly(new Object[]{"a", "b", "d", "e", "f"}).inOrder();
        Truth.assertThat(subset).containsExactly(new Object[]{"b", "d", "e"}).inOrder();
        TreeMultisetTest.assertEquals((int)10, (int)ms.size());
    }

    public void testElementSetSubsetRemoveAll() {
        TreeMultiset ms = TreeMultiset.create();
        ms.add((Object)"a", 1);
        ms.add((Object)"b", 3);
        ms.add((Object)"c", 2);
        ms.add((Object)"d", 1);
        ms.add((Object)"e", 3);
        ms.add((Object)"f", 2);
        NavigableSet elementSet = ms.elementSet();
        Truth.assertThat((Collection)elementSet).containsExactly(new Object[]{"a", "b", "c", "d", "e", "f"}).inOrder();
        SortedSet<String> subset = elementSet.subSet("b", "f");
        Truth.assertThat(subset).containsExactly(new Object[]{"b", "c", "d", "e"}).inOrder();
        TreeMultisetTest.assertTrue((boolean)subset.removeAll(Arrays.asList("a", "c")));
        Truth.assertThat((Collection)elementSet).containsExactly(new Object[]{"a", "b", "d", "e", "f"}).inOrder();
        Truth.assertThat(subset).containsExactly(new Object[]{"b", "d", "e"}).inOrder();
        TreeMultisetTest.assertEquals((int)10, (int)ms.size());
    }

    public void testElementSetSubsetRetainAll() {
        TreeMultiset ms = TreeMultiset.create();
        ms.add((Object)"a", 1);
        ms.add((Object)"b", 3);
        ms.add((Object)"c", 2);
        ms.add((Object)"d", 1);
        ms.add((Object)"e", 3);
        ms.add((Object)"f", 2);
        NavigableSet elementSet = ms.elementSet();
        Truth.assertThat((Collection)elementSet).containsExactly(new Object[]{"a", "b", "c", "d", "e", "f"}).inOrder();
        SortedSet<String> subset = elementSet.subSet("b", "f");
        Truth.assertThat(subset).containsExactly(new Object[]{"b", "c", "d", "e"}).inOrder();
        TreeMultisetTest.assertTrue((boolean)subset.retainAll(Arrays.asList("a", "c")));
        Truth.assertThat((Collection)elementSet).containsExactly(new Object[]{"a", "c", "f"}).inOrder();
        Truth.assertThat(subset).containsExactly(new Object[]{"c"});
        TreeMultisetTest.assertEquals((int)5, (int)ms.size());
    }

    public void testElementSetSubsetClear() {
        TreeMultiset ms = TreeMultiset.create();
        ms.add((Object)"a", 1);
        ms.add((Object)"b", 3);
        ms.add((Object)"c", 2);
        ms.add((Object)"d", 1);
        ms.add((Object)"e", 3);
        ms.add((Object)"f", 2);
        NavigableSet elementSet = ms.elementSet();
        Truth.assertThat((Collection)elementSet).containsExactly(new Object[]{"a", "b", "c", "d", "e", "f"}).inOrder();
        SortedSet<String> subset = elementSet.subSet("b", "f");
        Truth.assertThat(subset).containsExactly(new Object[]{"b", "c", "d", "e"}).inOrder();
        subset.clear();
        Truth.assertThat((Collection)elementSet).containsExactly(new Object[]{"a", "f"}).inOrder();
        Truth.assertThat(subset).isEmpty();
        TreeMultisetTest.assertEquals((int)3, (int)ms.size());
    }

    public void testCustomComparator() throws Exception {
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.compareTo(o1);
            }
        };
        TreeMultiset ms = TreeMultiset.create((Comparator)comparator);
        ms.add((Object)"b");
        ms.add((Object)"c");
        ms.add((Object)"a");
        ms.add((Object)"b");
        ms.add((Object)"d");
        Truth.assertThat((Multiset)ms).containsExactly(new Object[]{"d", "c", "b", "b", "a"}).inOrder();
        NavigableSet elementSet = ms.elementSet();
        TreeMultisetTest.assertEquals((String)"d", (String)((String)elementSet.first()));
        TreeMultisetTest.assertEquals((String)"a", (String)((String)elementSet.last()));
        TreeMultisetTest.assertEquals((Object)comparator, elementSet.comparator());
    }

    public void testNullAcceptingComparator() throws Exception {
        Ordering comparator = Ordering.natural().nullsFirst();
        TreeMultiset ms = TreeMultiset.create((Comparator)comparator);
        ms.add((Object)"b");
        ms.add(null);
        ms.add((Object)"a");
        ms.add((Object)"b");
        ms.add(null, 2);
        Truth.assertThat((Multiset)ms).containsExactly(new Object[]{null, null, null, "a", "b", "b"}).inOrder();
        TreeMultisetTest.assertEquals((int)3, (int)ms.count(null));
        NavigableSet elementSet = ms.elementSet();
        TreeMultisetTest.assertEquals(null, (String)((String)elementSet.first()));
        TreeMultisetTest.assertEquals((String)"b", (String)((String)elementSet.last()));
        TreeMultisetTest.assertEquals((Object)comparator, elementSet.comparator());
    }

    public void testDegenerateComparator() throws Exception {
        TreeMultiset ms = TreeMultiset.create(DEGENERATE_COMPARATOR);
        ms.add((Object)"foo");
        ms.add((Object)"a");
        ms.add((Object)"bar");
        ms.add((Object)"b");
        ms.add((Object)"c");
        TreeMultisetTest.assertEquals((int)2, (int)ms.count((Object)"bar"));
        TreeMultisetTest.assertEquals((int)3, (int)ms.count((Object)"b"));
        TreeMultiset ms2 = TreeMultiset.create(DEGENERATE_COMPARATOR);
        ms2.add((Object)"cat", 2);
        ms2.add((Object)"x", 3);
        TreeMultisetTest.assertEquals((Object)ms, (Object)ms2);
        TreeMultisetTest.assertEquals((Object)ms2, (Object)ms);
        NavigableSet elementSet = ms.elementSet();
        TreeMultisetTest.assertEquals((String)"a", (String)((String)elementSet.first()));
        TreeMultisetTest.assertEquals((String)"foo", (String)((String)elementSet.last()));
        TreeMultisetTest.assertEquals(DEGENERATE_COMPARATOR, elementSet.comparator());
    }

    public void testSubMultisetSize() {
        TreeMultiset ms = TreeMultiset.create();
        ms.add((Object)"a", Integer.MAX_VALUE);
        ms.add((Object)"b", Integer.MAX_VALUE);
        ms.add((Object)"c", 3);
        TreeMultisetTest.assertEquals((int)Integer.MAX_VALUE, (int)ms.count((Object)"a"));
        TreeMultisetTest.assertEquals((int)Integer.MAX_VALUE, (int)ms.count((Object)"b"));
        TreeMultisetTest.assertEquals((int)3, (int)ms.count((Object)"c"));
        TreeMultisetTest.assertEquals((int)Integer.MAX_VALUE, (int)ms.headMultiset((Object)"c", BoundType.CLOSED).size());
        TreeMultisetTest.assertEquals((int)Integer.MAX_VALUE, (int)ms.headMultiset((Object)"b", BoundType.CLOSED).size());
        TreeMultisetTest.assertEquals((int)Integer.MAX_VALUE, (int)ms.headMultiset((Object)"a", BoundType.CLOSED).size());
        TreeMultisetTest.assertEquals((int)3, (int)ms.tailMultiset((Object)"c", BoundType.CLOSED).size());
        TreeMultisetTest.assertEquals((int)Integer.MAX_VALUE, (int)ms.tailMultiset((Object)"b", BoundType.CLOSED).size());
        TreeMultisetTest.assertEquals((int)Integer.MAX_VALUE, (int)ms.tailMultiset((Object)"a", BoundType.CLOSED).size());
    }

    @GwtIncompatible(value="reflection")
    @SuppressUnderAndroid
    public void testElementSetBridgeMethods() {
        for (Method m : TreeMultiset.class.getMethods()) {
            if (!m.getName().equals("elementSet") || !m.getReturnType().equals(SortedSet.class)) continue;
            return;
        }
        TreeMultisetTest.fail((String)"No bridge method found");
    }
}

