/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.eventbus.Subscriber;
import com.google.common.testing.EqualsTester;
import com.google.common.truth.Truth;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.TestCase;

public class SubscriberTest
extends TestCase {
    private static final Object FIXTURE_ARGUMENT = new Object();
    private EventBus bus;
    private boolean methodCalled;
    private Object methodArgument;

    protected void setUp() throws Exception {
        this.bus = new EventBus();
        this.methodCalled = false;
        this.methodArgument = null;
    }

    public void testCreate() {
        Subscriber s1 = Subscriber.create((EventBus)this.bus, (Object)((Object)this), (Method)this.getTestSubscriberMethod("recordingMethod"));
        Truth.assertThat((Object)s1).isInstanceOf(Subscriber.SynchronizedSubscriber.class);
        Subscriber s2 = Subscriber.create((EventBus)this.bus, (Object)((Object)this), (Method)this.getTestSubscriberMethod("threadSafeMethod"));
        Truth.assertThat((Object)s2).isNotInstanceOf(Subscriber.SynchronizedSubscriber.class);
    }

    public void testInvokeSubscriberMethod_basicMethodCall() throws Throwable {
        Method method = this.getTestSubscriberMethod("recordingMethod");
        Subscriber subscriber = Subscriber.create((EventBus)this.bus, (Object)((Object)this), (Method)method);
        subscriber.invokeSubscriberMethod(FIXTURE_ARGUMENT);
        SubscriberTest.assertTrue((String)"Subscriber must call provided method", (boolean)this.methodCalled);
        SubscriberTest.assertTrue((String)"Subscriber argument must be exactly the provided object.", (this.methodArgument == FIXTURE_ARGUMENT ? 1 : 0) != 0);
    }

    public void testInvokeSubscriberMethod_exceptionWrapping() throws Throwable {
        Method method = this.getTestSubscriberMethod("exceptionThrowingMethod");
        Subscriber subscriber = Subscriber.create((EventBus)this.bus, (Object)((Object)this), (Method)method);
        try {
            subscriber.invokeSubscriberMethod(FIXTURE_ARGUMENT);
            SubscriberTest.fail((String)"Subscribers whose methods throw must throw InvocationTargetException");
        }
        catch (InvocationTargetException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(IntentionalException.class);
        }
    }

    public void testInvokeSubscriberMethod_errorPassthrough() throws Throwable {
        Method method = this.getTestSubscriberMethod("errorThrowingMethod");
        Subscriber subscriber = Subscriber.create((EventBus)this.bus, (Object)((Object)this), (Method)method);
        try {
            subscriber.invokeSubscriberMethod(FIXTURE_ARGUMENT);
            SubscriberTest.fail((String)"Subscribers whose methods throw Errors must rethrow them");
        }
        catch (JudgmentError judgmentError) {
            // empty catch block
        }
    }

    public void testEquals() throws Exception {
        Method charAt = String.class.getMethod("charAt", Integer.TYPE);
        Method concat = String.class.getMethod("concat", String.class);
        new EqualsTester().addEqualityGroup(new Object[]{Subscriber.create((EventBus)this.bus, (Object)"foo", (Method)charAt), Subscriber.create((EventBus)this.bus, (Object)"foo", (Method)charAt)}).addEqualityGroup(new Object[]{Subscriber.create((EventBus)this.bus, (Object)"bar", (Method)charAt)}).addEqualityGroup(new Object[]{Subscriber.create((EventBus)this.bus, (Object)"foo", (Method)concat)}).testEquals();
    }

    private Method getTestSubscriberMethod(String name) {
        try {
            return ((Object)((Object)this)).getClass().getDeclaredMethod(name, Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError();
        }
    }

    @Subscribe
    public void recordingMethod(Object arg) {
        SubscriberTest.assertFalse((boolean)this.methodCalled);
        this.methodCalled = true;
        this.methodArgument = arg;
    }

    @Subscribe
    public void exceptionThrowingMethod(Object arg) throws Exception {
        throw new IntentionalException();
    }

    @Subscribe
    public void errorThrowingMethod(Object arg) {
        throw new JudgmentError();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void threadSafeMethod(Object arg) {
    }

    class JudgmentError
    extends Error {
        private static final long serialVersionUID = 634248373797713373L;

        JudgmentError() {
        }
    }

    class IntentionalException
    extends Exception {
        private static final long serialVersionUID = -2500191180248181379L;

        IntentionalException() {
        }
    }
}

