/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharSinkTester;
import com.google.common.io.SourceSinkFactories;
import com.google.common.io.SourceSinkFactory;
import com.google.common.io.SourceSinkTester;
import com.google.common.io.SuppressUnderAndroid;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.Assert;

@SuppressUnderAndroid
public class ByteSinkTester
extends SourceSinkTester<ByteSink, byte[], SourceSinkFactory.ByteSinkFactory> {
    private static final ImmutableList<Method> testMethods = ByteSinkTester.getTestMethods(ByteSinkTester.class);
    private ByteSink sink;

    static TestSuite tests(String name, SourceSinkFactory.ByteSinkFactory factory) {
        TestSuite suite = new TestSuite(name);
        for (Map.Entry entry : TEST_STRINGS.entrySet()) {
            String desc = (String)entry.getKey();
            TestSuite stringSuite = ByteSinkTester.suiteForString(name, factory, (String)entry.getValue(), desc);
            suite.addTest((Test)stringSuite);
        }
        return suite;
    }

    private static TestSuite suiteForString(String name, SourceSinkFactory.ByteSinkFactory factory, String string, String desc) {
        byte[] bytes = string.getBytes(Charsets.UTF_8);
        TestSuite suite = ByteSinkTester.suiteForBytes(name, factory, desc, bytes);
        SourceSinkFactory.CharSinkFactory charSinkFactory = SourceSinkFactories.asCharSinkFactory(factory);
        suite.addTest((Test)CharSinkTester.suiteForString(name + ".asCharSink[Charset]", charSinkFactory, string, desc));
        return suite;
    }

    private static TestSuite suiteForBytes(String name, SourceSinkFactory.ByteSinkFactory factory, String desc, byte[] bytes) {
        TestSuite suite = new TestSuite(name + " [" + desc + "]");
        for (Method method : testMethods) {
            suite.addTest((Test)new ByteSinkTester(factory, bytes, name, desc, method));
        }
        return suite;
    }

    ByteSinkTester(SourceSinkFactory.ByteSinkFactory factory, byte[] data, String suiteName, String caseDesc, Method method) {
        super(factory, data, suiteName, caseDesc, method);
    }

    protected void setUp() throws Exception {
        this.sink = (ByteSink)((SourceSinkFactory.ByteSinkFactory)this.factory).createSink();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOpenStream() throws IOException {
        OutputStream out = this.sink.openStream();
        try {
            ByteStreams.copy((InputStream)new ByteArrayInputStream((byte[])this.data), (OutputStream)out);
        }
        finally {
            out.close();
        }
        this.assertContainsExpectedBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOpenBufferedStream() throws IOException {
        OutputStream out = this.sink.openBufferedStream();
        try {
            ByteStreams.copy((InputStream)new ByteArrayInputStream((byte[])this.data), (OutputStream)out);
        }
        finally {
            out.close();
        }
        this.assertContainsExpectedBytes();
    }

    public void testWrite() throws IOException {
        this.sink.write((byte[])this.data);
        this.assertContainsExpectedBytes();
    }

    public void testWriteFrom_inputStream() throws IOException {
        this.sink.writeFrom((InputStream)new ByteArrayInputStream((byte[])this.data));
        this.assertContainsExpectedBytes();
    }

    private void assertContainsExpectedBytes() throws IOException {
        Assert.assertArrayEquals((byte[])((byte[])this.expected), (byte[])((byte[])((SourceSinkFactory.ByteSinkFactory)this.factory).getSinkContents()));
    }
}

