/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.google.common.io.Closer;
import com.google.common.io.SuppressUnderAndroid;
import com.google.common.testing.TestLogHandler;
import com.google.common.truth.Truth;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.annotation.Nullable;
import junit.framework.TestCase;

public class CloserTest
extends TestCase {
    private TestSuppressor suppressor;

    protected void setUp() throws Exception {
        this.suppressor = new TestSuppressor();
    }

    @SuppressUnderAndroid
    public void testCreate() {
        Closer closer = Closer.create();
        String javaVersion = System.getProperty("java.version");
        String secondPart = (String)Iterables.get((Iterable)Splitter.on((char)'.').split((CharSequence)javaVersion), (int)1);
        int versionNumber = Integer.parseInt(secondPart);
        if (versionNumber < 7) {
            Truth.assertThat((Object)closer.suppressor).isInstanceOf(Closer.LoggingSuppressor.class);
        } else {
            Truth.assertThat((Object)closer.suppressor).isInstanceOf(Closer.SuppressingSuppressor.class);
        }
    }

    public void testNoExceptionsThrown() throws IOException {
        Closer closer = new Closer((Closer.Suppressor)this.suppressor);
        TestCloseable c1 = (TestCloseable)closer.register((Closeable)TestCloseable.normal());
        TestCloseable c2 = (TestCloseable)closer.register((Closeable)TestCloseable.normal());
        TestCloseable c3 = (TestCloseable)closer.register((Closeable)TestCloseable.normal());
        CloserTest.assertFalse((boolean)c1.isClosed());
        CloserTest.assertFalse((boolean)c2.isClosed());
        CloserTest.assertFalse((boolean)c3.isClosed());
        closer.close();
        CloserTest.assertTrue((boolean)c1.isClosed());
        CloserTest.assertTrue((boolean)c2.isClosed());
        CloserTest.assertTrue((boolean)c3.isClosed());
        CloserTest.assertTrue((boolean)this.suppressor.suppressions.isEmpty());
    }

    public void testExceptionThrown_fromTryBlock() throws IOException {
        Closer closer = new Closer((Closer.Suppressor)this.suppressor);
        TestCloseable c1 = (TestCloseable)closer.register((Closeable)TestCloseable.normal());
        TestCloseable c2 = (TestCloseable)closer.register((Closeable)TestCloseable.normal());
        IOException exception = new IOException();
        try {
            try {
                try {
                    throw exception;
                }
                catch (Throwable e) {
                    throw closer.rethrow(e);
                }
            }
            catch (Throwable throwable) {
                closer.close();
                throw throwable;
            }
        }
        catch (Throwable expected) {
            CloserTest.assertSame((Object)exception, (Object)expected);
            CloserTest.assertTrue((boolean)c1.isClosed());
            CloserTest.assertTrue((boolean)c2.isClosed());
            CloserTest.assertTrue((boolean)this.suppressor.suppressions.isEmpty());
            return;
        }
    }

    public void testExceptionThrown_whenCreatingCloseables() throws IOException {
        Closer closer = new Closer((Closer.Suppressor)this.suppressor);
        TestCloseable c1 = null;
        TestCloseable c2 = null;
        TestCloseable c3 = null;
        try {
            try {
                c1 = (TestCloseable)closer.register((Closeable)TestCloseable.normal());
                c2 = (TestCloseable)closer.register((Closeable)TestCloseable.normal());
                c3 = (TestCloseable)closer.register((Closeable)TestCloseable.throwsOnCreate());
            }
            catch (Throwable e) {
                throw closer.rethrow(e);
            }
            finally {
                closer.close();
            }
        }
        catch (Throwable expected) {
            Truth.assertThat((Throwable)expected).isInstanceOf(IOException.class);
        }
        CloserTest.assertTrue((boolean)c1.isClosed());
        CloserTest.assertTrue((boolean)c2.isClosed());
        CloserTest.assertNull(c3);
        CloserTest.assertTrue((boolean)this.suppressor.suppressions.isEmpty());
    }

    public void testExceptionThrown_whileClosingLastCloseable() throws IOException {
        Closer closer = new Closer((Closer.Suppressor)this.suppressor);
        IOException exception = new IOException();
        TestCloseable c1 = (TestCloseable)closer.register((Closeable)TestCloseable.throwsOnClose(exception));
        TestCloseable c2 = (TestCloseable)closer.register((Closeable)TestCloseable.normal());
        try {
            closer.close();
        }
        catch (Throwable expected) {
            CloserTest.assertSame((Object)exception, (Object)expected);
        }
        CloserTest.assertTrue((boolean)c1.isClosed());
        CloserTest.assertTrue((boolean)c2.isClosed());
        CloserTest.assertTrue((boolean)this.suppressor.suppressions.isEmpty());
    }

    public void testExceptionThrown_whileClosingFirstCloseable() throws IOException {
        Closer closer = new Closer((Closer.Suppressor)this.suppressor);
        IOException exception = new IOException();
        TestCloseable c1 = (TestCloseable)closer.register((Closeable)TestCloseable.normal());
        TestCloseable c2 = (TestCloseable)closer.register((Closeable)TestCloseable.throwsOnClose(exception));
        try {
            closer.close();
        }
        catch (Throwable expected) {
            CloserTest.assertSame((Object)exception, (Object)expected);
        }
        CloserTest.assertTrue((boolean)c1.isClosed());
        CloserTest.assertTrue((boolean)c2.isClosed());
        CloserTest.assertTrue((boolean)this.suppressor.suppressions.isEmpty());
    }

    public void testCloseExceptionsSuppressed_whenExceptionThrownFromTryBlock() throws IOException {
        Closer closer = new Closer((Closer.Suppressor)this.suppressor);
        IOException tryException = new IOException();
        IOException c1Exception = new IOException();
        IOException c2Exception = new IOException();
        TestCloseable c1 = (TestCloseable)closer.register((Closeable)TestCloseable.throwsOnClose(c1Exception));
        TestCloseable c2 = (TestCloseable)closer.register((Closeable)TestCloseable.throwsOnClose(c2Exception));
        try {
            try {
                try {
                    throw tryException;
                }
                catch (Throwable e) {
                    throw closer.rethrow(e);
                }
            }
            catch (Throwable throwable) {
                closer.close();
                throw throwable;
            }
        }
        catch (Throwable expected) {
            CloserTest.assertSame((Object)tryException, (Object)expected);
            CloserTest.assertTrue((boolean)c1.isClosed());
            CloserTest.assertTrue((boolean)c2.isClosed());
            this.assertSuppressed(new Suppression(c2, tryException, c2Exception), new Suppression(c1, tryException, c1Exception));
            return;
        }
    }

    public void testCloseExceptionsSuppressed_whenExceptionThrownClosingFirstCloseable() throws IOException {
        Closer closer = new Closer((Closer.Suppressor)this.suppressor);
        IOException c1Exception = new IOException();
        IOException c2Exception = new IOException();
        IOException c3Exception = new IOException();
        TestCloseable c1 = (TestCloseable)closer.register((Closeable)TestCloseable.throwsOnClose(c1Exception));
        TestCloseable c2 = (TestCloseable)closer.register((Closeable)TestCloseable.throwsOnClose(c2Exception));
        TestCloseable c3 = (TestCloseable)closer.register((Closeable)TestCloseable.throwsOnClose(c3Exception));
        try {
            closer.close();
        }
        catch (Throwable expected) {
            CloserTest.assertSame((Object)c3Exception, (Object)expected);
        }
        CloserTest.assertTrue((boolean)c1.isClosed());
        CloserTest.assertTrue((boolean)c2.isClosed());
        CloserTest.assertTrue((boolean)c3.isClosed());
        this.assertSuppressed(new Suppression(c2, c3Exception, c2Exception), new Suppression(c1, c3Exception, c1Exception));
    }

    public void testRuntimeExceptions() throws IOException {
        Closer closer = new Closer((Closer.Suppressor)this.suppressor);
        RuntimeException tryException = new RuntimeException();
        RuntimeException c1Exception = new RuntimeException();
        RuntimeException c2Exception = new RuntimeException();
        TestCloseable c1 = (TestCloseable)closer.register((Closeable)TestCloseable.throwsOnClose(c1Exception));
        TestCloseable c2 = (TestCloseable)closer.register((Closeable)TestCloseable.throwsOnClose(c2Exception));
        try {
            try {
                try {
                    throw tryException;
                }
                catch (Throwable e) {
                    throw closer.rethrow(e);
                }
            }
            catch (Throwable throwable) {
                closer.close();
                throw throwable;
            }
        }
        catch (Throwable expected) {
            CloserTest.assertSame((Object)tryException, (Object)expected);
            CloserTest.assertTrue((boolean)c1.isClosed());
            CloserTest.assertTrue((boolean)c2.isClosed());
            this.assertSuppressed(new Suppression(c2, tryException, c2Exception), new Suppression(c1, tryException, c1Exception));
            return;
        }
    }

    public void testErrors() throws IOException {
        Closer closer = new Closer((Closer.Suppressor)this.suppressor);
        Error c1Exception = new Error();
        Error c2Exception = new Error();
        Error c3Exception = new Error();
        TestCloseable c1 = (TestCloseable)closer.register((Closeable)TestCloseable.throwsOnClose(c1Exception));
        TestCloseable c2 = (TestCloseable)closer.register((Closeable)TestCloseable.throwsOnClose(c2Exception));
        TestCloseable c3 = (TestCloseable)closer.register((Closeable)TestCloseable.throwsOnClose(c3Exception));
        try {
            closer.close();
        }
        catch (Throwable expected) {
            CloserTest.assertSame((Object)c3Exception, (Object)expected);
        }
        CloserTest.assertTrue((boolean)c1.isClosed());
        CloserTest.assertTrue((boolean)c2.isClosed());
        CloserTest.assertTrue((boolean)c3.isClosed());
        this.assertSuppressed(new Suppression(c2, c3Exception, c2Exception), new Suppression(c1, c3Exception, c1Exception));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testLoggingSuppressor() throws IOException {
        TestLogHandler logHandler = new TestLogHandler();
        Closeables.logger.addHandler((Handler)logHandler);
        try {
            Closer closer = new Closer((Closer.Suppressor)new Closer.LoggingSuppressor());
            TestCloseable c1 = (TestCloseable)closer.register((Closeable)TestCloseable.throwsOnClose(new IOException()));
            TestCloseable c2 = (TestCloseable)closer.register((Closeable)TestCloseable.throwsOnClose(new RuntimeException()));
            try {
                throw closer.rethrow((Throwable)new IOException("thrown"), IOException.class);
            }
            catch (IOException expected) {
                CloserTest.assertTrue((boolean)logHandler.getStoredLogRecords().isEmpty());
                closer.close();
                CloserTest.assertEquals((int)2, (int)logHandler.getStoredLogRecords().size());
                LogRecord record = (LogRecord)logHandler.getStoredLogRecords().get(0);
                CloserTest.assertEquals((String)("Suppressing exception thrown when closing " + c2), (String)record.getMessage());
                record = (LogRecord)logHandler.getStoredLogRecords().get(1);
                CloserTest.assertEquals((String)("Suppressing exception thrown when closing " + c1), (String)record.getMessage());
                Closeables.logger.removeHandler((Handler)logHandler);
            }
        }
        catch (Throwable throwable) {
            Closeables.logger.removeHandler((Handler)logHandler);
            throw throwable;
        }
    }

    public static void testSuppressingSuppressorIfPossible() throws IOException {
        if (!Closer.SuppressingSuppressor.isAvailable()) {
            return;
        }
        Closer closer = new Closer((Closer.Suppressor)new Closer.SuppressingSuppressor());
        IOException thrownException = new IOException();
        IOException c1Exception = new IOException();
        RuntimeException c2Exception = new RuntimeException();
        TestCloseable c1 = (TestCloseable)closer.register((Closeable)TestCloseable.throwsOnClose(c1Exception));
        TestCloseable c2 = (TestCloseable)closer.register((Closeable)TestCloseable.throwsOnClose(c2Exception));
        try {
            try {
                try {
                    throw thrownException;
                }
                catch (Throwable e) {
                    throw closer.rethrow((Throwable)thrownException, IOException.class);
                }
            }
            catch (Throwable throwable) {
                Truth.assertThat((Object[])CloserTest.getSuppressed(thrownException)).isEmpty();
                closer.close();
                throw throwable;
            }
        }
        catch (IOException expected) {
            CloserTest.assertSame((Object)thrownException, (Object)expected);
            CloserTest.assertTrue((boolean)c1.isClosed());
            CloserTest.assertTrue((boolean)c2.isClosed());
            ImmutableSet suppressed = ImmutableSet.copyOf((Object[])CloserTest.getSuppressed(thrownException));
            CloserTest.assertEquals((int)2, (int)suppressed.size());
            CloserTest.assertEquals((Object)ImmutableSet.of((Object)c1Exception, (Object)c2Exception), (Object)suppressed);
            return;
        }
    }

    public void testNullCloseable() throws IOException {
        Closer closer = Closer.create();
        closer.register(null);
        closer.close();
    }

    static Throwable[] getSuppressed(Throwable throwable) {
        try {
            Method getSuppressed = Throwable.class.getDeclaredMethod("getSuppressed", new Class[0]);
            return (Throwable[])getSuppressed.invoke((Object)throwable, new Object[0]);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private void assertSuppressed(Suppression ... expected) {
        CloserTest.assertEquals((Object)ImmutableList.copyOf((Object[])expected), (Object)this.suppressor.suppressions);
    }

    private static class TestCloseable
    implements Closeable {
        private final Throwable throwOnClose;
        private boolean closed;

        static TestCloseable normal() throws IOException {
            return new TestCloseable(null);
        }

        static TestCloseable throwsOnClose(Throwable throwOnClose) throws IOException {
            return new TestCloseable(throwOnClose);
        }

        static TestCloseable throwsOnCreate() throws IOException {
            throw new IOException();
        }

        private TestCloseable(@Nullable Throwable throwOnClose) {
            this.throwOnClose = throwOnClose;
        }

        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            if (this.throwOnClose != null) {
                Throwables.propagateIfPossible((Throwable)this.throwOnClose, IOException.class);
                throw new AssertionError((Object)this.throwOnClose);
            }
        }
    }

    private static class Suppression {
        private final Closeable closeable;
        private final Throwable thrown;
        private final Throwable suppressed;

        private Suppression(Closeable closeable, Throwable thrown, Throwable suppressed) {
            this.closeable = closeable;
            this.thrown = thrown;
            this.suppressed = suppressed;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Suppression) {
                Suppression other = (Suppression)obj;
                return this.closeable.equals(other.closeable) && this.thrown.equals(other.thrown) && this.suppressed.equals(other.suppressed);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.closeable, this.thrown, this.suppressed});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("closeable", (Object)this.closeable).add("thrown", (Object)this.thrown).add("suppressed", (Object)this.suppressed).toString();
        }
    }

    private static class TestSuppressor
    implements Closer.Suppressor {
        private final List<Suppression> suppressions = Lists.newArrayList();

        private TestSuppressor() {
        }

        public void suppress(Closeable closeable, Throwable thrown, Throwable suppressed) {
            this.suppressions.add(new Suppression(closeable, thrown, suppressed));
        }
    }
}

