/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Charsets;
import com.google.common.io.CharSink;
import com.google.common.io.TestByteSink;
import com.google.common.io.TestOption;
import com.google.common.io.TestStreamSupplier;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class TestCharSink
extends CharSink
implements TestStreamSupplier {
    private final TestByteSink byteSink;

    public TestCharSink(TestOption ... options) {
        this.byteSink = new TestByteSink(options);
    }

    public String getString() {
        return new String(this.byteSink.getBytes(), Charsets.UTF_8);
    }

    @Override
    public boolean wasStreamOpened() {
        return this.byteSink.wasStreamOpened();
    }

    @Override
    public boolean wasStreamClosed() {
        return this.byteSink.wasStreamClosed();
    }

    public Writer openStream() throws IOException {
        return new FilterWriter(new OutputStreamWriter(this.byteSink.openStream(), Charsets.UTF_8)){

            @Override
            public void write(int c) throws IOException {
                super.write(c);
                this.flush();
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                super.write(cbuf, off, len);
                this.flush();
            }

            @Override
            public void write(String str, int off, int len) throws IOException {
                super.write(str, off, len);
                this.flush();
            }
        };
    }
}

