/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.TestOption;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class TestInputStream
extends FilterInputStream {
    private final ImmutableSet<TestOption> options;
    private boolean closed;

    public TestInputStream(InputStream in, TestOption ... options) throws IOException {
        this(in, Arrays.asList(options));
    }

    public TestInputStream(InputStream in, Iterable<TestOption> options) throws IOException {
        super((InputStream)Preconditions.checkNotNull((Object)in));
        this.options = ImmutableSet.copyOf(options);
        this.throwIf(TestOption.OPEN_THROWS);
    }

    public boolean closed() {
        return this.closed;
    }

    @Override
    public int read() throws IOException {
        TestInputStream.throwIf(this.closed);
        this.throwIf(TestOption.READ_THROWS);
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        TestInputStream.throwIf(this.closed);
        this.throwIf(TestOption.READ_THROWS);
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        TestInputStream.throwIf(this.closed);
        this.throwIf(TestOption.SKIP_THROWS);
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        TestInputStream.throwIf(this.closed);
        return this.options.contains((Object)TestOption.AVAILABLE_ALWAYS_ZERO) ? 0 : this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.throwIf(TestOption.CLOSE_THROWS);
        this.in.close();
    }

    private void throwIf(TestOption option) throws IOException {
        TestInputStream.throwIf(this.options.contains((Object)option));
    }

    private static void throwIf(boolean condition) throws IOException {
        if (condition) {
            throw new IOException();
        }
    }
}

