/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.common.math.LongMath;
import com.google.common.math.MathBenchmarking;

public class LongMathBenchmark {
    private static final int[] exponents = new int[65536];
    private static final int[] factorialArguments = new int[65536];
    private static final int[][] binomialArguments = new int[65536][2];
    private static final long[] positive = new long[65536];
    private static final long[] nonnegative = new long[65536];
    private static final long[] longs = new long[65536];

    @BeforeExperiment
    void setUp() {
        for (int i = 0; i < 65536; ++i) {
            LongMathBenchmark.exponents[i] = MathBenchmarking.randomExponent();
            LongMathBenchmark.positive[i] = MathBenchmarking.randomPositiveBigInteger(63).longValue();
            LongMathBenchmark.nonnegative[i] = MathBenchmarking.randomNonNegativeBigInteger(63).longValue();
            LongMathBenchmark.longs[i] = MathBenchmarking.RANDOM_SOURCE.nextLong();
            LongMathBenchmark.factorialArguments[i] = MathBenchmarking.RANDOM_SOURCE.nextInt(30);
            LongMathBenchmark.binomialArguments[i][1] = MathBenchmarking.RANDOM_SOURCE.nextInt(MathBenchmarking.biggestBinomials.length);
            int k = binomialArguments[i][1];
            LongMathBenchmark.binomialArguments[i][0] = MathBenchmarking.RANDOM_SOURCE.nextInt(MathBenchmarking.biggestBinomials[k] - k) + k;
        }
    }

    @Benchmark
    int pow(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp = (int)((long)tmp + LongMath.pow((long)positive[j], (int)exponents[j]));
        }
        return tmp;
    }

    @Benchmark
    int mod(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp = (int)((long)tmp + LongMath.mod((long)longs[j], (long)positive[j]));
        }
        return tmp;
    }

    @Benchmark
    int gCD(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp = (int)((long)tmp + LongMath.mod((long)nonnegative[j], (long)positive[j]));
        }
        return tmp;
    }

    @Benchmark
    int factorial(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp = (int)((long)tmp + LongMath.factorial((int)factorialArguments[j]));
        }
        return tmp;
    }

    @Benchmark
    int binomial(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp = (int)((long)tmp + LongMath.binomial((int)binomialArguments[j][0], (int)binomialArguments[j][1]));
        }
        return tmp;
    }
}

