/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Doubles;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Iterator;

@GwtCompatible
public class MathTesting {
    static final ImmutableSet<RoundingMode> ALL_ROUNDING_MODES = ImmutableSet.copyOf((Object[])RoundingMode.values());
    static final ImmutableList<RoundingMode> ALL_SAFE_ROUNDING_MODES = ImmutableList.of((Object)((Object)RoundingMode.DOWN), (Object)((Object)RoundingMode.UP), (Object)((Object)RoundingMode.FLOOR), (Object)((Object)RoundingMode.CEILING), (Object)((Object)RoundingMode.HALF_EVEN), (Object)((Object)RoundingMode.HALF_UP), (Object)((Object)RoundingMode.HALF_DOWN));
    static final ImmutableList<Integer> EXPONENTS = ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4, (Object)7, (Object)10, (Object)15, (Object)20, (Object)25, (Object)40, (Object)70, (Object[])new Integer[0]);
    private static final Function<Integer, Long> TO_LONG = new Function<Integer, Long>(){

        public Long apply(Integer n) {
            return (long)n;
        }
    };
    private static final Function<Long, BigInteger> TO_BIGINTEGER = new Function<Long, BigInteger>(){

        public BigInteger apply(Long n) {
            return BigInteger.valueOf(n);
        }
    };
    private static final Function<Integer, Integer> NEGATE_INT = new Function<Integer, Integer>(){

        public Integer apply(Integer x) {
            return -x.intValue();
        }
    };
    private static final Function<Long, Long> NEGATE_LONG = new Function<Long, Long>(){

        public Long apply(Long x) {
            return -x.longValue();
        }
    };
    private static final Function<BigInteger, BigInteger> NEGATE_BIGINT = new Function<BigInteger, BigInteger>(){

        public BigInteger apply(BigInteger x) {
            return x.negate();
        }
    };
    static final ImmutableSet<Integer> POSITIVE_INTEGER_CANDIDATES;
    static final Iterable<Integer> NEGATIVE_INTEGER_CANDIDATES;
    static final Iterable<Integer> NONZERO_INTEGER_CANDIDATES;
    static final Iterable<Integer> ALL_INTEGER_CANDIDATES;
    static final ImmutableSet<Long> POSITIVE_LONG_CANDIDATES;
    static final Iterable<Long> NEGATIVE_LONG_CANDIDATES;
    static final Iterable<Long> NONZERO_LONG_CANDIDATES;
    static final Iterable<Long> ALL_LONG_CANDIDATES;
    static final ImmutableSet<BigInteger> POSITIVE_BIGINTEGER_CANDIDATES;
    static final Iterable<BigInteger> NEGATIVE_BIGINTEGER_CANDIDATES;
    static final Iterable<BigInteger> NONZERO_BIGINTEGER_CANDIDATES;
    static final Iterable<BigInteger> ALL_BIGINTEGER_CANDIDATES;
    static final ImmutableSet<Double> INTEGRAL_DOUBLE_CANDIDATES;
    static final ImmutableSet<Double> FRACTIONAL_DOUBLE_CANDIDATES;
    static final Iterable<Double> INFINITIES;
    static final Iterable<Double> FINITE_DOUBLE_CANDIDATES;
    static final Iterable<Double> POSITIVE_FINITE_DOUBLE_CANDIDATES;
    static final Iterable<Double> ALL_DOUBLE_CANDIDATES;
    static final Iterable<Double> DOUBLE_CANDIDATES_EXCEPT_NAN;

    static {
        ImmutableSet.Builder intValues = ImmutableSet.builder();
        intValues.add((Object[])new Integer[]{0x7FFFFFFE, Integer.MAX_VALUE});
        for (int i = 1; i <= 40; ++i) {
            intValues.add((Object)i);
        }
        for (int exponent : Arrays.asList(2, 3, 4, 9, 15, 16, 17, 24, 25, 30)) {
            int x = 1 << exponent;
            intValues.add((Object[])new Integer[]{x, x + 1, x - 1});
        }
        intValues.add((Object)9999).add((Object)10000).add((Object)10001).add((Object)1000000);
        intValues.add((Object)5792).add((Object)5793);
        POSITIVE_INTEGER_CANDIDATES = intValues.build();
        NEGATIVE_INTEGER_CANDIDATES = ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(POSITIVE_INTEGER_CANDIDATES, NEGATE_INT), (Iterable)ImmutableList.of((Object)Integer.MIN_VALUE)));
        NONZERO_INTEGER_CANDIDATES = ImmutableList.copyOf((Iterable)Iterables.concat(POSITIVE_INTEGER_CANDIDATES, NEGATIVE_INTEGER_CANDIDATES));
        ALL_INTEGER_CANDIDATES = Iterables.concat(NONZERO_INTEGER_CANDIDATES, (Iterable)ImmutableList.of((Object)0));
        ImmutableSet.Builder longValues = ImmutableSet.builder();
        longValues.addAll(Iterables.transform(POSITIVE_INTEGER_CANDIDATES, TO_LONG));
        longValues.add((Object[])new Long[]{0x80000000L, 0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE});
        for (int exponent : Arrays.asList(32, 33, 39, 40, 41, 47, 48, 49, 55, 56, 57)) {
            long x = 1L << exponent;
            longValues.add((Object[])new Long[]{x, x + 1L, x - 1L});
        }
        longValues.add((Object)194368031998L).add((Object)194368031999L);
        POSITIVE_LONG_CANDIDATES = longValues.build();
        NEGATIVE_LONG_CANDIDATES = Iterables.concat((Iterable)Iterables.transform(POSITIVE_LONG_CANDIDATES, NEGATE_LONG), (Iterable)ImmutableList.of((Object)Long.MIN_VALUE));
        NONZERO_LONG_CANDIDATES = Iterables.concat(POSITIVE_LONG_CANDIDATES, NEGATIVE_LONG_CANDIDATES);
        ALL_LONG_CANDIDATES = Iterables.concat(NONZERO_LONG_CANDIDATES, (Iterable)ImmutableList.of((Object)0L));
        ImmutableSet.Builder bigValues = ImmutableSet.builder();
        bigValues.addAll(Iterables.transform(POSITIVE_LONG_CANDIDATES, TO_BIGINTEGER));
        bigValues.add((Object)BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE));
        for (int exponent : Arrays.asList(64, 65, 71, 72, 73, 79, 80, 81, 255, 256, 257, 511, 512, 513, 1022, 1023, 1024)) {
            BigInteger x = BigInteger.ONE.shiftLeft(exponent);
            bigValues.add((Object[])new BigInteger[]{x, x.add(BigInteger.ONE), x.subtract(BigInteger.ONE)});
        }
        bigValues.add((Object)new BigInteger("218838949120258359057546633"));
        bigValues.add((Object)new BigInteger("218838949120258359057546634"));
        POSITIVE_BIGINTEGER_CANDIDATES = bigValues.build();
        NEGATIVE_BIGINTEGER_CANDIDATES = Iterables.transform(POSITIVE_BIGINTEGER_CANDIDATES, NEGATE_BIGINT);
        NONZERO_BIGINTEGER_CANDIDATES = Iterables.concat(POSITIVE_BIGINTEGER_CANDIDATES, NEGATIVE_BIGINTEGER_CANDIDATES);
        ALL_BIGINTEGER_CANDIDATES = Iterables.concat(NONZERO_BIGINTEGER_CANDIDATES, (Iterable)ImmutableList.of((Object)BigInteger.ZERO));
        INFINITIES = Doubles.asList((double[])new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY});
        ImmutableSet.Builder integralBuilder = ImmutableSet.builder();
        ImmutableSet.Builder fractionalBuilder = ImmutableSet.builder();
        integralBuilder.addAll((Iterable)Doubles.asList((double[])new double[]{0.0, -0.0, Double.MAX_VALUE, -1.7976931348623157E308}));
        for (int scale = 1; scale <= 4; ++scale) {
            Iterator i$ = Doubles.asList((double[])new double[]{Double.MIN_VALUE, Double.MIN_NORMAL}).iterator();
            while (i$.hasNext()) {
                double d = (Double)i$.next();
                fractionalBuilder.add((Object)(d * (double)scale)).add((Object)(-d * (double)scale));
            }
        }
        Iterator i$ = Doubles.asList((double[])new double[]{0.0, 1.0, 2.0, 7.0, 51.0, 102.0, Math.scalb(1.0, 53), -2.147483648E9, 2.147483647E9, -9.223372036854776E18, 9.223372036854776E18}).iterator();
        while (i$.hasNext()) {
            double delta;
            double d = (Double)i$.next();
            Iterator i$2 = Doubles.asList((double[])new double[]{0.0, 1.0, 2.0}).iterator();
            while (i$2.hasNext()) {
                delta = (Double)i$2.next();
                integralBuilder.addAll((Iterable)Doubles.asList((double[])new double[]{d + delta, d - delta, -d - delta, -d + delta}));
            }
            i$2 = Doubles.asList((double[])new double[]{0.01, 0.1, 0.25, 0.499, 0.5, 0.501, 0.7, 0.8}).iterator();
            while (i$2.hasNext()) {
                delta = (Double)i$2.next();
                double x = d + delta;
                if (x == (double)Math.round(x)) continue;
                fractionalBuilder.add((Object)x);
            }
        }
        INTEGRAL_DOUBLE_CANDIDATES = integralBuilder.build();
        fractionalBuilder.add((Object)1.414).add((Object)1.415).add((Object)Math.sqrt(2.0));
        fractionalBuilder.add((Object)5.656).add((Object)5.657).add((Object)(4.0 * Math.sqrt(2.0)));
        i$ = INTEGRAL_DOUBLE_CANDIDATES.iterator();
        while (i$.hasNext()) {
            double d = (Double)i$.next();
            double x = 1.0 / d;
            if (x == Math.rint(x)) continue;
            fractionalBuilder.add((Object)x);
        }
        FRACTIONAL_DOUBLE_CANDIDATES = fractionalBuilder.build();
        FINITE_DOUBLE_CANDIDATES = Iterables.concat(FRACTIONAL_DOUBLE_CANDIDATES, INTEGRAL_DOUBLE_CANDIDATES);
        POSITIVE_FINITE_DOUBLE_CANDIDATES = Iterables.filter(FINITE_DOUBLE_CANDIDATES, (Predicate)new Predicate<Double>(){

            public boolean apply(Double input) {
                return input > 0.0;
            }
        });
        DOUBLE_CANDIDATES_EXCEPT_NAN = Iterables.concat(FINITE_DOUBLE_CANDIDATES, INFINITIES);
        ALL_DOUBLE_CANDIDATES = Iterables.concat(DOUBLE_CANDIDATES_EXCEPT_NAN, Arrays.asList(Double.NaN));
    }
}

