/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.primitives.Floats;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class FloatArrayAsListTest
extends TestCase {
    private static List<Float> asList(Float[] values) {
        float[] temp = new float[values.length];
        for (int i = 0; i < values.length; ++i) {
            temp[i] = ((Float)Preconditions.checkNotNull((Object)values[i])).floatValue();
        }
        return Floats.asList((float[])temp);
    }

    @GwtIncompatible(value="suite")
    public static Test suite() {
        ImmutableList builders = ImmutableList.of((Object)ListTestSuiteBuilder.using((TestListGenerator)new FloatsAsListGenerator()).named("Floats.asList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new FloatsAsListHeadSubListGenerator()).named("Floats.asList, head subList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new FloatsAsListTailSubListGenerator()).named("Floats.asList, tail subList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new FloatsAsListMiddleSubListGenerator()).named("Floats.asList, middle subList"));
        TestSuite suite = new TestSuite();
        for (ListTestSuiteBuilder builder : builders) {
            suite.addTest((Test)((ListTestSuiteBuilder)builder.withFeatures(new Feature[]{CollectionSize.ONE, CollectionSize.SEVERAL, CollectionFeature.RESTRICTS_ELEMENTS, ListFeature.SUPPORTS_SET})).createTestSuite());
        }
        return suite;
    }

    private static Float[] concat(Float[] left, Float[] right) {
        Float[] result = new Float[left.length + right.length];
        System.arraycopy(left, 0, result, 0, left.length);
        System.arraycopy(right, 0, result, left.length, right.length);
        return result;
    }

    public static class SampleFloats
    extends SampleElements<Float> {
        public SampleFloats() {
            super((Object)Float.valueOf(0.0f), (Object)Float.valueOf(1.0f), (Object)Float.valueOf(2.0f), (Object)Float.valueOf(3.0f), (Object)Float.valueOf(4.0f));
        }
    }

    public static abstract class TestFloatListGenerator
    implements TestListGenerator<Float> {
        public SampleElements<Float> samples() {
            return new SampleFloats();
        }

        public List<Float> create(Object ... elements) {
            Float[] array = new Float[elements.length];
            int i = 0;
            for (Object e : elements) {
                array[i++] = (Float)e;
            }
            return this.create(array);
        }

        protected abstract List<Float> create(Float[] var1);

        public Float[] createArray(int length) {
            return new Float[length];
        }

        public List<Float> order(List<Float> insertionOrder) {
            return insertionOrder;
        }
    }

    public static final class FloatsAsListMiddleSubListGenerator
    extends TestFloatListGenerator {
        @Override
        protected List<Float> create(Float[] elements) {
            Float[] prefix = new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE)};
            Float[] suffix = new Float[]{Float.valueOf(86.0f), Float.valueOf(99.0f)};
            Float[] all = FloatArrayAsListTest.concat(FloatArrayAsListTest.concat(prefix, elements), suffix);
            return FloatArrayAsListTest.asList(all).subList(2, elements.length + 2);
        }
    }

    public static final class FloatsAsListTailSubListGenerator
    extends TestFloatListGenerator {
        @Override
        protected List<Float> create(Float[] elements) {
            Float[] prefix = new Float[]{Float.valueOf(86.0f), Float.valueOf(99.0f)};
            Float[] all = FloatArrayAsListTest.concat(prefix, elements);
            return FloatArrayAsListTest.asList(all).subList(2, elements.length + 2);
        }
    }

    public static final class FloatsAsListHeadSubListGenerator
    extends TestFloatListGenerator {
        @Override
        protected List<Float> create(Float[] elements) {
            Float[] suffix = new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE)};
            Float[] all = FloatArrayAsListTest.concat(elements, suffix);
            return FloatArrayAsListTest.asList(all).subList(0, elements.length);
        }
    }

    public static final class FloatsAsListGenerator
    extends TestFloatListGenerator {
        @Override
        protected List<Float> create(Float[] elements) {
            return FloatArrayAsListTest.asList(elements);
        }
    }
}

