/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Converter;
import com.google.common.collect.testing.Helpers;
import com.google.common.primitives.Ints;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class IntsTest
extends TestCase {
    private static final int[] EMPTY = new int[0];
    private static final int[] ARRAY1 = new int[]{1};
    private static final int[] ARRAY234 = new int[]{2, 3, 4};
    private static final int LEAST = Integer.MIN_VALUE;
    private static final int GREATEST = Integer.MAX_VALUE;
    private static final int[] VALUES = new int[]{Integer.MIN_VALUE, -1, 0, 1, Integer.MAX_VALUE};

    public void testHashCode() {
        for (int value : VALUES) {
            IntsTest.assertEquals((int)Integer.valueOf(value).hashCode(), (int)Ints.hashCode((int)value));
        }
    }

    public void testCheckedCast() {
        for (int value : VALUES) {
            IntsTest.assertEquals((int)value, (int)Ints.checkedCast((long)value));
        }
        IntsTest.assertCastFails(0x80000000L);
        IntsTest.assertCastFails(-2147483649L);
        IntsTest.assertCastFails(Long.MAX_VALUE);
        IntsTest.assertCastFails(Long.MIN_VALUE);
    }

    public void testSaturatedCast() {
        for (int value : VALUES) {
            IntsTest.assertEquals((int)value, (int)Ints.saturatedCast((long)value));
        }
        IntsTest.assertEquals((int)Integer.MAX_VALUE, (int)Ints.saturatedCast((long)0x80000000L));
        IntsTest.assertEquals((int)Integer.MIN_VALUE, (int)Ints.saturatedCast((long)-2147483649L));
        IntsTest.assertEquals((int)Integer.MAX_VALUE, (int)Ints.saturatedCast((long)Long.MAX_VALUE));
        IntsTest.assertEquals((int)Integer.MIN_VALUE, (int)Ints.saturatedCast((long)Long.MIN_VALUE));
    }

    private static void assertCastFails(long value) {
        try {
            Ints.checkedCast((long)value);
            IntsTest.fail((String)("Cast to int should have failed: " + value));
        }
        catch (IllegalArgumentException ex) {
            IntsTest.assertTrue((String)(value + " not found in exception text: " + ex.getMessage()), (boolean)ex.getMessage().contains(String.valueOf(value)));
        }
    }

    public void testCompare() {
        for (int x : VALUES) {
            for (int y : VALUES) {
                IntsTest.assertEquals((String)(x + ", " + y), (int)Integer.valueOf(x).compareTo(y), (int)Ints.compare((int)x, (int)y));
            }
        }
    }

    public void testContains() {
        IntsTest.assertFalse((boolean)Ints.contains((int[])EMPTY, (int)1));
        IntsTest.assertFalse((boolean)Ints.contains((int[])ARRAY1, (int)2));
        IntsTest.assertFalse((boolean)Ints.contains((int[])ARRAY234, (int)1));
        IntsTest.assertTrue((boolean)Ints.contains((int[])new int[]{-1}, (int)-1));
        IntsTest.assertTrue((boolean)Ints.contains((int[])ARRAY234, (int)2));
        IntsTest.assertTrue((boolean)Ints.contains((int[])ARRAY234, (int)3));
        IntsTest.assertTrue((boolean)Ints.contains((int[])ARRAY234, (int)4));
    }

    public void testIndexOf() {
        IntsTest.assertEquals((int)-1, (int)Ints.indexOf((int[])EMPTY, (int)1));
        IntsTest.assertEquals((int)-1, (int)Ints.indexOf((int[])ARRAY1, (int)2));
        IntsTest.assertEquals((int)-1, (int)Ints.indexOf((int[])ARRAY234, (int)1));
        IntsTest.assertEquals((int)0, (int)Ints.indexOf((int[])new int[]{-1}, (int)-1));
        IntsTest.assertEquals((int)0, (int)Ints.indexOf((int[])ARRAY234, (int)2));
        IntsTest.assertEquals((int)1, (int)Ints.indexOf((int[])ARRAY234, (int)3));
        IntsTest.assertEquals((int)2, (int)Ints.indexOf((int[])ARRAY234, (int)4));
        IntsTest.assertEquals((int)1, (int)Ints.indexOf((int[])new int[]{2, 3, 2, 3}, (int)3));
    }

    public void testIndexOf_arrayTarget() {
        IntsTest.assertEquals((int)0, (int)Ints.indexOf((int[])EMPTY, (int[])EMPTY));
        IntsTest.assertEquals((int)0, (int)Ints.indexOf((int[])ARRAY234, (int[])EMPTY));
        IntsTest.assertEquals((int)-1, (int)Ints.indexOf((int[])EMPTY, (int[])ARRAY234));
        IntsTest.assertEquals((int)-1, (int)Ints.indexOf((int[])ARRAY234, (int[])ARRAY1));
        IntsTest.assertEquals((int)-1, (int)Ints.indexOf((int[])ARRAY1, (int[])ARRAY234));
        IntsTest.assertEquals((int)0, (int)Ints.indexOf((int[])ARRAY1, (int[])ARRAY1));
        IntsTest.assertEquals((int)0, (int)Ints.indexOf((int[])ARRAY234, (int[])ARRAY234));
        IntsTest.assertEquals((int)0, (int)Ints.indexOf((int[])ARRAY234, (int[])new int[]{2, 3}));
        IntsTest.assertEquals((int)1, (int)Ints.indexOf((int[])ARRAY234, (int[])new int[]{3, 4}));
        IntsTest.assertEquals((int)1, (int)Ints.indexOf((int[])ARRAY234, (int[])new int[]{3}));
        IntsTest.assertEquals((int)2, (int)Ints.indexOf((int[])ARRAY234, (int[])new int[]{4}));
        IntsTest.assertEquals((int)1, (int)Ints.indexOf((int[])new int[]{2, 3, 3, 3, 3}, (int[])new int[]{3}));
        IntsTest.assertEquals((int)2, (int)Ints.indexOf((int[])new int[]{2, 3, 2, 3, 4, 2, 3}, (int[])new int[]{2, 3, 4}));
        IntsTest.assertEquals((int)1, (int)Ints.indexOf((int[])new int[]{2, 2, 3, 4, 2, 3, 4}, (int[])new int[]{2, 3, 4}));
        IntsTest.assertEquals((int)-1, (int)Ints.indexOf((int[])new int[]{4, 3, 2}, (int[])new int[]{2, 3, 4}));
    }

    public void testLastIndexOf() {
        IntsTest.assertEquals((int)-1, (int)Ints.lastIndexOf((int[])EMPTY, (int)1));
        IntsTest.assertEquals((int)-1, (int)Ints.lastIndexOf((int[])ARRAY1, (int)2));
        IntsTest.assertEquals((int)-1, (int)Ints.lastIndexOf((int[])ARRAY234, (int)1));
        IntsTest.assertEquals((int)0, (int)Ints.lastIndexOf((int[])new int[]{-1}, (int)-1));
        IntsTest.assertEquals((int)0, (int)Ints.lastIndexOf((int[])ARRAY234, (int)2));
        IntsTest.assertEquals((int)1, (int)Ints.lastIndexOf((int[])ARRAY234, (int)3));
        IntsTest.assertEquals((int)2, (int)Ints.lastIndexOf((int[])ARRAY234, (int)4));
        IntsTest.assertEquals((int)3, (int)Ints.lastIndexOf((int[])new int[]{2, 3, 2, 3}, (int)3));
    }

    public void testMax_noArgs() {
        try {
            Ints.max((int[])new int[0]);
            IntsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMax() {
        IntsTest.assertEquals((int)Integer.MIN_VALUE, (int)Ints.max((int[])new int[]{Integer.MIN_VALUE}));
        IntsTest.assertEquals((int)Integer.MAX_VALUE, (int)Ints.max((int[])new int[]{Integer.MAX_VALUE}));
        IntsTest.assertEquals((int)9, (int)Ints.max((int[])new int[]{8, 6, 7, 5, 3, 0, 9}));
    }

    public void testMin_noArgs() {
        try {
            Ints.min((int[])new int[0]);
            IntsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMin() {
        IntsTest.assertEquals((int)Integer.MIN_VALUE, (int)Ints.min((int[])new int[]{Integer.MIN_VALUE}));
        IntsTest.assertEquals((int)Integer.MAX_VALUE, (int)Ints.min((int[])new int[]{Integer.MAX_VALUE}));
        IntsTest.assertEquals((int)0, (int)Ints.min((int[])new int[]{8, 6, 7, 5, 3, 0, 9}));
    }

    public void testConcat() {
        IntsTest.assertTrue((boolean)Arrays.equals(EMPTY, Ints.concat((int[][])new int[0][])));
        IntsTest.assertTrue((boolean)Arrays.equals(EMPTY, Ints.concat((int[][])new int[][]{EMPTY})));
        IntsTest.assertTrue((boolean)Arrays.equals(EMPTY, Ints.concat((int[][])new int[][]{EMPTY, EMPTY, EMPTY})));
        IntsTest.assertTrue((boolean)Arrays.equals(ARRAY1, Ints.concat((int[][])new int[][]{ARRAY1})));
        IntsTest.assertNotSame((Object)ARRAY1, (Object)Ints.concat((int[][])new int[][]{ARRAY1}));
        IntsTest.assertTrue((boolean)Arrays.equals(ARRAY1, Ints.concat((int[][])new int[][]{EMPTY, ARRAY1, EMPTY})));
        IntsTest.assertTrue((boolean)Arrays.equals(new int[]{1, 1, 1}, Ints.concat((int[][])new int[][]{ARRAY1, ARRAY1, ARRAY1})));
        IntsTest.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 3, 4}, Ints.concat((int[][])new int[][]{ARRAY1, ARRAY234})));
    }

    @GwtIncompatible(value="Ints.toByteArray")
    public void testToByteArray() {
        IntsTest.assertTrue((boolean)Arrays.equals(new byte[]{18, 19, 20, 21}, Ints.toByteArray((int)303240213)));
        IntsTest.assertTrue((boolean)Arrays.equals(new byte[]{-1, -18, -35, -52}, Ints.toByteArray((int)-1122868)));
    }

    @GwtIncompatible(value="Ints.fromByteArray")
    public void testFromByteArray() {
        IntsTest.assertEquals((int)303240213, (int)Ints.fromByteArray((byte[])new byte[]{18, 19, 20, 21, 51}));
        IntsTest.assertEquals((int)-1122868, (int)Ints.fromByteArray((byte[])new byte[]{-1, -18, -35, -52}));
    }

    @GwtIncompatible(value="Ints.fromByteArray")
    public void testFromByteArrayFails() {
        try {
            Ints.fromByteArray((byte[])new byte[3]);
            IntsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible(value="Ints.fromBytes")
    public void testFromBytes() {
        IntsTest.assertEquals((int)303240213, (int)Ints.fromBytes((byte)18, (byte)19, (byte)20, (byte)21));
        IntsTest.assertEquals((int)-1122868, (int)Ints.fromBytes((byte)-1, (byte)-18, (byte)-35, (byte)-52));
    }

    @GwtIncompatible(value="Ints.fromByteArray, Ints.toByteArray")
    public void testByteArrayRoundTrips() {
        Random r = new Random(5L);
        byte[] b = new byte[4];
        for (int i = 0; i < 10000; ++i) {
            int num = r.nextInt();
            IntsTest.assertEquals((int)num, (int)Ints.fromByteArray((byte[])Ints.toByteArray((int)num)));
            r.nextBytes(b);
            IntsTest.assertTrue((boolean)Arrays.equals(b, Ints.toByteArray((int)Ints.fromByteArray((byte[])b))));
        }
    }

    public void testEnsureCapacity() {
        IntsTest.assertSame((Object)EMPTY, (Object)Ints.ensureCapacity((int[])EMPTY, (int)0, (int)1));
        IntsTest.assertSame((Object)ARRAY1, (Object)Ints.ensureCapacity((int[])ARRAY1, (int)0, (int)1));
        IntsTest.assertSame((Object)ARRAY1, (Object)Ints.ensureCapacity((int[])ARRAY1, (int)1, (int)1));
        IntsTest.assertTrue((boolean)Arrays.equals(new int[]{1, 0, 0}, Ints.ensureCapacity((int[])ARRAY1, (int)2, (int)1)));
    }

    public void testEnsureCapacity_fail() {
        try {
            Ints.ensureCapacity((int[])ARRAY1, (int)-1, (int)1);
            IntsTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            Ints.ensureCapacity((int[])ARRAY1, (int)1, (int)-1);
            IntsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testJoin() {
        IntsTest.assertEquals((String)"", (String)Ints.join((String)",", (int[])EMPTY));
        IntsTest.assertEquals((String)"1", (String)Ints.join((String)",", (int[])ARRAY1));
        IntsTest.assertEquals((String)"1,2", (String)Ints.join((String)",", (int[])new int[]{1, 2}));
        IntsTest.assertEquals((String)"123", (String)Ints.join((String)"", (int[])new int[]{1, 2, 3}));
    }

    public void testLexicographicalComparator() {
        List ordered = Arrays.asList(new int[0], {Integer.MIN_VALUE}, {Integer.MIN_VALUE, Integer.MIN_VALUE}, {Integer.MIN_VALUE, 1}, {1}, {1, Integer.MIN_VALUE}, {Integer.MAX_VALUE, 0x7FFFFFFE}, {Integer.MAX_VALUE, Integer.MAX_VALUE}, {Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE});
        Comparator comparator = Ints.lexicographicalComparator();
        Helpers.testComparator((Comparator)comparator, ordered);
    }

    @GwtIncompatible(value="SerializableTester")
    public void testLexicographicalComparatorSerializable() {
        Comparator comparator = Ints.lexicographicalComparator();
        IntsTest.assertSame((Object)comparator, (Object)SerializableTester.reserialize((Object)comparator));
    }

    @GwtIncompatible(value="SerializableTester")
    public void testStringConverterSerialization() {
        SerializableTester.reserializeAndAssert((Object)Ints.stringConverter());
    }

    public void testToArray() {
        List<Integer> none = Arrays.asList(new Integer[0]);
        IntsTest.assertTrue((boolean)Arrays.equals(EMPTY, Ints.toArray(none)));
        List<Integer> one = Arrays.asList(1);
        IntsTest.assertTrue((boolean)Arrays.equals(ARRAY1, Ints.toArray(one)));
        int[] array = new int[]{0, 1, -559038737};
        List<Integer> three = Arrays.asList(0, 1, -559038737);
        IntsTest.assertTrue((boolean)Arrays.equals(array, Ints.toArray(three)));
        IntsTest.assertTrue((boolean)Arrays.equals(array, Ints.toArray((Collection)Ints.asList((int[])array))));
    }

    public void testToArray_threadSafe() {
        for (int delta : new int[]{1, 0, -1}) {
            for (int i = 0; i < VALUES.length; ++i) {
                List list = Ints.asList((int[])VALUES).subList(0, i);
                Collection misleadingSize = Helpers.misleadingSizeCollection((int)delta);
                misleadingSize.addAll(list);
                int[] arr = Ints.toArray((Collection)misleadingSize);
                IntsTest.assertEquals((int)i, (int)arr.length);
                for (int j = 0; j < i; ++j) {
                    IntsTest.assertEquals((int)VALUES[j], (int)arr[j]);
                }
            }
        }
    }

    public void testToArray_withNull() {
        List<Integer> list = Arrays.asList(0, 1, null);
        try {
            Ints.toArray(list);
            IntsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToArray_withConversion() {
        int[] array = new int[]{0, 1, 2};
        List<Byte> bytes = Arrays.asList((byte)0, (byte)1, (byte)2);
        List<Short> shorts = Arrays.asList((short)0, (short)1, (short)2);
        List<Integer> ints = Arrays.asList(0, 1, 2);
        List<Float> floats = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(2.0f));
        List<Long> longs = Arrays.asList(0L, 1L, 2L);
        List<Double> doubles = Arrays.asList(0.0, 1.0, 2.0);
        IntsTest.assertTrue((boolean)Arrays.equals(array, Ints.toArray(bytes)));
        IntsTest.assertTrue((boolean)Arrays.equals(array, Ints.toArray(shorts)));
        IntsTest.assertTrue((boolean)Arrays.equals(array, Ints.toArray(ints)));
        IntsTest.assertTrue((boolean)Arrays.equals(array, Ints.toArray(floats)));
        IntsTest.assertTrue((boolean)Arrays.equals(array, Ints.toArray(longs)));
        IntsTest.assertTrue((boolean)Arrays.equals(array, Ints.toArray(doubles)));
    }

    public void testAsList_isAView() {
        int[] array = new int[]{0, 1};
        List list = Ints.asList((int[])array);
        list.set(0, 2);
        IntsTest.assertTrue((boolean)Arrays.equals(new int[]{2, 1}, array));
        array[1] = 3;
        IntsTest.assertEquals(Arrays.asList(2, 3), (Object)list);
    }

    public void testAsList_toArray_roundTrip() {
        int[] array = new int[]{0, 1, 2};
        List list = Ints.asList((int[])array);
        int[] newArray = Ints.toArray((Collection)list);
        list.set(0, 4);
        IntsTest.assertTrue((boolean)Arrays.equals(new int[]{0, 1, 2}, newArray));
        newArray[1] = 5;
        IntsTest.assertEquals((int)1, (int)((Integer)list.get(1)));
    }

    public void testAsList_subList_toArray_roundTrip() {
        int[] array = new int[]{0, 1, 2, 3};
        List list = Ints.asList((int[])array);
        IntsTest.assertTrue((boolean)Arrays.equals(new int[]{1, 2}, Ints.toArray(list.subList(1, 3))));
        IntsTest.assertTrue((boolean)Arrays.equals(new int[0], Ints.toArray(list.subList(2, 2))));
    }

    public void testAsListEmpty() {
        IntsTest.assertSame(Collections.emptyList(), (Object)Ints.asList((int[])EMPTY));
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNulls() {
        new NullPointerTester().testAllPublicStaticMethods(Ints.class);
    }

    public void testStringConverter_convert() {
        Converter converter = Ints.stringConverter();
        IntsTest.assertEquals((Object)1, (Object)converter.convert((Object)"1"));
        IntsTest.assertEquals((Object)0, (Object)converter.convert((Object)"0"));
        IntsTest.assertEquals((Object)-1, (Object)converter.convert((Object)"-1"));
        IntsTest.assertEquals((Object)255, (Object)converter.convert((Object)"0xff"));
        IntsTest.assertEquals((Object)255, (Object)converter.convert((Object)"0xFF"));
        IntsTest.assertEquals((Object)-255, (Object)converter.convert((Object)"-0xFF"));
        IntsTest.assertEquals((Object)255, (Object)converter.convert((Object)"#0000FF"));
        IntsTest.assertEquals((Object)438, (Object)converter.convert((Object)"0666"));
    }

    public void testStringConverter_convertError() {
        try {
            Ints.stringConverter().convert((Object)"notanumber");
            IntsTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testStringConverter_nullConversions() {
        IntsTest.assertNull((Object)Ints.stringConverter().convert(null));
        IntsTest.assertNull((Object)Ints.stringConverter().reverse().convert(null));
    }

    public void testStringConverter_reverse() {
        Converter converter = Ints.stringConverter();
        IntsTest.assertEquals((String)"1", (String)((String)converter.reverse().convert((Object)1)));
        IntsTest.assertEquals((String)"0", (String)((String)converter.reverse().convert((Object)0)));
        IntsTest.assertEquals((String)"-1", (String)((String)converter.reverse().convert((Object)-1)));
        IntsTest.assertEquals((String)"255", (String)((String)converter.reverse().convert((Object)255)));
        IntsTest.assertEquals((String)"255", (String)((String)converter.reverse().convert((Object)255)));
        IntsTest.assertEquals((String)"-255", (String)((String)converter.reverse().convert((Object)-255)));
        IntsTest.assertEquals((String)"438", (String)((String)converter.reverse().convert((Object)438)));
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testStringConverter_nullPointerTester() throws Exception {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicInstanceMethods((Object)Ints.stringConverter());
    }

    public void testTryParse() {
        IntsTest.tryParseAndAssertEquals(0, "0");
        IntsTest.tryParseAndAssertEquals(0, "-0");
        IntsTest.tryParseAndAssertEquals(1, "1");
        IntsTest.tryParseAndAssertEquals(-1, "-1");
        IntsTest.tryParseAndAssertEquals(8900, "8900");
        IntsTest.tryParseAndAssertEquals(-8900, "-8900");
        IntsTest.tryParseAndAssertEquals(Integer.MAX_VALUE, Integer.toString(Integer.MAX_VALUE));
        IntsTest.tryParseAndAssertEquals(Integer.MIN_VALUE, Integer.toString(Integer.MIN_VALUE));
        IntsTest.assertNull((Object)Ints.tryParse((String)""));
        IntsTest.assertNull((Object)Ints.tryParse((String)"-"));
        IntsTest.assertNull((Object)Ints.tryParse((String)"+1"));
        IntsTest.assertNull((Object)Ints.tryParse((String)"9999999999999999"));
        IntsTest.assertNull((String)"Max integer + 1", (Object)Ints.tryParse((String)Long.toString(0x80000000L)));
        IntsTest.assertNull((String)"Max integer * 10", (Object)Ints.tryParse((String)Long.toString(0x4FFFFFFF6L)));
        IntsTest.assertNull((String)"Min integer - 1", (Object)Ints.tryParse((String)Long.toString(-2147483649L)));
        IntsTest.assertNull((String)"Min integer * 10", (Object)Ints.tryParse((String)Long.toString(-21474836480L)));
        IntsTest.assertNull((String)"Max long", (Object)Ints.tryParse((String)Long.toString(Long.MAX_VALUE)));
        IntsTest.assertNull((String)"Min long", (Object)Ints.tryParse((String)Long.toString(Long.MIN_VALUE)));
        IntsTest.assertNull((Object)Ints.tryParse((String)"\u0662\u06f3"));
    }

    private static void tryParseAndAssertEquals(Integer expected, String value) {
        IntsTest.assertEquals((Object)expected, (Object)Ints.tryParse((String)value));
    }

    public void testTryParse_radix() {
        for (int radix = 2; radix <= 36; ++radix) {
            IntsTest.radixEncodeParseAndAssertEquals(0, radix);
            IntsTest.radixEncodeParseAndAssertEquals(8000, radix);
            IntsTest.radixEncodeParseAndAssertEquals(-8000, radix);
            IntsTest.radixEncodeParseAndAssertEquals(Integer.MAX_VALUE, radix);
            IntsTest.radixEncodeParseAndAssertEquals(Integer.MIN_VALUE, radix);
            IntsTest.assertNull((String)("Radix: " + radix), (Object)Ints.tryParse((String)"9999999999999999", (int)radix));
            IntsTest.assertNull((String)("Radix: " + radix), (Object)Ints.tryParse((String)Long.toString(0x80000000L, radix), (int)radix));
            IntsTest.assertNull((String)("Radix: " + radix), (Object)Ints.tryParse((String)Long.toString(-2147483649L, radix), (int)radix));
        }
        IntsTest.assertNull((String)"Hex string and dec parm", (Object)Ints.tryParse((String)"FFFF", (int)10));
        IntsTest.assertEquals((String)"Mixed hex case", (int)65535, (int)Ints.tryParse((String)"ffFF", (int)16));
    }

    private static void radixEncodeParseAndAssertEquals(Integer value, int radix) {
        IntsTest.assertEquals((String)("Radix: " + radix), (Object)value, (Object)Ints.tryParse((String)Integer.toString(value, radix), (int)radix));
    }

    public void testTryParse_radixTooBig() {
        try {
            Ints.tryParse((String)"0", (int)37);
            IntsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTryParse_radixTooSmall() {
        try {
            Ints.tryParse((String)"0", (int)1);
            IntsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

