/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.testing.TearDown;
import com.google.common.testing.TearDownStack;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.testing.TestingExecutors;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Assert;
import junit.framework.TestCase;

public class AbstractExecutionThreadServiceTest
extends TestCase {
    private final TearDownStack tearDownStack = new TearDownStack(true);
    private final CountDownLatch enterRun = new CountDownLatch(1);
    private final CountDownLatch exitRun = new CountDownLatch(1);
    private Thread executionThread;
    private Throwable thrownByExecutionThread;
    private final Executor exceptionCatchingExecutor = new Executor(){

        @Override
        public void execute(Runnable command) {
            AbstractExecutionThreadServiceTest.this.executionThread = new Thread(command);
            AbstractExecutionThreadServiceTest.this.executionThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable e) {
                    AbstractExecutionThreadServiceTest.this.thrownByExecutionThread = e;
                }
            });
            AbstractExecutionThreadServiceTest.this.executionThread.start();
        }
    };

    protected final void tearDown() {
        this.tearDownStack.runTearDown();
        AbstractExecutionThreadServiceTest.assertNull((String)"exceptions should not be propagated to uncaught exception handlers", (Object)this.thrownByExecutionThread);
    }

    public void testServiceStartStop() throws Exception {
        WaitOnRunService service = new WaitOnRunService();
        AbstractExecutionThreadServiceTest.assertFalse((boolean)service.startUpCalled);
        service.startAsync().awaitRunning();
        AbstractExecutionThreadServiceTest.assertTrue((boolean)service.startUpCalled);
        AbstractExecutionThreadServiceTest.assertEquals((Object)Service.State.RUNNING, (Object)service.state());
        this.enterRun.await();
        service.stopAsync().awaitTerminated();
        AbstractExecutionThreadServiceTest.assertTrue((boolean)service.shutDownCalled);
        AbstractExecutionThreadServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
        this.executionThread.join();
    }

    public void testServiceStopIdempotence() throws Exception {
        WaitOnRunService service = new WaitOnRunService();
        service.startAsync().awaitRunning();
        this.enterRun.await();
        service.stopAsync();
        service.stopAsync();
        service.stopAsync().awaitTerminated();
        AbstractExecutionThreadServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
        service.stopAsync().awaitTerminated();
        AbstractExecutionThreadServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
        this.executionThread.join();
    }

    public void testServiceExitingOnItsOwn() throws Exception {
        WaitOnRunService service = new WaitOnRunService();
        service.expectedShutdownState = Service.State.RUNNING;
        service.startAsync().awaitRunning();
        AbstractExecutionThreadServiceTest.assertTrue((boolean)service.startUpCalled);
        AbstractExecutionThreadServiceTest.assertEquals((Object)Service.State.RUNNING, (Object)service.state());
        this.exitRun.countDown();
        this.executionThread.join();
        AbstractExecutionThreadServiceTest.assertTrue((boolean)service.shutDownCalled);
        AbstractExecutionThreadServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
        service.stopAsync().awaitTerminated();
        AbstractExecutionThreadServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
        AbstractExecutionThreadServiceTest.assertTrue((boolean)service.shutDownCalled);
    }

    public void testServiceThrowOnStartUp() throws Exception {
        ThrowOnStartUpService service = new ThrowOnStartUpService();
        AbstractExecutionThreadServiceTest.assertFalse((boolean)service.startUpCalled);
        service.startAsync();
        try {
            service.awaitRunning();
            AbstractExecutionThreadServiceTest.fail();
        }
        catch (IllegalStateException expected) {
            Truth.assertThat((Throwable)expected.getCause()).hasMessage("kaboom!");
        }
        this.executionThread.join();
        AbstractExecutionThreadServiceTest.assertTrue((boolean)service.startUpCalled);
        AbstractExecutionThreadServiceTest.assertEquals((Object)Service.State.FAILED, (Object)service.state());
        Truth.assertThat((Throwable)service.failureCause()).hasMessage("kaboom!");
    }

    public void testServiceThrowOnRun() throws Exception {
        ThrowOnRunService service = new ThrowOnRunService();
        service.startAsync();
        try {
            service.awaitTerminated();
            AbstractExecutionThreadServiceTest.fail();
        }
        catch (IllegalStateException expected) {
            this.executionThread.join();
            AbstractExecutionThreadServiceTest.assertEquals((Object)service.failureCause(), (Object)expected.getCause());
            Truth.assertThat((Throwable)expected.getCause()).hasMessage("kaboom!");
        }
        AbstractExecutionThreadServiceTest.assertTrue((boolean)service.shutDownCalled);
        AbstractExecutionThreadServiceTest.assertEquals((Object)Service.State.FAILED, (Object)service.state());
    }

    public void testServiceThrowOnRunAndThenAgainOnShutDown() throws Exception {
        ThrowOnRunService service = new ThrowOnRunService();
        service.throwOnShutDown = true;
        service.startAsync();
        try {
            service.awaitTerminated();
            AbstractExecutionThreadServiceTest.fail();
        }
        catch (IllegalStateException expected) {
            this.executionThread.join();
            AbstractExecutionThreadServiceTest.assertEquals((Object)service.failureCause(), (Object)expected.getCause());
            Truth.assertThat((Throwable)expected.getCause()).hasMessage("kaboom!");
        }
        AbstractExecutionThreadServiceTest.assertTrue((boolean)service.shutDownCalled);
        AbstractExecutionThreadServiceTest.assertEquals((Object)Service.State.FAILED, (Object)service.state());
    }

    public void testServiceThrowOnShutDown() throws Exception {
        ThrowOnShutDown service = new ThrowOnShutDown();
        service.startAsync().awaitRunning();
        AbstractExecutionThreadServiceTest.assertEquals((Object)Service.State.RUNNING, (Object)service.state());
        service.stopAsync();
        this.enterRun.countDown();
        this.executionThread.join();
        AbstractExecutionThreadServiceTest.assertEquals((Object)Service.State.FAILED, (Object)service.state());
        Truth.assertThat((Throwable)service.failureCause()).hasMessage("kaboom!");
    }

    public void testServiceTimeoutOnStartUp() throws Exception {
        TimeoutOnStartUp service = new TimeoutOnStartUp();
        try {
            service.startAsync().awaitRunning(1L, TimeUnit.MILLISECONDS);
            AbstractExecutionThreadServiceTest.fail();
        }
        catch (TimeoutException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)Service.State.STARTING.toString());
        }
    }

    public void testStopWhileStarting_runNotCalled() throws Exception {
        final CountDownLatch started = new CountDownLatch(1);
        FakeService service = new FakeService(){

            @Override
            protected void startUp() throws Exception {
                super.startUp();
                started.await();
            }
        };
        service.startAsync();
        service.stopAsync();
        started.countDown();
        service.awaitTerminated();
        AbstractExecutionThreadServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
        AbstractExecutionThreadServiceTest.assertEquals((int)1, (int)service.startupCalled);
        AbstractExecutionThreadServiceTest.assertEquals((int)0, (int)service.runCalled);
        AbstractExecutionThreadServiceTest.assertEquals((int)1, (int)service.shutdownCalled);
    }

    public void testStop_noStart() {
        FakeService service = new FakeService();
        service.stopAsync().awaitTerminated();
        AbstractExecutionThreadServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
        AbstractExecutionThreadServiceTest.assertEquals((int)0, (int)service.startupCalled);
        AbstractExecutionThreadServiceTest.assertEquals((int)0, (int)service.runCalled);
        AbstractExecutionThreadServiceTest.assertEquals((int)0, (int)service.shutdownCalled);
    }

    public void testDefaultService() throws InterruptedException {
        WaitOnRunService service = new WaitOnRunService();
        service.startAsync().awaitRunning();
        this.enterRun.await();
        service.stopAsync().awaitTerminated();
    }

    public void testTimeout() {
        AbstractExecutionThreadService service = new AbstractExecutionThreadService(){

            protected void run() throws Exception {
            }

            protected ScheduledExecutorService executor() {
                return TestingExecutors.noOpScheduledExecutor();
            }

            protected String serviceName() {
                return "Foo";
            }
        };
        try {
            service.startAsync().awaitRunning(1L, TimeUnit.MILLISECONDS);
            AbstractExecutionThreadServiceTest.fail((String)"Expected timeout");
        }
        catch (TimeoutException e) {
            Truth.assertThat((Throwable)e).hasMessage("Timed out waiting for Foo [STARTING] to reach the RUNNING state.");
        }
    }

    private class FakeService
    extends AbstractExecutionThreadService
    implements TearDown {
        private final ExecutorService executor = Executors.newSingleThreadExecutor();
        volatile int startupCalled = 0;
        volatile int shutdownCalled = 0;
        volatile int runCalled = 0;

        FakeService() {
            AbstractExecutionThreadServiceTest.this.tearDownStack.addTearDown((TearDown)this);
        }

        protected void startUp() throws Exception {
            Assert.assertEquals((int)0, (int)this.startupCalled);
            Assert.assertEquals((int)0, (int)this.runCalled);
            Assert.assertEquals((int)0, (int)this.shutdownCalled);
            ++this.startupCalled;
        }

        protected void run() throws Exception {
            Assert.assertEquals((int)1, (int)this.startupCalled);
            Assert.assertEquals((int)0, (int)this.runCalled);
            Assert.assertEquals((int)0, (int)this.shutdownCalled);
            ++this.runCalled;
        }

        protected void shutDown() throws Exception {
            Assert.assertEquals((int)1, (int)this.startupCalled);
            Assert.assertEquals((int)0, (int)this.shutdownCalled);
            Assert.assertEquals((Object)Service.State.STOPPING, (Object)this.state());
            ++this.shutdownCalled;
        }

        protected Executor executor() {
            return this.executor;
        }

        public void tearDown() throws Exception {
            this.executor.shutdown();
        }
    }

    private class TimeoutOnStartUp
    extends AbstractExecutionThreadService {
        private TimeoutOnStartUp() {
        }

        protected Executor executor() {
            return new Executor(){

                @Override
                public void execute(Runnable command) {
                }
            };
        }

        protected void run() throws Exception {
        }
    }

    private class ThrowOnShutDown
    extends AbstractExecutionThreadService {
        private ThrowOnShutDown() {
        }

        protected void run() {
            try {
                AbstractExecutionThreadServiceTest.this.enterRun.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        protected void shutDown() {
            throw new UnsupportedOperationException("kaboom!");
        }

        protected Executor executor() {
            return AbstractExecutionThreadServiceTest.this.exceptionCatchingExecutor;
        }
    }

    private class ThrowOnRunService
    extends AbstractExecutionThreadService {
        private boolean shutDownCalled = false;
        private boolean throwOnShutDown = false;

        private ThrowOnRunService() {
        }

        protected void run() {
            throw new UnsupportedOperationException("kaboom!");
        }

        protected void shutDown() {
            this.shutDownCalled = true;
            if (this.throwOnShutDown) {
                throw new UnsupportedOperationException("double kaboom!");
            }
        }

        protected Executor executor() {
            return AbstractExecutionThreadServiceTest.this.exceptionCatchingExecutor;
        }
    }

    private class ThrowOnStartUpService
    extends AbstractExecutionThreadService {
        private boolean startUpCalled = false;

        private ThrowOnStartUpService() {
        }

        protected void startUp() {
            this.startUpCalled = true;
            throw new UnsupportedOperationException("kaboom!");
        }

        protected void run() {
            throw new AssertionError((Object)"run() should not be called");
        }

        protected Executor executor() {
            return AbstractExecutionThreadServiceTest.this.exceptionCatchingExecutor;
        }
    }

    private class WaitOnRunService
    extends AbstractExecutionThreadService {
        private boolean startUpCalled = false;
        private boolean runCalled = false;
        private boolean shutDownCalled = false;
        private Service.State expectedShutdownState = Service.State.STOPPING;

        private WaitOnRunService() {
        }

        protected void startUp() {
            Assert.assertFalse((boolean)this.startUpCalled);
            Assert.assertFalse((boolean)this.runCalled);
            Assert.assertFalse((boolean)this.shutDownCalled);
            this.startUpCalled = true;
            Assert.assertEquals((Object)Service.State.STARTING, (Object)this.state());
        }

        protected void run() {
            Assert.assertTrue((boolean)this.startUpCalled);
            Assert.assertFalse((boolean)this.runCalled);
            Assert.assertFalse((boolean)this.shutDownCalled);
            this.runCalled = true;
            Assert.assertEquals((Object)Service.State.RUNNING, (Object)this.state());
            AbstractExecutionThreadServiceTest.this.enterRun.countDown();
            try {
                AbstractExecutionThreadServiceTest.this.exitRun.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        protected void shutDown() {
            Assert.assertTrue((boolean)this.startUpCalled);
            Assert.assertTrue((boolean)this.runCalled);
            Assert.assertFalse((boolean)this.shutDownCalled);
            this.shutDownCalled = true;
            Assert.assertEquals((Object)this.expectedShutdownState, (Object)this.state());
        }

        protected void triggerShutdown() {
            AbstractExecutionThreadServiceTest.this.exitRun.countDown();
        }

        protected Executor executor() {
            return AbstractExecutionThreadServiceTest.this.exceptionCatchingExecutor;
        }
    }
}

